#pragma once

#include <string>
#include <vector>

class CTinyClientSocket;
class CReceiveThread;

typedef std::vector<std::string> StringVector;

class CTestConnection
{
public:
	CTestConnection(void);
	~CTestConnection(void);

public:
	void Execute(const std::string& command);
	void FileExecute(const std::string& filename);
	void Close();
	
protected:
	void Execute_Connect(const StringVector& argList);
	void Execute_Login(const StringVector& argList);
	void Execute_Chat(const StringVector& argList);


protected:
	void ExecuteImpl(const std::string& command, const StringVector& argList);
	bool Connect(const char* ip, int port);
	bool SendLogin(const std::string& username);
	bool ReceiveResult(uint32 waitTime);
	bool SendChat(const std::string& message);
	bool SendMonsterListRequest();
	bool SendMovement(const StringVector& argList);
	bool SendRequestMyInfo();
	bool SendRequestOtherInfo();


private:
	CTinyClientSocket*	m_clientSocket;
	CReceiveThread* m_recvThread;
};
