#include "StdAfx.h"
#include "TinyClientSocket.h"
#pragma comment( lib, "ws2_32.lib" )

CTinyClientSocket::CTinyClientSocket() 
	: m_socket(INVALID_SOCKET)
	, m_event(WSA_INVALID_EVENT)
	, m_isConnected(false)
	, m_immediateReturn(true)
{
}

CTinyClientSocket::~CTinyClientSocket()
{
}


bool CTinyClientSocket::InitNetwork()
{
	WSADATA wsaData;
	if (0 != WSAStartup(MAKEWORD(2,2), &wsaData))
		return false;

	m_event = WSACreateEvent();
	if (WSA_INVALID_EVENT == m_event)
		return false;

	return true;
}

bool CTinyClientSocket::InitSocket()
{
	m_isConnected = false;
	m_socket = socket(AF_INET,SOCK_STREAM,0);
	if (INVALID_SOCKET == m_socket)
		return false;

	return true;
}

void CTinyClientSocket::FiniNetwork()
{
	WSACloseEvent(m_event);
	m_event = WSA_INVALID_EVENT;
	WSACleanup();
}

void CTinyClientSocket::FiniSocket()
{
	if (m_isConnected)
		Disconnect();
	m_socket = INVALID_SOCKET;
}

bool CTinyClientSocket::Connect(const char* ip, const int port)
{
	hostent* host = NULL;
	host = gethostbyname(ip);
	if (NULL == host)
		return false;

	sockaddr_in addr;
	addr.sin_family = AF_INET;
	addr.sin_port = htons(port);
	addr.sin_addr = *((in_addr *)host->h_addr);
	memset(&(addr.sin_zero), 0, 8); 

	if (SOCKET_ERROR == ::connect(m_socket, (sockaddr*)&addr, sizeof(sockaddr))) 
		return false;

	if (SOCKET_ERROR == WSAEventSelect(m_socket, m_event, FD_READ|FD_CLOSE))
		return false;

	m_isConnected = true;

	return true;
}

void CTinyClientSocket::Disconnect()
{
	m_isConnected = false;
	MakeEmptySocketBuffer();
	closesocket(m_socket);
}

bool CTinyClientSocket::Send(const char* buffer, const uint32 len)
{
	if (len <= 0)
		return false;
	if (false == m_isConnected)
		return false;

	uint32 offset = 0;
	while (offset < len)
	{
		int resultCode = ::send(m_socket, buffer+offset, len-offset, 0);
		if (SOCKET_ERROR == resultCode)
		{
			m_isConnected = false;
			return false;
		}
		offset += resultCode;
	}
	return true;
}

uint32 CTinyClientSocket::Receive(char* buffer, const uint32 len, const uint32 timeoutMs)
{
	uint32 recvLen = 0;
	bool eventReset = false;
	while (recvLen < len)
	{
		DWORD resultCode = WSAWaitForMultipleEvents(1, &m_event, FALSE, timeoutMs, FALSE);
		if (WSA_WAIT_FAILED == resultCode)
		{
			eventReset = true;
			m_isConnected = false;
			break;
		}
		else if (WSA_WAIT_TIMEOUT == resultCode)
		{
			eventReset = true;
			break;
		}

		WSANETWORKEVENTS netEvents;
		if (SOCKET_ERROR == WSAEnumNetworkEvents(m_socket, m_event, &netEvents))
		{
			eventReset = true;
			m_isConnected = false;
			break;
		}

		if ((netEvents.lNetworkEvents&FD_READ) && (!netEvents.iErrorCode[FD_READ_BIT]))
		{
			int recvResult = ::recv(m_socket, buffer+recvLen, len, 0);
			if (SOCKET_ERROR == recvResult)
				break;
			recvLen += recvResult;
			if (m_immediateReturn)
				break;
		}
		if ((netEvents.lNetworkEvents&FD_CLOSE) && (!netEvents.iErrorCode[FD_CLOSE_BIT]))
		{
			eventReset = true;
			m_isConnected = false;
			break;
		}
	}

	if (eventReset)
		WSAResetEvent(m_event);
	return recvLen;
}

bool CTinyClientSocket::IsConnected() const
{
	return m_isConnected;
}

void CTinyClientSocket::MakeEmptySocketBuffer() const
{
	const uint32 ReceiveBufferSize = 1024;
	char buffer[ReceiveBufferSize] = {0,};
	while(true)
	{
		int recvResult = ::recv(m_socket, buffer, ReceiveBufferSize, 0);
		if (0 == recvResult || SOCKET_ERROR == recvResult )
			break;
	}
}

//////////////////////////////////////////////////////////////////////////
bool CTinyClientSocket::GetLocalIPAddress(char* ip, uint32 bufferLen) const
{
	char ac[80] = {0,};
	if (gethostname(ac, sizeof(ac)) == SOCKET_ERROR)
		return false;

	struct hostent *phe = gethostbyname(ac);
	if (phe == 0)
		return false;

	for (int i = 0; phe->h_addr_list[i] != 0; ++i) 
	{
		struct in_addr addr;
		memcpy(&addr, phe->h_addr_list[i], sizeof(struct in_addr));
		if (bufferLen < strlen(inet_ntoa(addr)))
			return false;
		strcpy_s(ip, bufferLen, inet_ntoa(addr));

		if (0 != strcmp(ip, "127.0.0.1"))
			return true;
	}
	return false;
}
