
/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2004.
-------------------------------------------------------------------------
$Id: GameRealtimeRemoveUpdate.h,v 1.1 23/09/2009 Johnmichael Quinlan
Description:  This is the header file for the game module specific Realtime remote update. 
							The purpose of this module is to allow data update to happen remotely inside 
							the game layer so that you can, for example, edit the terrain and see 
							the changes in the console.
-------------------------------------------------------------------------
History:
- 23/09/2009   10:45: Created by Johnmichael Quinlan
*************************************************************************/

#ifndef GameRealtimeRemoteUpdate_h__
#define GameRealtimeRemoteUpdate_h__

#pragma once

#include <IRealtimeRemoteUpdate.h>

class CGameRealtimeRemoteUpdateListener : 
	public IRealtimeUpdateGameHandler
{
protected:
	CGameRealtimeRemoteUpdateListener();
	VIRTUAL ~CGameRealtimeRemoteUpdateListener();

public:
	static CGameRealtimeRemoteUpdateListener& GetGameRealtimeRemoteUpdateListener();
	
	VIRTUAL bool	Enable(bool boEnable);
	VIRTUAL bool	Update();

protected:
	
	VIRTUAL bool	UpdateGameData(XmlNodeRef oXmlNode, unsigned char * auchBinaryData);
	VIRTUAL void	UpdateCamera(XmlNodeRef oXmlNode);
	VIRTUAL void	CloseLevel();
	VIRTUAL void	CameraSync();
	VIRTUAL void	EndCameraSync();
private:
	bool m_bCameraSync;
	int  m_nPreviousFlyMode;
	Vec3 m_Position;
	Vec3 m_ViewDirection;

	XmlNodeRef	m_CameraUpdateInfo;
};

#endif //GameRealtimeRemoteUpdate_h__

