#############################################################################
## Crytek Source File
## Copyright (C) 2007, Crytek Studios
##
## Creator: Sascha Demetrio
## Date: Apr 05 2007
## Description: GNU-make based build system
#############################################################################

PROJECT_TYPE := program

PROJECT_PS3_PRX := 1

-include $(PROJECT_CODE)/Project_override.mk

PROJECT_CPPFLAGS_COMMON += \
	-I$(CODE_ROOT)/CryEngine/CryCommon \
	-I$(CODE_ROOT)/CryEngine/CrySystem \
	-I$(CODE_ROOT)/CryEngine/CryAction

# Local option enabling the use of the dmalloc library in the malloc wrapper
# code.  This will become a global option if this turns out to be useful.
# Note that $(option_use_dmalloc) is evaluated only if
# $(OPTION_PS3_MALLOCWRAPPER) is enabled.
option_use_dmalloc ?= 1

dmalloc_version := 5.5.2-1
dmalloc_dir := dmalloc-$(dmalloc_version)

ifeq ($(OPTION_PS3_MALLOCWRAPPER),1)
 ifeq ($(option_use_dmalloc),1)
  PROJECT_CPPFLAGS += -DUSE_DMALLOC -I$(PROJECT_CODE)/$(dmalloc_dir)
 endif
endif

# The list of modules (shared and/or static objects) that should be linked to
# the final executable.
ifneq ($(BUILD_WITH_PS3_SDK),1)
	ifeq ($(OPTION_PS3_PRX),1)
	 PROJECT_LINKMODULES := CrySystem GameDll CryNetwork
	 PROJECT_DEPMODULES := \
		$(PROJECT_LINKMODULES) \
		Cry3DEngine \
		CryAISystem \
		CryAnimation \
		CryEntitySystem \
		CryFont \
		CryInput \
		CryMovie \
		CryPhysics \
		CryScriptSystem \
		CrySoundSystem \
		$(PROJECTS_Renderer)
	else
	 PROJECT_LINKMODULES := \
		CrySystem \
		Cry3DEngine \
		CryAISystem \
		CryAnimation \
		CryEntitySystem \
		CryFont \
		CryInput \
		CryMovie \
		CryNetwork \
		CryPhysics \
		CryScriptSystem \
		CrySoundSystem \
		$(PROJECTS_Renderer)
	endif
else
	PROJECT_LINKMODULES := \
		GameDll		
endif

ifneq ($(GENERATE_PS3_SDK),1)
ifneq ($(OPTION_PS3_PRX),1)
	PROJECT_LINKMODULES := $(PROJECT_LINKMODULES) \
		GameDll
endif
endif

include $(MAKE_ROOT)/Lib/ps3prxdefs.mk

ifneq ($(BUILD_WITH_PS3_SDK),1)
  PROJECT_SOURCES_CPP := ../../CryEngine/CryCommon/PS3LauncherCommon.cpp
  -include $(PROJECT_BUILD)/../CryEngine/CryCommon/PS3LauncherCommon.d
endif

ifeq ($(OPTION_PROFILE),1)
 PROJECT_XFLAGS += -O3
# PROJECT_XFLAGS += -O0 -g
endif

#ifeq ($(OPTION_PROFILE),1)
  GFX_LIB = GFx_opt_nortti
#else
#  GFX_LIB = GFx_debug_nortti
#endif

SCALEFORM_GFX_LIBS := \
	-l$(GFX_LIB) -ljpeg

FMOD_LIBS_COMMON := \
	-laudio_stub -latrac3plus_stub -lmic_stub

FMOD_LIBS_DEBUG := \
	$(CODE_ROOT)/CryEngine/CrySoundSystem/FmodEx/lib/ps3/fmodexD.a \
	$(CODE_ROOT)/CryEngine/CrySoundSystem/FmodEx/lib/ps3/fmod_event_netD.a \
	$(CODE_ROOT)/CryEngine/CrySoundSystem/FmodEx/lib/ps3/fmod_eventD.a

#FMOD_LIBS_DEBUG := \
#	$(CODE_ROOT)/SDKs/FMODEX/ps3/PS3_PPU_Debug/fmodexD.a \
#	$(CODE_ROOT)/CryEngine/CrySoundSystem/FmodEx/lib/ps3/fmod_event_netL.a \
#	$(CODE_ROOT)/SDKs/FMODEX/tools/fmod_event/ps3/PS3_PPU_Debug/fmod_eventD.a

FMOD_LIBS := \
	$(CODE_ROOT)/CryEngine/CrySoundSystem/FmodEx/lib/ps3/fmodex_SPURS.a \
	$(CODE_ROOT)/CryEngine/CrySoundSystem/FmodEx/lib/ps3/fmod_event_net.a \
	$(CODE_ROOT)/CryEngine/CrySoundSystem/FmodEx/lib/ps3/fmod_event.a

PROJECT_LDFLAGS := \
	-L$(CODE_ROOT)/Tools/PS3JobManager/lib\
	-L$(CODE_ROOT)/SDKs/Scaleform/Lib\
	-L$(CODE_ROOT)/SDKs/CRIMW/PS3/Lib
ifeq ($(OPTION_PS3_GCMHUD),1)
 gcm_libs := -lgcm_hud -lgcm_pm -lsysutil_avconf_ext_stub
else
 ifeq ($(OPTION_PS3_GCMDEBUG),1)
  gcm_libs := -lgcm_cmddbg -lgcm_sys_stub -lsysutil_avconf_ext_stub
 else
  gcm_libs := -lgcm_cmd -lgcm_sys_stub -lsysutil_avconf_ext_stub
 endif
endif
PROJECT_LDLIBS := \
	$(gcm_libs) \
	-lcgc \
	-lfios \
	-lm \
	-lio_stub -lfs_stub -lrtc_stub \
	-lsysutil_stub -lsysmodule_stub -lsysutil_game_stub\
	-lsysutil_avc2_stub -lsysutil_np2_stub -lsysutil_np_stub -lsysutil_avc2_stub\
	-lpthread -lnetctl_stub -lsheap_stub -lcontrol_console_ppu \
	-lmixer \
	-lnet_stub \
	-lsync_stub -lspurs_stub -ljpgdec_stub -llv2dbg_stub\
	-lfont_stub -lfontFT_stub -lfreetype_stub -lfreetypeTT_stub\
	-lperf -ldbg -lsntuner\
	$(FMOD_LIBS_COMMON) \
#	$(SCALEFORM_GFX_LIBS)

ifeq ($(BUILD_WITH_PS3_SDK),1)
	PROJECT_LDLIBS := \
		$(PROJECT_LDLIBS) \
		$(PS3_SDK_ROOT)/CryEngine3rdParty.a \
		`ls -d $(PS3_SDK_ROOT)/ObjectFiles/*.o`		
else
	PROJECT_LDLIBS := \
		$(PROJECT_LDLIBS) \
		$(FMOD_LIBS)\
		$(CODE_ROOT)/SDKs/Speex/ps3/lib/libspeex.a\
		$(CODE_ROOT)/SDKs/BigDigits/ps3/lib/libBigDigits.a\
		$(CODE_ROOT)/CryEngine/CryFont/FreeType2/ps3/lib/libfreetype2.a\
		$(CODE_ROOT)/CryEngine/CrySystem/zlib/ps3/lib/libzlib.a\
		$(CODE_ROOT)/CryEngine/CryScriptSystem/ps3/lib/liblua.a\
		$(CODE_ROOT)/CryEngine/CrySystem/XML/Expat/ps3/lib/libxmlexpat.a		
endif

#$(FMOD_LIBS_DEBUG)

ifeq ($(OPTION_PS3_PRX),1)
 PROJECT_LDLIBS += \
	$(CELL_SDK)/target/ppu/lib/fno-exceptions/fno-rtti/libc_libent.o \
	$(CELL_SDK)/target/ppu/lib/fno-exceptions/fno-rtti/libm_libent.o \
	$(CELL_SDK)/target/ppu/lib/fno-exceptions/fno-rtti/libstdc++_libent.o
endif

##############################################################################
# Special rules for buiding the mallocwrapper object Malloc.o.

ifeq ($(OPTION_PS3_MALLOCWRAPPER),1)

PROJECT_OBJECTS_ADD = $(PROJECT_BUILD)/Malloc.o

MALLOCWRAPPER_CPPFLAGS =
MALLOCWRAPPER_LDFLAGS =
MALLOCWRAPPER_LIBS =
malloc_from_libc := 1
ifeq ($(option_use_dmalloc),1)
 MALLOCWRAPPER_CPPFLAGS += \
	-DMALLOCWRAPPER_USE_DMALLOC \
	-I$(PROJECT_CODE)/$(dmalloc_dir)
 MALLOCWRAPPER_LDFLAGS += -L$(PROJECT_CODE)/$(dmalloc_dir)
 MALLOCWRAPPER_LIBS += -ldmallocth
 malloc_from_libc := 0
endif
ifeq ($(malloc_from_libc),1)
 MALLOCWRAPPER_LIBS += -lc
endif

MALLOCWRAPPER_OBJECTS = \
	$(PROJECT_BUILD)/MallocWrapper.o \
	$(PROJECT_BUILD)/RealMalloc.o
ifneq ($(malloc_from_libc),1)
 MALLOCWRAPPER_OBJECTS += $(PROJECT_BUILD)/LibcMalloc.o
endif

# Symbols exported by the malloc wrapper.
MALLOCWRAPPER_SYMBOLS := \
	malloc calloc realloc free memalign reallocalign valloc strdup

MALLOCWRAPPER_LIBC := $(CELL_SDK)/target/ppu/lib/fno-exceptions/fno-rtti/libc.a 

MALLOCWRAPPER_LIBREALMALLOC_OBJECTS = \
	$(PROJECT_BUILD)/memcpy.o

$(PROJECT_BUILD)/libRealMalloc.a: $(MALLOCWRAPPER_LIBREALMALLOC_OBJECTS)
	$(SILENT) rm -f $@
	$(BUILD_LINK) $(AR) cq $@ $^
	$(BUILD_LINK) $(RANLIB) $@

# LIBC symbols which should _not_ be renamed when linking RealMalloc.o.  These
# are the exported names from libc.a(malloc.o) which are _not_ wrapped by the
# malloc wrapper.
$(PROJECT_BUILD)/mallocwrapper_symbols.mk:
	$(BUILD_ECHO) 'Scanning libc.a(malloc.o) for exported symbols'
	$(SILENT) rm -f $@
	$(BUILD_LINK) \
		$(NM) $(MALLOCWRAPPER_LIBC) 2>/dev/null \
		|sed -ne '/^malloc.o:$$/,/^\s*$$/p' \
		|sed -ne 's/^[0-9a-f]*\s\+[DT]\s\+//p' \
		$(foreach symbol,\
			$(MALLOCWRAPPER_SYMBOLS) memcpy,\
			|grep -wv '$(symbol)') \
		|(echo -n 'MALLOCWRAPPER_LIBCMALLOCSYMS := '; xargs echo) \
		>$@

include $(PROJECT_BUILD)/mallocwrapper_symbols.mk

# Temporary hack until all files have reached their final destination.
#_mwdir := MallocWrapper
_mwdir :=

$(PROJECT_BUILD)/Malloc.o: $(MALLOCWRAPPER_OBJECTS)
	$(BUILD_ECHO) 'Linking Malloc.o (MallocWrapper)'
	$(BUILD_LINK) $(LD) -r $(LDRFLAGS) -o $@ $^

$(PROJECT_BUILD)/RealMalloc.o: \
  $(PROJECT_CODE)/$(_mwdir)/RealMalloc.c \
  $(PROJECT_BUILD)/libRealMalloc.a
	$(BUILD_ECHO) 'RealMalloc.c (MallocWrapper)'
	$(SILENT) mkdir -p $(PROJECT_BUILD)/tmp
	$(BUILD) $(CC) $(MALLOCWRAPPER_CPPFLAGS) $(CPPFLAGS) $(CFLAGS) \
		-c -g -o $(PROJECT_BUILD)/tmp/RealMalloc_1.o $<
	$(BUILD_ECHO) 'Linking malloc symbols (MallocWrapper)'
	$(BUILD_LINK) $(LD) -g -r $(LDRFLAGS) \
		-o $(PROJECT_BUILD)/tmp/RealMalloc_2.o \
		$(PROJECT_BUILD)/tmp/RealMalloc_1.o \
		-L $(CELL_SDK)/target/ppu/lib \
		$(MALLOCWRAPPER_LDFLAGS) $(MALLOCWRAPPER_LIBS) \
		-L $(PROJECT_BUILD) -lRealMalloc
	$(SILENT) rm -f $(PROJECT_BUILD)/tmp/RealMalloc_1.o
	$(BUILD_ECHO) 'Redefining malloc symbols (MallocWrapper)'
	$(BUILD_LINK) $(NM) $(PROJECT_BUILD)/tmp/RealMalloc_2.o \
		|grep -v mallocwrapper_ \
		|grep -v dmalloc_ \
		$(foreach symbol,\
			$(MALLOCWRAPPER_LIBCMALLOCSYMS),\
			|grep -wv '$(symbol)') \
		|sed -ne 's/^[0-9a-f]*\s\+[BDTR]\s\+//p' \
		>$(PROJECT_BUILD)/tmp/RealMalloc_libc.syms
	$(BUILD_LINK) $(OBJCOPY) \
		`sed \
		  -e 's/^\.\(\S*\)\$$/--redefine-sym .\1=.mwprivate1_\1/' \
		  -e 's/^[^\. ]\S*\$$/--redefine-sym \0=mwprivate1_\0/' \
		  $(PROJECT_BUILD)/tmp/RealMalloc_libc.syms` \
		$(PROJECT_BUILD)/tmp/RealMalloc_2.o \
		$@
	$(SILENT) rm -f $(PROJECT_BUILD)/tmp/RealMalloc_2.o
	$(SILENT) rm -f $(PROJECT_BUILD)/tmp/RealMalloc_libc.syms

$(PROJECT_BUILD)/LibcMalloc.o: $(MALLOCWRAPPER_LIBC)
	$(SILENT) mkdir -p $(PROJECT_BUILD)/tmp
	$(SILENT) rm -f $(PROJECT_BUILD)/tmp/malloc.o
	$(SILENT) rm -f $(PROJECT_BUILD)/tmp/libc_malloc.o
	$(SILENT) (cd $(PROJECT_BUILD)/tmp \
		&& $(_BUILD_LINK) $(AR) x $(MALLOCWRAPPER_LIBC) malloc.o \
		&& mv malloc.o libc_malloc.o)
	$(BUILD_LINK) $(OBJCOPY) \
		$(foreach symbol,\
			$(MALLOCWRAPPER_SYMBOLS),\
			--redefine-sym $(symbol)=mwprivate2_$(symbol) \
			--redefine-sym .$(symbol)=.mwprivate2_$(symbol)) \
		--redefine-sym memcpy=mwprivate1_memcpy \
		--redefine-sym .memcpy=.mwprivate1_memcpy \
		$(PROJECT_BUILD)/tmp/libc_malloc.o \
		$@
	$(SILENT) rm -f $(PROJECT_BUILD)/tmp/libc_malloc.o

$(PROJECT_BUILD)/MallocWrapper.o: $(PROJECT_CODE)/$(_mwdir)/MallocWrapper.c
	$(BUILD_ECHO) 'MallocWrapper.c (MallocWrapper)'
	$(BUILD) $(CC) $(CPPFLAGS) $(CFLAGS) -c -g -o $@ $<

$(PROJECT_BUILD)/%.o: $(PROJECT_CODE)/MallocWrapper/%.c
	$(BUILD) $(CC) $(CPPFLAGS) $(CFLAGS) -c -g -o $@ $<

endif # OPTION_PS3_MALLOCWRAPPER == 1

##############################################################################
# Special rules for buiding the I/O wrapper for the load sequencer.

ifeq ($(OPTION_PS3_LOADSEQ),1)

PROJECT_OBJECTS_ADD += $(PROJECT_BUILD)/LoadSequencer.o

LOADSEQ_OBJECTS := $(PROJECT_BUILD)/LoadSeq.o

ifeq ($(STAGE),compile)
-include $(PROJECT_BUILD)/LoadSeq.$(EXT_D)
$(PROJECT_BUILD)/LoadSeq.o: $(PROJECT_CODE)/LoadSeq.cpp
	$(SILENT) mkdir -p "$(dir $@)"
	$(BUILD_ECHO) $(tag_cxx) $(TARGET)/LoadSeq.cpp
	$(BUILD_SILENT) $(RM) $@
	$(call COMPILE_CXX,$<,$<,$@,$(XFLAGS))
endif # STAGE == compile

PROJECT_DEPS_compile += $(LOADSEQ_OBJECTS)

$(PROJECT_BUILD)/LoadSequencer.o: $(PROJECT_BUILD)/LoadSeq.o
	$(SILENT) $(RM) $@
	$(_BUILD) $(prelink) -o $@ $^

else # else OPTION_PS3_LOADSEQ
# If the load sequencer is not linked, then we'll provide dummy
# implementations for the load sequencer API.
#PROJECT_SOURCES_CPP_ADD += LoadSeqDummy.cpp
endif # !OPTION_PS3_LOADSEQ

COMPILE_CLEAN_$(TARGET) += \
	$(PROJECT_BUILD)/LoadSequencer.o \
	$(PROJECT_BUILD)/LoadSeq.o \
	$(PROJECT_BUILD)/LoadSeqDummy.o

##############################################################################
# Special rules for buiding fast trigonometric funcs.

#PROJECT_OBJECTS_ADD += $(PROJECT_BUILD)/Cry_PS3_Math.o
#XFLAGS_MATH := $(XFLAGS) -O3 -fstrict-aliasing $(PS3_MATHOPT) -DPS3OPT
#ifeq ($(STAGE),compile)
#-include $(PROJECT_BUILD)/Cry_PS3_Math.$(EXT_D)
#$(PROJECT_BUILD)/Cry_PS3_Math.o: ../../CryEngine/CryCommon/console/Cry_PS3_Math.cpp
#	$(SILENT) mkdir -p "$(dir $@)"
#	$(BUILD_ECHO) $(tag_cxx) $(TARGET)/Cry_PS3_Math.cpp
#	$(BUILD_SILENT) $(RM) $@
#	$(_BUILD) $(call COMPILE_CXX,$<,$<,$@,$(XFLAGS_MATH))
#endif # STAGE == compile
#PROJECT_DEPS_compile += $(PROJECT_BUILD)/Cry_PS3_Math.o

##############################################################################
# Special rules for buiding the memory tracer.


MEMORY_INTERFACE_SOURCE := ../../CryEngine/CryCommon/PS3MemoryInterface.cpp

PROJECT_OBJECTS_ADD += $(PROJECT_BUILD)/MemoryInterface.o

MEMORY_INTERFACE_OBJECTS := $(PROJECT_BUILD)/PS3MemoryInterface.o

ifeq ($(STAGE),compile)
-include $(PROJECT_BUILD)/PS3MemoryInterface.$(EXT_D)
$(PROJECT_BUILD)/PS3MemoryInterface.o: $(MEMORY_INTERFACE_SOURCE)
	$(SILENT) mkdir -p "$(dir $@)"
	$(BUILD_ECHO) $(tag_cxx) $(MEMORY_INTERFACE_SOURCE)
	$(BUILD_SILENT) $(RM) $@
	$(call COMPILE_CXX,$<,$<,$@,$(XFLAGS))
endif # STAGE == compile

PROJECT_DEPS_compile += $(MEMORY_INTERFACE_OBJECTS)

$(PROJECT_BUILD)/MemoryInterface.o: $(PROJECT_BUILD)/PS3MemoryInterface.o
	$(SILENT) $(RM) $@
	$(BUILD_ECHO) $(tag_prelink) $(TARGET)/$(notdir $@)
	$(SILENT) $(prelink) -o $@ $^

COMPILE_CLEAN_$(TARGET) += \
	$(PROJECT_BUILD)/MemoryInterface.o \
	$(PROJECT_BUILD)/PS3MemoryInterface.o

$(PROJECT_BUILD)/mymemcpy16.o: $(PROJECT_CODE)/memcpy16.s
	$(BUILD_ECHO) $(tag_cxx) $(TARGET)/memcpy16.s
	$(BUILD_SILENT) $(RM) $@
	$(_BUILD) $(CXX) -c -o $@ $<

PROJECT_OBJECTS_ADD += $(PROJECT_BUILD)/mymemcpy16.o

COMPILE_CLEAN_$(TARGET) += \
	$(PROJECT_BUILD)/mymemcpy16.o

ifeq ($(GENERATE_PS3_SDK),1)
	PROJECT_DEPS_compile += $(PROJECT_BUILD)/mymemcpy16.o
endif # GENERATE_PS3_SDK == 1

# No PCH for the launcher.
MKOPTION_NOPCH := 1

# vim:ts=8:sw=8
