/***************************************************************************
 *
 *	CRI Middleware SDK
 *
 *	Copyright (c) 2008 CRI-MW
 *
 *	Library	: ADX Library
 *	Module	: Functions for DirectSound8
 *	File	: adx_dsound8.h
 *
 ***************************************************************************/

/* d`h~					*/
/* Prevention of redefinition	*/
#ifndef _ADXDSOUND8_H_INCLUDED
#define _ADXDSOUND8_H_INCLUDED

/***************************************************************************
 *       o[W
 *       Version
 ***************************************************************************/
#define ADXDSOUND8_VERSION			"1.02"

/***************************************************************************
 *      CN[ht@C
 *      Include files
 ***************************************************************************/
/* Disable VC++ warning 
 *   In some cases, including windows.h, dsound.h causes the following warning:
 *       rpcasync.h(45) : warning C4115: '_RPC_ASYNC_STATE' : ...
 */
#if defined(_MSC_VER) && ((_MSC_VER >= 1200) && (_MSC_VER < 1300))
	#pragma warning(disable : 4115)
#endif

#include "cri_xpt.h"
#include <dsound.h>

/***************************************************************************
 *      萔}N
 *      Macro Constants
 ***************************************************************************/

/***************************************************************************
 *      }N
 *      Macro Functions
 ***************************************************************************/

/***************************************************************************
 *      f[^^錾
 *      Data Type Declarations
 ***************************************************************************/
/*--------------------------------------------------------------------------
 * obt@쐬̔zuʒu
 * n[hEFAANZ[V̗LɊ֌W
 * Locate mode of DirectSoundBuffer
 * Influences the use of hardware acceleration
 *-------------------------------------------------------------------------*/
typedef enum {
	ADXPC_LOCMODE_SOFTWAREONLY = 0x00,
		/* Softwareobt@^~LVÔݎgp					*/
		/* Only software buffer/mixing will be used				*/
	ADXPC_LOCMODE_HARDWAREONLY = 0x01,
		/* Hardwareobt@^~LVÔݎgp					*/
		/* Only hardware buffer/mixing will be used				*/
	ADXPC_LOCMODE_HARDWARE = 0x02,
		/* \ȂHardwaregp								*/
		/* Hardware buffer/mixing will be used if available		*/
	ADXPC_LOCMODE_DEFER = 0x03,
		/* obt@mۂĐ܂ŒxA\ȂHardwaregp	*/
		/* The buffer can be assigned to a hardware or software	*/
		/* resource at play time								*/
} ADXPC_LOCMODE;

/***************************************************************************
 *      ϐ錾
 *      Prototype Variables
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Prototype Functions
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/* TEh̃ZbgAbv */
/* Setup of sound */
CriSint32 CRIAPI ADXPC_SetupSoundDirectSound8(LPDIRECTSOUND8 ds);

/* TEh̃Vbg_E */
/* Shutdown of sound */
CriSint32 CRIAPI ADXPC_ShutdownSound(void);

/* XeIo̓XCb`̐ݒ */
/* Enable force stereo output mode */
void CRIAPI ADXPC_SetOutputStereo(CriBool flag);

/*---------------------------------------------------------------------------
 * DirectSoundBufferp֐
 * Functions for setting DirectSoundBuffer parameters
 *-------------------------------------------------------------------------*/
/* DirectSoundBuffer8IuWFNg̎擾	*/
/* Get the DirectSoundBuffer8 object	*/
LPDIRECTSOUNDBUFFER8 CRIAPI ADXPC_GetDirectSoundBuffer8(ADXT adxt);

/* DirectSoundBuffer̔zuʒu̐ݒ		*/
/* Set the locate mode of DirectSoundBuffer	*/
void CRIAPI ADXPC_SetDsbCapsLocMode(CriSint32 loc_mode);

/* DirectSoundBuffer̔zuʒu̎擾		*/
/* Get the locate mode of DirectSoundBuffer	*/
CriSint32 CRIAPI ADXPC_GetDsbCapsLocMode(void);

/* DirectSoundBuffer̃`l̐ݒ			*/
/* Set the number of channels of DirectSoundBuffer	*/
void CRIAPI ADXPC_SetDsbNumChannels(CriSint32 num);

/* DirectSoundBuffer̃`l̎擾			*/
/* Get the number of channels of DirectSoundBuffer	*/
CriSint32 CRIAPI ADXPC_GetDsbNumChannels(void);

/* DirectSoundBufferŃobt@OTv̐ݒ	*/
/* Set the number of samples that DirectSoundBuffer buffers	*/
void CRIAPI ADXPC_SetDsbNumSamples(CriSint32 nsmpl);

/* DirectSoundBufferŃobt@OTv̎擾	*/
/* Get the number of samples that DirectSoundBuffer buffers	*/
CriSint32 CRIAPI ADXPC_GetDsbNumSamples(void);

/* O[otH[JXDirectSoundBuffer쐬邩ǂݒ	*/
/* Set DirectSoundBuffer to have global focus							*/
void CRIAPI ADXPC_SetDsbCapsGlobalFocus(CriBool flag);

/* O[otH[JXDirectSoundBuffer쐬邩ǂ擾	*/
/* Get whether DirectSoundBuffer is having global focus					*/
CriBool CRIAPI ADXPC_GetDsbCapsGlobalFocus(void);

/* 3DRg[@\DirectSoundBuffer쐬邩ǂݒ	*/
/* Set DirectSoundBuffer to support 3D control							*/
void CRIAPI ADXPC_SetDsbCapsCtrl3D(CriBool flag);

/* 3DRg[@\DirectSoundBuffer쐬邩ǂ擾	*/
/* Get whether DirectSoundBuffer is supporting 3D control				*/
CriBool CRIAPI ADXPC_GetDsbCapsCtrl3D(void);

/* GtFNg@\DirectSoundBuffer쐬邩ǂݒ	*/
/* Set DirectSoundBuffer to support effects processing				*/
void CRIAPI ADXPC_SetDsbCapsCtrlFx(CriBool flag);

/* GtFNg@\DirectSoundBuffer쐬邩ǂ擾	*/
/* Get whether DirectSoundBuffer is supporting effects processing	*/
CriBool CRIAPI ADXPC_GetDsbCapsCtrlFx(void);

/* GtFNgݒ肷			*/
/* Enable effects on a buffer	*/
CriBool CRIAPI ADXPC_SetDsFx(
	ADXT adxt, CriSint32 count, LPDSEFFECTDESC effect, CriUint32 *result);

#ifdef __cplusplus
}
#endif

/***************************************************************************
 *      o[WƂ̌݊p
 *      For compatibility with old version
 ***************************************************************************/
#define ADXPC_SetupSound(obj)			ADXPC_SetupSoundDirectSound8(obj)
#define ADXPC_Setup3DSound()			ADXPC_SetDsbCapsCtrl3D(TRUE)
#define ADXPC_Shutdown3DSound()			ADXPC_SetDsbCapsCtrl3D(FALSE)
#define ADXPC_GetDsb(adxt, dsb)	\
	(*dsb) = (void *)ADXPC_GetDirectSoundBuffer8(adxt);
#define ADXPC_GetDirectSoundBuffer(adxt, dsb)	\
	(*dsb) = (void *)ADXPC_GetDirectSoundBuffer8(adxt);
#define ADXPC_SetSndBufGlobalFocus(mode)	\
	ADXPC_SetDsbCapsFocusMode(mode)
#define ADXPC_GetSndBufGlobalFocus()	ADXPC_GetDsbCapsFocusMode()
#define ADXPC_SetLocMode(mode)			ADXPC_SetDsbCapsLocMode(mode)
#define ADXPC_GetLocMode()				ADXPC_GetDsbCapsLocMode()
#define ADXPC_SPEAKER_FRONT_LEFT		ADXT_SPEAKER_FRONT_LEFT
#define ADXPC_SPEAKER_FRONT_RIGHT		ADXT_SPEAKER_FRONT_RIGHT
#define ADXPC_SPEAKER_FRONT_CENTER		ADXT_SPEAKER_FRONT_CENTER
#define ADXPC_SPEAKER_LOW_FREQUENCY		ADXT_SPEAKER_LOW_FREQUENCY
#define ADXPC_SPEAKER_BACK_LEFT 		ADXT_SPEAKER_BACK_LEFT
#define ADXPC_SPEAKER_BACK_RIGHT		ADXT_SPEAKER_BACK_RIGHT
#define ADXPC_GetSendSpeakerLevel(adxt, ch_id, spk_id)	\
	ADXT_GetSendSpeakerLevel(adxt, ch_id, spk_id)
#define ADXPC_SetSendSpeakerLevel(adxt, ch_id, spk_id, volume)	\
	ADXT_SetSendSpeakerLevel(adxt, ch_id, spk_id, volume)

#endif	/* #ifndef _ADXDSOUND8_H_INCLUDED */

/* --- end of file --- */
