/***************************************************************************
 *
 *  CRI Middleware
 *
 *  Copyright (c) 2001-2007 CRI-MW
 *
 *  Library : ADX Library (CRI ADX for PC)
 *  Module  : Functions for PC
 *  File    : adx_pc.h
 *
 ***************************************************************************/
/* Prevention of redefinition */
#ifndef _ADXPC_H_INCLUDED
#define _ADXPC_H_INCLUDED

/***************************************************************************
 *       o[W
 *       Version
 ***************************************************************************/
#define ADXPC_VER					"1.74"

/***************************************************************************
 *      CN[ht@C
 *      Include file
 ***************************************************************************/

/* Disable VC++ warning 
 *   In some cases, including windows.h, dsound.h causes the following warning:
 *       rpcasync.h(45) : warning C4115: '_RPC_ASYNC_STATE' : ...
 */
#if defined(_MSC_VER) && ((_MSC_VER >= 1200) && (_MSC_VER < 1300))
#pragma warning(push)
#pragma warning(disable:4115)
#endif

#include <windows.h>
#include <dsound.h>

#if defined(_MSC_VER) && ((_MSC_VER >= 1200) && (_MSC_VER < 1300))
#pragma warning(pop)
#endif

#include "cri_xpt.h"
#include "cri_adxt.h"

/***************************************************************************
 *      萔}N
 *      MACRO CONSTANT
 ***************************************************************************/
/* ftHgvCIeB */
/* Default thread priority */
#define ADXM_PRIO_VSYNC				(THREAD_PRIORITY_HIGHEST)		/* VsyncXbh */
#define ADXM_PRIO_FS				(THREAD_PRIORITY_ABOVE_NORMAL)	/* t@CXbh */
#define ADXM_PRIO_MWIDLE			(THREAD_PRIORITY_IDLE)			/* AChXbh */

/* X^bNTCY */
/* Thread stack size */
#define	ADXM_STACK_SIZE_VSYNC		(1024 * 1024)
#define	ADXM_STACK_SIZE_FS			(1024 * 1024)
#define	ADXM_STACK_SIZE_MWIDLE		(1024 * 1024)

/* fBNgT[h		*/
/* Mode of directory look-up	*/
#define ADXFIC_MODE_ALLDIR			(-1)
#define ADXFIC_MODE_CURRENT			(0)

/* ADXFICnhXe[^X	 */
/* Status of ADXFIC handle */
#define ADXFIC_STAT_STOP			(0)
#define ADXFIC_STAT_CACHING			(1)
#define ADXFIC_STAT_CACHEEND		(2)
#define ADXFIC_STAT_ERROR			(3)

/* ftHggx100					*/
/* Default of virtual vsync frequency x100	*/
#define ADXPC_DEF_VHZ100			(6000)

/***************************************************************************
 *      }N
 *      MACRO FUNCTIONS
 ***************************************************************************/
/* [N̈őTCYvZ}N */
/* Macro that calculates maximum work area size */
#define ADXFIC_CALC_WORK_SIZE(nfiles, max_flen) \
	((nfiles + 1) * (16 + maxflen) + 32)

/***************************************************************************
 *      f[^^錾
 *      Data type declaration
 ***************************************************************************/
/*--------------------------------------------------------------------------
 * t[[NʁiPCj
 * Type of framework
 *-------------------------------------------------------------------------*/
typedef enum {
	ADXM_FRAMEWORK_DEFAULT			= 0,
	ADXM_FRAMEWORK_PC_SINGLE_THREAD	= 1,
	ADXM_FRAMEWORK_PC_MULTI_THREAD	= 2,
} AdxmFramework;

/*--------------------------------------------------------------------------
 * XbhZbgAbvp[^iPCj
 * Thread setup parameter for PC
 *-------------------------------------------------------------------------*/
typedef struct {
	/* vCIeB */
	CriSint32			priority_vsync;		/* VsyncXbh */
	CriSint32 			priority_fs;		/* t@CXbh */
	CriSint32 			priority_mwidle;	/* AChXbh */
} AdxmThreadSprm;

/* Xbh̃ZbgAbvsۂ̒ӓ_									*/
/* (a) ZbgAbvp[^́At[[NƂ						*/
/* @@ADXM_FRAMEWORK_Pc_MULTI_THREADI񂾏ꍇ̂ݗLłB				*/
/* (b) ZbgAbvp[^́AADXM_SetupFramework֐Ɉprm			*/
/* @@ēn܂BNULLw肷ƃftHgݒ肪gp܂B			*/
/* Notes when setup of thread												*/
/* (a) If you need to apply custom framework setting, set the setup			*/
/*     parameter to ADXM_SetupFramework function as argument "prm".			*/
/*     When NULL is passed, the default setting is used.	 				*/
/* (b) The setup parameter is effective only when you chose 				*/
/*     ADXM_FRAMEWORK_PC_MULTI_THREAD as framework.							*/

/*--------------------------------------------------------------------------
 * t@CVXẽZbgAbvp[^\
 * Parameter structure for file system setup function
 *-------------------------------------------------------------------------*/
typedef struct {
	CriChar8	*rtdir;				/* [gfBNg	*/
								/* Root directory		*/
} AdxpcSprmFs;

/*--------------------------------------------------------------------------
 * t@CLbVnhiADXFICnhj
 * File information cache handle (ADXFIC handle)
 *-------------------------------------------------------------------------*/
typedef void *ADXFIC;

/*--------------------------------------------------------------------------
 * VVXepIuWFNg̎
 * Kind of the object for Vsync system
 *-------------------------------------------------------------------------*/
typedef enum {
	ADXPC_VIDEO_NONE = 0x00,
	ADXPC_VIDEO_DDRAW7 = 0x01,		// DirectDraw7
	ADXPC_VIDEO_D3D8 = 0x02,		// Direct3D8
} ADXPC_VIDEO;

/***************************************************************************
 *      ϐ錾
 *      Prototype Function 
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Prototype Function 
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus

/***
*			t[[Nݒ֐
*			Framework setting function
***/

/* CRI~hEFÃt[[NZbgAbv */
/* Setup the framework */
CriBool CRIAPI ADXM_SetupFramework(AdxmFramework framework, void *prm);

/* CRI~hEFÃt[[N̏I */
/* Shutdown the framework */
CriBool CRIAPI ADXM_ShutdownFramework(void);

/***
 *          Xbh֌W
 *          Thread
 ***/
 
/* ADXT[o֐(Xbhp)							*/
/* ADX server function(for using ADX without thread)	*/
void CRIAPI ADXPC_ExecServer(void);

/* ADXT[o֐(Xbhp)						*/
/* ADX server function(for using ADX with thread)	*/
CriBool CRIAPI ADXPC_ExecServerEx(void *obj);

/***
 *          t@C֌W
 *          File proseccing
 ***/

/* t@CVXẽZbgAbv	*/
/* Set up the file system			*/
void CRIAPI ADXPC_SetupFileSystem(AdxpcSprmFs *sprmd);

/* t@CVXẽVbg_E	*/
/* Shut down the file system		*/
void CRIAPI ADXPC_ShutdownFileSystem(void);

/***
 *          V֌W
 *          V-Sync system
 ***/

/* VVXeZbgAbv	*/
/* Set up the V-Sync system		*/
CriSint32 CRIAPI ADXPC_SetupVsync(void *video_obj, CriSint32 mode);

/* VVXeVbg_E	*/
/* Shut down the V-Sync system		*/
CriBool CRIAPI ADXPC_ShutdownVsync(void);

/* VVXeĐݒ	*/
/* Reset the V-Sync system	*/
CriSint32 CRIAPI ADXPC_ResetVsync(void);

/* ADXT[o[VBlankǂꂾ炷ݒ	*/
/* Set ADX server offset from VBlank				*/
void CRIAPI ADXPC_SetSvrOffset(CriSint32 offset_msec);

/* zVg̐ݒi1/100HzPʁA60HzȂ6000j				*/
/* Set virtual Vsync frequency	(in unit of 1/100Hz, 60Hz=6000)	*/
void CRIAPI ADXPC_SetVirtualVhz(CriUint32 vhz100);

/* zVg̎擾			*/
/* Get virtual Vsync frequency	*/
CriUint32 CRIAPI ADXPC_GetVirtualVhz(void);

/* Present^C~O̒ʒm */
void CRIAPI ADXPC_NotifyPresentTiming(void);

/* Present^C~O}[W̐ݒ [%] */
void CRIAPI ADXPC_SetPresentTimingMargin(CriSint32 margin);

/***
 *          t@CLbVOp֐
 *          Functions for file information cache
 ***/

/* FIC̏	*/
/* Initialize FIC	*/
void CRIAPI ADXFIC_Init(void);

/* I		*/
/* Finish FIC	*/
void CRIAPI ADXFIC_Finish(void);

/* Ɨ̈TCY̎擾		*/
/* Get size of work area	*/
CriSint32 CRIAPI ADXFIC_GetWorkSize(const CriChar8 *dname, CriSint32 mode);

/* ADXFICnh̍쐬	*/
/* Create ADXFIC handle	*/
ADXFIC CRIAPI ADXFIC_Create(const CriChar8 *dname, CriSint32 mode, void *work, CriSint32 wksize);

/* ADXFICnh̏		*/
/* Destroy ADXFIC handle	*/
void CRIAPI ADXFIC_Destroy(ADXFIC fic);

/* LbVOꂽt@C̎擾	*/
/* Get number of cached files			*/
CriSint32 CRIAPI ADXFIC_GetNumFiles(ADXFIC fic);

/* pĂƗ̈TCY̎擾	*/
/* Get size of used work area			*/
CriSint32 CRIAPI ADXFIC_GetUsedWkSize(ADXFIC fic);

/* t@CTsfBNg̎擾 */
/* Get directory name for look-up			*/
CriChar8 * CRIAPI ADXFIC_GetDirName(ADXFIC fic);

/* LbVOꂽt@C̃TCY擾iZN^Pʁj	*/
/* Get size of cached file (sector)							*/
CriSint32 CRIAPI ADXFIC_GetFsizeSct(ADXFIC fic, const CriChar8 *fname);

/* LbVOꂽt@C̃TCY擾ioCgPʁj	*/
/* Get size of cached file (Byte)							*/
CriSint64 CRIAPI ADXFIC_GetFileSize(ADXFIC fic, const CriChar8 *fname);

/* t@CLbVĂ邩ǂ̃`FbN */
/* Check whether the file is cached					*/
CriBool CRIAPI ADXFIC_IsFileCached(const CriChar8 *fname);

/* wt@C̃LbV		*/
/* Disable caching of specified file	*/
void CRIAPI ADXFIC_DisableFile(ADXFIC fic, const CriChar8 *fname);

/* wt@C̃LbVL		*/
/* Enable chaching of specified file	*/
void CRIAPI ADXFIC_EnableFile(ADXFIC fic, const CriChar8 *fname);

/* Xe[^X̎擾	*/
/* Get state		*/
CriSint32 CRIAPI ADXFIC_GetStat(ADXFIC fic);

/***
 *          ̑
 *          Others
 ***/

/* o[W̎擾	*/
/* Get version string		*/
CriChar8 * CRIAPI ADXPC_GetVersion(void);

/***
 *          fobOp
 *          For debugging
 ***/

#ifdef _DEBUG

/* t@C̃fobOo	*/
/* Print cached file names	*/
void CRIAPI ADXFIC_DebugPrintFlist(ADXFIC fic);

/* SẴt@C̃fobOo */
/* Print all cached file names	*/
void CRIAPI ADXFIC_DebugPrintFlistAll(void);

#endif	// #ifdef _DEBUG

#ifdef __cplusplus
}
#endif	// __cplusplus

/***************************************************************************
 *      o[WƂ̌݊p
 *      For compatibility with old version
 ***************************************************************************/
#define ADXPC_SetupThrd(tprm)			ADXM_SetupThrd(tprm)
#define ADXPC_SetupThread(tprm)			ADXM_SetupThrd(tprm)
#define ADXPC_ShutdownThread()			ADXM_ShutdownThrd()
#define ADXPC_SPRM_DVD					AdxpcSprmFs
#define ADXPC_SPRM_WINFS				AdxpcSprmFs
#define ADXPC_SPRM_ANSI					AdxpcSprmFs
#define ADXPC_SetupWinFs(prm)			ADXPC_SetupFileSystem(prm)
#define ADXPC_SetupDvdFs(prm)			ADXPC_SetupFileSystem(prm)
#define ADXPC_SPRM_WINFS				AdxpcSprmFs
#define ADXPC_SPRM_DVD					AdxpcSprmFs
#define ADXPC_SPRM_ANSI					AdxpcSprmFs
#define ADXPC_SetupWinFs(prm)			ADXPC_SetupFileSystem(prm)
#define ADXPC_SetupDvdFs(prm)			ADXPC_SetupFileSystem(prm)
#define ADXPC_SetupAnsiFs(prm)			ADXPC_SetupFileSystem(prm)
#define ADXPC_ShutdownWinFs()			ADXPC_ShutdownFileSystem()
#define ADXPC_ShutdownDvdFs()			ADXPC_ShutdownFileSystem()
#define ADXPC_ShutdownAnsiFs()			ADXPC_ShutdownFileSystem()

#endif	// #ifndef _ADXPC_H_INCLUDED

/* end of file */
