#ifndef	_ADXT_H_INCLUDED
#define	_ADXT_H_INCLUDED
/****************************************************************************/
/*																			*/
/*			$title$ `cwf[^Đ Cu								*/
/*					ADXT (ADX TALK) Library									*/
/*																			*/
/*				1997.2.25		written M.Oshimi							*/
/*																			*/
/****************************************************************************/

/* This is a meaningless comment line for avoiding Warning C4819. */

/*	Version number of ADXT library 		*/
#define	ADXT_VER	"10.67"

/*	Include Files	*/
#include "cri_xpt.h"
#include "sj.h"

/*	Xg[Rg[				*/
/*	Stream Controller					*/
#ifndef ADXSTM_DEFINED
#define ADXSTM_DEFINED
typedef	void	*ADXSTM;
#endif

/*	Xg[WCgfR[_		*/
/*	Stream Joint decoder				*/
#ifndef ADXSJD_DEFINED
#define ADXSJD_DEFINED
typedef void	*ADXSJD;
#endif

/*	I[fBI_					*/
/*	Audio Renderer						*/
#ifndef ADXRNA_DEFINED
#define ADXRNA_DEFINED
typedef void	*ADXRNA;
#endif

#ifndef TRUE
#define TRUE	1
#endif
#ifndef FALSE
#define FALSE	0
#endif

/****************************************************************************/
/*		萔}N															*/
/*		MACRO CONSTANT														*/
/****************************************************************************/

/*	ő哯						*/
/*	Maximum number of ADXT handle		*/
/*
#if defined(XPT_TGT_PC)
#define	ADXT_MAX_OBJ		(32)
#else
#define	ADXT_MAX_OBJ		(16)
#endif
*/

/*	őf[^TCY					*/
/*	Maximum data size					*/
#define	ADXT_MAX_DATASIZE	(0x40000000)

/*	̓obt@̃GLXg̈̑傫	*/
/*	Size of Extra area in input buffer		*/
#define ADXT_IBUF_XLEN (36)

/*	ADX Talk ̏o̓obt@̑傫@iTvPʁj	*/
/*	Output buffer size of ADX Talk (unit:sample)		*/
#if defined (XPT_TGT_NITRO)
#define	ADXT_OBUF_SIZE	(0x0800)
#else
#define	ADXT_OBUF_SIZE	(0x2000)
#endif

#if !defined(XPT_TGT_PC_LE)
#define DECODE_AHX
#endif

#ifdef DECODE_AHX
#if defined (XPT_TGT_NITRO)
#define	ADXT_OBUF_DIST	(0x0860)
#else
#define	ADXT_OBUF_DIST	(0x2060)
#endif
#else
#define	ADXT_OBUF_DIST	(0x2020)
#endif

/*	őTvOg				*/
/*	Maximum sampling frequency			*/
#define	ADXT_MAX_SFREQ	(48000)

/*	ADX Talk̍Đ	(ADXT_CALC_WORK}NŎgp)		*/
/*	Play method of ADX Talk (used 'ADXT_CALC_WORK' macro)	*/
#define ADXT_PLY_MEM	(0)			/*	̍Đ					*/
									/*	Play memory data					*/
#define ADXT_PLY_STM	(1)			/*	CD̃Xg[Đ				*/
									/*	Stream play from CD-ROM				*/

#if	defined(XPT_TGT_NITRO)
/* ROMfBA̓ǂݍ */
#define ADXT_CALC_IBUFSIZE0(nch, sfreq)	( 2500*(nch)*((sfreq)/1000)/16)
#else
#define ADXT_CALC_IBUFSIZE0(nch, sfreq)	(25000*(nch)*((sfreq)/1000)/44)
#endif

#define ADXT_CALC_IBUFSIZE(nch, nstm, sfreq)	\
	((ADXT_CALC_IBUFSIZE0(nch, sfreq)*((nstm)+1)+2048)/2048*2048+ADXT_IBUF_XLEN)

#if defined(XPT_TGT_GC) || defined(XPT_TGT_WII)
#define	ADXT_RNABUF_SIZE	(0x1000)
#define ADXT_CALC_OBUFSIZE(nch)	\
	( (ADXT_OBUF_DIST+ADXT_RNABUF_SIZE)*(nch)*sizeof(CriSint16))
#elif defined(XPT_TGT_NITRO)
#define	ADXT_RNABUF_SIZE	(6*1024/2)
#define ADXT_CALC_OBUFSIZE(nch)	\
	( (ADXT_OBUF_DIST+ADXT_RNABUF_SIZE)*(nch)*sizeof(CriSint16))
#elif defined(XPT_TGT_KTZEVIO)
#define	ADXT_RNABUF_SIZE	(8 * 1024)
#define ADXT_CALC_OBUFSIZE(nch)	\
	((ADXT_OBUF_DIST+ADXT_RNABUF_SIZE) * (nch) * sizeof(CriSint16))
#else
#define ADXT_CALC_OBUFSIZE(nch)	\
	( ADXT_OBUF_DIST*(nch)*sizeof(CriSint16))
#endif

#if defined(XPT_TGT_EE) || defined(XPT_TGT_GC) || defined(XPT_TGT_WII)
#define ADXT_PL2BUF_SIZE	(1024)
#else
#define ADXT_PL2BUF_SIZE	(0)
#endif

#define ADXT_3D_MAX_NCH_IBUF	(1)

#if defined(XPT_TGT_EE) || defined(XPT_TGT_GC) || defined(XPT_TGT_PC) || defined(XPT_TGT_WII)
#define ADXT_3D_MAX_NCH_OBUF	(2)
#else
#define ADXT_3D_MAX_NCH_OBUF	(1)
#endif

#define ADXT_CALC_WORK(nch, stmflg, nstm, sfreq)	\
	(ADXT_CALC_IBUFSIZE(nch, nstm, sfreq) * (stmflg) + ADXT_CALC_OBUFSIZE(nch) + 64)

#define ADXT_CALC_IBUFSIZE_3D(nstm, sfreq)	\
	(ADXT_CALC_IBUFSIZE(ADXT_3D_MAX_NCH_IBUF, nstm, sfreq))

#define ADXT_OBUFSIZE_3D	(ADXT_CALC_OBUFSIZE(ADXT_3D_MAX_NCH_OBUF))

#define ADXT_CALC_WORK_3D(stmflg, nstm, sfreq)	\
	(ADXT_CALC_IBUFSIZE_3D(nstm, sfreq) * (stmflg) + ADXT_OBUFSIZE_3D + ADXT_PL2BUF_SIZE + 64)

/*	f[^eʂ̌vZ		*/
/*	Calc ADX Data size		*/
#define	ADXT_CalcDataLen(sec, nch, sfreq)	((sec)*(nch)*(sfreq)*18/32 + 256)

/* AHX[N̈TCY		*/
/* Work size of AHX 		*/
#if defined(XPT_TGT_EE) || defined(XPT_TGT_PSP) || defined(XPT_TGT_NITRO)
#define ADXT_WORKSIZE_AHX	(6144)		/* 6KB */
#else
#define ADXT_WORKSIZE_AHX	(8192)		/* 8KB */
#endif

/*	̓obt@ւ̓ǂݍݗ						*/
/*	Number of sectors to read into the input buffer	*/
#define ADXT_MAX_CDBSCT		(75)
#define ADXT_MIN_CDBSCT		(65)
#define ADXT_PREP_RDSCT		(25)

/*	$define$ ADX Talk̓(ADXT_STAT_`)	*/
/*	Status of ADX Talk							*/
#define	ADXT_STAT_STOP		(0)		/*	~ 								*/
									/*	During standstill					*/
#define ADXT_STAT_DECINFO	(1)		/*	`cw ̃wb_擾			*/
									/*	Getting header information			*/
#define ADXT_STAT_PREP		(2)		/*	Đ 							*/
									/*	During play preparation				*/
#define ADXT_STAT_PLAYING	(3)		/*	fR[hĐ 					*/
									/*	During decode and play				*/
#define ADXT_STAT_DECEND	(4)		/*	fR[hI 						*/
									/*	Decode end							*/
#define ADXT_STAT_PLAYEND	(5)		/*	ĐI 							*/
									/*	Play end							*/
#define ADXT_STAT_ERROR		(6)		/*	ǂݍ݃G[					*/
									/*	Read-in error outbreak state		*/

/*	$define$ ADX Talk̃G[R[h@(ADXT_ERR_`)	*/
/*	Error code of ADX Talk							*/
#define	ADXT_ERR_OK			(0)		/*	 								*/
									/*	Normality							*/
#define ADXT_ERR_SHRTBUF	(-1)	/*	̓obt@GveB				*/
									/*	The input buffer is empty			*/
#define ADXT_ERR_SNDBLK		(-2)	/*	TEhubNG[				*/
									/*	Error of sound block				*/

/*	$define$ tB^[h	(ADXT_FLTMODE_`)		*/
/*	Filter mode										*/
#define	ADXT_FLTMODE_CPU	(0)		/*	botɂWJ[h				*/
									/*	by CPU								*/
#define	ADXT_FLTMODE_SCSP	(1)		/*	AICA-DSPɂWJ[h			*/
									/*	by AICA-DSP							*/

/*	$define$ Đ[h	(ADXT_PMODE_`)				*/
/*	Play mode										*/
#define	ADXT_PMODE_FNAME	(0)		/*	t@C܂ FID ɂw		*/
									/*	Play specified file name or file ID	*/
#define	ADXT_PMODE_AFS		(1)		/*	AFS ɂw						*/
									/*	Play specified AFS file				*/
#define	ADXT_PMODE_MEM		(2)		/*	Đ							*/
									/*	Play data from memory				*/
#define	ADXT_PMODE_SJ		(3)		/*	Xg[WCgĐ			*/
									/*	Play data from StreamJoint			*/
#define	ADXT_PMODE_SLFILE	(4)		/*	V[XAĐit@Cj		*/
									/*	Seamless continuous play from file	*/

/*	$define$ G[Jo[[h	(ADXT_RMODE_`)	*/
/*	Mode of error recovery							*/
#define	ADXT_RMODE_NOACT	(0)		/*	Jo[Ȃ					*/
									/*	Do not recover						*/
#define	ADXT_RMODE_STOP		(1)		/*	~							*/
									/*	Automatic stop						*/
#define	ADXT_RMODE_REPLAY	(2)		/*	ăvC						*/
									/*	Automatic replay					*/

/*	p|bg̐ݒl		*/
/*	Panpot parameter		*/
#define	ADXT_PAN_LEFT		(-15)
#define	ADXT_PAN_CENTER		(0)
#define	ADXT_PAN_RIGHT		(15)
#define	ADXT_PAN_AUTO		(-128)	/*	MONO/STE ɂĎIɐ؂ւ	*/
									/*	Changes automatically by data		*/

/*	oX̐ݒl		*/
/*	Panpot parameter		*/
#define	ADXT_BALANCE_LEFT		(-15)
#define	ADXT_BALANCE_CENTER		(0)
#define	ADXT_BALANCE_RIGHT		(15)

/*	XeIĐ̃`lԍ		*/
/*	Channel number playing stereo data	*/
/*	ADXT_CH_L:left, ADXT_CH_R:right		*/
#define	ADXT_CH_L			(0)
#define	ADXT_CH_R			(1)

/*	}``lĐpXs[J[ID				*/
/*	Speaker IDs for multi-channel audio playback	*/
#define ADXT_SPEAKER_FRONT_LEFT			(0)
#define ADXT_SPEAKER_FRONT_RIGHT		(1)
#define ADXT_SPEAKER_BACK_LEFT 			(2)
#define ADXT_SPEAKER_BACK_RIGHT			(3)
#define ADXT_SPEAKER_FRONT_CENTER		(4)
#define ADXT_SPEAKER_LOW_FREQUENCY		(5)

/*	_E~bNX̕@	*/
/*	Method of downmix */
#define ADXT_DOWNMIX_NONE				(0)
#define ADXT_DOWNMIX_MONO				(1)
#define ADXT_DOWNMIX_STEREO				(2)

/*	őĐ`l				*/
/*	Maximum number of play channel		*/
#define	ADXT_MAX_NCH		(2)

/*	T[o֐̌Ăяopx̋Kl@60i/bj				*/
/*	Default value of frequency called server function(times/sec)	*/
#define ADXT_DEF_SVRFREQ	(60)

/*	Default value of output volume(0.1dB)	*/
#define	ADXT_DEF_OUTVOL		(0)			/*	  0 dB	*/
#define	ADXT_MAX_OUTVOL		(0)			/*	  0 dB	*/
#define	ADXT_MIN_OUTVOL		(-960)		/*	-96 dB	*/

/*	̓obt@̉l (G[pAPʃoCgj				*/
/*	Minimum data in the input buffer(byte) (for coping with error)	*/
#define	ADXT_MIN_BUFDATA	(64)

/*	G[ʎԁ@iP:b)			*/
/*	Error distinction time(sec)			*/
#define	ADXT_EWAIT_PLY		(5)
#define	ADXT_EWAIT_NOTPLY	(20)

/*	CfbNX̍ő吔				*/
/*	Maximum number of index				*/
#define	ADXT_MAX_IDX		(0xFFFF)

/*	ADXtH[}bg^Cv				*/
/*	Format type of ADX					*/
#define ADXT_FMT_ADX		(1)
#define ADXT_FMT_AHX		(2)

/*	t@C̍ő咷	*/
/*	Maximum length of the file path		*/
#define	ADXT_MAX_FNAME		(256)

/*	fR[hG[[h	*/
/*	Decode error mode		*/
#define	ADXT_DECERR_MODE_ERRCB	(0)		/*	G[R[obN	*/
										/*	Error callback		*/
#define	ADXT_DECERR_MODE_STAT	(1)		/*	nh		*/
										/*	Handle state		*/

/****************************************************************************/
/*		f[^^															*/
/*      Data type declaration												*/
/****************************************************************************/

/*	ADX Talk IuWFNg\		*/
/*	Structure of ADX Talk object	*/
typedef struct _adx_talk {
	CriSint8	used;						/*	gpۂ					*/
	CriSint8	stat;						/*							*/
	CriSint8	pmode;						/*	Đ[h						*/
	CriSint8	maxnch;						/*	őĐ`l			*/
	ADXSJD	sjd;						/*	ADXXg[WCgfR[_	*/
	ADXSTM	stm;						/*	̓Xg[Rg[		*/
	ADXRNA	rna;						/*	I[fBI_				*/
	SJ		sjf;						/*	t@C̓Xg[WCg*/
	SJ		sji;						/*	̓Xg[WCg		*/
	SJ		sjo[ADXT_MAX_NCH];			/*	o̓Xg[WCg		*/
	CriSint8	*ibuf;						/*	̓obt@					*/
	CriSint32	ibuflen;					/*	̓obt@TCYioCgP)	*/
	CriSint32	ibufxlen;					/*	̓obt@GNXgTCY	*/
	CriSint16	*obuf;						/*	o̓obt@					*/
	CriSint32	obufsize;					/*	o̓obt@TCYiTvj	*/
	CriSint32	obufdist;					/*	o̓obt@ԊuiTvj	*/
	CriSint32	svrfreq;					/*	T[o֐Ăяopx			*/
	CriSint16	maxsct;						/*	̓obt@̍ōZN^	*/
	CriSint16	minsct;						/*	̓obt@̍ŒZN^	*/
	CriSint16	outvol;						/*	o̓{[					*/
	CriSint16	outpan[ADXT_MAX_NCH];		/*	o̓p|bg̐ݒl			*/
	CriSint16	outbalance;					/*	o̓oX̐ݒl			*/
	CriSint32	maxdecsmpl;					/*	őfR[hTv			*/
	CriSint32	lpcnt;						/*	[vJE^					*/
	CriSint32	lp_skiplen;					/*	[vXLbvoCg			*/
	CriSint32	trp;						/*	gX|[Y (Zg)		*/
	CriSint32	wpos;						/*	fBȀ݈ʒu		*/
	CriSint32	mofst;						/*	fBÃItZbg			*/
	CriSint16	ercode;						/*	G[R[h					*/
	CriSint32	edecpos;					/*	G[opfR[hʒu		*/
	CriSint16	edeccnt;					/*	fR[hʒuJE^			*/
	CriSint16	eshrtcnt;					/*	ޯ̧è			*/
	CriSint8	lpflg;						/*	[v邩ۂ				*/
	CriSint8	autorcvr;					/*	IɃG[A邩ۂ	*/
	CriSint8	fltmode;					/*	tB^[h					*/
	CriSint8	execflag;					/*	T[os邩ۂ			*/
	CriSint8	pstwait_flag;				/*	o͊Jn҂tO			*/
	CriSint8	pstready_flag;				/*	o͏tO			*/
	CriSint8	pause_flag;					/*	ꎞ~tO					*/
	CriSint8	auto_pause_flag;			/*	ꎞ~tOiWiipj		*/
	void	*amp;						/*	Uo						*/
	SJ		ampsji[ADXT_MAX_NCH];		/*	UopSJ				*/
	SJ		ampsjo[ADXT_MAX_NCH];		/*	UopoSJ				*/
	CriSint32	time_ofst;					/*	̃ItZbg				*/
	CriSint32	lesct;						/*	[vĐ̍ŏIZN^ԍ	*/
	CriSint32	trpnsmpl;					/*			gbvTvԍ	*/
	void	*lsc;						/*	AXg[Rg[		*/
	CriSint8	lnkflg;						/*	AĐtO					*/
	CriSint8	rsv;						/*	\							*/
	CriSint16	rsv2;						/*	\Q							*/
	CriUint32 tvofst;						/*	X^[gԃItZbg			*/
	CriUint32 svcnt;						/*	X^[gV-SyncJEg			*/
	CriUint32 decofst;						/*	g[^fR[hItZbg		*/
	#ifdef __EE__
	CriSint32	flush_nsmpl;				/*	tbVɑ}Tv	*/
	#endif
	CriSint8 stm_start_flg;				/*	Xg[JntO			*/
	CriSint8 ainf_sw;						/*	tXCb`(1=L 0=)	*/
	CriSint16 rsv4;						/*	\							*/
	CriChar8 *fname_wk;					/*	t@C̈@(work)		*/
	CriChar8 *fname;						/*	t@C						*/
	void *dir;							/*	fBNgnh			*/
	CriUint32 ofst;						/*	ItZbgiZN^P)			*/
	CriUint32 nsct;						/*	͈ iZN^P)				*/
	//	2005.2.14 added by M.Oshimi
	CriUint32 lpoff_len;					/*	[vItLɂȂfR[h*/
} ADX_TALK;
typedef	ADX_TALK	*ADXT;

/*	CfbNXf[^	*/
/*	Index data			*/
typedef struct _adxt_idx {
	CriUint16 nidx;
	CriUint16 top;
} ADXT_IDX;

/*	Xbhp[^\		*/
/*	Parameter structure of Thread Param	*/
typedef struct {
	int	prio_lock;		/* Lock Thread priority				*/
	int	prio_safe;		/* Safe Thread priority				*/
	int	prio_vsync;		/* Vsync Thread priority			*/
	int	prio_fs;		/* Filesystem Thread priority		*/
	int	prio_main;		/* Main Thread Normary priority		*/
	int	prio_mwidle;	/* Middleware Idle Thread priority	*/
} ADXM_TPRM;

/*	Xbhp[^\(g)				*/
/*	Parameter structure of Extended Thread Param	*/
typedef struct {
	int	prio_lock;		/* Lock Thread priority				*/
	int	prio_safe;		/* Safe Thread priority				*/
	int	prio_usrvsync;	/* User Vsync Thread priority		*/
	int	prio_vsync;		/* Vsync Thread priority			*/
	int	prio_fs;		/* Filesystem Thread priority		*/
	int	prio_main;		/* Main Thread Normary priority		*/
	int	prio_mwidle;	/* Middleware Idle Thread priority	*/
	int	prio_usridle;	/* User Idle Thread priority		*/
	
	void  *stkptr_usrvsync;	/* User Vsync Stack buffer address(In NULL, stack size is 4KB)	*/
	CriSint32 stksize_usrvsync;/* User Vsync Stack size										*/
	void  *stkptr_usridle;	/* User Idle Stack buffer address(In NULL, stack size is 8KB)	*/
	CriSint32 stksize_usridle;	/* User Idle Stack size											*/
} ADXM_TPRM_EX;

/*	ADXwb_\					*/
/*	Parameter structure of ADX header	*/
typedef struct {
	CriSint32 fmt;			/* Format type (ADX/AHX)			*/
	CriSint32 sfreq;		/* Sampling rate					*/
	CriSint32 nch;			/* Number of channel				*/
	CriSint32 bps;			/* Number of bit per sample			*/
	CriSint32 nsmpl;		/* Total number of sample			*/
	CriSint32 lptype;		/* Loop type						*/
	CriSint32 lpstart;		/* Loop start position				*/
	CriSint32 lpend;		/* Loop end position				*/
} ADXHINFO;


/* Callback funtion */
typedef void (*ADXM_CBFN)(void *obj);

/****************************************************************************/
/*		֐̐錾															*/
/*      Function Declaration												*/
/****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* $func$ Cuo[W̎擾
 * [@] CriChar8 *ADXT_GetVersion(void);
 * [@] Ȃ
 * [o@] Ȃ
 * [֐l] o[W
 * [@@\] ADXCũo[W擾B
 *  Gets the version of library
 * [Inputs  ] None
 * [Outputs ] None
 * [Return  ] Version string
 * [Function] Gets the version string of ADX library.
 */
CriChar8 * CRIAPI ADXT_GetVersion(void);

/* $func$ ADX Talk ̏
 * [@] void ADXT_Init(void);
 * [@] Ȃ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ADX Talk B
 *			ϐ̈̏sB
 *  Initialization of ADX Talk
 * [Inputs  ] None
 * [Outputs ] None
 * [Return  ] None
 * [Function] Initializes ADX Talk. Initializes variable.
 */
void CRIAPI ADXT_Init(void);

/* $func$ ADX Talk̏I
 * [@] void ADXT_Finish(void);
 * [@] Ȃ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ADX Talk ̏IB
 *  Termination of ADX Talk
 * [Inputs  ] None
 * [Outputs ] None
 * [Return  ] None
 * [Function] Finalizes ADX Talk.
 */
void CRIAPI ADXT_Finish(void);

/*	$func$ ׂĂADXTnh̏
 * [@] void ADXT_DestroyAll(void);
 * [@] Ȃ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ׂĂADXTnhB
 * [Inputs  ] None
 * [Outputs ] None
 * [Return  ] None
 * [Function] You can destroy all ADXT handles.
 */
void CRIAPI ADXT_DestroyAll(void);

/*	$func$ ׂĂADXTADXFnh̏
 * [@] void ADXT_CloseAllHandles(void);
 * [@] Ȃ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ׂĂADXTnhADXFnhB
 * [Inputs  ] None
 * [Outputs ] None
 * [Return  ] None
 * [Function] You can destroy all ADXT handles and close all ADXF handles.
 */
void CRIAPI ADXT_CloseAllHandles(void);

/*	$func$ ADXTnh ̐
 * [@] ADXT ADXT_Create(CriSint32 maxnch, void *work, CriSint32 worksize);
 * [@] maxnch	: őĐ`lim݂̂PFXeIQj
 *			work	: [N̈
 *			worksize: [N̈̃TCY
 * [o@] Ȃ
 * [֐l] ADXTnh
 * [@@\] ADXTnh𐶐B
 *			work̈̃TCÝAADXT_CALC_WORK}Nɂċ߂B
 *  Creation of ADXT handle
 * [Inputs  ] maxnch  : Number of maximum channels(monoral:1, stereo:2)
 *			  work    : Working area
 *			  worksize: Size of working area(byte)
 * [Outputs ] None
 * [Return  ] ADXT handle
 * [Function] Creates ADXT handle.
 * [Remarks ] You calculate size of working area used 'ADXT_CALC_WORK' macro. 
 */
ADXT CRIAPI ADXT_Create(CriSint32 maxnch, void *work, CriSint32 worksize);

/*	$func$ ADXT 3Dnh̐
 * [@] ADXT_Create3D(void *work, CriSint32 worksize);
 * [@] work	: [N̈
 *			worksize: [N̈̃TCY
 * [o@] Ȃ
 * [֐l] ADXTnh
 * [@@\] ADXTnh𐶐B
 *			work̈̃TCÝAADXT_CALC_WORK_3D}Nɂċ߂B
 *  Creation of ADXT 3D handle
 * [Inputs  ] work    : Working area
 *			  worksize: Size of working area(byte)
 * [Outputs ] None
 * [Return  ] ADXT handle
 * [Function] Creates ADXT handle.
 * [Remarks ] You calculate size of working area used 'ADXT_CALC_WORK_3D' macro. 
 */
ADXT CRIAPI ADXT_Create3D(void *work, CriSint32 worksize);

/* $func$ ADXTnh ̏
 * [@] void ADXT_Destroy(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] w肳ꂽ ADXTnhB
 *  Destroy of ADXT handle
 * [Inputs  ] adxt   : ADXT handle
 * [Outputs ] None
 * [Return  ] None
 * [Function] Destroys specified ADXT handle.
 */
void CRIAPI ADXT_Destroy(ADXT adxt);

/* $func$ FID wɂĐ̊Jn
 * [@] void ADXT_StartAfs(ADXT adxt, CriSint32 patid, CriSint32 fid);
 * [@] adxt	: ADXTnh
 *			patid	: p[eBVʎq
 *			fid		: t@Cʎq
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] p[eBVʎqƃt@CʎqŎw肳ꂽ`cwt@C
 *			ĐJnB
 *  Play start of ADX data by specified file ID
 * [Inputs  ] adxt	: ADXT handl
 *			  patid	: Partition ID
 *			  fid	: File ID
 * [Outputs ] None
 * [Return  ] None
 * [Function] Starts to play ADX file when you specify partition ID and file ID.
 */
void CRIAPI ADXT_StartAfs(ADXT adxt, CriSint32 patid, CriSint32 fid);

/* $func$ t@CwɂĐ̊Jn
 * [@] void ADXT_StartFname(ADXT adxt, const CriChar8 *fname);
 * [@] adxt	: ADXTnh
 *			fname	: t@C
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] fname Ŏw肳ꂽ`cwt@C̍ĐJnB
 *  Play start of ADX data specified file name
 * [Inputs  ] adxt	: ADXT handle
 *			  fname	: File name
 * [Outputs ] None
 * [Return  ] None
 * [Function] Starts to play ADX file when you specify file name.
 */
void CRIAPI ADXT_StartFname(ADXT adxt, const CriChar8 *fname);

/* $func$ t@CwɂĐ̊Jn
 * [@] void ADXT_StartFnameRange(ADXT adxt, CriChar8 *fname, CriSint32 offset_sct, CriSint32 range_sct);
 * [@] adxt	: ADXTnh
 *			fname	: t@C
 *			offset_sct	: t@C̃ItZbgiZN^Pʁj
 *			range_sct	: ͈́iZN^Pʁj
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] fname Ŏw肳ꂽ`cwt@C̍ĐJnB
 *  Play start of ADX data specified file name
 * [Inputs  ] adxt	: ADXT handle
 *			  fname	: File name
 *			  offset_sct	: File offset from top of the file as a sector
 *			  range_sct		: File range as a sector
 * [Outputs ] None
 * [Return  ] None
 * [Function] Starts to play ADX file when you specify file name and the range as a sector.
 */
void CRIAPI ADXT_StartFnameRange(ADXT adxt, const CriChar8 *fname, CriSint32 offset_sct, CriSint32 range_sct);

/* $func$ Xg[WCgɂĐ̊Jn
 * [@] void ADXT_StartSj(ADXT adxt, SJ sj);
 * [@] adxt	: ADXTnh
 *			sj		: Xg[WCg
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] Xg[WCg瓾f[^ĐB
 *  Play start of ADX data from Stream Joint
 * [Inputs  ] adxt	: ADXT handle
 *			  sj	: Stream Joint
 * [Outputs ] None
 * [Return  ] None
 * [Function] Starts to play ADX file when you specify Stream Joint.
 */
void CRIAPI ADXT_StartSj(ADXT adxt, SJ sj);

/* $func$ wɂĐ̊Jn
 * [@] void ADXT_StartMem(ADXT adxt, void *adxdat);
 * [@] adxt	: ADXTnh
 *			adxdat	: `cwf[^̃AhX
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] adxdatŎw肳ꂽ`cwf[^ĐB
 *  Play start of ADX data on memory
 * [Inputs  ] adxt	: ADXT handle
 *			  adxdat: Address of ADX data
 * [Outputs ] None
 * [Return  ] None
 * [Function] Starts to play ADX data on memory when you specify address.
 */
void CRIAPI ADXT_StartMem(ADXT adxt, void *adxdat);

/* $func$ wɂĐ̊Jn
 * [@] void ADXT_StartMem2(ADXT adxt, void *adxdat, CriSint32 datlen);
 * [@] adxt	: ADXTnh
 *			adxdat	: `cwf[^̃AhX
 *			datlen	: `cwf[^̑傫
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] adxdata Ŏw肳ꂽ`cwf[^ĐB
 *  Play start of ADX data on memory (TYPE 2)
 * [Inputs  ] adxt	: ADXT handle
 *			  adxdat: Address of ADX data
 *			  datlen: Length of playing ADX data
 * [Outputs ] None
 * [Return  ] None
 * [Function] Starts to play ADX data on memory. Plays to specified length.
 */
void CRIAPI ADXT_StartMem2(ADXT adxt, void *adxdat, CriSint32 datlen);

/* $func$ wɂĐ̊Jn
 * [@] void ADXT_StartMemIdx(ADXT adxt, void *acx, CriSint32 no);
 * [@] adxt	: ADXTnh
 *			acx		: `bwf[^̃AhX
 *			no		: CfbNXԍ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] acx Ŏw肳ꂽ`bwf[^noԖڂ̃f[^ĐB
 *  Play start of ACX data
 * [Inputs  ] adxt	: ADXT handle
 *			  acx	: Address of ACX data
 *			  no	: Index number
 * [Outputs ] None
 * [Return  ] None
 * [Function] Starts to play a part of ACX data when you specify index number.
 */
void CRIAPI ADXT_StartMemIdx(ADXT adxt, void *acx, CriSint32 no);

/* $func$ Đ̒~
 * [@] void ADXT_Stop(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] `cw̍Đ~B
 *  Play stop
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] None
 * [Function] Stops to play ADX data.
 */
void CRIAPI ADXT_Stop(ADXT adxt);

/* $func$ Ԃ̎擾
 * [@] CriSint32 ADXT_GetStat( ADXT adxt );
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] ݂ ADXTnh̏Ԃ\萔
 * 				ADXT_STAT_STOP	 :	~
 *				ADXT_STAT_DECINFO:	`cw ̃wb_擾
 *				ADXT_STAT_PREP	 :	Đ
 *				ADXT_STAT_PLAYING:	fR[hĐ
 *				ADXT_STAT_DECEND :	fR[hI
 *				ADXT_STAT_PLAYEND:	ĐI
 * [@@\] ݂ADXTnh̏Ԃ擾B
 *  Get status
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] Status of ADXT handle
 * [Function] Obtains status of ADXT handle.
 */
CriSint32 CRIAPI ADXT_GetStat(ADXT adxt);

/* $func$ TvPʂł̍Đ̎擾
 * [@] void ADXT_GetTime( ADXT adxt, CriSint32 *ncount, CriSint32 *tscale );
 * [@] adxt	: ADXTnh
 * [o@] ncount	: ĐTv
 *			tscale	: TvOg [ Hz ]
 * [֐l] Ȃ
 * [@@\] TvPʂōĐ擾B
 *  Get play time by sample unit
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] ncount: Number of play sample
 *			  tscale: Sampling frequency(Hz)
 * [Return  ] None
 * [Function] Obtains play time by sample unit.
 */
void CRIAPI ADXT_GetTime(ADXT adxt, CriSint32 *ncount, CriSint32 *tscale);

/* $func$ Ԃł̍Đ̎擾
 * [@] CriSint32 ADXT_GetTimeReal(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] Đ [ 1/100sec ]
 * [@@\] ԂōĐ擾B
 *  Get play time in real time
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] Play time(1/100sec)
 * [Function] Obtains play time in real time.
 */
CriSint32 CRIAPI ADXT_GetTimeReal(ADXT adxt);

/* $func$ f[^̑Tv̎擾
 * [@] CriSint32 ADXT_GetNumSmpl( ADXT adxt );
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] f[^̑Tv
 * [@@\] Đ `cw f[^̑Tv擾B
 * [@l] ԂAĐ(ADXT_STAT_PREP)ĐI(ADXT_STAT_PLAYEND)
 *			܂ł̎Ɏ擾\B
 *  Get a general sample number of sound data
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] General sample number of sound data
 * [Function] Obtains a general sample number of sound data.
 * [Remarks ] You can obtain a time between status of preparation
 *			  (ADXT_STAT_PREP) and status of play end(ADXT_STAT_PLAYEND).
 */
CriSint32 CRIAPI ADXT_GetNumSmpl(ADXT adxt);

/* $func$ f[^̃TvOg̎擾
 * [@] CriSint32 ADXT_GetSfreq(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] f[^̃TvOg
 * [@@\] Đ TvOg߂B
 * [@l] ԂAĐ(ADXT_STAT_PREP)ĐI(ADXT_STAT_PLAYEND)
 *			܂ł̎Ɏ擾\B
 *  Get sampling frequecy
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] Sampling frequency
 * [Function] Obtains sampling frequency.
 * [Remarks ] You can obtain a sampling frequency between status of preparation
 *			 (ADXT_STAT_PREP) and status of play end(ADXT_STAT_PLAYEND).
 */
CriSint32 CRIAPI ADXT_GetSfreq(ADXT adxt);

/* $func$ f[^̃`l̎擾
 * [@] CriSint32 ADXT_GetNumChan(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] f[^̃`l̎擾
 * [@@\] Đ̉̃`l߂B
 * [@l] ԂAĐ(ADXT_STAT_PREP)ĐI(ADXT_STAT_PLAYEND)
 *			܂ł̎Ɏ擾\B
 */
CriSint32 CRIAPI ADXT_GetNumChan(ADXT adxt);

/* $func$ wb_̎擾
 * [@] CriSint32 CriSint32 ADXT_GetHdrLen(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] f[^̃wb_
 * [@@\] Đ̉̃wb_߂B
 * [@l] ԂAĐ(ADXT_STAT_PREP)ĐI(ADXT_STAT_PLAYEND)
 *			܂ł̎Ɏ擾\B
 */
CriSint32 CRIAPI ADXT_GetHdrLen(ADXT adxt);

/* $func$ f[^̗ʎq̎擾
 * [@] CriSint32 ADXT_GetFmtBps(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] f[^̗ʎqrbg
 * [@@\] Đ̗̉ʎqrbg߂B
 * [@l] ԂAĐ(ADXT_STAT_PREP)ĐI(ADXT_STAT_PLAYEND)
 *			܂ł̎Ɏ擾\B
 */
CriSint32 CRIAPI ADXT_GetFmtBps(ADXT adxt);

/*	$func$ p|bg̐ݒ
 * [@] void ADXT_SetOutPan(ADXT adxt, CriSint32 ch, CriSint32 pan);
 * [@] adxt	: ADXTnh
 *			ch		: `lԍ (0, 1)
 *						ADXT_CH_L=0, ADXT_CH_R=1
 *			pan		: pݒl (-15`+15, -128)
 *						ADXT_PAN_LEFT=-15, ADXT_PAN_CENTER=0
 *						ADXT_PAN_RIGHT=15, ADXT_PAN_AUTO=-128
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] o̓p|bgݒ肷B
 *			AUTO ̏ꍇ́AADX f[^mXeIɂĎI
 *			pݒ肳B
 *  Set panpot
 * [Inputs  ] adxt	: ADXT handle
 *			  ch	: Channel number(ADXT_CH_L:0, ADXT_CH_R:1)
 *			  pan	: Panpot(from -15 to +15, -128)
 *						ADXT_PAN_LEFT=-15, ADXT_PAN_CENTER=0
 *						ADXT_PAN_RIGHT=15, ADXT_PAN_AUTO=-128
 * [Outputs ] None
 * [Return  ] None
 * [Function] Sets panpot of specified channel number.
 *			 Sets automatically panpot by data, monoral or stereo, when you 
 *			 specified 'ADXT_PAN_AUTO'.
 */
void CRIAPI ADXT_SetOutPan(ADXT adxt, CriSint32 ch, CriSint32 pan);

/*	$func$ p|bg̎擾
 * [@] CriSint32 ADXT_GetOutPan(ADXT adxt, CriSint32 ch);
 * [@] adxt	: ADXTnh
 *			ch		: `lԍ (0, 1)
 *						ADXT_CH_L=0, ADXT_CH_R=1
 * [o@] Ȃ
 * [֐l] p|bg̐ݒl
 * [@@\] o̓p|bg擾B
 *  Get panpot
 * [Inputs  ] adxt	: ADXT handle
 *			  ch	: Channel number(ADXT_CH_L:0, ADXT_CH_R:1)
 * [Outputs ] None
 * [Return  ] Panpot
 * [Function] Obtains panpot of specified channel number.
 */
CriSint32 CRIAPI ADXT_GetOutPan(ADXT adxt, CriSint32 ch);

/*	$func$ ʒu̐ݒ
 * [@] void ADXT_SetOutPos(ADXT adxt, CriSint32 x, CriSint32 y);
 * [@] adxt	: ADXTnh
 *			x, y	: ʒu (-127`+127)
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ̈ʒuݒ肷B
 *  Set position
 * [Inputs  ] adxt	: ADXT handle
 *			  x, y	: Position (from -127 to +127)
 * [Outputs ] None
 * [Return  ] None
 * [Function] Sets position.
 */
void CRIAPI ADXT_SetOutPos(ADXT adxt, CriSint32 x, CriSint32 y);

/*	$func$ oX̐ݒ
 * [@] void ADXT_SetOutBalance(ADXT adxt, CriSint32 balance);
 * [@] adxt	: ADXTnh
 *			balance	: oXݒl (-15`+15)
 *						ADXT_BALANCE_LEFT=-15, ADXT_BALANCE_CENTER=0
 *						ADXT_BALANCE_RIGHT=15
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] o̓oXݒ肷B
 *  Set output balance
 * [Inputs  ] adxt		: ADXT handle
 *			  balance	: balance(from -15 to +15)
 *						ADXT_BALANCE_LEFT=-15, ADXT_BALANCE_CENTER=0
 *						ADXT_BALANCE_RIGHT=15
 * [Outputs ] None
 * [Return  ] None
 * [Function] Set output balance.
 */
void CRIAPI ADXT_SetOutBalance(ADXT adxt, CriSint32 balance);

/*	$func$ oX̎擾
 * [@] CriSint32 ADXT_GetOutBalance(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] oX̐ݒl
 * [@@\] o̓oX擾B
 *  Get output balance
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] Output balance
 * [Function] Obtains output balance.
 */
CriSint32 CRIAPI ADXT_GetOutBalance(ADXT adxt);

/*	$func$ o̓{[̐ݒ
 * [@] void ADXT_SetOutVol(ADXT adxt, CriSint32 vol);
 * [@] adxt	: ADXTnh
 *			vol		: x@(0:-0dB, -960:-96.0dB)
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] o̓{[ݒ肷B
 *			vol̐ݒl	0    :    -0dB  Ȃ
 *						-30  :    -3dB  70%
 *						-60  :    -6dB  50%
 *						-960 : -96.0dB  ő̌
 *  Set volume
 * [Inputs  ] adxt	: ADXT handle
 *			  vol	: Volume (0:-dB, -960:-96.0dB)
 * [Outputs ] None
 * [Return  ] None
 * [Function] Sets the volume of a ADXT handle.
 *			 'vol'value	0    :    -0dB  No attenuation
 *						-30  :    -3dB  about 70%
 *						-60  :    -6dB  about 50%
 *						-960 : -96.0dB  Maximum attenuation
 */
void CRIAPI ADXT_SetOutVol(ADXT adxt, CriSint32 vol);

/*	$func$ o̓{[̎擾
 * [@] CriSint32 ADXT_GetOutVol(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] o̓{[̐ݒl@(0:-0dB ` -960:-96.0dB)
 * [@@\] o̓{[擾B
 *  Get volume
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] Volume (0:-0dB, -960:-96.0dB)
 * [Function] Obtains the volume for a ADXT handle.
 */
CriSint32 CRIAPI ADXT_GetOutVol(ADXT adxt);

/*	$func$ ftHgo̓{[̎擾
 * [@] CriSint32 ADXT_GetDefOutVol(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] ftHgo̓{[(0:-0dB ` -960:-96.0dB)
 * [@@\] ADXf[^Ɋ܂܂ftHgo̓{[擾B
 */
CriSint32 CRIAPI ADXT_GetDefOutVol(ADXT adxt);

/*	$func$ ftHgp|bg̎擾
 * [@] CriSint32 ADXT_GetDefOutPan(ADXT adxt CriSint32 chno);
 * [@] adxt	: ADXTnh
 *          chno    : `lԍ
 * [o@] Ȃ
 * [֐l] ftHgp|bg̐ݒl
 * [@@\] ADXf[^Ɋ܂܂ftHgp|bg擾B
 */
CriSint32 CRIAPI ADXT_GetDefOutPan(ADXT adxt, CriSint32 chno);

/*	$func$ f[^ʕ̎擾
 * [@] CriChar8 *ADXT_GetDataId(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] f[^ʕ
 * [@@\] ADXf[^Ɋ܂܂f[^ʕ擾B
 */
CriChar8 * CRIAPI ADXT_GetDataId(ADXT adxt);


/*	$func$ f[^ʕ̎擾(ADXf[^)
 * [@] CriChar8 *ADXT_GetDataIdFromMem(CriChar8 *addr);
 * [@] addr	: ADXf[^̃AhX
 * [o@] Ȃ
 * [֐l] f[^ʕ
 * [@@\] ADXf[^Ɋ܂܂f[^ʕ擾B
 */
CriChar8 * CRIAPI ADXT_GetDataIdFromMem(CriChar8 *addr);

/*	$func$ tLɂ邩ۂ̐ݒ
 * [@] void ADXT_SetAinfSw(ADXT adxt, CriSint32 sw)
 * [@] adxt	: ADXTnh
 *          sw		: XCb`i1=LA0=j
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] tɎw肳Ă{[^p|bgŁAĐ邩ۂݒ肷B
 */
void CRIAPI ADXT_SetAinfSw(ADXT adxt, CriSint32 sw);

/*	$func$ t񂪗Lۂ̎擾
 * [@] CriSint32 ADXT_GetAinfSw(ADXT adxt)
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] XCb`i1=LA0=j
 * [@@\] t̃{[^p|bgŁAĐĂ邩ۂ擾B
 */
CriSint32 CRIAPI ADXT_GetAinfSw(ADXT adxt);

/*	$func$ T[o֐̌Ăяopx̃ftHgl̐ݒ	(Pb̌Ăяo)
 * [@] void ADXT_SetDefSvrFreq(CriSint32 freq);
 * [@] freq	: T[o֐̌Ăяopx̃ftHgl (Pb̌Ăяo)
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] T[o֐(ADXT_ExecServer֐)̌Ăяopx̃ftHgl̐ݒ肷B
 *			ʏAݒ肷Kv͂ȂB
 */
void CRIAPI ADXT_SetDefSvrFreq(CriSint32 freq);

/*	$func$ T[o֐̌Ăяopx̐ݒ	(Pb̌Ăяo)
 * [@] void ADXT_SetSvrFreq(ADXT adxt, CriSint32 freq);
 * [@] adxt	: ADXTnh
 *			freq	: T[o֐̌Ăяopx (Pb̌Ăяo)
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] T[o֐(ADXT_ExecServer֐)̌Ăяopx̐ݒ肷B
 *			ftHgł́A60ݒ肳ĂB
 *			ʏAݒ肷Kv͂ȂB
 *  Set the frequency called server function(times/sec)
 * [Inputs  ] adxt	: ADXT handle
 *			  freq	: Frequency called server function(times/sec)
 * [Outputs ] None
 * [Return  ] None
 * [Function] Sets the frequency called server function(ADXT_ExecServer).
 *			 You do not need to set it usually. Default value is 60.
 */
void CRIAPI ADXT_SetSvrFreq(ADXT adxt, CriSint32 freq);

/*	$func$ ēǂݍ݊JnԂ̐ݒ
 * [@] void ADXT_SetReloadTime(ADXT adxt,float time,CriSint32 nch,CriSint32 sfreq);
 * [@] adxt	: ADXTnh
 *			time	: ēǂݍ݊Jn
 *			nch		: `l
 *			sfreq	: TvOg
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ̓obt@ւ̍ēǂݍ݊JnԂݒ肷B
 *			̓obt@̃f[^ʂ time b菭ȂȂƃfBXN
 *			f[^ǂݍށB
 *  Set the time of start sector to reload
 * [Inputs  ] adxt	: ADXT handle
 *			  time  : start remain time
 *			  nch   : number of channel
 *			  sfreq : sampling frequency
 * [Outputs ] None
 * [Return  ] None
 * [Function] Sets of the time of start sector to reload into input buffer.
 *			 Reads data from disc when a quantity of data in the input 
 *			 buffer becomes less than 'time' [second].
 */
void CRIAPI ADXT_SetReloadTime(ADXT adxt, float time, CriSint32 nch, CriSint32 sfreq);

void CRIAPI ADXT_ResetReloadTime(ADXT adxt);

/*	$func$ ēǂݍ݊JnZN^̐ݒ
 * [@] void ADXT_SetReloadSct(ADXT adxt, CriSint32 minsct);
 * [@] adxt	: ADXTnh
 *			minsct	: ēǂݍ݊JnZN^
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ̓obt@ւ̍ēǂݍ݊JnZN^ݒ肷B
 *			̓obt@̃f[^ʂ minsct ZN^菭ȂȂƃfBXN
 *			f[^ǂݍށB
 *  Set the number of start sector to reload
 * [Inputs  ] adxt	: ADXT handle
 *			  minsct: start sector number
 * [Outputs ] None
 * [Return  ] None
 * [Function] Sets of the number of start sector to reload into input buffer.
 *			 Reads data from disc when a quantity of data in the input 
 *			 buffer becomes less than 'minsct' [sector].
 */
void CRIAPI ADXT_SetReloadSct(ADXT adxt, CriSint32 minsct);

/*	$func$ ̓obt@̃ZN^̎擾
 * [@] CriSint32 ADXT_GetNumSctIbuf(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] ZN^
 * [@@\] ̓obt@ɓǂݍ܂ĂZN^擾B
 *  Get the amount of data stored in input buffer(sector)
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] Number of sector
 * [Function] Obtains the amount of data that is stored in input buffer.
 */
CriSint32 CRIAPI ADXT_GetNumSctIbuf(ADXT adxt);

/*	$func$ o̓obt@̃Tv̎擾
 * [@] CriSint32 ADXT_GetNumSmplObuf(ADXT adxt, CriSint32 chno);
 * [@] adxt	: ADXTnh
 *			chno	: `lԍ
 * [o@] Ȃ
 * [֐l] Tv
 * [@@\] o̓obt@̃Tv擾B
 */
CriSint32 CRIAPI ADXT_GetNumSmplObuf(ADXT adxt, CriSint32 chno);

/*	$func$ ̓obt@Đ
 * [@] float ADXT_GetIbufRemainTime(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] Đ\ԁ@(PʁFb)
 * [@@\] ̓obt@ɂf[^ōĐ\ȎԂ擾B
 *			ADXf[^̂ݑΉB
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] Playable time (sec)
 * [Function] Obtains playable time using only data in input buffer.
 *			  You can use this function only playing ADX data.
 */
float CRIAPI ADXT_GetIbufRemainTime(ADXT adxt);

/*	$func$ ̓obt@ɏ\ȃf[^邩ۂ̌
 * [@] CriSint32 ADXT_IsIbufSafety(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] TRUE(1):\ȃf[^AFALSE(0):f[^s
 * [@@\] ̓obt@ɏ\ȃf[^邩ۂB
 *			ADXT_SetReloadSct֐ɂĎw肳ꂽēǂݍ݊JnZN^ȏ
 *			f[^̓obt@ɑ݂ꍇATRUEԂB
 *  Check whether the input buffer is having enough data or not
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] TRUE(1):Has enough data, FALSE(0):Data are insufficient
 * [Function] Checks whether the input buffer is having enough data or not.
 *			  Returns 'TRUE' when data more than the number of sector appointed
 *			  exist in the input buffer.
 */
CriSint32 CRIAPI ADXT_IsIbufSafety(ADXT adxt);

/*	$func$ G[Jo[[h̎w
 * [@] void ADXT_SetAutoRcvr(ADXT adxt, CriSint32 rmode);
 * [@] adxt	: ADXTnh
 *			rmode	: G[Jo[̕@
 *					  ADXT_RMODE_NOACT, ADXT_RMODE_STOP, ADXT_RMODE_REPLAY
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] G[Jo[̕@ݒ肷B
 *			ADXT_RMODE_NOACT : G[Jo[Ȃ
 *			ADXT_RMODE_STOP  : Iɒ~AԂADXT_STAT_STOPɂȂB
 *			ADXT_RMODE_REPLAY: CD̃f[^̋r؂ꂽƂɁAI
 *							   t@C̐擪ĐB
 *							   ̑̏ꍇ́AIɒ~B
 *  Set a mode of error recovery
 * [Inputs  ] adxt	: ADXT handle
 *			  rmode	: Method of error recovery
 *					  ADXT_RMODE_NOACT, ADXT_RMODE_STOP, ADXT_RMODE_REPLAY
 * [Outputs ] None
 * [Return  ] None
 * [Function] Sets the method that recover from error.
 *			 ADXT_RMODE_NOACT : Does not recover
 *			 ADXT_RMODE_STOP  : Stops automatically
 *			 ADXT_RMODE_REPLAY: Replay from the top of a file automatically 
 *							    when data supply from CD-ROM broke off.
 *							    Other cases stop automatically.
 */
void CRIAPI ADXT_SetAutoRcvr(ADXT adxt, CriSint32 rmode);

/*	$func$ ĐIۂ̌
 * [@] CriSint32 ADXT_IsCompleted(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] TRUE(1):ĐIAFALSE(0):Đ
 * [@@\] ĐIۂ𒲂ׂB
 *  Check whether the play finished or not
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] TRUE(1):Finished, FALSE(0):Playing
 * [Function] Checks whether the play finished or not.
 */
CriSint32 CRIAPI ADXT_IsCompleted(ADXT adxt);

/*	$func$ enh̃T[o֐@iԂ̍XV)
 * [@] void ADXT_ExecHndl(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] enh̓ԂXVB
 *			ADXT_ExecServerĂяoB
 *  Server function of each handle
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] None
 * [Function] Update the inside status.
 *			  This function is called from 'ADXT_ExecServer' function.
 */
void CRIAPI ADXT_ExecHndl(ADXT adxt);

/*	$func$ T[o֐@iԂ̍XV)
 * [@] void ADXT_ExecServer(void);
 * [@] Ȃ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] Cu̓ԂXVB
 *			V-Sync ɌĂяoȂ΂ȂȂB
 *  Server function
 * [Inputs  ] None
 * [Outputs ] None
 * [Return  ] None
 * [Function] Update the inside status of library.
 */
void CRIAPI ADXT_ExecServer(void);
void CRIAPI ADXT_ExecDecServer(void);

/*	$func$ t@CVXeT[o֐@iԂ̍XV)
 * [@] void ADXT_ExecFsSvr(void);
 * [@] Ȃ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] Cu̓ԂXVB
 *			V-Sync ɌĂяoȂ΂ȂȂB
 *			DxADXT_ExecServerႭB
 *  File System Server function
 * [Inputs  ] None
 * [Outputs ] None
 * [Return  ] None
 * [Function] Update the inside status of library.
 */
void CRIAPI ADXT_ExecFsSvr(void);
void CRIAPI ADXT_ExecFsServer(void);

/*	$func$ AXg[Rg[T[o֐@iԂ̍XV)
 * [@] void ADXT_ExecLscSvr(void);
 * [@] Ȃ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] Cu̓ԂXVB
 *			V-Sync ɌĂяoȂ΂ȂȂB
 *			DxADXT_ExecServerႭB
 *  Linking Stream Controller Server function
 * [Inputs  ] None
 * [Outputs ] None
 * [Return  ] None
 * [Function] Update the inside status of library.
 */
void CRIAPI ADXT_ExecLscSvr(void);

/*	$func$ t@CVXeT[oۂ
 * [@] CriSint32 ADXT_IsActiveFsSvr(void);
 * [@] Ȃ
 * [o@] Ȃ
 * [֐l] TRUE:^FALSE:ĂȂ
 * [@@\] t@CVXeT[oۂ`FbNB
 *  Check active File System Server function
 * [Inputs  ] None
 * [Outputs ] None
 * [Return  ] TRUE:active/FALSE:no active
 * [Function] Checks that File System server function is active.
 */
CriSint32 CRIAPI ADXT_IsActiveFsSvr(void);

/*	$func$ G[R[h̎擾
 * [@] CriSint32 ADXT_GetErrCode(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] G[R[h擾B
 *  Get error code
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] None
 * [Function] Obtains the error code.
 */
CriSint32 CRIAPI ADXT_GetErrCode(ADXT adxt);

/*	$func$ G[R[h̃NA
 * [@] void ADXT_ClearErrCode(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] G[R[hNAB
 *  Clear error code
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] None
 * [Function] Clears the error code.
 */
void CRIAPI ADXT_ClearErrCode(ADXT adxt);

/*	$func$ [v|Cg̎擾
 * [@] void ADXT_GetLpInfo(ADXT adxt, CriSint32 *lpst, CriSint32 *lped);
 * [@] adxt	: ADXTnh
 * [o@] lpst	: [vJnTv
 *			lped	: [vITv
 * [֐l] Ȃ
 * [@@\] [vJnʒuƃ[vIʒȕ擾B
 * [@l] ԂAĐ(ADXT_STAT_PREP)ĐI(ADXT_STAT_PLAYEND)
 *			܂ł̎Ɏ擾\B
 *  Get position of loop points
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] lpst	: Loop start point
 *            lped	: Loop end point
 * [Return  ] None
 * [Function] Get information of the loop start position and the loop end position. 
 * [Remarks ] You can obtain a time between status of preparation
 *			  (ADXT_STAT_PREP) and status of play end(ADXT_STAT_PLAYEND).
 */
void ADXT_GetLpInfo(ADXT adxt, CriSint32 *lpst, CriSint32 *lped);

/*	$func$ [v񐔂̎擾
 * [@] CriSint32 ADXT_GetLpCnt(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] [v
 * [@@\] [v񐔂擾B
 *  Get the number of times played a loop
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] Number of times played a loop
 * [Function] Obtains the number of times that played a loop.
 */
CriSint32 CRIAPI ADXT_GetLpCnt(ADXT adxt);

/*	$func$ [vtO̐ݒ
 * [@] void ADXT_SetLpFlg(ADXT adxt, CriSint32 flg);
 * [@] adxt	: ADXTnh
 *			flg		: 1=[vA0=[vȂ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] [v邩ۂݒ肷B
 *			Đ́A[v邱Ƃ̂݉\B
 *			ēxA[vݒ肷鎞́AĐJnOɐݒ肷邱ƁB
 *  Set the loop flag
 * [Inputs  ] adxt	: ADXT handle
 *			  flg	: 1=loop, 0=not loop
 * [Outputs ] None
 * [Return  ] None
 * [Function] Sets whether play a loop or not.
 *			  You can only release looping play while playing.
 *			  If you set this flag again,
 *			  you have to set just before start playing.
 */
void CRIAPI ADXT_SetLpFlg(ADXT adxt, CriSint32 flg);

/*	$func$ ̓Xg[WCg̎擾
 * [@] SJ ADXT_GetInputSj(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] Xg[WCgnh
 * [@@\] ͗pXg[WCg擾B
 *  Get input Stream Joint
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] Stream Joint
 * [Function] Obtains Stream Joint for the input.
 */
SJ CRIAPI ADXT_GetInputSj(ADXT adxt);

/*	$func$ o͊Jn҂̐ݒ
 * [@] void ADXT_SetWaitPlayStart(ADXT adxt, CriSint32 flg);
 * [@] adxt	: ADXTnh
 *			flg		: 1=EFCgA0=o͂𑦍ɊJn
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ̏o͂̊Jn҂ݒ肷B
 *  Set waiting for starting to output the sound
 * [Inputs  ] adxt	: ADXT handle
 *			  flg	: 1=waits, 0=starts to output sound
 * [Outputs ] None
 * [Return  ] None
 * [Function] Sets waiting for starting to output the sound.
 */
void CRIAPI ADXT_SetWaitPlayStart(ADXT adxt, CriSint32 flg);

/*	$func$ o͊Jnۂ̔
 * [@] CriSint32 ADXT_IsReadyPlayStart(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] 1:^0:
 * [@@\] o͊Jn̏ۂ𔻒肷B
 *  Check whether preparations completion
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] None
 * [Function] Checks whether ADXT handle was preparations completion.
 */
CriSint32 CRIAPI ADXT_IsReadyPlayStart(ADXT adxt);

/*	$func$ ꎞ~̐ݒ
 * [@] void ADXT_Pause(ADXT adxt, CriSint32 sw);
 * [@] adxt	: ADXTnh
 *			sw		: 1=ꎞ~A0=ĊJ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ꎞ~邩ۂݒ肷B
 *  Pause/Continue
 * [Inputs  ] adxt	: ADXT handle
 *			  sw	: 1=pause, 0=continue
 * [Outputs ] None
 * [Return  ] None
 * [Function] Stops temporarily by a specified switch and release temporary 
 *			  standstill.
 */
void CRIAPI ADXT_Pause(ADXT adxt, CriSint32 sw);

/*	$func$ ꎞ~Ԃ̎擾
 * [@] CriSint32 ADXT_GetStatPause(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] ꎞ~ 1=ꎞ~A0=ꎞ~
 * [֐l] Ȃ
 * [@@\] ꎞ~Ԃ擾B
 *  Pause/Continue
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] 1=pause, 0=not pause
 * [Return  ] None
 * [Function] Obtains the status of pause.
 */
CriSint32 CRIAPI ADXT_GetStatPause(ADXT adxt);

/*	$func$ S̈ꎞ~̐ݒ
 * [@] void ADXT_PauseAll(CriSint32 sw);
 * [@] sw		: 1=ꎞ~A0=ĊJ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ׂĂ̍Đꎞ~邩ۂݒ肷B
 *          nhƂ̈ꎞ~D悵ēKpB
 * Pause/Continue all playbacks
 * [Inputs  ] sw	: 1=pause, 0=continue
 * [Outputs ] None
 * [Return  ] None
 * [Function] Stops temporarily all playbacks by a specified switch and
 *            release temporary standstill.
 *            Applies in preference to pause on each handle.
 */
void CRIAPI ADXT_PauseAll(CriSint32 sw);

/*	$func$ S̈ꎞ~Ԃ̎擾
 * [@] CriSint32 ADXT_GetStatPauseAll(void);
 * [@] Ȃ
 * [o@] ꎞ~ 1=ꎞ~A0=ꎞ~
 * [֐l] Ȃ
 * [@@\] Ŝ̈ꎞ~Ԃ擾B
 * Get state of pausing of all playbacks
 * [Inputs  ] None
 * [Outputs ] 1=pause, 0=not pause
 * [Return  ] None
 * [Function] Obtains the status of pausing of all playbacks.
 */
CriSint32 CRIAPI ADXT_GetStatPauseAll(void);

/*	$func$ _CNgZhx̐ݒ
 * [@] void ADXT_SetDrctLvl(ADXT adxt, CriSint32 drctlvl)
 * [@] adxt	: ADXTnh
 *			drctlvl	: _CNgZhx@(0dB ` -45dB)
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] _CNgZhxݒ肷B
 */
void CRIAPI ADXT_SetDrctLvl(ADXT adxt, CriSint32 drctlvl);

/*	$func$ _CNgZhx̎擾
 * [@] CriSint32 ADXT_GetDrctLvl(ADXT adxt)
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] _CNgZhx@(0dB ` -45dB)
 * [@@\] _CNgZhx擾B
 */
CriSint32 CRIAPI ADXT_GetDrctLvl(ADXT adxt);

/*	$func$ GtFN^̐ݒ
 * [@] void ADXT_SetFx(ADXT adxt, CriSint32 fxch, CriSint32 fxlvl);
 * [@] adxt	: ADXTnh
 *			fxch	: GtFN^̓̓`lԍ (0`15)
 *			fxlvl	: GtFN^̓̓x@(0dB ` -45dB)
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] GtFN^ւ̏o͂ݒ肷B
 *  Set the effect
 * [Inputs  ] adxt	: ADXT handle
 *			  fxch	: Input channel number to Effector (0-15)
 *			  fxlvl	: Input level to Effector(from 0 to -45[dB])
 * [Outputs ] None
 * [Return  ] None
 * [Function] Sets output to the effect.
 */
void CRIAPI ADXT_SetFx(ADXT adxt, CriSint32 fxch, CriSint32 fxlvl);

/*	$func$ GtFN^ݒl̎擾
 * [@] void ADXT_GetFx(ADXT adxt, CriSint32 *fxch, CriSint32 *fxlvl);
 * [@] adxt	: ADXTnh
 * [o@] fxch	: GtFN^ւ̓̓`lԍ (0`15)
 *			fxlvl	: GtFN^̓̓x@(0dB ` -45dB)
 * [֐l] Ȃ
 * [@@\] GtFN^̐ݒl擾B
 *  Get the effect value
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] fxch	: Input channel number to Effector(0-15)
 *			  fxlvl	: Input level to Effector(from 0 to -45[dB])
 * [Return  ] None
 * [Function] Obtains the effect value.
 */
void CRIAPI ADXT_GetFx(ADXT adxt, CriSint32 *fxch, CriSint32 *fxlvl);

/*	$func$ tB^̐ݒ
 * [@] void ADXT_SetFilter(ADXT adxt, CriSint32 coff, CriSint32 q);
 * [@] adxt	: ADXTnh
 *			coff	: JbgItg
 *			q		: sx
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] tB^ւ̏o͂ݒ肷B
 *  Set the filter
 * [Inputs  ] adxt	: ADXT handle
 *			  coff	: Cut off frequency
 *			  q		: 
 * [Outputs ] None
 * [Return  ] None
 * [Function] Sets the filter.
 */
void CRIAPI ADXT_SetFilter(ADXT adxt, CriSint32 coff, CriSint32 q);

/*	$func$ tB^ݒl̎擾
 * [@] void ADXT_GetFilter(ADXT adxt, CriSint32 *coff, CriSint32 *q);
 * [@] adxt	: ADXTnh
 * [o@] coff	: JbgItg
 *			q		: sx
 * [֐l] Ȃ
 * [@@\] tB^ւ̏o͒l擾B
 *  Get the filter value
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] coff	: Cut off frequency
 *			  q		: 
 * [Return  ] None
 * [Function] Obtains the filter value.
 */
void CRIAPI ADXT_GetFilter(ADXT adxt, CriSint32 *coff, CriSint32 *q);

/*	$func$ gX|[Y̐ݒ
 * [@] void ADXT_SetTranspose(ADXT adxt, CriSint32 transps, CriSint32 detune);
 * [@] adxt	: ADXTnh
 *			transps	: gX|[Y
 *			detune	: f`[
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] gX|[Yݒ肷B
 *  Set transpose
 * [Inputs  ] adxt		: ADXT handle
 *			  transps	: Amount of transpose
 *			  detune	: Amount of detune
 * [Outputs ] None
 * [Return  ] None
 * [Function] Sets the transpose.
 */
void CRIAPI ADXT_SetTranspose(ADXT adxt, CriSint32 transps, CriSint32 detune);

/*	$func$ gX|[Y̎擾
 * [@] void ADXT_GetTranspose(ADXT adxt, CriSint32 *transps, CriSint32 *detune);
 * [@] adxt	: ADXTnh
 * [o@] transps	: gX|[Y
 *			detune	: f`[
 * [֐l] Ȃ
 * [@@\] gX|[Yʂ擾B
 *  Get tanspose
 * [Inputs  ] adxt		: ADXT handle
 * [Outputs ] transps	: Amount of transpose
 *			  detune	: Amount of detune
 * [Return  ] None
 * [Function] Obtains the amount of transpose.
 */
void CRIAPI ADXT_GetTranspose(ADXT adxt, CriSint32 *transps, CriSint32 *detune);

/*	$func$ Đx̐ݒ
 * [@] void ADXT_SetSpeedRational(ADXT adxt, CriSint32 speed_n, CriSint32 speed_d);
 * [@] adxt	: ADXTnh
 * [o@] speed_n	: ĐxFq(numerator)
 *			speed_d	: ĐxF(denominator)
 * [֐l] Ȃ
 * [@@\] ĐgύXBύXʂ͂ƂƂ̍ĐgƂ̔ŕ\B
 *  Set Speed Rational
 * [Inputs  ] adxt		: ADXT handle
 * [Outputs ] speed_n	: numerator
 *			  speed_d	: denominator
 * [Return  ] None
 * [Function] 
 */
void ADXT_SetSpeedRational(ADXT adxt, CriSint32 speed_n, CriSint32 speed_d);
    
/*	$func$ G[֐̓o^
 * [@] void ADXT_EntryErrFunc(void (*func)(void *obj, CriSint8 *msg),
 *																void *obj);
 * [@] func	: G[֐
 *			obj		: G[֐̑1
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] G[֐o^B
 *  Entry error callback function
 * [Inputs  ] func	: Error handling function
 *			  obj	: First argument of error handling function
 * [Outputs ] None
 * [Return  ] None
 * [Function] Entry error callback function.
 */
void CRIAPI ADXT_EntryErrFunc(void (*func)(void *obj, CriSint8 *msg), void *obj);

/*	$func$ f[^̕
 * [@] CriSint32 ADXT_DiscardSmpl(ADXT adxt, CriSint32 nsmpl)
 * [@] adxt	: ADXTnh
 *			nsmpl	: Tv
 * [o@] Ȃ
 * [֐l] ̂ĂTv
 * [@@\] fR[hf[^̂ĂB
 *  Discard sound data
 * [Inputs  ] adxt	: ADXT handle
 *			  nsmpl	: Number of sample
 * [Outputs ] None
 * [Return  ] sample number discarded
 * [Function] Discards sound data decoded.
 */
CriSint32 CRIAPI ADXT_DiscardSmpl(ADXT adxt, CriSint32 nsmpl);

/*	gC񐔂̐ݒ	*/
void CRIAPI ADXT_SetNumRetry(CriSint32 num);

/*	gCݒl̎擾	*/
CriSint32 CRIAPI ADXT_GetNumRetry(void);

/*	G[񐔂̎擾	*/
CriSint32 CRIAPI ADXT_GetNumErr(ADXT adxt);

/*	$func$ wb_̎擾
 * [@] void ADXT_GetHdrInfo(CriSint8 *buf, CriSint32 bsize, ADXHINFO *hinfo);
 * [@] buf		: ADXf[^i[ꂽobt@
 *			bsize	: obt@̃TCY
 * [o@] hinfo	: wb_
 * [֐l] Ȃ
 * [@@\] IADXf[^͂Awb_擾B
 *			擾łp[^ɂĂADXHINFOQƂĂB
 *	Gets the ADX header information
 * [Inputs  ] buf	: Buffer including the ADX data
 *			  bsize	: Buffer size
 * [Outputs ] hinfo	: ADX header information
 * [Return  ] None
 * [Function] Analyzes the ADX data in buffer to get the header information.
 *			  The results of analysis is stored into the ADXHINFO structure.
*/
void CRIAPI ADXT_GetHdrInfo(CriSint8 *buf, CriSint32 bsize, ADXHINFO *hinfo);

/*	$func$ t@Cǂݍ݃Xe[^X̎擾
 * [@] CriSint32 ADXT_GetStatRead(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] 1=ǂݍݒ/ǂݍݏA0=ǂݍݒ/ǂݍݏ
 * [@@\] ǂݍݏԂ擾
 */
CriSint32 CRIAPI ADXT_GetStatRead(ADXT adxt);

/*	$func$ STM̎擾
 * [@] ADXSTM ADXT_GetStm(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] STM
 * [@@\] STM擾B
 */
ADXSTM CRIAPI ADXT_GetStm(ADXT adxt);

/* f[^~ʒm */
void CRIAPI ADXT_TermSupply(ADXT adxt);

/***
*		Xs[J[ւ̃[eBOݒ
*		Functions for audio routing to speakers
**/
/* Xs[J[ւ̃Zhx̎擾			*/
/* Gets the sending level to the speaker 	*/
CriSint32 CRIAPI ADXT_GetSendSpeakerLevel(
	ADXT adxt, CriSint32 ch_id, CriSint32 spk_id);

/* Xs[J[ւ̃Zhx̊蓖		*/
/* Sets the sending level to the speaker 	*/
void CRIAPI ADXT_SetSendSpeakerLevel(
	ADXT adxt, CriSint32 ch_id, CriSint32 spk_id, CriSint32 volume);

/* Zhx蓖ẴZbg				*/
/* Resets all sending levels to the speakers 	*/
void CRIAPI ADXT_ResetAllSendSpeakerLevel(ADXT adxt);

/***
*		_E~bNX̐ݒ
*		Functions for audio downmix
**/
/* _E~bNX@̐ݒ */
/* Sets the method of downmix */
void CRIAPI ADXT_SetDownmixMode(CriSint32 mode);

/***
*			tB^쐬pR[obN
*
*			fR[h閈ɓo^ꂽ֐ĂяoB
*			(*user_flt_cbf)(void *obj, CriSint32 ch, void *data, CriSint32 dtlen);
*			obj:	ADXT_EntryFltFunc֐̑R
*			ch:		`lԍ@(0:, 1:E)
*			data:	WJꂽf[^ (ADX̏ꍇ́A16bitPCM)
*			dtlen:	WJꂽf[^̃oCg
*			@Uo@\Ƃ͋płȂB
**/

/*	tB^R[obN֐̓o^	*/
void CRIAPI ADXT_EntryFltFunc(ADXT adxt,
		void (*f)(void *obj, CriSint32 ch, void *data, CriSint32 dtlen), void *obj);

/* $func$ fR[hTv̎擾
 * [@] CriSint32 ADXT_GetDecNumSmpl(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] fR[hf[^̑Tv
 * [@@\] fR[hf[^̑Tv擾B
 * [@l] ԂAĐ(ADXT_STAT_PREP)ĐI(ADXT_STAT_PLAYEND)
 *			܂ł̎Ɏ擾\B
 *  Get a decoded sample number of sound data
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] decoded sample number of sound data
 * [Function] Obtains a decoded sample number of sound data.
 * [Remarks ] You can obtain a time between status of preparation
 *			  (ADXT_STAT_PREP) and status of play end(ADXT_STAT_PLAYEND).
 */
CriSint32 CRIAPI ADXT_GetDecNumSmpl(ADXT adxt);

/*	fR[hf[^ʂ̎擾 (oCgP)	*/
CriSint32 CRIAPI ADXT_GetDecDtLen(ADXT adxt);

/*	fR[hR[obN̓o^ */
void CRIAPI ADXT_SetCbDec(ADXT adxt, 
	void (*func)(void *obj, CriSint32 ibyte, CriSint32 obyte), void *obj);

/* $func$ I[fBI_̎擾
 * [@] ADXRNA ADXT_GetRna(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] I[fBI_
 * [@@\] ADXTnh̎I[fBI_擾B
 * [@l] 
 *  Getting Audio Renderer 
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] Audio Renderer
 * [Function] Obtains Audio Renderer of ADXT handle.
 * [Remarks ] 
 */
ADXRNA CRIAPI ADXT_GetRna(ADXT adxt);


/***
*		V[XAĐ@\
*
*		E[vݒ̖PADX f[^̂ݘAĐ\
*		Eő16t@C܂œo^\
*
***/

/*	őo^t@C									*/
/*	Number of maximum files to entry 					*/
#define	ADXT_MAX_ENTRY_FILES		(16)

/*	$func$ V[XAĐt@C̓o^
 * [@] void ADXT_EntryFname(ADXT adxt, const CriChar8 *fname)
 * [@] adxt	: ADXTnh
 *			fname	: t@C
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] V[XAĐp̃t@Co^B
 *			[vݒ̂ȂPADXf[^̂ݓo^łB
 *  Entry file for seamless continuous play
 * [Inputs  ] adxt	: ADXT handle
 *			  fname	: ADX File name
 * [Outputs ] None
 * [Return  ] None
 * [Function] Entry file for seamless continuous play.
 *			  You can only simple ADX data file without looping.
 */
void CRIAPI ADXT_EntryFname(ADXT adxt, const CriChar8 *fname);

/*	V[XAĐt@C̓o^i͈͎wj	*/
void CRIAPI ADXT_EntryFnameRange(ADXT adxt, const CriChar8 *fname, CriSint32 ofst_sct, CriSint32 range_sct);

/*	$func$ V[XAĐTut@C̓o^
 * [@] void ADXT_EntryAfs(ADXT adxt, CriSint32 patid, CriSint32 fid)
 * [@] adxt	: ADXTnh
 *			patid	: p[eBVID
 *			fid		: t@CID
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] V[XAĐp̃Tut@Co^B
 *			[vݒ̂ȂPADXf[^̂ݓo^łB
 *  Entry file for seamless continuous play
 * [Inputs  ] adxt	: ADXT handle
 *			  patid	: Partition ID
 *			  fid	: File ID
 * [Outputs ] None
 * [Return  ] None
 * [Function] Entry subfile for seamless continuous play.
 *			  You can only simple ADX data subfile without looping.
 */
void CRIAPI ADXT_EntryAfs(ADXT adxt, CriSint32 patid, CriSint32 fid);

/*	$func$ V[XAĐ̊Jn
 * [@] void ADXT_StartSeamless(ADXT adxt)
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] V[XAĐJnB
 *  Start seamless continuous play
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] None
 * [Function] Start seamless continuous play.
 */
void CRIAPI ADXT_StartSeamless(ADXT adxt);

/*	$func$ V[X[vĐ̐ݒ
 * [@] void ADXT_SetSeamlessLp(ADXT adxt, CriSint32 flg)
 * [@] adxt	: ADXTnh
 *			flg		: 0-[vĐȂ,1-[vĐ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ݁Ao^Ăt@CJԂĐB
 *			t@ĈׂẴf[^ǂݏIƎIɍēxo^B
 *  Set seamless loop play
 * [Inputs  ] adxt	: ADXT handle
 *			  flg	: 0-Off, 1-On
 * [Outputs ] None
 * [Return  ] None
 * [Function] You can play all entried files with looping.
 */
void CRIAPI ADXT_SetSeamlessLp(ADXT adxt, CriSint32 flg);

/*	$func$ V[X[vĐ̊Jn
 * [@] void ADXT_StartFnameLp(ADXT adxt, const CriChar8 *fname)
 * [@] adxt	: ADXTnh
 *			fname	: t@C
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] w肳ꂽt@CJԂĐB
 *  Start seamless loop play
 * [Inputs  ] adxt	: ADXT handle
 *			  fname	: ADX File Name
 * [Outputs ] None
 * [Return  ] None
 * [Function] Start seamless loop plaing your specified file (fname).
 */
void CRIAPI ADXT_StartFnameLp(ADXT adxt, const CriChar8 *fname);

/*	V[X[vĐ̊Jni͈͎wj	*/
void CRIAPI ADXT_StartFnameRangeLp(ADXT adxt, const CriChar8 *fname, CriSint32 ofst_sct, CriSint32 range_sct);

/*	AFSV[X[vĐ̊Jn
 * [@] ADXT_StartAfsLp(ADXT adxt, CriSint32 patid, CriSint32 fid)
 * [@] adxt	: ADXTnh
 *			patid	: p[eBVID
 *			fid		: t@CID
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] w肳ꂽAFSt@CJԂĐB
 *  Start seamless loop play
 * [Inputs  ] adxt	: ADXT handle
 *			  patid	: Partition ID
 *			  fid	: File ID
 * [Outputs ] None
 * [Return  ] None
 * [Function] Start seamless loop plaing your specified AFS file.
 */
void CRIAPI ADXT_StartAfsLp(ADXT adxt, CriSint32 patid, CriSint32 fid);

/*	$func$ V[XAĐ̉
 * [@] void ADXT_ReleaseSeamless(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] V[XAĐ̉B
 *  Release seamless continuous play
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] None
 * [Function] Release seamless continuous play.
 */
void CRIAPI ADXT_ReleaseSeamless(ADXT adxt);

/*	$func$ o^t@C̎擾
 * [@] CriSint32 ADXT_GetNumFiles(ADXT adxt)
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] o^Ăt@C
 * [@@\] o^Ăt@C擾B
 *  Get number of entried files
 * [Inputs  ] adxt	: ADXT handle
 * [Outputs ] None
 * [Return  ] Number of Entried Files
 * [Function] Get number of entried files
 */
CriSint32 CRIAPI ADXT_GetNumFiles(ADXT adxt);

/*	AĐ̐ݒ@(1:A0:Ȃ)	*/
void CRIAPI ADXT_SetLnkSw(ADXT adxt, CriSint32 sw);

/*	AĐ̎擾@(1:A0:Ȃ)	*/
CriSint32 CRIAPI ADXT_GetLnkSw(ADXT adxt);

/*	t@C̓o^Zbg(STOPԂł̂ݗL)	*/
void CRIAPI ADXT_ResetEntry(ADXT adxt);

/***
*			Uo@\
***/

/*	U擾pƗ̈̑傫̌vZ	*/
CriSint32 CRIAPI ADXT_CalcAmpWork(CriSint32 maxnch);
/*	U擾pƗ̈̐ݒ	*/
void CRIAPI ADXT_SetAmpWork(ADXT adxt, void *work, CriSint32 wksize);
/*	U̎擾	*/
CriSint32 CRIAPI ADXT_GetAmplitude(ADXT adxt, CriSint32 ch);
/*	U̎擾 (ItZbgwt)	*/
CriSint32 CRIAPI ADXT_GetAmplitude2(ADXT adxt, CriSint32 ch, CriSint32 msec, CriSint32 *msec2);

/***
*			Sofdecpg֐
***/

/*	V-Sync荞ݗp֐			*/
/*	Shinobił́AɊ荞݂ɎIɓo^̂ŁA		*/
/*	gp܂BNaomiSofdec MovieĐꍇɂ́A			*/
/*	̊֐V-Sync荞݂sĂB						*/
void CRIAPI ADXT_VsyncProc(void);

/*	̒Pʂ̐ݒ@(0:Sfreq(Audio), 1:V-Sync(NTSC), 2:V-sync(PAL)	*/
void CRIAPI ADXT_SetTimeMode(CriSint32 mode);

/* ADXwb_̔ */
CriSint32 CRIAPI ADXT_IsHeader(CriSint8 *adr, CriSint32 siz, CriSint32 *hdrsiz);

/* ADXIR[h̔ */
CriSint32 CRIAPI ADXT_IsEndcode(CriSint8 *adr, CriSint32 siz, CriSint32 *endsiz);
/*
	adr   FI|C^(ADXf[^36oCgE)
	siz   FITCY (ɕKvȃTCY͍XoCg
			܂񂪁At@C[hāAobt@
			~ςĂTCY͂܂)
	ndsizFIR[hTCYitb^TCYj
*/

/* f[^̋} */
CriSint32 CRIAPI ADXT_InsertSilence(ADXT adxt, CriSint32 nch, CriSint32 nsmpl);
/*
	nsmpl @F}vTv [sample/1ch]
	֐l  F}sTv (0 ` nsmpl)
			  ADXT͗pSJɏ\ȋ󂫂 nsmpl ̒[
			  ؂̂ĂlԂB
*/

/*			mo̓XCb`̐ݒ
[  ]	void ADXT_SetOutputMono(CriSint32 flag);
[  ]	CriSint32 flag		mo̓tO(OFF:0, ON:1)
[߂l]	Ȃ					
[@  \]	XeIf[^IɃmf[^Ƃďo͂B
[@l]	
*/
void CRIAPI ADXT_SetOutputMono(CriSint32 flag);

/*	wb_̋}	*/
void CRIAPI ADXT_InsertHdrSfa(ADXT adxt, CriSint32 nch, CriSint32 sfreq, CriSint32 nsmpl);
/*	^CItZbg̎擾	*/
CriSint32 CRIAPI ADXT_GetTimeOfst(ADXT adxt);
/*	^CItZbg̐ݒ	*/
void CRIAPI ADXT_SetTimeOfst(ADXT adxt, CriSint32 ofst);
/*	Tv̒	*/
CriSint32 CRIAPI ADXT_AdjustSmpl(ADXT adxt, CriSint32 nsmpl);
/* ftHgtH[}bg̊Ow */
void CRIAPI ADXT_SetDefFmt(ADXT adxt, CriSint32 fmt);

/***
*		AHX p֐
*		Functions for AHX
***/

/*	$func$ AHX̑gݍ
 * [@] void ADXT_AttachAhx(ADXT adxt, void *work, CriSint32 worksize);
 * [@] adxt	: ADXTnh
 *			work	: AHX[N̈
 *			worksize: AHX[N̈̃TCY
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] AHX̑gݍ݂sAAHX̗p\ɂB
 *  Attach AHX
 * [Inputs  ] adxt    : ADXT handle
 *			  work    : Working area for AHX
 *			  worksize: Size of AHX working area(byte)
 * [Outputs ] None
 * [Return  ] None
 * [Function] Attach AHX, Use of AHX is attained.
 */
void CRIAPI ADXT_AttachAhx(ADXT adxt, void *work, CriSint32 worksize);

/*	$func$ AHX̕
 * [@] void ADXT_DetachAhx(ADXT adxt);
 * [@] adxt	: ADXTnh
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] AHX𕪗AAHX̗p߂B
 *  Detach AHX
 * [Inputs  ] adxt    : ADXT handle
 * [Outputs ] None
 * [Return  ] None
 * [Function] Detach AHX, Unuse of AHX is attained.
 */
void CRIAPI ADXT_DetachAhx(ADXT adxt);

/***
*		Íp֐
*		Functions for encrypted file
***/

/* nh̃L[R[h̐ݒ */
void CRIAPI ADXT_SetKeyString(ADXT adxt, CriChar8 *str);

/* Ŝ̃L[R[h̐ݒ */
void CRIAPI ADXT_SetDefKeyString(CriChar8 *str);


/***
*		fR[hG[p֐
*		Functions for Decode error
***/

/*	fR[hG[[h̐ݒ	*/
/*	Sets decode error mode		*/
void CRIAPI ADXT_SetDecErrMode(CriSint32 mode);
/*	fR[hG[[h̎擾	*/
/*	Gets decode error mode		*/
CriSint32 CRIAPI ADXT_GetDecErrMode(void);

/***
*		ADX}l[W֐
*		ADX Manager Functions
***/

/*	ADXXbh̏					*/
/*	Initialization of ADX Thread 		*/
void CRIAPI ADXM_SetupThrd(ADXM_TPRM *tprm);
/*	ADXXbh̏I				*/
/*	Termination of ADX Thread Extended 	*/
void CRIAPI ADXM_ShutdownThrd(void);
/*	ADXXbhp[^̎擾			*/
/*	Gets parameters of ADX Thread 		*/
void CRIAPI ADXM_GetThrdParam(ADXM_TPRM *tprm);

/*	ADXXbh̏(g)				*/
/*	Initialization of ADX Thread Extended 	*/
void CRIAPI ADXM_SetupThrdEx(ADXM_TPRM_EX *tprm);
/*	ADXXbh̏I(g)			*/
/*	Termination of ADX Thread Extended 		*/
void CRIAPI ADXM_ShutdownThrdEx(void);

/*	[UVSYNCXbhւ̊֐o^				*/
/*	Set callback function on UsrVsync Thread	*/
void CRIAPI ADXM_SetCbUsrVsync(CriBool (*func)(void *obj), void *obj);
/*	[UAChXbhւ̊֐o^			*/
/*	Set callback function on UsrIdle Thread		*/
void CRIAPI ADXM_SetCbUsrIdle(CriBool (*func)(void *obj), void *obj);
/*	[UAChT[ő؂菈						*/
/*	Execution UsrIdle Thread for termination of function	*/
void CRIAPI ADXM_GotoUsrIdleBdr(void);
/*	UsrVsyncT[o֐̎s	*/
/*	Execution UsrVsync Server	*/
CriSint32 CRIAPI ADXM_ExecSvrUsrVsync(void);
/*	UsrIdleT[o֐̎s		*/
/*	Execution UsrIdle Server	*/
CriSint32 CRIAPI ADXM_ExecSvrUsrIdle(void);
/*	VsyncT[o֐	*/
CriSint32 CRIAPI ADXM_ExecSvrVsync(void);
/*	t@CVXeT[o֐	*/
CriSint32 CRIAPI ADXM_ExecSvrFs(void);
/*	C[vŌĂяo֐	*/
CriSint32 CRIAPI ADXM_ExecSvrMain(void);
/*	~hEFApXbhŌĂяo֐	*/
CriSint32 CRIAPI ADXM_ExecSvrMwIdle(void);
/*	ׂẴT[oĂяo֐	*/
CriSint32 CRIAPI ADXM_ExecSvrAll(void);

/*	G[֐̓o^								*/
void CRIAPI ADXM_SetCbErr(void (*fn)(void *obj, CriChar8 *emsg), void *obj);
/*	בp֐	*/
void CRIAPI ADXM_SetCbSleepMwIdle(void (*fn)(void *), void *obj);
/*	Xbhsꂽۂ̔	*/
CriBool CRIAPI ADXM_IsSetupThrd(void);

/*	Xbh̃bN	*/
void CRIAPI ADXM_Lock(void);
/*	Xbh̃AbN	*/
void CRIAPI ADXM_Unlock(void);
/* bNx̎擾 */
CriSint32 CRIAPI ADXM_GetLockLevel(void);

/*	V-Sync҂֐	*/
void CRIAPI ADXM_WaitVsync(void);

/*	V-Sync荞݃nh	*/
CriSint32 CRIAPI ADXM_ExecVint(CriSint32 arg);

/*	CXbhŌĂяo֐	*/
CriSint32 CRIAPI ADXM_ExecMain(void);

/* AChXbh̃gbv^GhR[obN֐̓o^ */
void CRIAPI ADXM_SetCbIdleTopEnd(ADXM_CBFN topfn, void *topobj, ADXM_CBFN endfn, void *endobj);

/***
*		WAVt@C̓Đp֐
*		Functions for WAV file special playback
***/

/*	WAVt@C̖ĐXCb`̐ݒ	*/
void CRIAPI ADXT_SetEndlessPlaySw(ADXT adxt, CriSint32 sw);
/*	WAVt@C̖ĐXCb`̎擾	*/
CriSint32 CRIAPI ADXT_GetEndlessPlaySw(ADXT adxt);


#ifdef __cplusplus
}
#endif

#endif

/* end of file */
