#ifndef	_AIXP_H_INCLUDED
#define	_AIXP_H_INCLUDED
/****************************************************************************/
/*																			*/
/*			$title$  AIX Đ Cu									*/
/*																			*/
/*				2001.7.29		written M.Oshimi							*/
/*																			*/
/****************************************************************************/

/*	o[Wԍ						*/
/*	Version number of AIXP library 		*/
#define	AIXP_VER	"3.13"

#include "cri_xpt.h"
#include "sj.h"
#include "cri_adxt.h"

/*	Xg[Rg[				*/
/*	Stream Controller					*/
#ifndef ADXSTM_DEFINED
#define ADXSTM_DEFINED
typedef	void	*ADXSTM;
#endif

/*	Xg[WCgfR[_		*/
/*	Stream Joint decoder				*/
#ifndef AIXSJD_DEFINED
#define AIXSJD_DEFINED
typedef void	*AIXSJD;
#endif

/*	I[fBI_					*/
/*	Audio Renderer						*/
#ifndef ADXRNA_DEFINED
#define ADXRNA_DEFINED
typedef void	*ADXRNA;
#endif

/****************************************************************************/
/*		萔}N															*/
/*		MACRO CONSTANT														*/
/****************************************************************************/

/*	ő哯						*/
/*	Maximum number of AIXP handle		*/
#define	AIXP_MAX_OBJ		(4)

/*	őgbN						*/
/*	Maximum number of track				*/
#define	AIXP_MAX_TR			(32)

/*	őTvOg				*/
/*	Maximum sampling frequency			*/
#define	AIXP_MAX_SFREQ		(48000)

/*	$define$ AIX Talk̓(AIXP_STAT_`)	*/
/*	Status of AIX Talk							*/
#define	AIXP_STAT_STOP		(0)		/*	~ 								*/
									/*	During standstill					*/
#define AIXP_STAT_PREP		(1)		/*	Đ 							*/
									/*	During play preparation				*/
#define AIXP_STAT_PLAYING	(2)		/*	fR[hĐ 					*/
									/*	During decode and play				*/
#define AIXP_STAT_PLAYEND	(3)		/*	ĐI 							*/
									/*	Play end							*/
#define AIXP_STAT_ERROR		(4)		/*	ĐI 							*/
									/*	Play end							*/

/*	őĐ`l				*/
/*	Maximum number of play channel		*/
#define	AIXP_MAX_NCH		(2)

/*	}``lo͗pp[^		*/
/*	Parameters for multi channal output	*/
#define AIXP_MC_NTR			(3)
#define AIXP_MC_NCH			(6)

/*	T[o֐̌Ăяopx̋Kl@60(/b)				*/
/*	Default value of frequency called server function(times/sec)	*/
#define AIXP_DEF_SVRFREQ	(60)

/*	Default value of output volume(dB)	*/
#define	AIXP_DEF_OUTVOL		(0)

/*	t@C̍ő咷	*/
/*	Maximum length of the file path		*/
#define AIXP_MAX_FNAME		(256)

#define AIXP_CALC_WORK_COMMON(nch, nstm, sfreq, ntr)	\
	((ADXT_CALC_IBUFSIZE(nch, nstm, sfreq) + (ADXT_CALC_WORK(nch, ADXT_PLY_MEM, nstm, sfreq) - 64)) * (ntr) + 64)
#define AIXP_CALC_WORK_COMMON_3D(nstm, sfreq, ntr)	\
	((ADXT_CALC_IBUFSIZE_3D(nstm, sfreq) + (ADXT_CALC_WORK_3D(ADXT_PLY_MEM, nstm, sfreq) - 64)) * (ntr) + 64)

/* [NTCY	*/
/* Work size	*/
#ifdef XPT_TGT_PC
#define AIXP_CALC_WORK(nch, nstm, sfreq, ntr)	\
	(AIXP_CALC_WORK_COMMON(nch, nstm, sfreq, ntr) + ADXT_CALC_OBUFSIZE(nch))
#else	// #ifdef XPT_TGT_PC
#define AIXP_CALC_WORK(nch, nstm, sfreq, ntr)	\
	(AIXP_CALC_WORK_COMMON(nch, nstm, sfreq, ntr))
#endif	// #ifdef XPT_TGT_PC

/* A^C3DpjOsۂ̃[NTCY				*/
/* Work size to create handle that can use realtime 3D panning	*/
#ifdef XPT_TGT_PC
#define AIXP_CALC_WORK_3D(nstm, sfreq, ntr)	\
	(AIXP_CALC_WORK_COMMON_3D(nstm, sfreq, ntr) + ADXT_OBUFSIZE_3D)
#else
#define AIXP_CALC_WORK_3D(nstm, sfreq, ntr)	\
	(AIXP_CALC_WORK_COMMON_3D(nstm, sfreq, ntr))
#endif

/* }`t[YĐp[N̈										*/
/* Work size for multi phrase playback (required on 5 or more phases)	*/
#define AIXP_CALC_PHRASE_WORK(nph)			(((nph) * 16) + 64)

/*	̓obt@̃GLXg̈̑傫	*/
/*	Size of Extra area in input buffer		*/
#define AIXP_IBUF_XLEN (8*1024)

/*	AIX Talk ̏o̓obt@̑傫@(TvP)	*/
/*	Output buffer size of AIX Talk (unit:sample)		*/
#define	AIXP_OBUF_SIZE	(0x2000)

#ifndef XPT_TGT_PC_LE
#define DECODE_AHX
#endif

#ifdef DECODE_AHX
#define	AIXP_OBUF_DIST	(0x2060)
#else
#define	AIXP_OBUF_DIST	(0x2020)
#endif

/*	̓obt@ւ̓ǂݍݗ						*/
/*	Number of sectors to read into the input buffer	*/
#define AIXP_MAX_CDBSCT		(75)
#define AIXP_MIN_CDBSCT		(65)
#define AIXP_PREP_RDSCT		(25)

/*	p|bg̐ݒl		*/
/*	Panpot parameter		*/
#define	AIXP_PAN_LEFT		(-15)
#define	AIXP_PAN_CENTER		(0)
#define	AIXP_PAN_RIGHT		(15)
#define	AIXP_PAN_AUTO		(-128)	/*	MONO/STE ɂĎIɐ؂ւ	*/
									/*	Changes automatically by data		*/

/*	XeIĐ̃`lԍ		*/
/*	Channel number playing stereo data	*/
/*	AIXP_CH_L:left, AIXP_CH_R:right		*/
#define	AIXP_CH_L			(0)
#define	AIXP_CH_R			(1)

/*	5.1chĐ̃Xs[Jԍ			*/
/*	Speaker number playing 5.1ch sound	*/
#define	AIXP_SPKID_FL		(ADXT_SPEAKER_FRONT_LEFT)		/* Front Left   */
#define	AIXP_SPKID_FR		(ADXT_SPEAKER_FRONT_RIGHT)		/* Front Right  */
#define	AIXP_SPKID_BL		(ADXT_SPEAKER_BACK_LEFT)		/* Back Left    */
#define	AIXP_SPKID_BR		(ADXT_SPEAKER_BACK_RIGHT)		/* Back Right   */
#define	AIXP_SPKID_FC		(ADXT_SPEAKER_FRONT_CENTER)		/* Front Center */
#define	AIXP_SPKID_LF		(ADXT_SPEAKER_LOW_FREQUENCY)	/* Low Freqency */
#define	AIXP_SPK_NUM		(6)
#define AIXP_TRK_NUM		(3)
#define	AIXP_SPK_VOL_MAX	(0)
#define	AIXP_SPK_VOL_MIN	(-10000)

/*	Đ[h	*/
/*	Play mode	*/
#define	AIXP_PMODE_FNAME	(0)		/*	Play specified file name	*/
#define	AIXP_PMODE_AFS		(1)		/*	Play specified file ID		*/
#define	AIXP_PMODE_MEM		(2)		/*	Play data from memory		*/
#define	AIXP_PMODE_SJ		(3)		/*	Play data from StreamJoint	*/

/*	~LT[샂[h	*/
/*	Mixer mode			*/
#define AIXP_MIX_HARDWARE	(0)
#define AIXP_MIX_SOFTWARE	(1)

/* o[WƂ̌݊p */
/* For compatibility with old version */
#define AIXP_StartFnameDolbyDigital		AIXP_StartFnameMultiChannel
#define AIXP_StartAfsDolbyDigital		AIXP_StartAfsMultiChannel
#define AIXP_StartMemDolbyDigital		AIXP_StartMemMultiChannel
#define AIXP_SetOutVolDolbyDigital		AIXP_SetOutVolMultiChannel

/****************************************************************************/
/*		f[^^															*/
/*      Data type declaration												*/
/****************************************************************************/

/* t[YRg[pR[obN֐ */
/*	Structure of phrase control           */
typedef CriSint32 (*AIXP_CBFN_PHCTRL)(void *obj, CriSint32 ph_now, CriSint32 ph_max);

#if defined(XPT_TGT_PC)
/* Uo@\p\ */
typedef struct {
	void *amp;
	SJ sji[AIXP_MAX_NCH];
	SJ sjo[AIXP_MAX_NCH];
	void *context;
} AIXAMP;
#endif

/*	AIX Talk IuWFNg\		*/
/*	Structure of AIX Talk object	*/
typedef	struct _aix_ply {
	CriSint8	used;						/*	gpۂ					*/
	CriSint8	stat;						/*							*/
	CriSint8	maxnch;						/*	őĐ`l			*/
	CriSint8	maxntr;						/*	őĐgbN				*/
	CriSint8	nch;						/*	݂̍Đ`l			*/
	CriSint8	ntr;						/*	݂̍ĐgbN			*/
	CriSint8	seek_flag;					/*	V[Nsǂ		*/
	CriSint8	rsv1;						/*	\							*/
	AIXSJD	sjd;						/*	AIXXg[WCgfR[_	*/
	ADXSTM	stm;						/*	̓Xg[Rg[		*/
	ADXT	adxt[AIXP_MAX_TR];			/*	ADXTĐ						*/
	SJ		sjf;						/*	̓Xg[WCg		*/
	SJ		sji;						/*	̓Xg[WCg		*/
	SJ		sjo[AIXP_MAX_TR];			/*	o̓Xg[WCg		*/
	CriSint8	*ibuf;						/*	̓obt@					*/
	CriSint32	ibufbsize;					/*	̓obt@TCY(oCgP)	*/
	CriSint32	ibufxsize;					/*	̓obt@GNXgTCY	*/
	CriSint8	*obuf[AIXP_MAX_TR];			/*	o̓obt@					*/
	CriSint32	obufbsize;					/*	o̓obt@TCY(oCgP)	*/
	CriSint32	obufxsize;					/*	o̓obt@TCY(oCgP)	*/
	CriSint32	pause_flag;					/*	|[YtO					*/
	CriSint32	demux_flag;					/*	f}`vNXtO			*/
	CriSint8	lpsw;						/*	[vXCb`					*/
	CriSint8	lnksw;						/*	AXCb`					*/
	CriSint8	cmdstart;					/*	X^[gR}h				*/
	CriSint8	rsv2;						/*	\							*/
	CriSint32	lpcnt;						/*	[vJE^					*/
	CriSint32	ldph;						/*	să[ht[Y	*/
	CriSint32	curph;						/*	ݍĐ̃t[Yԍ		*/
	CriSint32	stph;						/*	ĐJnt[Yԍ			*/
	CriSint32	lpsp;						/*	[vX^[gt[Yԍ		*/
	CriSint32	lpep;						/*	[vGht[Yԍ		*/
	CriChar8	*fname_wk;					/*	t@Cێ̈iworkj	*/
	CriChar8	*fname;						/*	t@C						*/
	void	*dir;						/*	fBNg				*/
	CriUint32	ofst;						/*	t@CItZbg				*/
	CriUint32	nsct;						/*	t@CTCY(ZN^)			*/
	CriSint32	pmode;						/*	Đ[h						*/
	CriSint32	svrfreq;					/*	T[o֐Ăяopx			*/
	CriFloat32 reload_time;				/*	ēǂݍݎ (0:default)		*/
	CriSint32 master_volume;				/*	S̃{[					*/
	CriSint32 track_volume[AIXP_MAX_TR];	/*	gbNƂ̃{[		*/
	CriBool	use_3d_panning;				/*  3DpjOs邩ǂ	*/
	CriSint32	time_offset;				/*	ĐAItZbg			*/
	CriSint32	time_scale;					/*	ĐAXP[			*/
	CriSint32	start_smpl_phrase;			/*	ĐJnTvit[Yj	*/
	CriSint32	start_smpl;					/*	ĐJnTv				*/
	CriFloat32	start_time;					/*	ĐJn					*/
	CriSint32	time_offset_seek;			/*	V[Nɂ鎞ItZbg		*/
	
	/* t[YRg[Đpp[^ */
	AIXP_CBFN_PHCTRL phctrl_cbfn;
	void *phctrl_obj;
	
	/* }``lI[fBIo͗pp[^ */
#if defined(XPT_SUPPORT_MULTICHANNEL)
	
#if defined(XPT_TGT_PC)
	/* PCŗL̃p[^ */
	CriSint8 *wkpcm[AIXP_MAX_TR * AIXP_MAX_NCH];
	SJ sjpcm[AIXP_MAX_TR * AIXP_MAX_NCH];
	void *dcd[AIXP_MAX_TR];
	void *mcrna;
	CriBool attached;
	AIXAMP aixamp[AIXP_MAX_TR];
#elif defined(XPT_TGT_XB)
	/* XboxŗL̃p[^ */
	CriBool dolby_flag[AIXP_TRK_NUM];
	CriSint32 spk_idx[AIXP_SPK_NUM];
#elif defined(XPT_TGT_PS3PPU)
	/* PS3ŗL̃p[^ */
	CriSint32 group_id;
#endif
	
	/* Xs[J[w̃{[Rg[p */
	CriSint32 spk_vol[AIXP_SPK_NUM];
	
	/* SofdecXVpgp[^ */
	CriSint32 last_sample;
	CriSint64 last_count;
#endif
} AIX_PLY;
typedef	AIX_PLY	*AIXP;

/****************************************************************************/
/*		֐̐錾															*/
/*      Function Declaration												*/
/****************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* $func$ AIXP̏
 * [@] void AIXP_Init(void);
 * [@] Ȃ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] AIXPB
 *			ϐ̈̏sB
 *  Initialization of AIXP
 * [Format  ] void AIXP_Init(void);
 * [Inputs  ] None
 * [Outputs ] None
 * [Return  ] None
 * [Function] Initializes AIXP. Initializes variable.
 */
void CRIAPI AIXP_Init(void);

/* $func$ AIXP̏I
 * [@] void AIXP_Finish(void);
 * [@] Ȃ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] AIXP ̏IB
 *  Termination of AIXP
 * [Format  ] void AIXP_Finish(void);
 * [Inputs  ] None
 * [Outputs ] None
 * [Return  ] None
 * [Function] Finalizes AIXP.
 */
void CRIAPI AIXP_Finish(void);

/*	$func$ AIXPnh ̐
 * [@] AIXP AIXP_Create(CriSint32 maxtr, CriSint32 maxnch, void *work, CriSint32 worksize);
 * [@] maxntr	: őgbN
 *			maxnch	: őĐ`l(m݂̂PFXeIQ)
 *			work	: [N̈
 *			worksize: [N̈̃TCY
 * [o@] Ȃ
 * [֐l] AIXPnh
 * [@@\] AIXPnh𐶐B
 *			work̈̃TCÝAAIXP_CALC_WORK}Nɂċ߂B
 *  Creation of AIXP handle
 * [Format  ] AIXP AIXP_Create(CriSint32 maxtr, CriSint32 maxnch, void *work, CriSint32 worksize);
 * [Inputs  ] maxntr  : Number of maximum tracks
 *			  maxnch  : Number of maximum channels(monoral:1, stereo:2)
 *			  work    : Working area
 *			  worksize: Size of working area(byte)
 * [Outputs ] None
 * [Return  ] AIXP handle
 * [Function] Creates AIXP handle.
 * [Remarks ] Use 'AIXP_CALC_WORK' macro to calculate size of working area.
 */
AIXP CRIAPI AIXP_Create(CriSint32 maxntr, CriSint32 maxnch, void *work, CriSint32 worksize);

/*	$func$ AIXP 3Dnh ̐
 * [@] AIXP AIXP_Create3D(CriSint32 maxtr, void *work, CriSint32 worksize);
 * [@] maxntr	: őgbN
 *			work	: [N̈
 *			worksize: [N̈̃TCY
 * [o@] Ȃ
 * [֐l] AIXPnh
 * [@@\] A^C3DpjO\AIXPnh𐶐B
 *			work̈̃TCÝAAIXP_CALC_WORK_3D}Nɂċ߂B
 *  Creation of AIXP 3D handle
 * [Format  ] AIXP AIXP_Create3D(CriSint32 maxtr, void *work, CriSint32 worksize);
 * [Inputs  ] maxtr  : Number of maximum tracks
 *			  work    : Working area
 *			  worksize: Size of working area(byte)
 * [Outputs ] None
 * [Return  ] AIXP handle
 * [Function] Creates AIXP handle that can use realtime 3D panning.
 * [Remarks ] Use 'AIXP_CALC_WORK_3D' macro to calculate size of working area.
 */
AIXP CRIAPI AIXP_Create3D(CriSint32 maxntr, void *work, CriSint32 worksize);

/* $func$ AIXPnh ̏
 * [@] void AIXP_Destroy(AIXP aixp);
 * [@] AIXP	: AIXPnh
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] w肳ꂽ AIXPnhB
 *  Destroy of AIXP handle
 * [Format  ] void AIXP_Destroy(AIXP aixp);
 * [Inputs  ] AIXP   : AIXP handle
 * [Outputs ] None
 * [Return  ] None
 * [Function] Destroys specified AIXP handle.
 */
void CRIAPI AIXP_Destroy(AIXP aixp);

/* $func$ t[YĐp[N̈̐ݒ
 * [@] void AIXP_SetPhraseWork(AIXP aixp, void *work, CriSint32 wksize);
 * [@] AIXP	: AIXPnh
 *			work	: [N̈
 *			worksize: [N̈̃TCY
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] }`t[YAIXt@Ci5ȏ̃t[Y܂AIXt@Cj
 *          Đ̂ɕKvȃ[N̈ݒ肵܂B
 *          t[Y4ȉAIXt@CĐꍇɂ́A
 *          {֐gpKv͂܂B
 * [@l] [N̈̃TCÝAAIXP_CALC_PHRASE_WORK}NɂČvZ܂B
 *  Set the work area used for multi phrase playback
 * [Format  ] void AIXP_SetPhraseWork(AIXP aixp, void *work, CriSint32 wksize);
 * [Inputs  ] AIXP    : AIXP handle
 *			  work    : Working area
 *			  worksize: Size of working area(byte)
 * [Outputs ] None
 * [Return  ] None
 * [Function] Set the work area used for multi phrase (5 or more phases) playback.
 *            If you play AIX files which contain less than 4 phases, you don't 
 *            need to call this function.
 * [Remarks ] Use 'AIXP_CALC_PHRASE_WORK' macro to calculate size of working area.
*/
void CRIAPI AIXP_SetPhraseWork(AIXP aixp, void *work, CriSint32 wksize);

/* $func$ t@CwɂĐ̊Jn
 * [@] void AIXP_StartFname(AIXP aixp, CriChar8 *fname, void *atr);
 * [@] AIXP	: AIXPnh
 *			fname	: t@C
 *			atr		: fBNg
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] fname Ŏw肳ꂽAIXt@C̍ĐJnB
 *  Play start of AIX data specified file name
 * [Format  ] void AIXP_StartFname(AIXP aixp, CriChar8 *fname, void *atr);
 * [Inputs  ] AIXP	: AIXP handle
 *			  fname	: File name
 *			  atr	: Directry Information
 * [Outputs ] None
 * [Return  ] None
 * [Function] Starts to play AIX file when you specify file name.
 */
void CRIAPI AIXP_StartFname(AIXP aixp, const CriChar8 *fname, void *atr);

/* $func$ t@C͈͎̔wɂĐ̊Jn
 * [@] void AIXP_StartFnameRange(AIXP aixp, CriChar8 *fname, void *atr, CriSint32 ofst, CriSint32 nsct);
 * [@] AIXP	: AIXPnh
 *			fname	: t@C
 *			atr		: fBNg
 *			ofst	: ItZbg
 *			nsct	: TCY(ZN^P)
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] fname t@CofstnsctŎw肳ꂽAIXf[^̍ĐJnB
 *  Play start of AIX data specified file name and offset, size
 * [Format  ] void AIXP_StartFnameRange(AIXP aixp, CriChar8 *fname, void *atr, CriSint32 ofst, CriSint32 nsct);
 * [Inputs  ] AIXP	: AIXP handle
 *			  fname	: File name
 *			  atr	: Directry Information
 *			  ofst	: Offset(unit:sector)
 *			  nsct	: Size(unit:sector)
 * [Outputs ] None
 * [Return  ] None
 * [Function] Starts to play AIX data when you specify offset and size.
 */
void CRIAPI AIXP_StartFnameRange(AIXP aixp, const CriChar8 *fname, void *atr, CriSint32 ofst, CriSint32 nsct);

/* $func$ FID wɂĐ̊Jn
 * [@] void AIXP_StartAfs(AIXP aixp, CriSint32 patid, CriSint32 fid);
 * [@] AIXP	: AIXPnh
 *			patid	: p[eBVʎq
 *			fid		: t@Cʎq
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] p[eBVʎqƃt@CʎqŎw肳ꂽAIXt@C
 *			ĐJnB
 *  Play start of AIX data by specified file ID
 * [Format  ] void AIXP_StartAfs(AIXP aixp, CriSint32 patid, CriSint32 fid);
 * [Inputs  ] AIXP	: AIXP handl
 *			  patid	: Partition ID
 *			  fid	: File ID
 * [Outputs ] None
 * [Return  ] None
 * [Function] Starts to play AIX file when you specify partition ID and file ID.
 */
void CRIAPI AIXP_StartAfs(AIXP aixp, CriSint32 patid, CriSint32 fid);

/* $func$ Xg[WCgɂĐ̊Jn
 * [@] void AIXP_StartSj(AIXP aixp, SJ sj);
 * [@] AIXP	: AIXPnh
 *			sj		: Xg[WCg
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] Xg[WCg瓾f[^ĐB
 *  Play start of AIX data from Stream Joint
 * [Format  ] void AIXP_StartSj(AIXP aixp, SJ sj);
 * [Inputs  ] AIXP	: AIXP handle
 *			  sj	: Stream Joint
 * [Outputs ] None
 * [Return  ] None
 * [Function] Starts to play AIX file when you specify Stream Joint.
 */
void CRIAPI AIXP_StartSj(AIXP aixp, SJ sj);

/* $func$ wɂĐ̊Jn
 * [@] void AIXP_StartMem(AIXP aixp, void *aixdat, CriSint32 datlen);
 * [@] AIXP	: AIXPnh
 *			aixdat	: AIXf[^̃AhX
 *			datlen	: AIXf[^̑傫
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] aixdata Ŏw肳ꂽAIXf[^ĐB
 *  Play start of AIX data on memory
 * [Format  ] void AIXP_StartMem(AIXP aixp, void *aixdat, CriSint32 datlen);
 * [Inputs  ] AIXP	: AIXP handle
 *			  aixdat: Address of AIX data
 *			  datlen: Length of playing AIX data
 * [Outputs ] None
 * [Return  ] None
 * [Function] Starts to play AIX data on memory. Plays to specified length.
 */
void CRIAPI AIXP_StartMem(AIXP aixp, void *aixdat, CriSint32 datlen);

/* $func$ Đ̒~
 * [@] void AIXP_Stop(AIXP aixp);
 * [@] AIXP	: AIXPnh
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] AIX̍Đ~B
 *  Play stop
 * [Format  ] void AIXP_Stop(AIXP aixp);
 * [Inputs  ] AIXP	: AIXP handle
 * [Outputs ] None
 * [Return  ] None
 * [Function] Stops to play AIX data.
 */
void CRIAPI AIXP_Stop(AIXP aixp);

/* $func$ Ԃ̎擾
 * [@] CriSint32 AIXP_GetStat( AIXP aixp );
 * [@] AIXP	: AIXPnh
 * [o@] Ȃ
 * [֐l] ݂ AIXPnh̏Ԃ\萔
 * 				AIXP_STAT_STOP	 :	~
 *				AIXP_STAT_PREP	 :	Đ
 *				AIXP_STAT_PLAYING:	fR[hĐ
 *				AIXP_STAT_PLAYEND:	ĐI
 *				AIXP_STAT_ERROR	 :	G[
 * [@@\] ݂AIXPnh̏Ԃ擾B
 *  Get status
 * [Format  ] CriSint32 AIXP_GetStat( AIXP aixp );
 * [Inputs  ] AIXP	: AIXP handle
 * [Outputs ] None
 * [Return  ] Status of AIXP handle
 * [Function] Obtains status of AIXP handle.
 */
CriSint32 CRIAPI AIXP_GetStat(AIXP aixp);

/* $func$ TvPʂł̍Đ̎擾
 * [@] void AIXP_GetTime( AIXP aixp, CriSint32 *ncount, CriSint32 *tscale );
 * [@] aixp    : AIXPnh
 * [o@] ncount	: ĐTv
 *			tscale	: TvOg [ Hz ]
 * [֐l] Ȃ
 * [@@\] TvPʂōĐ擾B
 *  Get play time by sample unit
 * [Format  ] void AIXP_GetTime( AIXP aixp, CriSint32 *ncount, CriSint32 *tscale );
 * [Inputs  ] aixp	: AIXP handle
 * [Outputs ] ncount: Number of play sample
 *			  tscale: Sampling frequency(Hz)
 * [Return  ] None
 * [Function] Obtains play time by sample unit.
 */
void CRIAPI AIXP_GetTime(AIXP aixp, CriSint32 *ncount, CriSint32 *tscale);

/* $func$ ADXTnh̎擾
 * [@] ADXT AIXP_GetAdxt(AIXP aixp, CriSint32 trno);
 * [@] AIXP	: AIXPnh
 *			trno	: gbNԍ
 * [o@] Ȃ
 * [֐l] adxt	: ADXTnh
 * [@@\] ADXTnh擾B
 *  Getting a ADXT handle of specified track
 * [Format  ] ADXT AIXP_GetAdxt(AIXP aixp, CriSint32 trno);
 * [Inputs  ] AIXP	: AIXP handle
 *			  trno	: Track No.
 * [Outputs ] None
 * [Return  ] ADXT handle
 * [Function] Obtains a ADXT handle of specified track.
 */
ADXT CRIAPI AIXP_GetAdxt(AIXP aixp, CriSint32 trno);

/*	$func$ ēǂݍ݊JnԂ̐ݒ
 * [@] void AIXP_SetReloadTime(AIXP aixp, CriFloat32 time);
 * [@] AIXP	: AIXPnh
 *			time	: ēǂݍ݊JnԁiPʁFbj
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ̓obt@ւ̍ēǂݍ݊JnԂݒ肷B
 *			obt@̃f[^ʂ time bꍇ
 *			fBXNf[^ǂݍނ悤ݒ肵܂B
 *  Set the time of start sector to reload
 * [Format  ] void AIXP_SetReloadTime(AIXP aixp, CriFloat32 time);
 * [Inputs  ] AIXP	: AIXP handle
 *			  time  : start remain time (unit:second)
 * [Outputs ] None
 * [Return  ] None
 * [Function] Sets of the time of start sector to reload into input buffer.
 *			  Reads data from disc when a quantity of data in the input 
 *			  buffer becomes less than 'time' [second].
 */
void CRIAPI AIXP_SetReloadTime(AIXP aixp, CriFloat32 time);

/*	$func$ ̓obt@Đ
 * [@] CriFloat32 AIXP_GetIbufRemainTime(AIXP aixp);
 * [@] AIXP	: AIXPnh
 * [o@] Ȃ
 * [֐l] Đ\ԁ@(PʁFb)
 * [@@\] ̓obt@ɂf[^ōĐ\ȎԂ擾B
 *			AIXf[^̂ݑΉB
 * [Format  ] CriFloat32 AIXP_GetIbufRemainTime(AIXP aixp);
 * [Inputs  ] AIXP	: AIXP handle
 * [Outputs ] None
 * [Return  ] Playable time (sec)
 * [Function] Obtains playable time using only data in input buffer.
 *			  You can use this function only playing AIX data.
 */
CriFloat32 CRIAPI AIXP_GetIbufRemainTime(AIXP aixp);

/*	$func$ enh̃T[o֐@(Ԃ̍XV)
 * [@] CriSint32 AIXP_ExecHndl(AIXP aixp);
 * [@] AIXP	: AIXPnh
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] enh̓ԂXVB
 *			AIXP_ExecServerĂяoB
 *  Server function of each handle
 * [Format  ] CriSint32 AIXP_ExecHndl(AIXP aixp);
 * [Inputs  ] AIXP	: AIXP handle
 * [Outputs ] None
 * [Return  ] None
 * [Function] Update the inside status.
 *			  This function is called from 'AIXP_ExecServer' function.
 */
void CRIAPI AIXP_ExecHndl(AIXP aixp);

/*	$func$ T[o֐@(Ԃ̍XV)
 * [@] CriSint32 AIXP_ExecServer(void);
 * [@] Ȃ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] Cu̓ԂXVB
 *			V-Sync ɌĂяoȂ΂ȂȂB
 *  Server function
 * [Format  ] CriSint32 AIXP_ExecServer(void);
 * [Inputs  ] None
 * [Outputs ] None
 * [Return  ] None
 * [Function] Update the inside status of library.
 */
void CRIAPI AIXP_ExecServer(void);

/*	$func$ [v񐔂̎擾
 * [@] CriSint32 AIXP_GetLpCnt(AIXP aixp);
 * [@] AIXP	: AIXPnh
 * [o@] Ȃ
 * [֐l] [v
 * [@@\] [v񐔂擾B
 *  Get the number of times played a loop
 * [Format  ] CriSint32 AIXP_GetLpCnt(AIXP aixp);
 * [Inputs  ] AIXP	: AIXP handle
 * [Outputs ] None
 * [Return  ] Number of times played a loop
 * [Function] Obtains the number of times that played a loop.
 */
CriSint32 CRIAPI AIXP_GetLpCnt(AIXP aixp);

/*	$func$ [vXCb`̐ݒ
 * [@] void AIXP_SetLpSw(AIXP aixp, CriSint32 sw);
 * [@] aixp	: AIXPnh
 *			sw		: 1=[vA0=[vȂ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] [v邩ۂݒ肷B
 */
void CRIAPI AIXP_SetLpSw(AIXP aixp, CriSint32 sw);

/*	$func$ t[YNXCb`̐ݒ
 * [@] void AIXP_SetLnkSw(AIXP aixp, CriSint32 sw);
 * [@] aixp	: AIXPnh
 *			sw		: 1=AA0=AȂ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] t[YAĐ邩ۂݒ肷B
 */
void CRIAPI AIXP_SetLnkSw(AIXP aixp, CriSint32 sw);

/*	$func$ ĐJnt[Yԍ̐ݒ
 * [@] void AIXP_SetStartPh(AIXP aixp, CriSint32 phno);
 * [@] aixp	: AIXPnh
 *			phno	: t[Yԍ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ĐJnt[Yԍݒ肷B
 */
void CRIAPI AIXP_SetStartPh(AIXP aixp, CriSint32 phno);

/*	$func$ ĐJnt[Yԍ̎擾
 * [@] CriSint32 AIXP_GetStartPh(AIXP aixp);
 * [@] aixp	: AIXPnh
 * [o@] Ȃ
 * [֐l] t[Yԍ
 * [@@\] ĐJnt[Yԍ擾B
 */
CriSint32 CRIAPI AIXP_GetStartPh(AIXP aixp);

/*	$func$ [v̐ݒ
 * [@] void AIXP_SetLpInfo(AIXP aixp, CriSint32 start_phno, CriSint32 length);
 * [@] aixp		: AIXPnh
 *			start_phno	: Jnt[Yԍ
 *			length		: [vt[Y
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] [v(Jnt[Yԍƒ)ݒ肷B
 *  Set the loop infomation
 * [Format  ] void AIXP_SetLpInfo(AIXP aixp, CriSint32 start_phno, CriSint32 length);
 * [Inputs  ] AIXP			: AIXP handle
 *			  start_phno	: start phrase number
 *			  length		: loop length in phrase count
 * [Outputs ] None
 * [Return  ] None
 * [Function] Set the loop infomation.
 */
void CRIAPI AIXP_SetLpInfo(AIXP aixp, CriSint32 start_phno, CriSint32 length);

/*	$func$ [v̎擾
 * [@] void AIXP_GetLpInfo(AIXP aixp, CriSint32 *start_phno, CriSint32 *length);
 * [@] aixp		: AIXPnh
 *			start_phno	: Jnt[Yԍi[ϐւ̃|C^
 *			length		: [vt[Yi[ϐւ̃|C^
 * [o@] Ȃ
 * [֐l] t[Yԍ
 * [@@\] [vX^[gt[Yԍ擾B
 *  Get the loop infomation
 * [Format  ] void AIXP_GetLpInfo(AIXP aixp, CriSint32 *start_phno, CriSint32 *length);
 * [Inputs  ] AIXP			: AIXP handle
 *			  start_phno	: pointer to start phrase number
 *			  length		: pointer to loop length in phrase count
 * [Outputs ] None
 * [Return  ] None
 * [Function] Get the loop infomation.
 */
void CRIAPI AIXP_GetLpInfo(AIXP aixp, CriSint32 *start_phno, CriSint32 *length);

/*	$func$ ꎞ~̐ݒ
 * [@] void AIXP_Pause(AIXP aixp, CriSint32 sw);
 * [@] AIXP	: AIXPnh
 *			sw		: 1=ꎞ~A0=ĊJ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ꎞ~邩ۂݒ肷B
 *  Pause/Continue
 * [Format  ] void AIXP_Pause(AIXP aixp, CriSint32 sw);
 * [Inputs  ] AIXP	: AIXP handle
 *			  sw	: 1=pause, 0=continue
 * [Outputs ] None
 * [Return  ] None
 * [Function] Stops temporarily by a specified switch and release temporary 
 *			  standstill.
 */
void CRIAPI AIXP_Pause(AIXP aixp, CriSint32 sw);

/*	$func$ ꎞ~Ԃ̎擾
 * [@] CriSint32 AIXP_GetStatPause(AIXP aixp);
 * [@] aixp	: AIXPnh
 * [o@] ꎞ~ 1=ꎞ~A0=ꎞ~
 * [֐l] Ȃ
 * [@@\] ꎞ~Ԃ擾B
 *  Pause/Continue
 * [Format  ] CriSint32 AIXP_GetStatPause(AIXP aixp);
 * [Inputs  ] aixp	: AIXP handle
 * [Outputs ] 1=pause, 0=not pause
 * [Return  ] None
 * [Function] Obtains the status of pause.
 */
CriSint32 CRIAPI AIXP_GetStatPause(AIXP aixp);

/*			mo̓XCb`̐ݒ	
[  ]	void AIXP_SetOutoputMono(CriSint32 flag);
[  ]	CriSint32 flag		mo̓tO(OFF:0, ON:1)
[߂l]	Ȃ					
[@  \]	XeIf[^IɃmf[^Ƃďo͂B
[@l]	
*/
/* 2003-02-26 ݖ */
/* Not implemented... */
/* void CRIAPI AIXP_SetOutputMono(CriSint32 flag); */

/* $func$ f[^̑Tv̎擾
 * [@] CriSint32 AIXP_GetTotalNumSmpl(AIXP aixp);
 * [@] aixp	: AIXPnh
 * [o@] Ȃ
 * [֐l] f[^̑Tv
 * [@@\] Đ AIX f[^̑Tv擾B
 * [@l] ԂAĐ(AIXP_STAT_PLAYING)ĐI(AIXP_STAT_PLAYEND)
 *			܂ł̎Ɏ擾\B
 *  Get total number of sample of the sound data
 * [Format  ] CriSint32 AIXP_GetTotalNumSmpl(AIXP aixp);
 * [Inputs  ] aixp	: AIXP handle
 * [Outputs ] None
 * [Return  ] Total number of sample of sound data
 * [Function] Obtains a total number of sample of sound data.
 * [Remarks ] You can obtain when status is between
 *			  playing(AIXP_STAT_PLAYING) and play end(AIXP_STAT_PLAYEND).
 */
CriSint32 CRIAPI AIXP_GetTotalNumSmpl(AIXP aixp);

/* $func$ gbN̎擾
 * [@] CriSint32 AIXP_GetNumTrack(AIXP aixp);
 * [@] aixp	: AIXPnh
 * [o@] Ȃ
 * [֐l] gbN
 * [@@\] Đ AIX f[^̃gbN擾B
 * [@l] ԂAĐ(AIXP_STAT_PLAYING)ĐI(AIXP_STAT_PLAYEND)
 *			܂ł̎Ɏ擾\B
 *  Get number of the track
 * [Format  ] CriSint32 AIXP_GetNumTrack(AIXP aixp);
 * [Inputs  ] aixp	: AIXP handle
 * [Outputs ] None
 * [Return  ] Number of the track
 * [Function] Obtains number of the track.
 * [Remarks ] You can obtain when status is between
 *			  playing(AIXP_STAT_PLAYING) and play end(AIXP_STAT_PLAYEND).
 */
CriSint32 CRIAPI AIXP_GetNumTrack(AIXP aixp);

/* $func$ t[Y̎擾
 * [@] CriSint32 AIXP_GetNumPhrase(AIXP aixp);
 * [@] aixp	: AIXPnh
 * [o@] Ȃ
 * [֐l] gbN
 * [@@\] Đ AIX f[^̃t[Y擾B
 * [@l] ԂAĐ(AIXP_STAT_PLAYING)ĐI(AIXP_STAT_PLAYEND)
 *			܂ł̎Ɏ擾\B
 *  Get number of the phrase
 * [Format  ] CriSint32 AIXP_GetNumPhrase(AIXP aixp);
 * [Inputs  ] aixp	: AIXP handle
 * [Outputs ] None
 * [Return  ] Number of the phrase
 * [Function] Obtains number of the phrase.
 * [Remarks ] You can obtain when status is between
 *			  playing(AIXP_STAT_PLAYING) and play end(AIXP_STAT_PLAYEND).
 */
CriSint32 CRIAPI AIXP_GetNumPhrase(AIXP aixp);

/* $func$ \O̎擾
 * [@] CriSint32 AIXP_GetNumSong(AIXP aixp);
 * [@] aixp	: AIXPnh
 * [o@] Ȃ
 * [֐l] gbN
 * [@@\] Đ AIX f[^̃\O擾B
 * [@l] ԂAĐ(AIXP_STAT_PLAYING)ĐI(AIXP_STAT_PLAYEND)
 *			܂ł̎Ɏ擾\B
 *  Get number of the song
 * [Format  ] CriSint32 AIXP_GetNumSong(AIXP aixp);
 * [Inputs  ] aixp	: AIXP handle
 * [Outputs ] None
 * [Return  ] Number of the song
 * [Function] Obtains number of the song
 * [Remarks ] You can obtain when status is between
 *			  playing(AIXP_STAT_PLAYING) and play end(AIXP_STAT_PLAYEND).
 */
CriSint32 CRIAPI AIXP_GetNumSong(AIXP aixp);

/*	$func$ o̓{[̎擾
 * [@] CriSint32 AIXP_GetOutVol(AIXP aixp);
 * [@] aixp	: AIXPnh
 * [o@] Ȃ
 * [֐l] x@(0:-0dB, -999:-99.9dB)
 * [@@\] o̓{[擾B
 *  Get volume
 * [Format  ] CriSint32 AIXP_GetOutVol(AIXP aixp);
 * [Inputs  ] aixp	: AIXP handle
 * [Outputs ] None
 * [Return  ] Volume (0:-dB, -999:-99.9dB)
 * [Function] Gets the volume.
 */
CriSint32 CRIAPI AIXP_GetOutVol(AIXP aixp);

/*	$func$ o̓{[̐ݒ
 * [@] void AIXP_SetOutVol(AIXP aixp, CriSint32 vol);
 * [@] aixp	: AIXPnh
 *			vol		: x@(0:-0dB, -999:-99.9dB)
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] o̓{[ݒ肷B
 *			vol̐ݒl	0    :    -0dB  Ȃ
 *						-30  :    -3dB  70%
 *						-60  :    -6dB  50%
 *						-999 : -99.9dB  ő̌
 *  Set volume
 * [Format  ] void AIXP_SetOutVol(AIXP aixp, CriSint32 vol);
 * [Inputs  ] aixp	: AIXP handle
 *			  vol	: Volume (0:-dB, -999:-99.9dB)
 * [Outputs ] None
 * [Return  ] None
 * [Function] Sets the volume.
 *			 'vol'value	0    :    -0dB  No attenuation
 *						-30  :    -3dB  about 70%
 *						-60  :    -6dB  about 50%
 *						-999 : -99.9dB  Maximum attenuation
 */
void CRIAPI AIXP_SetOutVol(AIXP aixp, CriSint32 vol);

/*	$func$ gbNƂ̏o̓{[̎擾
 * [@] CriSint32 AIXP_GetTrackVol(AIXP aixp, CriSint32 trno);
 * [@] aixp	: AIXPnh
 *          trno    : gbNԍ
 * [o@] Ȃ
 * [֐l] x@(0:-0dB, -999:-99.9dB)
 * [@@\] gbNPʂ̏o̓{[擾B
 *  Get track volume
 * [Format  ] CriSint32 AIXP_GetTrackVol(AIXP aixp, CriSint32 trno);
 * [Inputs  ] aixp	: AIXP handle
 *            trno  : Track No.
 * [Outputs ] None
 * [Return  ] Volume (0:-dB, -999:-99.9dB)
 * [Function] Gets the volume of specified track.
 */
CriSint32 CRIAPI AIXP_GetTrackVol(AIXP aixp, CriSint32 trno);

/*	$func$ gbNƂ̏o̓{[̐ݒ
 * [@] void AIXP_SetTrackVol(AIXP aixp, CriSint32 trno, CriSint32 vol);
 * [@] aixp	: AIXPnh
 *          trno    : gbNԍ
 *			vol		: x@(0:-0dB, -999:-99.9dB)
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] gbNPʂ̏o̓{[ݒ肷B
 *			vol̐ݒl	0    :    -0dB  Ȃ
 *						-30  :    -3dB  70%
 *						-60  :    -6dB  50%
 *						-999 : -99.9dB  ő̌
 *  Set track volume
 * [Format  ] void AIXP_SetTrackVol(AIXP aixp, CriSint32 trno, CriSint32 vol);
 * [Inputs  ] aixp	: AIXP handle
 *            trno  : Track No.
 *			  vol	: Volume (0:-dB, -999:-99.9dB)
 * [Outputs ] None
 * [Return  ] None
 * [Function] Sets the volume of specified track.
 *			 'vol'value	0    :    -0dB  No attenuation
 *						-30  :    -3dB  about 70%
 *						-60  :    -6dB  about 50%
 *						-999 : -99.9dB  Maximum attenuation
 */
void CRIAPI AIXP_SetTrackVol(AIXP aixp, CriSint32 trno, CriSint32 vol);

/* $func$ f[^(oCgCg)̎擾
 * [@] CriSint32 AIXP_GetByteRate(AIXP aixp);
 * [@] aixp	: AIXPnh
 * [o@] Ȃ
 * [֐l] f[^(oCgCg)
 * [@@\] Đ AIX f[^̃f[^ʂ擾B
 * [@l] ԂAĐ(AIXP_STAT_PLAYING)ĐI(AIXP_STAT_PLAYEND)
 *			܂ł̎Ɏ擾\B
 */
CriSint32 CRIAPI AIXP_GetByteRate(AIXP aixp);

/* $func$ t[YRg[pR[obN֐̓o^
 * [@] void AIXP_SetCbPhraseControl(AIXP aixp, AIXP_CBFN_PHCTRL cbfunc, void *obj);
 * [@] AIXP	: AIXPnh
 *			cbfunc	: t[YRg[R[obN֐
 *			obj		: Cӂ̈nIuWFNg
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] t[YRg[p̃R[obN֐o^܂
 * [@] {֐AIXP_SetNumPreloadPhrases֐Ƃ𕹗p邱Ƃ͂ł܂B
 *  Setting callback function for phrase control
 * [Format  ] void AIXP_SetCbPhraseControl(AIXP aixp, AIXP_CBFN_PHCTRL cbfunc, void *obj);
 * [Inputs  ] AIXP	 : AIXP handle
 *			  cbfunc : callback function for phrase controls.
 *			  obj	 : Object for argument
 * [Outputs ] None
 * [Return  ] None
 * [Function] Setting callback function for phrase controls.
 * [Note    ] It is impossible to use both this function and 
 *            the AIXP_SetNumPreloadPhrases function.
 */
void CRIAPI AIXP_SetCbPhraseControl(AIXP aixp, AIXP_CBFN_PHCTRL cbfunc, void *obj);

/* $func$ v[ht[Y̐ݒ
 * [@] void AIXP_SetNumPreloadPhrases(AIXP aixp, CriSint32 num);
 * [@] AIXP	: AIXPnh
 *			num		: ĐJnɈꊇ[ht[Y
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ĐJnɈꊇ[ht[Y̐ݒ肵܂
 * [@l] v[ht[ỸftHgl1łB
 *@@@@@[ht[Y̐ύXۂɂ́A1ȏ̒lݒ肵ĂB
 * [@] {֐AIXP_SetCbPhraseControl֐Ƃ𕹗p邱Ƃ͂ł܂B
 *  Set the number of preload phrases
 * [Format  ] void AIXP_SetNumPreloadPhrases(AIXP aixp, CriSint32 num);
 * [Inputs  ] AIXP	 : AIXP handle
 *			  num    : Number of preload phrases
 * [Outputs ] None
 * [Return  ] None
 * [Function] Set the number of phrases that will be preloaded at 
 *            the beginning of the playback.
 * [Remarks ] The default value of 'num' is 1.
 *            You must specify 1 or greater to 'num'.
 * [Note    ] It is impossible to use both this function and 
 *            the AIXP_SetCbPhraseControl function.
 */
void CRIAPI AIXP_SetNumPreloadPhrases(AIXP aixp, CriSint32 num);

/* $func$ v[ht[Y̎擾
 * [@] CriSint32 AIXP_GetNumPreloadPhrases(AIXP aixp);
 * [@] AIXP	: AIXPnh
 * [o@] Ȃ
 * [֐l] ĐJnɈꊇ[ht[Y
 * [@@\] ĐJnɈꊇ[ht[Y̐擾܂
 *  Get the number of preload phrases
 * [Format  ] CriSint32 AIXP_GetNumPreloadPhrases(AIXP aixp);
 * [Inputs  ] AIXP	 : AIXP handle
 * [Outputs ] None
 * [Return  ] Number of preload phrases
 * [Function] Get the number of phrases that will be preloaded at 
 *            the beginning of the playback.
 */
CriSint32 CRIAPI AIXP_GetNumPreloadPhrases(AIXP aixp);

/* $func$ ftHg̃T[og̐ݒ
 * [@] void AIXP_SetDefSvrFreq(CriSint32 freq);
 * [@] freq : T[o֐̌Ăяopxi1b̌Ăяo񐔁j
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] T[o֐ɃfR[hʂ𐧌䂵܂B
 *@@@@@ftHgł́A60iVsyncjݒ肳Ă܂B
 * [@l] {֐́AVysncg60Hzł͂ȂŁAfR[hʂ
 *@@@@@邽߂Ɏgp܂B
 */
void CRIAPI AIXP_SetDefSvrFreq(CriSint32 freq);

/* $func$ T[og̐ݒ
 * [@] void AIXP_SetSvrFreq(AIXP aixp, CriSint32 freq);
 * [@] aixp : AIXPnh
 *@@@@@freq : T[o֐̌Ăяopxi1b̌Ăяo񐔁j
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] T[o֐ɃfR[hʂnhPʂŐ䂵܂B
 *@@@@@ftHgł́A60iVsyncjݒ肳Ă܂B
 * [@l] {֐́A̍Đsb`グꍇAnhPʂ
 *@@@@@f[^̃fR[hʂ𒲐ꍇɎgp܂B
 *@@@@@freq̒lɂ́u1b̉f[^VsyncŃfR[h邩v
 *@@@@@w肵܂B
 *@@@@@Ⴆ΁A30w肵ꍇɂ́A60VsyncŃfR[h镪̉
 *@@@@@f[^A30VsyncŃfR[hĂ܂܂B
 */
void CRIAPI AIXP_SetSvrFreq(AIXP aixp, CriSint32 freq);

/* $func$ fR[hf[^̔j
 * [@] CriSint32 AIXP_DiscardSmpl(AIXP aixp, CriSint32 nsmpl);
 * [@] aixp  : AIXPnh
 *			nsmpl : jTv
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] fR[hf[^j܂B
 *m@ln{֐́AĐʒuXLbv邽߂Ɏgp܂B
 * [@] ̊֐ADXTnh̃Xe[^XADXT_STAT_PLAYINGɂȂ
 *@@@@@ĂĂԕKv܂
 *@@@@@܂Aʂ̃f[^jꍇAo̓f[^̌͊ɂTE
 *@@@@@hobt@̉IɃ[včĐꍇ
 *@@@@@܂B
 */
CriSint32 CRIAPI AIXP_DiscardSmpl(AIXP aixp, CriSint32 nsmpl);


/* $func$ ĐJnʒu̐ݒibPʁj
 * [@] void CRIAPI AIXP_SetStartTime(AIXP aixp, CriFloat32 start_time);
 * [@] AIXP		: AIXPnh
 *			start_time	: ĐJnʒuibPʁj
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ĐJnʒubPʂŐݒ肵܂B
 * [@l] ĐiPREPPLAYEND܂ށjɐݒ肵ꍇAĐJnɓKp܂B
 * [@] (a) {֐AIXP_SetStartPh֐AAIXP_SetStartSmpl֐Ƃ𕹗p邱Ƃ͂ł܂BiɌĂяoDj
 * 			(b) [vĐɂ͎gpł܂B
 * 			(c) t[Y܂ރf[^̍Đɂ͎gpł܂B
 * 			(d) ĐiAIXP_StartMem֐ɂĐjɂ͎gpł܂B
 * Set the start position of a playback by the second
 * [Format  ] void CRIAPI AIXP_SetStartTime(AIXP aixp, CriFloat32 start_time);
 * [Inputs  ] AIXP			: AIXP handle
 *			  start_time	: Start position of a playback by the second
 * [Outputs ] None
 * [Return  ] None
 * [Function] This function sets the start position of a playback by the second.
 * [Remarks ] If you call this function after a playback is started,
 *            the setting is applied at the next playback.
 * [Note    ] (a) It is impossible to use both this function and the
 * 				  AIXP_SetStartPh function or the AIXP_SetStartSmpl function.
 * 				  Only the function that has been last called is effective.
 * 			  (b) This function can not be used for a looping playback.
 * 			  (c) This function can not be used for the AIX data which is
 *				  including phrase information.
 * 			  (d) This function can not be used for the playback started by
 * 				  AIXP_StartMem function.
 */
void CRIAPI AIXP_SetStartTime(AIXP aixp, CriFloat32 start_time);

/* $func$ ĐJnʒu̎擾ibPʁj
 * [@] CriFloat32 CRIAPI AIXP_GetStartTime(AIXP aixp);
 * [@] AIXP		: AIXPnh
 * [o@] Ȃ
 * [֐l] ĐJnʒuibPʁj
 * [@@\] ĐJnʒubPʂŎ擾܂B
 *  Get the start position of a playback by the second
 * [Format  ] CriFloat32 CRIAPI AIXP_GetStartTime(AIXP aixp);
 * [Inputs  ] AIXP			: AIXP handle
 * [Outputs ] None
 * [Return  ] Start position of a playback by the second
 * [Function] This function gets the start position of a playback by the second.
 */
CriFloat32 CRIAPI AIXP_GetStartTime(AIXP aixp);

/* $func$ ĐJnʒu̐ݒiTvPʁj
 * [@] void CRIAPI AIXP_SetStartSmpl(AIXP aixp, CriSint32 start_smpl);
 * [@] AIXP		: AIXPnh
 *			start_smpl	: ĐJnʒuiTvPʁj
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ĐJnʒuTvPʂŐݒ肵܂B
 * [@l] ĐiPREPPLAYEND܂ށjɐݒ肵ꍇAĐJnɓKp܂B
 * [@] (a) {֐AIXP_SetStartPh֐AAIXP_SetStartTime֐Ƃ𕹗p邱Ƃ͂ł܂BiɌĂяoDj
 * 			(b) [vĐɂ͎gpł܂B
 * 			(c) t[Y܂ރf[^̍Đɂ͎gpł܂B
 * 			(d) ĐiAIXP_StartMem֐ɂĐjɂ͎gpł܂B
 * Set the start position of a playback by the number of samples
 * [Format  ] void CRIAPI AIXP_SetStartSmpl(AIXP aixp, CriSint32 start_smpl);
 * [Inputs  ] AIXP			: AIXP handle
 *			  start_smpl	: Start position of a playback by the number of samples
 * [Outputs ] None
 * [Return  ] None
 * [Function] This function sets the start position of a playback by the second.
 * [Remarks ] If you call this function after a playback is started,
 *            the setting is applied at the next playback.
 * [Note    ] (a) It is impossible to use both this function and the
 * 				  AIXP_SetStartPh function or the AIXP_SetStartTime function.
 * 				  Only the function that has been last called is effective.
 * 			  (b) This function can not be used for a looping playback.
 * 			  (c) This function can not be used for the AIX data which is
 *				  including phrase information.
 * 			  (d) This function can not be used for the playback started by
 * 				  AIXP_StartMem function.
 */
void CRIAPI AIXP_SetStartSmpl(AIXP aixp, CriSint32 start_smpl);

/* $func$ ĐJnʒu̎擾iTvPʁj
 * [@] CriSint32 CRIAPI AIXP_GetStartSmpl(AIXP aixp);
 * [@] AIXP		: AIXPnh
 * [o@] Ȃ
 * [֐l] ĐJnʒuiTvPʁj
 * [@@\] ĐJnʒuTvPʂŎ擾܂B
 *  Get the start position of a playback by the number of samples
 * [Format  ] CriSint32 CRIAPI AIXP_GetStartSmpl(AIXP aixp);
 * [Inputs  ] AIXP			: AIXP handle
 * [Outputs ] None
 * [Return  ] Start position of a playback by the number of samples
 * [Function] This function gets the start position of a playback by the number of samples.
 */
CriSint32 CRIAPI AIXP_GetStartSmpl(AIXP aixp);

/*--------------------------------------------------------------------------*/
/*		U擾p֐														*/
/*		Functions for amplitude analysis									*/
/*--------------------------------------------------------------------------*/

/* $func$ U擾p[N̈TCY̌vZ
 * [@] CriSint32 AIXP_CalcAmpWork(CriSint32 maxtr, CriSint32 maxnch);
 * [@] maxtr	: őgbN
 *          maxnch	: ő`l
 * [o@] Ȃ
 * [֐l] [N̈TCY
 * [@@\] U擾@\gp̂ɕKvȃ[N̈̃TCYvZ܂B
 * Work area size calculation
 * [Format  ] CriSint32 AIXP_CalcAmpWork(CriSint32 maxtr, CriSint32 maxnch);
 * [Inputs  ] maxtr	: Number of maximum tracks
 *            maxch	: Number of maximum channels
 * [Outputs ] None
 * [Return  ] Work area size
 * [Function] Calculate work area size used for amplitude analysis.
 */
CriSint32 CRIAPI AIXP_CalcAmpWork(CriSint32 maxtr, CriSint32 maxnch);

/* $func$ U擾pƗ̈̐ݒ
 * [@] void AIXP_SetAmpWork(AIXP aixp, void *work, CriSint32 wksize);
 * [@] AIXP	: AIXPnh
 *          work	: [N̈
 *          wksize	: [N̈TCY
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] AIXPnhɐU擾@\t܂
 * Set the work area used for amplitude analysis
 * [Format  ] void AIXP_SetAmpWork(AIXP aixp, void *work, CriSint32 wksize);
 * [Inputs  ] AIXP		: AIXP handle
 *            work		: Working area
 *            worksize	: Size of working area (Byte)
 * [Outputs ] None
 * [Return  ] None
 * [Function] Set the work area to AIXP handle and enable the amplitude 
 *            analysis function.
 */
void CRIAPI AIXP_SetAmpWork(AIXP aixp, void *work, CriSint32 wksize);

/* $func$ U̎擾
 * [@] CriSint32 AIXP_GetAmplitude(AIXP aixp, CriSint32 tr, CriSint32 ch);
 * [@] AIXP	: AIXPnh
 *          tr		: gbNԍ
 *          ch		: `lԍ
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] Đ̉̐U擾܂B
 * Get the amplitude of the audio signal
 * [Format  ] CriSint32 AIXP_GetAmplitude(AIXP aixp, CriSint32 tr, CriSint32 ch);
 * [Inputs  ] AIXP		: AIXP handle
 *            tr		: Track number
 *            ch		: Channel number
 * [Outputs ] None
 * [Return  ] None
 * [Function] Get the amplitude of the audio signal under playing.
 */
CriSint32 CRIAPI AIXP_GetAmplitude(AIXP aixp, CriSint32 tr, CriSint32 ch);

/* $func$ U̎擾iItZbgwtj
 * [@] CriSint32 AIXP_GetAmplitude2(
 *              AIXP aixp, CriSint32 tr, CriSint32 ch, CriSint32 msec, CriSint32 *msec2);
 * [@] AIXP	: AIXPnh
 *          tr		: gbNԍ
 *          ch		: `lԍ
 *          msec	: vimsec~bO̐U擾j
 *          msec2	: 擾łU̎iۂɑkꂽj
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ĐỎ̐UOɎ擾܂B
 * Gets the amplitude of the audio signal (with time offset)
 * [Format  ] CriSint32 AIXP_GetAmplitude2(
 *                AIXP aixp, CriSint32 tr, CriSint32 ch, CriSint32 msec, CriSint32 *msec2);
 * [Inputs  ] AIXP		: AIXP handle
 *            tr		: Track number
 *            ch		: Channel number
 *            msec		: Request time (Get the amplitude which will be 
 *                        played after 'msec' millisecond.)
 *            msec2		: Actual time (actual time of acquired amplitude.)
 * [Outputs ] None
 * [Return  ] None
 * [Function] Get the amplitude of the audio signal before it played.
 */
CriSint32 CRIAPI AIXP_GetAmplitude2(
	AIXP aixp, CriSint32 tr, CriSint32 ch, CriSint32 msec, CriSint32 *msec2);

/*--------------------------------------------------------------------------*/
/*		Íp֐														*/
/*		Functions for encrypted file										*/
/*--------------------------------------------------------------------------*/

/* $func$ L[R[h̐ݒ
 * [@] void AIXP_SetKeyString(AIXP aixp, CriChar8 *str);
 * [@] aixp	: AIXPnh
 *          str     : L[
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] AIXnhɑ΂ĈÍp̃L[ݒ肷B
 * [@l] L[񂪐ݒ肳ꂽԂłAÍĂȂAIXt@C
 *          ɂĂ͍Đ\B
 */
void CRIAPI AIXP_SetKeyString(AIXP aixp, CriChar8 *str);

/*--------------------------------------------------------------------------*/
/*		}``lĐ@\										*/
/*		Functions for multi-channel audio playback							*/
/*--------------------------------------------------------------------------*/
/*	$func$ }``lĐ@\̑gݍ
 * [@] void AIXP_AttachMultiChannel(AIXP aixp, void *work, CriSint32 wksize);
 * [@] aipx	: AIXPnh
 *			work	: }``lĐp[N̈i=NULLj
 *			wksize	: }``lĐp[N̈i=0j
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] AIXPnhɑ΂ă}``lĐ@\ǉB
 *          {֐sɍĐAIX́ASă}``lI[fBI
 *          ƂčĐB
 * [  l] Aǉ̃[N͕̈svB
 *  Attachs multi-channel playback function
 * [Format  ] void AIXP_AttachMultiChannel(AIXP aixp, void *work, CriSint32 wksize);
 * [Inputs  ] aixp    : AIXP handle
 *			  work    : Working area for multi-channel playback (=NULL)
 *			  worksize: Size of multi-channel playback working area (=0)
 * [Outputs ] None
 * [Return  ] None
 * [Function] Attachs multi-channel playback function.
 *            Once this function has been called,
 *            all AIX data is played as multi-channel audio.
 * [Remarks ] Currently, no additional work area is required.
 */
void CRIAPI AIXP_AttachMultiChannel(AIXP aixp, void *work, CriSint32 wksize);

/*	$func$ }``lĐ@\̎O
 * [@] void AIXP_DetachMultiChannel(AIXP aixp);
 * [@] aipx	: AIXPnh
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] AIXPnh}``lĐ@\OB
 *  Detachs multi-channel playback function
 * [Format  ] void AIXP_DetachMultiChannel(AIXP aixp);
 * [Inputs  ] aixp    : AIXP handle
 * [Outputs ] None
 * [Return  ] None
 * [Function] Detachs multi-channel playback function.
 */
void CRIAPI AIXP_DetachMultiChannel(AIXP aixp);

/* $func$ t@CwɂĐ̊Jn(PCł̃}``lo͗p)
 * [@] void AIXP_StartFnameMultiChannel(AIXP aixp, CriSint8 *fname);
 * [@] AIXP	: AIXPnh
 *			fname	: t@C
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] fname Ŏw肳ꂽAIXt@C5.1chōĐB
 * [  l] {}N͋o[WƂ̌݊̂߂ɗpӂĂ܂B
 *  Play start of AIX data specified file name (support PC multi channel audio output)
 * [Format  ] void AIXP_StartFnameMultiChannel(AIXP aixp, CriSint8 *fname);
 * [Inputs  ] AIXP	: AIXP handle
 *			  fname	: File name
 * [Outputs ] None
 * [Return  ] None
 * [Function] Starts to play 5.1ch AIX file when you specify file name.
 * [Remarks ] This macro is only for compatibility with old version.
 */
#define AIXP_StartFnameMultiChannel(aixp, fname, atr)		\
{															\
	AIXP_AttachMultiChannel(aixp, NULL, 0);					\
	AIXP_StartFname(aixp, fname, atr);						\
}															\

/* $func$ FID wɂĐ̊Jn(PCł̃}``lo͗p)
 * [@] void AIXP_StartAfsMultiChannel(AIXP aixp, CriSint32 patid, CriSint32 fid);
 * [@] AIXP	: AIXPnh
 *			patid	: p[eBVʎq
 *			fid		: t@Cʎq
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] p[eBVʎqƃt@CʎqŎw肳ꂽAIXf[^5.1chōĐB
 * [  l] {}N͋o[WƂ̌݊̂߂ɗpӂĂ܂B
 *  Play start of AIX data by specified file ID (support PC multi channel audio output)
 * [Format  ] void AIXP_StartAfsMultiChannel(AIXP aixp, CriSint32 patid, CriSint32 fid);
 * [Inputs  ] AIXP	: AIXP handl
 *			  patid	: Partition ID
 *			  fid	: File ID
 * [Outputs ] None
 * [Return  ] None
 * [Function] Starts to play 5.1ch AIX data when you specify partition ID and file ID.
 * [Remarks ] This macro is only for compatibility with old version.
 */
#define AIXP_StartAfsMultiChannel(aixp, patid, fid)			\
{															\
	AIXP_AttachMultiChannel(aixp, NULL, 0);					\
	AIXP_StartAfs(aixp, patid, fid);						\
}															\

/* $func$ wɂĐ̊Jn(PCł̃}``lo͗p)
 * [@] void AIXP_StartMemMultiChannel(AIXP aixp, void *aixdat, CriSint32 datlen);
 * [@] AIXP	: AIXPnh
 *			aixdat	: AIXf[^̃AhX
 *			datlen	: AIXf[^̑傫
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] aixdata Ŏw肳ꂽAIXf[^5.1chōĐB
 * [  l] {}N͋o[WƂ̌݊̂߂ɗpӂĂ܂B
 *  Play start of AIX data on memory (support PC multi channel audio output)
 * [Format  ] void AIXP_StartMemMultiChannel(AIXP aixp, void *aixdat, CriSint32 datlen);
 * [Inputs  ] AIXP	: AIXP handle
 *			  aixdat: Address of AIX data
 *			  datlen: Length of playing AIX data
 * [Outputs ] None
 * [Return  ] None
 * [Function] Starts to play 5.1ch AIX data on memory. Plays to specified length.
 * [Remarks ] This macro is only for compatibility with old version.
 */
#define AIXP_StartMemMultiChannel(aixp, aixdat, datlen)		\
{															\
	AIXP_AttachMultiChannel(aixp, NULL, 0);					\
	AIXP_StartMem(aixp, aixdat, datlen);					\
}															\

/* $func$ Xs[J[ʃ{[w(PCł̃}``lo͗p)
 * [@] void AIXP_SetOutVolMultiChannel(AIXP aixp, CriSint32 spkid, CriSint32 vol);
 * [@] AIXP	: AIXPnh
 *			spkid	: Xs[J[ID
 *			vol		: {[
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] spkid Ŏw肳ꂽXs[J[̃{[ݒ肷B
 *  Setting volumes to speaker (support PC multi channel audio output)
 * [Format  ] void AIXP_SetOutVolMultiChannel(AIXP aixp, CriSint32 spkid, CriSint32 vol);
 * [Inputs  ] AIXP	: AIXP handle
 *			  spkid	: Speaker ID
 *			  vol	: Volume
 * [Outputs ] None
 * [Return  ] None
 * [Function] Setting volumes specified by spkid.
 */
void CRIAPI AIXP_SetOutVolMultiChannel(AIXP aixp, CriSint32 spkid, CriSint32 vol);

#if defined(XPT_TGT_PC)
/*--------------------------------------------------------------------------*/
/*		PCpg@\														*/
/*		Functions for PC													*/
/*--------------------------------------------------------------------------*/
/*	$func$ ftHg~LT[[h̐ݒ
 * [@] void AIXP_SetDefMixerMode(CriSint32 mode);
 * [@] mode	: ~LT[[h
 * [o@] Ȃ
 * [֐l] Ȃ
 * [@@\] ~LT[̓샂[hݒ肷B
 *			mode̐ݒl	AIXP_MIX_HARDWARE : n[hEFA~LVO
 *							AIXP_MIX_SOFTWARE : \tgEFA~LVO
 *  Set default mixer mode
 * [Format  ] void AIXP_SetDefMixerMode(CriSint32 mode);
 * [Inputs  ] mode	: mixer mode
 * [Outputs ] None
 * [Return  ] None
 * [Function] Sets the mixer mode.
 *			 'mode'value	AIXP_MIX_HARDWARE : Use hardware mixer
 *							AIXP_MIX_SOFTWARE : Use software mixer
 */
void CRIAPI AIXP_SetDefMixerMode(CriSint32 mode);
#endif

#ifdef __cplusplus
}
#endif

#endif

/* end of file */
