/***************************************************************************
 *
 *	CRI Middleware SDK
 *
 *	Copyright (c) 2005 CRI-MW
 *
 *	Library	: ADX Library
 *	Module	: Environmentally-dependent header for PS3 PPU
 *	File	: adx_ps3ppu.h
 *	Create	: 2005-08-05
 *	Version	: Refer "ADXPS3PPU_VER_NUM"
 *
 ***************************************************************************/

/* d`h~					*/
/* Prevention of redefinition	*/
#ifndef _ADXPS3PPU_H_INCLUDED
#define _ADXPS3PPU_H_INCLUDED

/***************************************************************************
 *       o[W
 *       Version
 ***************************************************************************/
#define ADXPS3PPU_VER_NAME		"ADXPS3PPU"
#define ADXPS3PPU_VER_NUM		"1.50"
#define ADXPS3PPU_VER_OPTION	

/***************************************************************************
 *      CN[ht@C
 *      Include files
 ***************************************************************************/
#include <stdio.h>
#include <cell/mixer.h>
#include "cri_xpt.h"
#include "cri_adxt.h"
#include "cri_aixp.h"

/***************************************************************************
 *      萔
 *      Constants
 ***************************************************************************/
/* t[[NʁiPS3 PPUj */
/* Framework type for PS3 PPU */
typedef enum {
	ADXM_FRAMEWORK_DEFAULT				= 0,	/* ftHg				*/
												/* Default					*/
	ADXM_FRAMEWORK_PS3PPU_SINGLE_THREAD	= 1,	/* VOXbh			*/
												/* Single thread			*/
	ADXM_FRAMEWORK_PS3PPU_MULTI_THREAD	= 2,	/* }`Xbh			*/
												/* Multi thread				*/
} AdxmFramework;
/* t[[NʁiPS3 PPUjɂĂ̕⑫ */
/* (a) ADXM_FRAMEWORK_DEFAULT̓vbgtH[ʂ̒`łÃv		*/
/* @@bgtH[ł߂̃t[[NI܂B				*/
/* @@PS3 PPUł̓}`XbhiADXM_FRAMEWORK_PS3PPU_MULTI_THREADj	*/
/* @@I܂B														*/

/* TEho̓[h */
/* Sound output mode */
typedef enum {
	ADXPS3_SOUND_OUTPUT_MODE_LIBMIXER	= 0,	/* libmixergp			*/
												/* Using libmixer				*/
//	ADXPS3_SOUND_OUTPUT_MODE_LIBAUDIO	= 1,	/* libaudiogp			*/
												/* Using libaudio				*/
	ADXPS3_SOUND_OUTPUT_MODE_EXTERNAL	= 2,	/* CuOŏo͂		*/
												/* Using user's own audio engine or methods	*/
												/* ADX library does not output any sound	*/
	ADXPS3_SOUND_OUTPUT_MODE_NONE	= 3			/* TEho͂Ȃ			*/
												/* No sound output				*/
} Adxps3SoundOutputMode;

/* ftHgvCIeB */
/* Default priority */
#define ADXM_PS3PPU_PRIO_VV			(100)		/* zVsync				*/
												/* Virtual Vsync			*/
#define ADXM_PS3PPU_PRIO_VSYNC		(500)		/* VsyncXbh			*/
												/* Vsync thread				*/
#define ADXM_PS3PPU_PRIO_FS			(600)		/* t@CXbh		*/
												/* File processing thread	*/
#define ADXM_PS3PPU_PRIO_MAIN		(1001)		/* CXbh			*/
												/* Main thread				*/
#define ADXM_PS3PPU_PRIO_IDLE		(1500)		/* AChXbh			*/
												/* Idle thread				*/

/* Vsync M */
/* Vsync signal notifier */
#define	ADXM_PS3PPU_VSYNC_SIG_VIRTUAL	(0)		/* zVsync				*/
												/* Virtual Vsync			*/
#define	ADXM_PS3PPU_VSYNC_SIG_EXTERNAL	(1)		/* OVsync				*/
												/* External Vsync			*/

/* Virtual Vsync frequency */
#define	ADXM_PS3PPU_VVSYNC_FREQ_59_94	(59940)		/* 59.94 (x1000) */
#define	ADXM_PS3PPU_VVSYNC_FREQ_60_00	(60000)		/* 60.00 (x1000) */
#define	ADXM_PS3PPU_VVSYNC_FREQ_50_00	(50000)		/* 50.00 (x1000) */

/* ftHgX^bNTCY */
/* Default stack size */
#define ADXM_PS3PPU_STACK_SIZE		(8192)		/* 8k byte */

/*	t@CLbVɊւKl								*/
/*	Default value for file cache information							*/
#define	ADXPS3_DEF_NUM_FILE			(253)		/* Number of files				*/
#define	ADXPS3_DEF_MAXFLEN			(1024 + 32)	/* Maximum length of a filename */

/* fBNgT[h	 */
/* Mode of directory look-up */
#define ADXFIC_MODE_ALLDIR			(-1)
#define ADXFIC_MODE_CURRENT			(0)

/* ADXFICnhXe[^X	 */
/* Status of ADXFIC handle */
#define ADXFIC_STAT_STOP			(0)
#define ADXFIC_STAT_CACHING			(1)
#define ADXFIC_STAT_CACHEEND		(2)
#define ADXFIC_STAT_ERROR			(3)

/* t@CRs[p[N̈TCỸftHgw */
/* Default specifivation for work area size calculation to copy file by ADXFCP */
#define ADXFCP_WORK_SIZE_DEFAULT	(-1)

/* ADXFCPnhXe[^X */
/* Status of ADXFCP handle */
#define ADXFCP_STAT_STOP			(0)
#define ADXFCP_STAT_PREP			(1)
#define ADXFCP_STAT_COPYING			(2)
#define ADXFCP_STAT_COPYEND			(3)
#define ADXFCP_STAT_ERROR			(4)

/***************************************************************************
 *      }N
 *      Macro Functions
 ***************************************************************************/
#define	ADXPS3_CALC_FCSIZE(nfile, maxflen)	(nfile*sizeof(Adxps3FcObj)+nfile*(maxflen+1))
#define	ADXPS3_DEF_FCSIZE	(ADXPS3_CALC_FCSIZE(ADXPS3_DEF_NUM_FILE, ADXPS3_DEF_MAXFLEN))

/***************************************************************************
 *      f[^^錾
 *      Data Type Declarations
 ***************************************************************************/

/* fobȌo̓x */
/* Debugging information level */
typedef enum {
	ADXPS3_DEBUG_INFO_LEVEL_NOTHING = 0,
	ADXPS3_DEBUG_INFO_LEVEL_ALL = 1
} Adxps3DebugInfoLevel;

/* XbhZbgAbvp[^iPS3 PPUj */
/* Thread setup parameter for PS3 PPU */
typedef struct {
	/* vCIeB */
	Sint32	priority_vv;		/* zVsync				*/
								/* Virtual Vsync			*/
	Sint32	priority_vsync;		/* VsyncXbh			*/
								/* Vsync thread				*/
	Sint32	priority_fs;		/* t@CXbh		*/
								/* File processing thread	*/
	Sint32	priority_main;		/* CXbh			*/
								/* Main thread				*/
	Sint32	priority_idle;		/* AChXbh			*/
								/* Idle thread				*/
	Sint32	vsync_sig;			/* Vsync M				*/
								/* Vsync Signal				*/
	Sint32	vvsync_frequency;	/* zVsyncg(1000{̒l)			*/
								/* Vitrual Vsync Frequency(1000*value)	*/
} AdxmThreadSprm_PS3PPU;
/* Xbh̃ZbgAbvsۂ̒ӓ_									*/
/* (a) ZbgAbvp[^́AADXM_SetupFramework֐ɈprmƂ		*/
/* @@n܂BNULLw肷ƃftHgݒ肪gp܂B				*/
/* (b) ZbgAbvp[^́At[[NƂ						*/
/* @@ADXM_FRAMEWORK_PS3PPU_MULTI_THREADI񂾏ꍇ̂ݗLłB			*/
/* (c) vCIeB͐lႢقǗDxłB						*/


/* TEhVXe̐ݒ\		*/
/* Configuration of sound system	*/
typedef struct {
	CellAANHandle	mixer_handle;			/* TEh~LT̃nh	*/
											/* Handle of Surround Mixer		*/
	Sint32			num_output_channels;	/* o̓`l				*/
											/* Number of output channels	*/
	Sint32			num_max_voices;			/* ő{CX					*/
											/* Maximum number of voices		*/
	Uint8			*work;					/* [N̈					*/
											/* Working area					*/
	Sint32			work_size;				/* [N̈TCY				*/
											/* Size of working area			*/
	Adxps3SoundOutputMode	output_mode;	/* TEho̓[h			*/
											/* Sound output mode			*/
} Adxps3SoundConfig;
/* TEhVXe̐ݒ\̂ɂĂ̕⑫								*/
/* (a) [N̈TCYADXPS3_CalcSoundWorkSize֐ɂvZĂ		*/
/* @@B܂AvZ[N̈TCỸmۂA[N		*/
/* @@ƂĐݒ肵ĂB											*/
/*	yz																	*/
/*		Adxps3SoundConfig config;											*/
/*		memset(&config, 0, sizeof(config));									*/
/*		config.mixer_handle			= sur_mixer_handle;						*/
/*		config.num_output_channels	= NUM_OUTPUT_CHANNELS;					*/
/*		config.num_voices			= NUM_MAX_VOICES;						*/
/*		config.work_size			= ADXPS3_CalcSoundWorkSize(&config);	*/
/*		config.work					= malloc(config.work_size);				*/
/* (b) mixer_handleNULLݒ肷邱ƂŁAo͂ȂiTEh		*/
/* @@~LT쐬ȂjɂΉł܂B							*/


/* PS3t@CVXẽZbgAbvp[^\	*/
/* Parameter structure for setup of PS3 file system	*/
typedef struct {
	const Char8 *rtdir;				/* [gfBNg	*/
									/* Root directory		*/
} Adxps3SprmPs3Fs;

/* PS3t@CLbṼIuWFNg								*/
/* PS3 File information cache object									*/
typedef struct {
	Sint32	fd;									/* File descripter		*/
	Sint32	reserve;							/* Reserved				*/
	Uint64	size;								/* File size      		*/
} Adxps3FcObj;

/* PS3t@CLbṼp[^\ */
/* Parameter structure for loading file information cache */
typedef struct {
	const Char8	*flist;					/*	t@CXgt@C	*/
	Sint32	maxflen;					/*	t@C̍ő咷			*/
	Sint8	*fcbuf;						/*	t@CLbV̈		*/
	Sint32	fcsize;						/*	t@CLbVTCY	*/
} Adxps3Fcprm;

/* t@CRs[nhiADXFCPnhj*/
/* File copy handle (ADXFCP handle) */
typedef void *ADXFCP;

/* t@CLbVnhiADXFICnhj*/
/* File information cache handle (ADXFIC handle) */
typedef void *ADXFIC;

/***************************************************************************
 *      ϐ錾
 *      Variable Declarations
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Function Prototypes
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/***
*			t[[Nݒ֐
*			Framework setting functions
***/
/* CRI~hEFÃt[[NZbgAbv */
/* Setup the framework of CRI Middleware */
Bool CRIAPI ADXM_SetupFramework(AdxmFramework framework, void *prm);
/* CRI~hEFÃt[[N̏I */
/* Shutdown the framework of CRI Middleware */
Bool CRIAPI ADXM_ShutdownFramework(void);
/* CRIzVsync̃Zbg */
/* Reset CRI's virtual Vsync timer */
void CRIAPI ADXPS3_ResetVirtualVsync(Uint64 last_flip_usec);
/* CRIzVsyncJEgl̎擾 */
/* Get CRI's virtual Vsync counter */
Uint32 CRIAPI ADXPS3_GetVirtualVsyncCount();

/***
*			TEhVXe֐
*			Sound system functions
***/
/* TEhVXeɕKvȃ[NTCY̌vZ */
/* Calculate working area size for sound system */
Sint32 CRIAPI ADXPS3_CalcSoundWorkSize(const Adxps3SoundConfig *config);

/* TEhVXẽZbgAbv */
/* Setup sound system */
Bool CRIAPI ADXPS3_SetupSound(const Adxps3SoundConfig *config);
/* TEhVXẽVbg_E */
/* Shutdown sound system */
void CRIAPI ADXPS3_ShutdownSound(void);

/* TEh~LTɃI[fBIf[^͂邽߂̒ʒmR[obN֐ */
/* Callback function for notification of audio data input from surround mixer */
Sint32 CRIAPI ADXPS3_SoundNotifyCallback(void *arg, Uint32 counter, Uint32 num_samples);

/***
*			t@CVXeݒ֐
*			File system setting functions
***/
/* PS3t@CVXẽZbgAbv */
/* Setup file system for PS3 */
void CRIAPI ADXPS3_SetupPs3Fs(const Adxps3SprmPs3Fs *sprm);
/* PS3t@CVXẽVbg_E */
/* Shutdown file system for PS3 */
void CRIAPI ADXPS3_ShutdownPs3Fs(void);
/* PS3t@CVXẽ[gfBNg̎擾 */
/* Get root directory of file system */
const Char8 *ADXPS3_GetRootDir(void);

/***
*			t@CLbV֐ (ADXPS2݊API)
*			File information cache functions (ADXPS2 compatible API)
***/
/* LbVt@C̃[h^A[h */
/* Load file information for cache or unload */
Sint32 ADXPS3_LoadFcache(Adxps3Fcprm *fcprm);
Sint32 ADXPS3_SetFcache(Adxps3Fcprm *fcprm, void *flist_buf, Sint32 read_size);
Sint32 ADXPS3_OpenDirFcache(Adxps3Fcprm *fcprm, const Char8 *dname, Sint32 mode);
/* fBNgGǧ */
/* Search directory and get the number of files and maximum length of file name */
void ADXPS3_SearchDirFcache(const Char8 *dname, Sint32 mode, Sint32 *filenum, Sint32 *maxflen);
/* LbVɑ݂邩̔ */
/* Check if file were cached */
Sint32 ADXPS3_IsExistFcache(const Char8 *fname);
/* LbVɓo^Ăt@C̃fobO\ */
/* Debug printf of cahced file */
Sint32 ADXPS3_DebugPrintFcache(void);

/***
*			fobO֐
*			Debugging information functions
***/
/* fobȌo̓x̐ݒ */
/* Set debugging information level */
void CRIAPI ADXPS3_SetDebugInfoLevel(Adxps3DebugInfoLevel level);
/* fobȌo̓x̎擾 */
/* Get debugging information level */
Adxps3DebugInfoLevel CRIAPI ADXPS3_GetDebugInfoLevel();
/* gCI[vR[obN֐̐ݒ */
/* Set tray open callback function */
void CRIAPI ADXPS3_SetCbTrayopen(void (*func)(void *obj, Char8 *msg), void *obj);
/* ʃt@CVXeG[R[obN֐̐ݒ */
/* Set lower file system error callback function */
void CRIAPI ADXPS3_SetCbFsErr(void (*func)(void *obj, Char8 *func, Sint32 err), void *obj, Char8 *ent_buf, Sint32 ent_size);


/***
*			t@CLbVp֐ (ADXFIC)
*			Functions for file information cache (ADXFIC)
***/
/*  */
/* Initialization of ADXFIC */
void CRIAPI ADXFIC_Init(void);

/* I */
/* Finalization of ADXFIC */
void CRIAPI ADXFIC_Finish(void);

/* t@CLbVp[N̈TCY̎擾 */
/* Gets the work area size for file information cache creation */
Sint32 CRIAPI ADXFIC_GetWorkSize(const Char8 *dname, Sint32 mode);

/* t@CLbViADXFICnhj̍쐬 */
/* Creation of file information cache (ADXFIC handle creation) */
ADXFIC CRIAPI ADXFIC_Create(
	const Char8 *dname, Sint32 mode, void *work, Sint32 wksize);

/* t@CLbViADXFICnhj̔j */
/* Deletion of file information cache (ADXFIC handle deletion) */
void CRIAPI ADXFIC_Destroy(ADXFIC fic);

/* Xe[^X̎擾 */
/* Gets the status of handle */
Sint32 CRIAPI ADXFIC_GetStat(ADXFIC fic);

/* t@CLbVĂ邩ǂ̃`FbN							*/
/* ӁjADXFIC_IsFileCached֐́At@CLbVfBNg	*/
/*       ܂܂Ă邩ǂApX̉͂̂ݔ肵܂B				*/
/*       ۂɃt@C݂邩ǂ͕ʓrADXF_IsExistFile֐		*/
/*       gpă`FbNKv܂B								*/
/* Checks whether specified file is in cache								*/
/* NOTE: The ADXFIC_IsFileCached function judges whether 					*/
/*       specified file is in cache, using the path analysis.				*/
/*       If you want to check the file existence, 							*/
/*       you should use the ADXF_IsExistFile function.						*/
Bool CRIAPI ADXFIC_IsFileCached(const Char8 *fname);

/* ӁjL2֐̓fobÔ݂p							*/
/*       L2֐́A֐OutputDebugString֐gp܂B			*/
/*       [XɉL֐gpꍇATCRɒG܂B				*/
/* NOTE: The following two functions are only for debugging.				*/
/*       These functions use OutputDebugString function.					*/
/*       If you use these functions, your application conflicts with TCR.	*/

/* wnhɃLbVꂽt@C̈ꗗ\ */
/* Print the list of cached files in the handle */
void CRIAPI ADXFIC_DebugPrintFlist(ADXFIC fic);

/* SẴnhɃLbVꂽt@C̈ꗗ\ */
/* Print the list of cached files in all handles */
void CRIAPI ADXFIC_DebugPrintFlistAll(void);

/***
*			t@CRs[֐
*			Functions for file copy
***/
/*  */
/* Initialization of ADXFCP */
void CRIAPI ADXFCP_Init(void);

/* I */
/* Finalization of ADXFCP */
void CRIAPI ADXFCP_Finish(void);

/* t@CRs[nh[N̈TCY̌vZ */
/* Calculation work size for file copy handle */
Sint32 ADXFCP_CalcWorkSize(Sint32 bufsize);

/* t@CRs[nhiADXFCPnhj̍쐬 */
/* Creation of file copy handle (ADXFCP handle creation) */
ADXFCP CRIAPI ADXFCP_Create(void *work, Sint32 wksize, Sint32 bufsize);

/* t@CRs[nhiADXFCPnhj̔j */
/* Deletion of file copy handle (ADXFCP handle deletion) */
void CRIAPI ADXFCP_Destroy(ADXFCP fcp);

/* T[o */
/* Server function of all file copy handles */
void CRIAPI ADXFCP_ExecServer(void);

/* nhPʂ̃T[o */
/* Server function of file copy handle */
void CRIAPI ADXFCP_ExecHndl(ADXFCP fcp);

/* t@CRs[̊Jn */
/* Begins the file copy */
void CRIAPI ADXFCP_CopyFileNw(ADXFCP fcp, const Char8 *src, const Char8 *dst);

/* t@CTCY̎擾 */
/* Gets the total size of the file */
Sint64 ADXFCP_GetFileSize(ADXFCP fcp);

/* Rs[ς݃TCY̎擾 */
/* Gets the total number of bytes transferred */
Sint64 ADXFCP_GetNumTransferred(ADXFCP fcp);

/* t@CRs[̒~ */
/* Stops the file copy */
void CRIAPI ADXFCP_Stop(ADXFCP fcp);

/* t@CRs[̈ꎞ~ */
/* Pauses the file copy */
void CRIAPI ADXFCP_Pause(ADXFCP fcp, Sint32 flag);

/* |[YԂ̎擾 */
/* Checks whether current copy process is paused */
Bool CRIAPI ADXFCP_IsPaused(ADXFCP fcp);

/* Xe[^X̎擾 */
/* Gets the status of ADXFCP handle */
Sint32 CRIAPI ADXFCP_GetStat(ADXFCP fcp);

/* ꎞt@Cgq̐ݒ */
/* Sets the file extension of the temporary file */
void CRIAPI ADXFCP_SetTempFileExt(const Char8 *ext);

/***
*			PCMf[^擾֐
*			Functions for obtaining of audio PCM data
***/
Sint32 CRIAPI ADXPS3_GetPcmDataAdx(ADXT adxt, Float32 data[], Uint32 num_channels, Uint32 num_samples);
Sint32 CRIAPI ADXPS3_GetPcmDataAix(AIXP aixp, Float32 data[], Uint32 num_channels, Uint32 num_samples);

#ifdef __cplusplus
}
#endif

#endif	/* #ifndef _ADXPS3_H_INCLUDED */

/* end of file */
