/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2001-2005 CRI-MW
 *
 * Library : UT Library
 * Module  : Library header (PS3-Specific)
 * File    : cri_ut_ps3.h
 * Date    : 2005-09-08
 *
 ****************************************************************************/

#ifndef INCLUDED_CRIUT_PS3_H		/* Re-definition prevention */
#define INCLUDED_CRIUT_PS3_H

/*******************************************************************
 *      Include file
 *******************************************************************/
/*--- CRI-MW header ---*/
#include	<cri_ut.h>

/*******************************************************************
 *      Macro constant
 *******************************************************************/
/* the number of pad key mask */
#define UTPAD_PS3_KEYMSK_NUM		(13)

/*******************************************************************
 *      Enumarate constant
 *******************************************************************/
/*--- UTTMR ---*/
typedef	enum {
	UTTMR_PS3_METHOD_DEAFULT	= (0),
	UTTMR_PS3_METHOD_LPAR		= (1),	// LPAR individually timer
	UTTMR_PS3_METHOD_END
} UTTMR_PS3_METHOD;

/*******************************************************************
 *      Process macro
 *******************************************************************/

/*******************************************************************
 *      Data type declaration
 *******************************************************************/

/*--- UTPAD ---*/
/* pad key mask */
typedef	struct {
	Uint8	ofs;	/* CellUsbPadData\̂buttonỏԖڂ */
	Uint8	mask;	/* rbg}XNl */
	Uint8	val;	/* rl */
	Sint16	retval; /* UTPAD̃{^ƂĕԂl */
} UTPAD_PS3_KEYMSK;
/*
	buttonofsʒũf[^ɂ
	maskŃ}XNlvalƔrēretvalԂ
	if ((keymsk->mask & paddata.button[keymsk->ofs]) == keymsk->val) {
		peri->on |= keymsk->retval;
	}
*/

/* pad key specification */
typedef	struct {
	Uint32	vid;	// vender id
	Uint32	pid;	// product id
	UTPAD_PS3_KEYMSK	keymsk[UTPAD_PS3_KEYMSK_NUM];
} UTPAD_PS3_SPEC;

/* debug print initialize parameter */
typedef struct {
	Uint32	bufsize;	// print string buffer size
	Uint32	width;		// screen width
	Uint32	height;		// screen height
	Uint32	ofs_x;		// cursor offset for horizontal
	Uint32	ofs_y;		// cursor offset for vertical
	Float32	scale;		// print string scale
} UTPRT_INIT_PRM;

/*******************************************************************
 *      Function macro
 *******************************************************************/

/*******************************************************************
 *      Variable declaration
 *******************************************************************/

/*******************************************************************
 *      External Function declaration
 *******************************************************************/

/*******************************************************************
 *      Function declaration
 *******************************************************************/
#ifdef  __cplusplus
extern "C" {					/* __cplusplus */
#endif
/*--- UTPAD ---*/
/* pbh̃L[}XNݒ肷 */
void UTPAD_SetPadSpec(void *spec, Uint32 port);
/* fobO̕\^\ݒiftHg\jsw = ON:\, OFF:\ */
void UTPAD_SetDebugSw(Sint32 sw);

/*--- UTTMR ---*/
Uint64 UTTMR_CountToMicro64(Uint64 count);
Uint64 UTTMR_GetCount64(void);
Uint64 UTTMR_DiffCount64(Uint64 count1, Uint64 count2);
void UTTMR_ChangeMethod(Uint32 method);
Uint64 UTTMR_GetFreq(void);
void UTTMR_SetFreq(Uint64 freq);

#ifdef	__cplusplus
}								/* __cplusplus */
#endif

#endif							/* Re-definition prevention */

/* end of file */
