/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 1998-2008 CRI Middleware Co., Ltd.
 *
 * Library  : CRI Middleware Library
 * Module   : CRI Common Header for PS3 PPU
 * File     : cri_xpts_ps3ppu.h
 * Date     : 2008-02-01
 * Version  : 2.00
 *
 ****************************************************************************/
#ifndef CRI_XPTS_PS3PPU_H
#define CRI_XPTS_PS3PPU_H

#include <sdk_version.h>

/*****************************************************************************
 * {f[^^錾
 *****************************************************************************/

#ifndef _TYPEDEF_CriUint8
#define _TYPEDEF_CriUint8
typedef unsigned char			CriUint8;		/* ȂPoCg */
#endif

#ifndef _TYPEDEF_CriSint8
#define _TYPEDEF_CriSint8
typedef signed char				CriSint8;		/* PoCg */
#endif

#ifndef _TYPEDEF_CriUint16
#define _TYPEDEF_CriUint16
typedef unsigned short			CriUint16;		/* ȂQoCg */
#endif

#ifndef _TYPEDEF_CriSint16
#define _TYPEDEF_CriSint16
typedef signed short			CriSint16;		/* QoCg */
#endif

#ifndef _TYPEDEF_CriUint32
#define _TYPEDEF_CriUint32
typedef unsigned int			CriUint32;		/* ȂSoCg */
#endif

#ifndef _TYPEDEF_CriSint32
#define _TYPEDEF_CriSint32
typedef signed int				CriSint32;		/* SoCg */
#endif


#if (CELL_SDK_VERSION >= 0x080000)

#ifndef _TYPEDEF_CriUint64
#define _TYPEDEF_CriUint64
typedef unsigned long long		CriUint64;		/* ȂWoCg */
#endif

#ifndef _TYPEDEF_CriSint64
#define _TYPEDEF_CriSint64
typedef signed long long		CriSint64;		/* WoCg */
#endif

#else

#ifndef _TYPEDEF_CriUint64
#define _TYPEDEF_CriUint64
typedef unsigned long			CriUint64;		/* ȂWoCg */
#endif

#ifndef _TYPEDEF_CriSint64
#define _TYPEDEF_CriSint64
typedef signed long				CriSint64;		/* WoCg */
#endif

#endif


#ifndef _TYPEDEF_CriUint128
#define _TYPEDEF_CriUint128
typedef struct {								/* Ȃ16oCg */
	CriUint64			h;						/* 64rbg */
	CriUint64			l;						/* 64rbg */
} CriUint128;
#endif

#ifndef _TYPEDEF_CriSint128
#define _TYPEDEF_CriSint128
typedef struct {								/* 16oCg */
	CriSint64	h;								/* 64rbg */
	CriUint64	l;								/* 64rbg */
} CriSint128;
#endif

#ifndef _TYPEDEF_CriFloat16
#define _TYPEDEF_CriFloat16
typedef signed short			CriFloat16;		/* QoCg */
#endif

#ifndef _TYPEDEF_CriFloat32
#define _TYPEDEF_CriFloat32
typedef float					CriFloat32;		/* SoCg */
#endif

#ifndef _TYPEDEF_CriFloat64
#define _TYPEDEF_CriFloat64
typedef double					CriFloat64;		/* WoCg */
#endif

#ifndef _TYPEDEF_CriFixed32
#define _TYPEDEF_CriFixed32
typedef signed int				CriFixed32;		/* Œ菬_32rbg */
#endif

#ifndef _TYPEDEF_CriBool
#define _TYPEDEF_CriBool
typedef CriSint32				CriBool;		/* _^i_萔lɂƂj */
#endif

#ifndef _TYPEDEF_CriChar8
#define _TYPEDEF_CriChar8
typedef char					CriChar8;		/* ^ */
#endif

/*****************************************************************************
 * |C^i[\Ȑ^
 *****************************************************************************/
#if (CELL_SDK_VERSION >= 0x080000)

#ifndef _TYPEDEF_CriSintPtr
#define _TYPEDEF_CriSintPtr
typedef CriSint32				CriSintPtr;
#endif

#ifndef _TYPEDEF_CriUintPtr
#define _TYPEDEF_CriUintPtr
typedef CriUint32				CriUintPtr;
#endif

#else

#ifndef _TYPEDEF_CriSintPtr
#define _TYPEDEF_CriSintPtr
typedef CriSint64				CriSintPtr;
#endif

#ifndef _TYPEDEF_CriUintPtr
#define _TYPEDEF_CriUintPtr
typedef CriUint64				CriUintPtr;
#endif

#endif
/*****************************************************************************
 * xNgϐ
 *****************************************************************************/
#ifndef _TYPEDEF_Svec8
#define _TYPEDEF_Svec8
typedef __vector signed char		Svec8;
#endif

#ifndef _TYPEDEF_Uvec8
#define _TYPEDEF_Uvec8
typedef __vector unsigned char	Uvec8;
#endif

#ifndef _TYPEDEF_Svec16
#define _TYPEDEF_Svec16
typedef __vector signed short		Svec16;
#endif

#ifndef _TYPEDEF_Uvec16
#define _TYPEDEF_Uvec16
typedef __vector unsigned short	Uvec16;
#endif

#ifndef _TYPEDEF_Svec32
#define _TYPEDEF_Svec32
typedef __vector signed int		Svec32;
#endif

#ifndef _TYPEDEF_Uvec32
#define _TYPEDEF_Uvec32
typedef __vector unsigned int		Uvec32;
#endif

#ifndef _TYPEDEF_Fvec32
#define _TYPEDEF_Fvec32
typedef __vector float			Fvec32;
#endif

/*****************************************************************************
 * ĂяoK
 *****************************************************************************/

#ifndef CRIAPI
#define CRIAPI
#endif	/* endif CRIAPI */

#endif	/* CRI_XPTS_PS3PPU_H */

/* end of file */
