/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2001-2008 CRI Middleware Co., Ltd.
 *
 * Library  : MWSFD Library (CRI Sofdec)
 * Module   : Library User's Header
 * File     : crimwsfd.h
 * Date     : 2008-11-12
 * Version  : (see MWD_SFD_VER)
 *
 ****************************************************************************/
#ifndef	INCLUDED_CRIMWSFD_H		/* Re-definition prevention */
#define	INCLUDED_CRIMWSFD_H

/*	Version No.	*/
#define	MWD_SFD_VER		"4.75"
#define	MWD_SFD_NAME	"MWSFD"

/***************************************************************************
 *      Include file
 ***************************************************************************/
#include <cri_xpt.h>
#include <cri_adxt.h>
//#include <cri_log.h>
#include <sj.h>

/***************************************************************************
 *      MACRO CONSTANT
 ***************************************************************************/
/* g  */
/* Vsync frequency */
#define MWSFD_VHZ_59_94			(59.94f)
#define MWSFD_VHZ_50_00			(50.00f)
#define MWSFD_VHZ_60_00			(60.00f)

/* [h		*/
/* Composition Mode	*/
#define MWSFD_COMPO_AUTO		(0x00000000)	/* 						*/
												/* Auto						*/
#define MWSFD_COMPO_OPAQ		(0x00000011)	/* s					*/
												/* opacity					*/
#define MWSFD_COMPO_ALPHFULL	(0x00000021)	/* tAlpha			*/
												/* Full Alpha				*/
#define	MWSFD_COMPO_ALPHLUMI	(0x00000031)	/* ~iXL[ 		*/
												/* Luminance key alpha		*/
#define	MWSFD_COMPO_ALPH3		(0x00000041)	/* 3lAt@ 				*/
												/* 3-value alpha			*/
#define MWSFD_COMPO_Z			(0x00000101)	/* yl						*/
												/* Z value					*/

/* t@C^Cv		*/
/* File type			*/
#define	MWSFD_FTYPE_NON			(0)
#define	MWSFD_FTYPE_SFD			(1)
#define	MWSFD_FTYPE_MPV			(2)
#define MWSFD_FTYPE_VONLYSFD	(3)
#define MWSFD_FTYPE_M2TS		(5)		/* implemented only in a special platform */
#define	MWSFD_FTYPE_M4V			(6)		/* implemented only in a special platform */
#define	MWSFD_FTYPE_M4V_SFD		(7)		/* implemented only in a special platform */
#define	MWSFD_FTYPE_H264		(8)		/* implemented only in a special platform */
#define	MWSFD_FTYPE_H264_SFD	(9)		/* implemented only in a special platform */
#define	MWSFD_FTYPE_M4V_USF 	(10)	/* implemented only in a special platform */
#define MWSFD_FTYPE_H264_TS		(11)	/* implemented only in a special platform */

/* Audio Volume MAX, MIN */
#define	MWSFD_OUTVOL_MAX		(0)		/* MAX Volume */
#define	MWSFD_OUTVOL_MIN		(-960)	/* MIN Volume */

/* Audio Channel	*/
#define MWSFD_CH_L				(0)		/* Left		*/
#define MWSFD_CH_R				(1)		/* Right	*/

/*	Panpot Value	*/
#define	MWSFD_PAN_LEFT			(-15)
#define	MWSFD_PAN_CENTER		(0)
#define	MWSFD_PAN_RIGHT			(15)
#define	MWSFD_PAN_AUTO			(-128)

/* o̓obt@̃ftHgl 	*/
/* Default value of out-buffer size	*/
#define MWSFD_DFL_OUTBUFSIZE	(0)

/* [h	*/
/* Sync Mode	*/
#define MWSFD_SYNCMODE_NONE		(0)		/* 		*/ /* No sync		*/
#define MWSFD_SYNCMODE_VSYNC	(1)		/* V-Sync	*/ /* Sync Vint		*/
#define MWSFD_SYNCMODE_AUDIO	(2)		/* Audio 	*/ /* Sync Audio	*/
#define MWSFD_SYNCMODE_USRTIME	(4)		/* [U */
#define MWSFD_SYNCMODE_EXTCLOCK	(5)		/* ONbN */
#define MWSFD_SYNCMODE_EASYINFINI (6)	/* ȈՖĐ */ /* Easy infinite video only playback */

/* Đ̃t@CTCYȗ(TCY擾) */
#define MWSFD_FILESIZE_UNKNOWN			(0xFFFFFFFF)

/* PID̖l (wƓAw̏ꍇ̓Cũ}bv͂L) */
#define MWSFD_PID_VOID			(-1)

/* Z Value Range	*/
#define MWSFD_ZVAL_MIN			(0x00000000)	/* Minimum Z Value (32bit) */
#define MWSFD_ZVAL_MAX			(0x7fffffff)	/* Maximum Z Value (32bit) */
#define MWSFD_ZVAL_RANGE		(MWSFD_ZVAL_MAX - MWSFD_ZVAL_MIN)

/* [for Compatibility] */
#define	MWD_PLY_FTYPE_NON		MWSFD_FTYPE_NON
#define	MWD_PLY_FTYPE_SFD		MWSFD_FTYPE_SFD
#define	MWD_PLY_FTYPE_MPV		MWSFD_FTYPE_MPV
#define MWD_PLY_COMPO_OPEQ		MWSFD_COMPO_OPAQ
#define MWD_PLY_SYNC_NONE		MWSFD_SYNCMODE_NONE
#define MWD_PLY_SYNC_VSYNC		MWSFD_SYNCMODE_VSYNC
#define MWD_PLY_SYNC_AUDIO		MWSFD_SYNCMODE_AUDIO
#define MWD_CH_L				MWSFD_CH_L
#define MWD_CH_R				MWSFD_CH_R
#define	MWD_PAN_LEFT			MWSFD_PAN_LEFT
#define	MWD_PAN_CENTER			MWSFD_PAN_CENTER
#define	MWD_PAN_RIGHT			MWSFD_PAN_RIGHT
#define	MWD_PAN_AUTO			MWSFD_PAN_AUTO

/***************************************************************************
 *      Process MACRO
 ***************************************************************************/
/* Convert mwGetTime()'s return-value to second	*/
#define	MWSFD_TIME2SEC(ncount, tscale)		((ncount) / (tscale))

/* Convert mwGetTime()'s return-value to milli-second	*/
#define	MWSFD_TIME2MSEC(ncount, tscale)	((1000 * (ncount)) / (tscale))

/* sN`C[Uf[^p̃obt@TCYvZ */
/* Calculate buffer size of user data in picture layer */
#define MWSFD_SIZE_PICUSRBUF(npool, size1pic)	(((npool) + 4) * (size1pic))

/* mwPlyStartIpicture()p̍őBPSwl}N */
/* ͍ősN`f[^TCY[byte]  */
#define MWSFD_CALC_MAX_BPS_SEEKIPIC(max_picdata_size)	((max_picdata_size + 4096) * 16)

/* rfIPTSp[NTCYvZ */
#define MWSFD_CALC_WORK_VPTS(picnum)					((picnum) * 16 + 4)

/* [for Compatibility] */
#define	MWD_PLY_TIME2SEC(ncount, tscale)	MWSFD_TIME2SEC((ncount), (tscale))
#define	MWD_PLY_TIME2MSEC(ncount, tscale)	MWSFD_TIME2MSEC((ncount), (tscale))

/***************************************************************************
 *      Enum declaration
 ***************************************************************************/
/*	Status of MWPLY handles		*/
typedef	enum {
	MWSFD_STAT_STOP			= 0,		/*	stoped						*/
	MWSFD_STAT_PREP			= 1,		/*	preparing					*/
	MWSFD_STAT_PLAYING		= 2,		/*	playing						*/
	MWSFD_STAT_PLAYEND		= 3,		/*	end of playing				*/
	MWSFD_STAT_ERROR		= 4,		/*	error was occured			*/

	/* [for Compatibility] */
	MWE_PLY_STAT_STOP		= 0,		/*	stoped						*/
	MWE_PLY_STAT_PREP		= 1,		/*	preparing					*/
	MWE_PLY_STAT_PLAYING	= 2,		/*	playing						*/
	MWE_PLY_STAT_PLAYEND	= 3,		/*	end of playing				*/
	MWE_PLY_STAT_ERROR		= 4,		/*	error was occured			*/

	MWSFD_STAT_END,
	MWSFD_STAT_ENUM_BE_SINT32 = 0x7FFFFFFF
} MwsfdStat, MWE_PLY_STAT;

/* fR[hT[o */
/* Decode Server  */
typedef enum {
	MWSFD_DEC_SVR_IDLE		= 0,	/* C̗]莞ԂŃfR[hB */
									/* Decode in idel thread            */
	MWSFD_DEC_SVR_MAIN		= 1,	/* CŃfR[hB		*/
									/* Decode in main thread            */

	MWSFD_DEC_SVR_END,
	MWSFD_DEC_SVR_ENUM_BE_SINT32 = 0x7FFFFFFF
} MwsfdDecSvr;

/* fR[hʃobt@f[^`	*/
/* Decoder's output buffer data format	*/
typedef enum {
    MWSFD_BUFFMT_DEFAULT		= 0,	/* Default format		*/
    MWSFD_BUFFMT_MB_YCC420		= 1,	/* YCC 4:2:0 Macroblock */
    MWSFD_BUFFMT_MB_ARGB8888	= 2,	/* RGB 32bit Macroblock */
    MWSFD_BUFFMT_PLN_YCC420		= 3,	/* YCC 4:2:0 Plane      */
	/* [for Compatibility] */
    MWE_PLY_BUFFMT_MB_YCC420    = 1,	/* YCC 4:2:0 Macroblock */
    MWE_PLY_BUFFMT_MB_ARGB8888  = 2,	/* RGB 32bit Macroblock */
    MWE_PLY_BUFFMT_PLN_YCC420   = 3,	/* YCC 4:2:0 Plane      */

    MWSFD_BUFFMT_END,
	MWSFD_BUFFMT_ENUM_BE_SINT32 = 0x7FFFFFFF
} MwsfdBufFmt, MWE_PLY_BUFFMT;

/* ~iX̓߃L[				*/
/* Luminance alpha's transparence key	*/
typedef enum {
	MWSFD_LUMIKEY_BLACK		= 0,	/* Black key transparence */
	MWSFD_LUMIKEY_WHITE		= 1,	/* White key transparence */

	MWSFD_LUMIKEY_END,
	MWSFD_LUMIKEY_ENUM_BE_SINT32 = 0x7FFFFFFF
} MwsfdLumiKey;

/* t[^Cv	*/
/* Frame type		*/
typedef enum {
	MWSFD_FRMTYPE_UNKNOWN		= 0,	/* Unknown */
	MWSFD_FRMTYPE_PROGRESSIVE	= 1,	
	MWSFD_FRMTYPE_INTERLACE		= 2,

	MWSFD_FRMTYPE_END,
	MWSFD_FRMTYPE_ENUM_BE_SINT32 = 0x7FFFFFFF
} MwsfdFrmType;

/* sN`^Cv	*/
/* Picture type		*/
typedef enum {
    MWSFD_PTYPE_I			= 1,	/* I Picture */
    MWSFD_PTYPE_P			= 2,	/* P Picture */
    MWSFD_PTYPE_B			= 3,	/* B Picture */
    MWSFD_PTYPE_D			= 4,	/* D Picture */
	/* [for Compatibility] */
    MWE_PLY_PTYPE_I			= 1,	/* I Picture */
    MWE_PLY_PTYPE_P			= 2,	/* P Picture */
    MWE_PLY_PTYPE_B			= 3,	/* B Picture */
    MWE_PLY_PTYPE_D			= 4,	/* D Picture */

    MWSFD_PTYPE_END,
	MWSFD_PTYPE_ENUM_BE_SINT32 = 0x7FFFFFFF
} MwsfdPtype, MWE_PLY_PTYPE;

/* t[YUVϊ[h			*/
/* YUV conversion mode of the frame	*/
typedef enum {
	MWSFD_YUVMODE_UNKNOWN			= 0,	
	MWSFD_YUVMODE_ITU_R_BT_601		= 1,	/* [standard] It's CCIR601	*/
	MWSFD_YUVMODE_CSC				= 2,	/* Color space compensation	*/
	MWSFD_YUVMODE_BASIC_YCBCR		= 3,	/* [n/a] Basic YCbCr		*/
	MWSFD_YUVMODE_HIGH_CONTRAST		= 4,	/* [n/a] High contrast		*/
	MWSFD_YUVMODE_RAW_YUV			= 5,	/* [n/a] Raw YUV data		*/
	MWSFD_YUVMODE_HSYUV				= 6,	/* Simple coefficient color space conversion */

	MWSFD_YUVMODE_END,
	MWSFD_YUVMODE_ENUM_BE_SINT32 = 0x7FFFFFFF
} MwsfdYuvMode;

/* t[擾[h			*/
/* Sync mode of mwPlyGetCurFrm()	*/
typedef enum {
	MWSFD_FRMSYNC_TIME		= 0,	/* Sync with time	*/
	MWSFD_FRMSYNC_NONE		= 1,	/* No sync			*/

	MWSFD_FRMSYNC_END,
	MWSFD_FRMSYNC_ENUM_BE_SINT32 = 0x7FFFFFFF
} MwsfdFrmSync;

/* rfIR[fbN			*/
/* Codec detail infomation	*/
typedef enum MwsfdVideoCodec {
    MWSFD_VIDEOCODEC_UNKNOWN     = 0,    /* m */
    MWSFD_VIDEOCODEC_M1V         = 1,    /* MPEG-1 Video, Sofdec Video */
    MWSFD_VIDEOCODEC_M2V         = 2,    /* MPEG-2 Video */
    MWSFD_VIDEOCODEC_M4V         = 3,    /* MPEG-4 Video */
    MWSFD_VIDEOCODEC_H264        = 4,    /* H.264 */

    MWSFD_VIDEOCODEC_END,
	MWSFD_VIDEOCODEC_ENUM_BE_SINT32 = 0x7FFFFFFF
} MwsfdVideoCodec;

/* fBU[h	*/
/* Dither mode	*/
typedef enum MwsfdDitherMode {
	MWSFD_DITHERMODE_AUTO	= 0,    /*  */
	MWSFD_DITHERMODE_ON		= 1,    /* fBUL */
	MWSFD_DITHERMODE_OFF	= 2,    /* fBU */

	MWSFD_DITHERMODE_END,
	MWSFD_DITHERMODE_ENUM_BE_SINT32 = 0x7FFFFFFF
} MwsfdDitherMode;

/***************************************************************************
 *      Data type declaration
 ***************************************************************************/
/*	MWPLY handle	*/
typedef void* MWPLY;

/* t[v[nh */
typedef CriSint32 MwsfdFrmpoolHn;

/* Sofdec̏p[^\							*/
/* Parameter structure of Sofdec initialization function	*/
typedef struct {
	CriFloat32		vhz;			/* g[Hz]						*/
								/* Vsync frequency[Hz]						*/
	CriSint32		disp_cycle;		/* (gp) \XV[v]				 	*/
								/* (Not in use) Display update cycle[v]		*/
	CriSint32		disp_latency;	/* (gp) \CeV[v]				*/
								/* (Not in use) Display latency[v]			*/
	MwsfdDecSvr	dec_svr;		/* fR[hT[o				 			*/
								/* Decode Server							*/
	CriSint32		rsv[4];			/* \ (S0ݒ肵ĉ) 			*/
								/* Reserved(Please set 0 in all of area)	*/
} MwsfdInitPrm, MWS_PLY_INIT_SFD;

/* nhp[^\				*/
/* Parameter structure of handle creation	*/
typedef struct {
	CriSint32	ftype;				/* ĐXg[̎ 				*/
								/* File type								*/
	CriSint32	max_bps;			/* ő̃rbgXg[ʁ@(bit/sec)		*/
								/* Maximum number of bit per second			*/
	CriSint32	max_width;			/* Đ摜TCY̍ő啝					*/
								/* Maximum width of video stream			*/
	CriSint32	max_height;			/* Đ摜TCY̍ő卂					*/
								/* Maximum height of video stream			*/
	CriSint32	nfrm_pool_wk;		/* VXë̗Lt[v[B		*/
								/* ʏ(2)̒lw肷B͎Q		*/
								/* t[v[܂܂ȂB			*/
								/* t[ꍇ́A̒l	*/
								/* ₵ĂB						*/
								/* Number of effective frame pools in 		*/
								/* system memory. Normaly this number is 2.	*/
								/* this number dosen't contain number of 	*/
								/* reference frame pools. If frame is 		*/
								/* droped,you have to increase this number.	*/
	CriSint32	max_stm;			/* ǂݍ݃Xg[(ADX܂)		*/
								/* l0̏ꍇ̓ftHgl(1)Ƃ݂ȂB	*/
								/* The number of maximum streams playing 	*/
								/* at the same time. 						*/
								/* This number include ADXT/ADXF streams.	*/
								/* If the value is zero then assume 1.		*/
	CriSint8	*work;				/* [N̈								*/
								/* Address of working area					*/
	CriSint32	wksize;				/* [N̈TCY							*/
								/* Size of working area						*/
	CriSint32  compo_mode;			/* [h								*/
								/* Composition mode							*/
	MwsfdBufFmt		buffmt;		/* fR[ho̓t[obt@f[^`	*/
								/* l0̏ꍇ̓ftHg`Ƃ݂ȂB	*/
								/* Buffer format of decoder	output			*/
								/* If the value is 0 then assume defualt.	*/

	/* ȉ̃õ͓^[QbgłgpȂB       */
	/* The following members are used with a specific target. */
	CriSint32	outer_frmpool_num;	/* Ot[v[B͎Qƃt[	*/
								/* v[܂߂lB					*/
								/* Number of outer frame pools. 			*/
								/* this number contain number of reference	*/
								/* frame pools.								*/
	CriSint32	outer_frmpool_size;	/* Ot[v[pobt@TCY		*/
	                            /* iPt[j							*/
								/* Size of outer frame pool.                */
								/* (Size for one frame)                     */
	CriUint8	**outer_frmpool_ptr;/* Ot[v[pobt@|C^z */
	                            /* ւ̃|C^								*/
								/* Pointer to pointer array for outer frame */
								/* pools.									*/
	MwsfdFrmpoolHn	frmpool_hn;	/* t[v[nh                   */
	
	CriSint32	rsv[1];			/* \ (S0ݒ肵ĉ) 			*/
								/* Reserved(Please set 0 in all of area)	*/
} MwsfdCrePrm, MWS_PLY_CPRM_SFD;

/* f[^p[^	*/
/* Subtitle parameter		*/
typedef struct {
	CriBool	update;			/* update data flag								*/
	CriSint32	datasize;		/* size of data [byte]							*/
	CriSint32	tunit;			/* time unit									*/
	CriSint32	intime;			/* start display time.  sec = intime / tunit.	*/
	CriSint32	durtime;		/* duration of display time. sec = intime / tunit.	*/
} MwsfdSbtPrm;

/* MPEG-2t[		*/
/* MPEG-2 detail infomation	*/
typedef struct {
	CriSint64				pts;						/* PES   :PTS 33bit (-1:PTSȂ) */
	CriSint32				picture_structure;			/* PIC_C :sN`\ 0:\ 1:top-field, 2:bottom-f. 3:frame */
	CriSint32				chroma_format;				/* SEQ_X :FtH[}bg 0:\ 1:420 2:422 3:444	*/
	CriSint32				bit_rate;					/* SEQ,X :rbg[g 18+12=30bit */
	CriSint32				vbv_buffer_size;			/* SEQ,X :VBVobt@TCY 10+8=18bit */
	CriSint16				display_horizontal_size;	/* SEQ_D :\ 14bit */
	CriSint16				display_vertical_size;		/* SEQ_D :\ 14bit */
	CriSint8				progressive_frame;			/* PIC_C :0:C^[X 1:vObVu */
	CriSint8				top_field_first;			/* PIC_C :gbvtB[hDtO */
	CriSint8				repeat_first_field;			/* PIC_C :tB[h\tO */
	CriSint8				aspect_ratio_information;	/* SEQ   :AXyNg 4bit */
	CriSint8				constrained_parameters_flag;/* SEQ   :p[^tO */
	CriSint8				frame_rate_extension_n;		/* SEQ_X :t[[ggn 2bit */
	CriSint8				frame_rate_extension_d;		/* SEQ_X :t[[ggd 5bit */
	CriUint8				profile_and_level_indication;/*SEQ_X :vt@CAx 8bit */
	CriSint8				progressive_sequence;		/* SEQ_X :vObVuV[PXtO */
	CriSint8				low_delay;					/* SEQ_X :xtO */
	CriSint8				video_format;				/* SEQ_D :rfItH[}bg 3bit */
	CriSint8				colour_description;			/* SEQ_D :FL^tO 1bit */
	CriUint8				colour_primaries;			/* SEQ_D :񌹌F̐FxW 8bit */
	CriUint8				transfer_characteristics;	/* SEQ_D :ϊ 8bit */
	CriUint8				matrix_coefficients;		/* SEQ_D :}gNXW 8bit */
	CriSint16				num_slices;					/* slice :XCX */
} MwsfdFrmM2v;

/* MPEG-4t[		*/
/* MPEG-4 detail infomation	*/
typedef struct {
	CriSint64				pts;						/* PES   :PTS 33bit (-1:PTSȂ) */
	void				*header;					/* MPEG-4rfI̊ewb_ */
} MwsfdFrmM4v;

/* R[fbNŗL̃t[		*/
/* Codec-specific frame information	*/
typedef struct {
	MwsfdVideoCodec		videocodec;		/* rfIR[fbN */
	union {
		MwsfdFrmM2v		frmm2v;			/* MPEG-2t[iMPEG-1, SofdecVideołLj */
		MwsfdFrmM4v		frmm4v;			/* MPEG-4t[ */
	} u;
} MwsfdFrmCodec;

/* t[\ */
/* Frame Information  */
typedef struct {
	CriUint8			*bufadr;			/* fR[hʃobt@AhX		*/
										/* Decoder's output buffer address	*/
	CriSint32			frmid;				/* Frame ID */
	MwsfdBufFmt		buffmt;				/* fR[hʃobt@f[^`	*/
										/* Decoder's output buffer format	*/
	CriSint32			width;				/* sNZ						*/
										/* Width by the pixel				*/
	CriSint32			height;				/* csNZ						*/
										/* Height by the pixel				*/
	CriSint32			disp_width;			/* \sNZ					*/
										/* Effective Width by the pixel		*/
	CriSint32			disp_height;		/* \csNZ					*/
										/* Effective Height by the pixel	*/
	CriSint32			x_mb;				/* }NubN				*/
										/* Width by the macroblock			*/
	CriSint32			y_mb;				/* c}NubN				*/
										/* Height by the macroblock			*/
	MwsfdPtype		ptype;				/* sN`^Cv					*/
										/* Picture type						*/
	CriSint32			fps;				/* t[[g[fps * 1000]		*/
										/* Frame rate [fps * 1000]			*/
	CriSint32			fno;				/* t[ԍ						*/
										/* Count of frames					*/
	CriSint32			time;				/* \							*/
										/* Time of disp						*/
	CriSint32			tunit;				/* \P						*/
										/* Unit of display time				*/
	CriSint32			concat_cnt;			/* A						*/
										/* Count of concatenation			*/
	CriSint32			fno_per_file;		/* t@C̃t[ԍ			*/
										/* Count of frames per file			*/
	CriSint32			time_per_file;		/* t@C̍Đ				*/
										/* Playtime per file				*/
	CriSint32			errcnt;				/* f[^G[				*/
										/* Count of data error				*/
	CriSint32			rcvcnt;				/* f[^G[񕜉				*/
										/* Count of error recovery			*/
	void			*usrdatptr;			/* Picture layer user data address	*/
	CriSint32			usrdatsize;			/* Picture layer user data size		*/
	MwsfdFrmType	frmtype;			/* t[^Cv 					*/
										/* Frame type		 				*/

	MwsfdYuvMode	yuvmode;			/* YUVϊ[h					*/
										/* YUV conversion mode				*/
	CriUint32			zmin;				/* Minimum dynamic range for Z movie */
	CriUint32			zmax;				/* Maximum dynamic range for Z movie */

	MwsfdFrmCodec	frmcodec;			/* R[fbNŗL̃t[		*/

	void			*sud_ptr;
	CriSint32			sud_size;
} MwsfdFrmObj, MWS_PLY_FRM;

/* Đ\ 		*/
/* Playback information	*/
typedef struct {
	CriSint32		drop_frm_cnt;		/* Count of drop frame 						*/
	CriSint32		skip_dec_cnt;		/* Count of skip decode						*/
	CriSint32		skip_disp_cnt;		/* Count of skip frame was not obtatined	*/
	CriSint32		skip_emptyb_cnt;	/* Count of skip empty-Bpicture 			*/
	CriSint32		no_supply_cnt;		/* Count of data supply shortage			*/
	CriFloat32		average_fps;
} MwsfdPlyInf;

/* t@Cwb_		*/
/* File header information	*/
typedef struct {
	CriBool			playable;		/* TRUE: playable, FALSE: not playable	*/
	CriSint32		ftype;			/* File type (MWSFD_FTYPE_ )			*/
	CriSint32		width;			/* Width by the pixel					*/
	CriSint32		height;			/* Height by the pixel					*/
	CriSint32		disp_width;		/* Effective Width by the pixel			*/
	CriSint32		disp_height;	/* Effective Height by the pixel		*/
	CriSint32		fps;			/* Frame rate [fps * 1000]				*/
	CriSint32		frmnum;			/* Total video frames					*/
	CriSint32		fxtype;			/* F/X type	(MWSFD_COMPO_ )				*/
	CriSint32		ave_bps;		/* (Not Support Yet!!!)					*/

	/* <Elementary stream in SFD file> */
	CriSint32		num_video_ch;	/* the number of video channel stream	*/
	CriSint32		num_audio_ch;	/* the number of audio channel stream 	*/

	/* <Default audio channel stream information>	*/
	CriSint32		a_sfreq;		/* Audio: sampling freqency 			*/
	CriSint32		a_nch;			/* Audio: 0:NONE 1:MONO: 2:STEREO		*/

	/* <Video additional information>	*/
	CriSint32		max_picdata_size;

	CriUint64		file_size;		/* [Byte] */
} MwsfdHdrInf;

/*	Malloc Function	*/
typedef void *(*MwsfdMallocFn)(void *obj, CriUint32 size);

/*	Free Function	*/
typedef void (*MwsfdFreeFn)(void *obj, void *ptr);

/* YCbCrv[\ */
/* YCbCr Plane Information */
typedef struct {
	CriUint8 		*y_ptr;		/* Y  Buffer Pointer */
	CriUint8 		*cb_ptr;	/* Cb Buffer Pointer */
	CriUint8 		*cr_ptr;	/* Cr Buffer Pointer */
	CriSint32		y_width;	/* Y  Buffer width   */
	CriSint32		cb_width;	/* Cb Buffer width   */
	CriSint32		cr_width;	/* Cr Buffer width   */
} MwsfdYccPlane, MWS_PLY_YCC_PLANE;

/* I picture V[NĐp\     */
/* I pciture seek playback information  */
typedef struct {
	CriUint32		offset;		/* Byte offset from top of the file */
	CriSint32		fno;		/* Frame number in an I picture movie */
} MwsfdSeekIpic;

/* yϊpR[obN֐ */
/* yobt@pϊe[uAvP[V삷邽߂̊֐B
 * 	orgtbl : fR[hʂAyl(0x00000000`0x7FFFFFFF)ւ̕ϊe[u|C^B
 *           e[ûMWPLYnh̒ɂB
 *  znear, zfar : jA^t@[
 *  ztbl   : yl(0x00000000`0x7FFFFFFF)yobt@eւ̕ϊe[u|C^B
 *           ֐CriSint16CriSint32ɃLXgĎgpB
 *           e[ûMWPLYnh̒ɂB
 */
typedef void (*MwsfdMakeZTblCbFn)(CriUint32 *orgtbl, CriFloat32 znear, CriFloat32 zfar, void *ztbl);

/* ʃJE^ */
/* Flow counter	*/
typedef struct {
	CriSint64			supplied;		/* TCY[byte]                                     */
									/* supplied data size [byte]                            */
	CriSint64			consumed;		/* TCY[byte] (jTCY܂)                  */
									/* consumed data size [byte] (including discarded size) */
	CriSint64			discarded;		/* jTCY[byte]                                     */
									/* discarded data size [byte]                           */
} MwsfdFlowCnt;

/* ʏ\ 	*/
/* Flow information	*/
typedef struct {
	MwsfdFlowCnt	system;		/* system decoder flow counter                                 */
	MwsfdFlowCnt	video;		/* video decoder flow counter ("discarded" is not implemented) */
	MwsfdFlowCnt	audio;		/* audio decoder flow counter ("discarded" is not implemented) */
	MwsfdFlowCnt	adxtin;		/* adxt input sj flow counter ("discarded" is not implemented) */
} MwsfdFlowInf;

/* ONbN֐ */
typedef void (*MwsfdExtClockFn)(void *usrobj, CriSint32 *time, CriSint32 *tunit);

/* t[ϊR[obN֐ */
typedef void (*MwsfdCnvFrmCbFn)(void *usrobj, CriSint32 frmid);





/* Maximum number of Audio channel in a movie file */
#define MWSFD_MAX_AUDIO_CH		(32)

/* Audio Codec */
typedef enum {
	MWSFD_AUDIO_CODEC_NONE		= 0,	/* NONE							*/
	MWSFD_AUDIO_CODEC_SFA		= 1, 	/* Sofdec Audio					*/
	MWSFD_AUDIO_CODEC_MPA		= 2,	/* MPEG Audio					*/
	MWSFD_AUDIO_CODEC_AC3		= 3,	/* AC3							*/
	MWSFD_AUDIO_CODEC_AHX		= 4,	/* AHX							*/
	MWSFD_AUDIO_CODEC_AIX		= 5,	/* AIX (Multi Channel Audio)	*/

	MWSFD_AUDIO_CODEC_END
} MwsfdAudioCodec;

/* Audio Codec Info */
typedef struct {
	CriBool				exist_flag;
	MwsfdAudioCodec		audio_codec;
	CriSint32				num_channel;
	CriSint32				sampling_rate;
} MwsfdAudioInfo;

/* Audio Detail Info in Sofdec Header */
typedef struct {
	CriBool			used;
	MwsfdAudioInfo	audio_info[MWSFD_MAX_AUDIO_CH];
} MwsfdHdrAudioDetail;


/***************************************************************************
 *      Function Declaration
 ***************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/*=========================================================================*
 *		{Đ
 *      Basic functions
 *=========================================================================*/
/* MWSFD(Sofdec)Cȕ	*/
/* Initialization of Sofdec library	*/
void CRIAPI mwPlyInitSfdFx(MwsfdInitPrm *iprm);

/* MWSFD(Sofdec)CȕI	*/
/* Termination of Sofdec library 	*/
void CRIAPI mwPlyFinishSfdFx(void);

/* Ɨ̈TCY̌vZ										*/
/* Calculation of working area size from create parameter	*/
CriSint32 CRIAPI mwPlyCalcWorkCprmSfd(MwsfdCrePrm *cprm);

/* MWSFDnh̐				*/
/* Create MWPLY handle for Sofdec	*/
MWPLY CRIAPI mwPlyCreateSofdec(MwsfdCrePrm *cprm);

/* Đnh̏						*/
/* Destroy MWPLY handle						*/
void CRIAPI mwPlyDestroy(MWPLY mwply);

/* ĐJnit@C̍Đj								*/
/* Start playing by file name 									*/
void CRIAPI mwPlyStartFname(MWPLY mwply, const CriChar8 *fname);

/* Đ~									*/
/* Stop playing  							*/
void CRIAPI mwPlyStop(MWPLY mwply);

/* nhԂ̎擾								*/
/* Get status of MWPLY handle						*/
MwsfdStat CRIAPI mwPlyGetStat(MWPLY mwply);

/* t[̎擾           */
/* Get frame buffer pointer */
void CRIAPI mwPlyGetCurFrm(MWPLY mwply, MwsfdFrmObj *frm);

/* t[̉ 			*/
/* Release frame buffer		*/
void CRIAPI mwPlyRelCurFrm(MWPLY mwply);

/* ĐTv̎擾														*/
/* Get playing time															*/
/* If playing movie is 30 fps, *tscale is 30 and *ncount is total number of */
/*  displayed frames														*/
void CRIAPI mwPlyGetTime(MWPLY mwply, CriSint32 *ncount, CriSint32 *tscale);

/* |[Y^|[Y									*/
/* Set pause switch.  sw=0(Continue), 1(Pause)			*/
void CRIAPI mwPlyPause(MWPLY mwply, CriSint32 sw);

/* |[YԂ̎擾 */
/* Get pause ON/OFF	*/
CriBool CRIAPI mwPlyIsPause(MWPLY mwply);

/* R}   */
/* Step frame */
void CRIAPI mwPlyStepFrame(MWPLY mwply);

/* <NEW> Get frame */
/* <V> t[̎擾 */
/* []
 *    mwply    :MWPLYnh
 * [o]
 *    frmid    :擾łt[̃t[IDiϐ̂̓[U`j
 *    frm      :擾łt[̃t[\́iϐ̂̓[U`j
 * [֐l]
 *    TRUE     : t[擾ł
 *    FALSE    : t[擾łȂ
 * [l]
 * EmwPlyGetCurFrm֐/mwPlyRelCurFrm֐Ƃ̕p͋֎~B
 * E\ɂȂĂt[擾B
 * Et[͈x擾łB
 * EÂt[ȂĂAVt[擾łB
 * Et[emwPlyRelFrm֐ŉ邩AmwPlyStop֐s܂ŕێB
 * EmwPlyGetFrm֐mwPlyRelFrm֐͓XbhŎs邱ƁB
 */
CriBool CRIAPI mwPlyGetFrm(MWPLY mwply, CriSint32 *frmid, MwsfdFrmObj *frm);

/* <NEW> Release frame */
/* <V> t[̉ */
/* []
 *    mwply    :MWPLYnh
 *    frmid    :t[̃t[ID
 * [l]
 * EmwPlyGetCurFrm֐/mwPlyRelCurFrm֐Ƃ̕p͋֎~B
 * EfrmidŎw肵t[B
 * Et[IDɑ΂Ẳ͂Px̂݁BQxڈȍ~̓G[R[obNB
 * Et[擾ԂƉ鏇Ԃ͈vȂĂ悢B
 * ESĂ̎擾ς݃t[ȂAMWPLYnhPLAYENDԂɂȂȂB
 * EmwPlyGetFrm֐mwPlyRelFrm֐͓XbhŎs邱ƁB
 */
void CRIAPI mwPlyRelFrm(MWPLY mwply, CriSint32 frmid);

/*=========================================================================*
 *		gt@CĐ
 *		Extended File Playback
 *=========================================================================*/
/* FID wɂĐ̊Jn 				*/
/* Start AFS palyback by specified file ID	*/
void CRIAPI mwPlyStartAfs(MWPLY mwply, CriSint32 patid, CriSint32 fid);

/* pbNt@CSFDf[^̍ĐJn */
/* Start playing SFD data in packed file */
/* [Inputs  ] mwply			: MWPLY handle
 *			  fname			: File name
 *			  offset_sct	: File offset from top of the file as a sector
 *			  range_sct		: File range as a sector					 */
void CRIAPI mwPlyStartFnameRange(MWPLY mwply, const CriChar8 *fname, CriSint32 offset_sct, CriSint32 range_sct);

/* SJɂĐ̊Jn								*/
/* Start playing by stream joint					*/
void CRIAPI mwPlyStartSj(MWPLY mwply, SJ sji);

/* f[^I̒ʒm(SJĐp) */
/* Notify the end of data supply, for mwPlyStartSj() */
void CRIAPI mwPlyTermSupply(MWPLY mwply);

/* AhXw胁ɂĐJn										*/
/* Start playing by memory												*/
void CRIAPI mwPlyStartMem(MWPLY mwply, const void *addr, CriSint32 len);
/* AhXw胁ɂ郋[vĐJn								*/
/* Start looping playback by memory										*/
void CRIAPI mwPlyStartMemLp(MWPLY mwply, const void *data, CriSint32 dtlen);

/* AĐ̊Jn */
/* - SĂ̘At@Co^IAmwPlyReleaseMemSeamless֐Ă */
/* - mwPlyReleaseMemSeamless֐Ă΂Ȃꍇ́AĐIԂɂȂȂ */
void CRIAPI mwPlyStartMemSeamless(MWPLY mwply);
/* AĐ̓o^ */
/* - mwPlyStartMemSeamless֐̌ďoɗL */
/* - ɓo^ł̂͂PU܂ */
void CRIAPI mwPlyEntryMemSeamless(MWPLY mwply, const void *data, CriSint32 dtlen);
/* AĐ̓o^I錾 */
void CRIAPI mwPlyReleaseMemSeamless(MWPLY mwply);
/* AĐ̓o^擾 */
CriSint32 CRIAPI mwPlyGetNumMemSeamless(MWPLY mwply);

/*=========================================================================*
 *		V[X[vĐ
 *		Seamless Loop Playback
 *=========================================================================*/
/* V[X[vĐ̊Jn	*/
/* Start semaless loop playback	*/
void CRIAPI mwPlyStartFnameLp(MWPLY mwply, const CriChar8 *fname);

/* V[X[vĐ̉		*/
/* Release semaless loop playback	*/
void CRIAPI mwPlyReleaseLp(MWPLY mwply);

/* FID wɂV[X[vĐ̊Jn	  			*/
/* Start semaless loop playback by specified file ID	*/
void CRIAPI mwPlyStartAfsLp(MWPLY mwply, CriSint32 patid, CriSint32 fid);

/* pbNt@CSFDf[^̃V[X[vĐ̊Jn	*/
/* Start looping playing SFD data in packed file */
void CRIAPI mwPlyStartFnameRangeLp(MWPLY mwply, const CriChar8 *fname, CriSint32 offset_sct, CriSint32 range_sct);

/*=========================================================================*
 *		V[XAĐ
 *		Seamless Continuous Playback
 *=========================================================================*/
/* V[XAĐt@C̓o^				*/
/* Entry file of Seamless continuous playback	*/
void CRIAPI mwPlyEntryFname(MWPLY mwply,const CriChar8 *fname);

/* V[XAĐ̊Jn				*/
/* Start seamless continuous playback	*/
void CRIAPI mwPlyStartSeamless(MWPLY mwply);

/* V[XAĐ̉				*/
/* Release seamless continuous playback	*/
void CRIAPI mwPlyReleaseSeamless(MWPLY mwply);

/*	V[X[vĐ̐ݒ	*/
/*	Set semaless loop play   	*/
void CRIAPI mwPlySetSeamlessLp(MWPLY mwply, CriSint32 flg);

/* ݓo^Ăt@C̎擾			*/
/* Get number of file entried seamless loop 	*/
CriSint32 CRIAPI mwPlyGetNumSlFiles(MWPLY mwply);

/* V[XAĐɓo^Ăt@C̎擾	*/
/* Get file name of entried seamless				*/
const CriChar8 * CRIAPI mwPlyGetSlFname(MWPLY mwply, CriSint32 stm_no);

/* V[XAĐt@C̓o^ (AFS)			*/
/* Entry file of Seamless continuous playback (AFS)	*/
void CRIAPI mwPlyEntryAfs(MWPLY mwply, CriSint32 patid, CriSint32 fid);

/* pbNt@CSFDf[^̃V[XAĐo^				*/
/* Entry SFD data in packed file to seamless continuous playback	*/
void CRIAPI mwPlyEntryFnameRange(MWPLY mwply, const CriChar8 *fname, CriSint32 offset_sct, CriSint32 range_sct);

/*=========================================================================*
 *		I[fBIݒ
 *		Audio Configuration
 *=========================================================================*/
/* I[fBIo̓{[̐ݒ							*/
/* Set Output Volume (vol= 0 to -960)						*/
void CRIAPI mwPlySetOutVol(MWPLY mwply, CriSint32 vol);

/* I[fBIo̓{[̎擾				*/
/* Get Output Volume (return value= 0 to -960)	*/
CriSint32 CRIAPI mwPlyGetOutVol(MWPLY mwply);

/* I[fBIo̓p|bg̐ݒ										*/
/* Set output panpot c=0(Mono/Left),1(Right)							*/
/* p = +15(Right),0(Center),-15(Left),-128(Auto)						*/
void CRIAPI mwPlySetOutPan(MWPLY mwply, CriSint32 chno, CriSint32 pan);

/* I[fBIo̓p|bg̎擾								*/
/* Get output panpot c=0(Mono/Left),1(Right)					*/
CriSint32 CRIAPI mwPlyGetOutPan(MWPLY mwply, CriSint32 chno);

/* I[fBIXg[`l̎擾		*/
/* Get the number of audio channel streams	*/
CriSint32 CRIAPI mwPlyGetNumAudioCh(MWPLY mwply);

/* I[fBIXg[`l̐ݒ	*/
/* Set audio stream channel 			*/
void CRIAPI mwPlySetAudioCh(MWPLY mwply, CriSint32 ch);

/* I[fBIXg[`l̎擾 (-1: ܂͍ĐȂ)	*/
/* Get audio stream channel (-1: pending or out of work) */
CriSint32 CRIAPI mwPlyGetAudioCh(MWPLY mwply);

/*=========================================================================*
 *		eI[fBIݒ
 *		Various Audio Configuration
 *=========================================================================*/
/* {CXgbNĐp[Nobt@TCY̎擾 */
/* Get size of work buffer for voice track in movie */
CriSint32 CRIAPI mwPlyGetVoiceWorkSize(void);

/* {CXgbNĐ@\̒ǉ */
/* Attach voice track playback function to MWPLY */
void CRIAPI mwPlyAttachVoice(MWPLY mwply, void *wkptr, CriSint32 wksize);

/* {CXgbNĐ@\̕ */
/* Detach voice track playback function from MWPLY */
void CRIAPI mwPlyDetachVoice(MWPLY mwply);

/* {CXgbN`lԍ̐ݒ */
/* Set channel number of voice track */
void CRIAPI mwPlySetVoiceCh(MWPLY mwply, CriSint32 ch);

/* AHXĐp[Nobt@TCY̎擾 */
/* Get size of work buffer for AHX in movie */
CriSint32 CRIAPI mwPlyGetAhxWorkSize(void);

/* AHXĐ@\̒ǉ */
/* Attach AHX to MWPLY */
void CRIAPI mwPlyAttachAhx(MWPLY mwply, void *wkptr, CriSint32 wksize, CriSint32 ch);

/* AHXĐ@\̕ */
/* Detach AHX from MWPLY */
void CRIAPI mwPlyDetachAhx(MWPLY mwply);

/* AHX`lԍ̐ݒ */
/* Set channel number of AHX */
void CRIAPI mwPlySetAhxCh(MWPLY mwply, CriSint32 ch);

/*=========================================================================*
 *		Tu^Cgij
 *		Subtitle
 *=========================================================================*/
/* f[^̎擾 */
/* Get subtitle data */
CriSint32 CRIAPI mwPlyGetSubtitle(MWPLY mwply, CriUint8 *bufptr, CriSint32 bufsize, MwsfdSbtPrm *sbtprm);

/* f[^̃`lݒ		*/
/* Set channel of subtitle data	*/
void CRIAPI mwPlySetSubtitleCh(MWPLY mwply, CriSint32 chno);

/* Tu^Cg`l̎擾 */
/* Get the number of subtitle channel */
CriSint32 CRIAPI mwPlyGetNumSubtitleCh(MWPLY mwply);

/* f[^̃Vtg^Cݒ		*/
/* Set shift time of subtitle data	*/
void CRIAPI mwPlySetSubtitleScount(MWPLY mwply, CriSint32 scount);

/*=========================================================================*
 *		t[ϊݒ
 *		FrameConversion Configuration
 *=========================================================================*/

/* o̓obt@TCY̐ݒ */
/* Set size of out buffer 	*/
void CRIAPI mwPlyFxSetOutBufPitchHeight(MWPLY mwply, CriSint32 pitch, CriSint32 height);
/* o̓obt@TCY̎擾 */
/* Get size of out buffer 	*/
void CRIAPI mwPlyFxGetOutBufPitchHeight(MWPLY mwply, CriSint32 *pitch, CriSint32 *height);

/* [for Compatibility] */
void CRIAPI mwPlyFxSetOutBufSize(MWPLY mwply, CriSint32 width, CriSint32 height);
void CRIAPI mwPlyFxGetOutBufSize(MWPLY mwply, CriSint32 *width, CriSint32 *height);

/* [h̐ݒ 	*/
/* Set composition mode	*/
void CRIAPI mwPlyFxSetCompoMode(MWPLY mwply, CriSint32 mode);
/* [h̎擾 */
/* Get composition mode	*/
CriSint32 CRIAPI mwPlyFxGetCompoMode(MWPLY mwply);

/* ~iXL[p[^̐ݒ		*/
/* Set luminance key alpha parameter	*/
void CRIAPI mwPlyFxSetLumiPrm(MWPLY mwply, CriSint32 in_th, CriSint32 out_th, MwsfdLumiKey key);
/* ~iXL[p[^̎擾 		*/
/* Get luminance key alpha parameter	*/
void CRIAPI mwPlyFxGetLumiPrm(MWPLY mwply, CriSint32 *in_th, CriSint32 *out_th, MwsfdLumiKey *key);

/* RlAt@pp[^ݒ */
/* Set alpha 3-value parameter */
void CRIAPI mwPlyFxSetAlp3Prm(MWPLY mwply, CriUint8 zero, CriUint8 half, CriUint8 full);
/* RlAt@pp[^擾 */
/* Get alpha 3-value parameter */
void CRIAPI mwPlyFxGetAlp3Prm(MWPLY mwply, CriUint8 *zero, CriUint8 *half, CriUint8 *full);

/*=========================================================================*
 *		y[r
 *		Z movie
 *=========================================================================*/
/* 16bit-yobt@ւ̕ϊ 		*/
/* Convert to 16bit depth Z-value	*/
void CRIAPI mwPlyFxCnvFrmZ16(MWPLY mwply, MwsfdFrmObj *frm, CriUint8 *zout);
/* 32bit-yobt@ւ̕ϊ 					*/
/* Convert to 32bit depth Z-value	*/
void CRIAPI mwPlyFxCnvFrmZ32(MWPLY mwply, MwsfdFrmObj *frm, CriUint8 *zout);

/* yNbv̐ݒ */
/* Set Z-clip		*/
void CRIAPI mwPlyFxSetZclip(MWPLY mwply, CriFloat32 znear, CriFloat32 zfar);
/* yNbv̎擾 */
/* Get Z-clip		*/
void CRIAPI mwPlyFxGetZclip(MWPLY mwply, CriFloat32 *znear, CriFloat32 *zfar);

/* yϊe[u쐬R[obN֐̓o^ */
void CRIAPI mwPlyFxSetCbFnMakeZTbl(MWPLY mwply, MwsfdMakeZTblCbFn func);

/*=========================================================================*
 *		擾
 *		Information
 *=========================================================================*/

/* F/Xʂ̎擾 */
/* Get F/X type from SFD data */
CriSint32 CRIAPI mwPlyGetFxType(MWPLY mwply);

/* t@C̎擾			*/
/* Get file header information	*/
void CRIAPI mwPlyGetHdrInf(CriSint8 *buf, CriSint32 bsize, MwsfdHdrInf *hdrinf);

/* wb_iI[fBIڍׁj̎擾	*/
/* Get audio detail header information	*/
void CRIAPI mwPlyGetHdrAudioDetail(CriSint8 *buf, CriSint32 bsize, MwsfdHdrAudioDetail *audio_detail);

/* 2008-10-02 */
/* t@Cwɂ t@C wb_iI[fBIڍׁj̎擾	*/
/* Get header informations by filename	*/
CriBool CRIAPI mwPlyReadAndGetHdrInfs(const CriChar8 *fname,MwsfdHdrInf *hdrinf,MwsfdHdrAudioDetail *audio_detail);

/* t[̎擾 				*/
/* Get the number of movie frame	*/
CriSint32 CRIAPI mwPlyGetTotalFrmNum(MWPLY mwply);

/*=========================================================================*
 *		ݒ
 *		Special Configuration
 *=========================================================================*/
/* Malloc^Free ֐̓o^ */
/* Set memory allocation / free callback function */
void CRIAPI mwPlySetMallocFn(MwsfdMallocFn mallocfn, MwsfdFreeFn freefn, void *obj);

/* Đx̐ݒ(LŎw) */
/* Set playback speed by rational number */
void CRIAPI mwPlySetSpeedRational(MWPLY mwply, CriSint32 speed_numerator, CriSint32 speed_denominator);

/* Đx̐ݒ(Wx = 1000) */
/* Set playback speed (normal speed = 1000) */
void CRIAPI mwPlySetSpeed(MWPLY mwply, CriSint32 speed);

/* [h̐ݒ			*/
/* Set synchronization mode	*/
void CRIAPI mwPlySetSyncMode(MWPLY mwply, CriSint32 mode);
/* [h̎擾			*/
/* Get synchronization mode	*/
CriSint32 CRIAPI mwPlyGetSyncMode(MWPLY mwply);

/* ^C}`l̐ݒ */
/* Set timer channel	*/
void CRIAPI mwPlySetTimerCh(CriSint32 chno);
/* ^C}`l̎擾 */
/* Get timer channel	*/
CriSint32 CRIAPI mwPlyGetTimerCh(void);

/* sN`C̃[Uf[^pobt@̒ǉ */
/* Attach buffer for user data in picture layer */
void CRIAPI mwPlyAttachPicUsrBuf(MWPLY mwply, void *bufptr, CriSint32 bufsize, CriSint32 size1pic);

/* t[擾[h̐ݒ				*/
/* Set frame obtain synchronization mode	*/
void CRIAPI mwPlySetFrmSync(MWPLY mwply, MwsfdFrmSync frmsync);
/* t[擾[h̎擾				*/
/* Get frame obtain synchronization mode	*/
MwsfdFrmSync CRIAPI mwPlyGetFrmSync(MWPLY mwply);

/* ONbN֐̓o^
 * []
 *    mwply             :MWPLYnh
 *    extclock_fn       :ONbN֐
 *    extclock_max      :NbNl̍őlB(8rbg̏ꍇ0x000000FF, 32rbg̏ꍇ0xFFFFFFFF)
 *    extclock_usrobj   :[UIuWFNg(ONbN֐̑1Ƃă[Uɓn)
 * [ONbN̒`]
 * [r̍ĐǂɊւ炸AɒP鎞(JE^)B
 * [l]
 * o^NbN֐́A肵ĒPlo͂KvB
 * 炩̃n[hEFA瓾鐶̃NbNlł悭AĐɃI[ot[
 * 邱ƂĂ悢AI[ot[͎XVs
 * \ɑ傫Ȃ΂ȂȂB
 * Cu͑ONbNlƂ̍lƂȂ邱ƂŃI[ot[oB
 * I[ot[óANbNl extclock_max + 1 ZăI[ot[
 * ⏞B
 */
void CRIAPI mwPlySetCbExtClock(MWPLY mwply, MwsfdExtClockFn extclock_fn, CriSint32 extclock_max, void *extclock_usrobj);

/* t[̐ݒ */
void CRIAPI mwPlySetNumPrepFrm(MWPLY mwply, CriSint32 prep_frm);

/* t[̎擾 */
CriSint32 CRIAPI mwPlyGetNumPrepFrm(MWPLY mwply);

/*=========================================================================*
 *		fobOp
 *		Debugging
 *=========================================================================*/
/* SofdecCuo[W̎擾 */
/* Get Sofdec library version string */
const CriChar8 * CRIAPI mwPlyGetVersionStr(void);

/* Đԏ̐ݒiftHg 957 0bj			*/
/* Set playback limit time (default = 09-57-00(HH-MM-SS))	*/
void CRIAPI mwPlySetLimitTime(MWPLY mwply, CriSint32 sec);

/* Đ̎擾 			*/
/* Get playback information	*/
void CRIAPI mwPlyGetPlyInf(MWPLY mwply, MwsfdPlyInf *plyinf);

/* fR[hSsN`̎擾	*/
/* Get Number of Decoded Frames 	*/
CriSint32 CRIAPI mwPlyGetNumTotalDec(MWPLY mwply);

/* fR[hςݕێt[̎擾	*/
/* Get Number of Pooled Frames 		*/
CriSint32 CRIAPI mwPlyGetNumDecPool(MWPLY mwply);

/* R}t[̎擾	*/
/* Get number of droped frame	*/
CriSint32 CRIAPI mwPlyGetNumDropFrm(MWPLY mwply);
/* fR[ht[̎擾				*/
/* Get number of frames was skipped to decode	*/
CriSint32 CRIAPI mwPlyGetNumSkipDec(MWPLY mwply);
/* \ĩXLbv񐔂̎擾					*/
/* Get number of frames was skipped to obtain	*/
CriSint32 CRIAPI mwPlyGetNumSkipDisp(MWPLY mwply);
/* XLbvGveBBsN`̎擾	*/
/* Get the number of skipped empty-B picture	*/
CriSint32 CRIAPI mwPlyGetNumSkipEmptyB(MWPLY mwply);

/* ʏ̎擾           */
/* Get flow information	    */
void CRIAPI mwPlyGetFlowInf(MWPLY mwply, MwsfdFlowInf *flowinf);

/* B-PicturefR[h̃XLbvݒ 	*/
/* Set B-Picture skip decode 		*/
void CRIAPI mwPlySetBpicSkip(MWPLY mwply, CriBool sw);
/* GveBBsN`̃fR[hXLbvݒ 	*/
/* Set empty-B picture skip decode				*/
void CRIAPI mwPlySetEmptyBpicSkip(MWPLY mwply, CriBool sw);
/* P-PicturefR[h̃XLbvݒ 	*/
/* Set P-Picture skip decode 		*/
void CRIAPI mwPlySetPpicSkip(MWPLY mwply, CriBool sw);

/* ADXTnh̎擾	*/
/* Get ADXT handle		*/
ADXT CRIAPI mwPlyGetAdxtHn(MWPLY mwply);
/* ̓Xg[WCg̎擾	*/
/* Get SJ of Input          		*/
SJ CRIAPI mwPlyGetInputSj(MWPLY mwply);
/* rfIfR[_nh̎擾	*/
/* Get Video decoder handle		*/
void * CRIAPI mwPlyGetSfdHn(MWPLY mwply);

/* ct[̎擾 (o\ȃt[̎擾) */
CriSint32 CRIAPI mwPlyGetNumRemainFrm(MWPLY mwply);

/* OL^@\̒ǉ */
/* Attach Log recording function */
//void CRIAPI mwPlyAttachLog(CriLog log);

/* OL^@\̕ */
/* Attach Log recording function */
//void CRIAPI mwPlyDetachLog(void);

/*=========================================================================*
 *		W֐
 *		Nonstandard Functions
 *=========================================================================*/
/* [for Compatibility] */
/* Please call ADXM_WaitVsync(). This function is same function. */
void CRIAPI mwPlySwitchToIdle(void);

/* T[o؂₢킹							*/
/* Determine whether process is in server border	*/
CriBool CRIAPI mwPlyIsSvrBdr(void);

/* YCbCrv[̌vZ        */
/* Calculation of YCbCr plane */
void CRIAPI mwPlyCalcYccPlane(CriUint8 *bufptr, CriSint32 width, CriSint32 height, 
								MwsfdYccPlane *ycc);

/* o̓XCb`̐ݒ			*/
/* Set audio output switch			*/
void CRIAPI mwPlySetAudioSw(MWPLY mwply, CriSint32 sw);

/* rfIXg[`l̎擾			*/
/* Get the number of video channel streams	*/
CriSint32 CRIAPI mwPlyGetNumVideoCh(MWPLY mwply);
/* rfIXg[`l̐ݒ	*/
/* Set video stream channel 		*/
void CRIAPI mwPlySetVideoCh(MWPLY mwply, CriSint32 ch);
/* rfIXg[`l̎擾 (-1: ܂͍ĐȂ)	*/
/* Get video stream channel (-1: pending or out of work) */
CriSint32 CRIAPI mwPlyGetVideoCh(MWPLY mwply);

/* rfIo̓XCb`̐ݒ	*/
/* Set video output switch	*/
void CRIAPI mwPlySetVideoSw(MWPLY mwply, CriSint32 sw);

/* nhVsync	*/
/* V-sync function 			*/
void CRIAPI mwPlyVsyncHndl(MWPLY mwply);
/* nh̃T[o 		*/
/* Execute decoding one frame	*/
CriBool CRIAPI mwPlyExecSvrHndl(MWPLY mwply);

/* In the case of that no use ADXM_SetupThrd() and ADXM_ExecMain(). */
/* XbhOǗ̎XVT[o */
/* [Ԃl] TRUE : 邱ƂcĂBFALSE: 邱Ƃ͖B */
CriBool CRIAPI mwPlyExecVsyncServer(void);
/* In the case of that no use ADXM_SetupThrd() and ADXM_ExecMain(). */
/* XbhOǗ̃fR[hT[o */
/* [Ԃl] TRUE : 邱ƂcĂBFALSE: 邱Ƃ͖B */
/* ATTN: }`Xbhœꍇ̓T[o؂菈ɒӁB */
CriBool CRIAPI mwPlyExecDecServer(void);

/* L[[h̐ݒ(NULLwŃL[[h) */
void CRIAPI mwPlySetKeyString(MWPLY mwply, const CriChar8 *str);
/* t@C̎擾iL[[hwj	*/
void CRIAPI mwPlyGetHdrInfWithKey(CriSint8 *buf, CriSint32 bsize, const CriChar8 *str, MwsfdHdrInf *hdrinf);

/* XVVbInŎIɍsǂ̐ݒ							*/
/* sw = ON	: VbInŎIɍXViftHgj							*/
/*    = OFF	: IɍXV͍sȂimwPlyUpdateTime֐ōXVj	*/
void CRIAPI mwPlySetUpdateTimeAuto(MWPLY mwply, CriBool sw);

/* ̍XV
 * [l]
 * mwPlySetUpdateTimeAuto֐OFFw肵ꍇAIɌĂяoKvB
 * C[vV҂̒ȂǁAVԒ̂ł邾^C~O
 * ]܂B
 * Ăяo񐔂ǗKv͂ȂB܂AC[v
 * ɁA񐔂₤߂ɉxĂяoȂĂ悢B
 */
void CRIAPI mwPlyUpdateTime(MWPLY mwply);

/*=========================================================================*/
/*=========================================================================*
 *		t[ϊ
 *		Frame Conversion
 *=========================================================================*/
/*=========================================================================*/
/* ARGB8888v[tH[}bgւ̕ϊ	*/
/* Convert to plane ARGB8888 			*/
void CRIAPI mwPlyFxCnvFrmARGB8888(MWPLY mwply, MwsfdFrmObj *frm, CriUint8 *out);

/* YUV422v[tH[}bgϊ	*/
/* Convert to plane YUV422 			*/
void CRIAPI mwPlyFxCnvFrmYUV422(MWPLY mwply, MwsfdFrmObj *frm, CriUint8 *out);

/* Y84C44v[tH[}bgϊ	*/
/* Convert to plane Y84C44 			*/
void CRIAPI mwPlyFxCnvFrmY84C44(MWPLY mwply, MwsfdFrmObj *frm, CriUint8 *yout, CriUint8 *cout);

/* ARGB8888}NubNtH[}bgւ̕ϊ */
/* Conver to macloblock ARGB8888 */
void CRIAPI mwPlyFxCnvFrmMbARGB8888(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out);

/* RGBA8888v[tH[}bgւ̕ϊ */
/* Conver to plane RGBA8888 */
void CRIAPI mwPlyFxCnvFrmRgba8888(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out);

/* BGRA8888v[tH[}bgւ̕ϊ */
/* Conver to plane BGRA8888 */
void CRIAPI mwPlyFxCnvFrmBgra8888(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out);

#if defined(XPT_TGT_PC)
void CRIAPI mwPlyFxCnvFrmAbgr8888(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out);
void CRIAPI mwPlyFxCnvFrmClipAbgr8888(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out, CriSint32 lux, CriSint32 luy, CriSint32 w, CriSint32 h);
#endif

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*
 * [`wɂt[ϊ]
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*
 *  (lux, luy) : ϊƂ̍Wiwj
 *  (w, h)     : ϊ̈̕ƍ
 * [p[^w̗]
 *  ----+------------------------------------------------------------------
 *      |  㔼               E     c̒
 *  ----+------------------------------------------------------------------
 *  lux |    0          0          0       width/2        width/4
 *  luy |    0       height/2      0          0          height/4
 *  w   |  width      width     width/2    width/2        width/2
 *  h   | height/2   height/2    height     height       height/2
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*
 * [Convert frame by clipping rectangle area]
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*
 *  (lux, luy) : coordinate of left upper (luy is even onlly)
 *  (w, h)     : width and height of rectangle area
 * [example]
 *  ----+------------------------------------------------------------------
 *      | upper half  lower half  left half  right half    
 *  ----+------------------------------------------------------------------
 *  lux |     0           0           0       width/2      
 *  luy |     0        height/2       0          0         
 *   w  |   width       width      width/2    width/2      
 *   h  |  height/2    height/2     height     height      
 *=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=*/
/* `͈͎wARGB8888ɕϊ */
/* Convert frame to ARGB8888 by clipping rectangle area */
void CRIAPI mwPlyFxCnvFrmClipARGB8888(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out, 
								CriSint32 lux, CriSint32 luy, CriSint32 w, CriSint32 h);
/* `͈͎wYUV422ɕϊ */
/* Convert frame to YUV422 by clipping rectangle area */
void CRIAPI mwPlyFxCnvFrmClipYUV422(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out, 
								CriSint32 lux, CriSint32 luy, CriSint32 w, CriSint32 h);

/* RGB888v[tH[}bgւ̕ϊ	*/
/* Convert to plane RGB888 				*/
void CRIAPI mwPlyFxCnvFrmRGB888(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out);

/* `wRGB565ϊ֐					*/
/* Convert frame to RGB565 by clipping rectangle area */
void CRIAPI mwPlyFxCnvFrmClipRGB565(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out,
									CriSint32 lux, CriSint32 luy, CriSint32 w, CriSint32 h);
/* `wRGB565ϊ֐ifBUtj	*/
/* Convert frame to RGB565 with dithering by clipping rectangle area */
void CRIAPI mwPlyFxCnvFrmClipRGB565WithDither(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out,
									CriSint32 lux, CriSint32 luy, CriSint32 w, CriSint32 h);

/* `wRGB555ϊ֐					*/
/* Convert frame to RGB555 by clipping rectangle area */
void CRIAPI mwPlyFxCnvFrmClipRGB555(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out,
									CriSint32 lux, CriSint32 luy, CriSint32 w, CriSint32 h);
/* `wRGB555ϊ֐ifBUtj	*/
/* Convert frame to RGB555 with dithering by clipping rectangle area */
void CRIAPI mwPlyFxCnvFrmClipRGB555WithDither(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out,
									CriSint32 lux, CriSint32 luy, CriSint32 w, CriSint32 h);

/* `͈͎wRGBA8888ɕϊ */
/* Convert frame to RGBA8888 by clipping rectangle area */
void CRIAPI mwPlyFxCnvFrmClipRgba8888(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out, 
								CriSint32 lux, CriSint32 luy, CriSint32 w, CriSint32 h);

/* `͈͎wBGRA8888ɕϊ */
/* Convert frame to BGRA8888 by clipping rectangle area */
void CRIAPI mwPlyFxCnvFrmClipBgra8888(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out, 
								CriSint32 lux, CriSint32 luy, CriSint32 w, CriSint32 h);

/* At@̂݃v[ւ̕ϊ */
/* ϊOɃAt@v[p̃sb`ݒsĂ */
void CRIAPI mwPlyFxCnvFrmA8(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *alphaout);
/* Ŷ݃v[ւ̕ϊiRlAt@̂Ƃ̂ݒlςj */
/* ϊOYv[p̃sb`ݒsĂ */
void CRIAPI mwPlyFxCnvFrmY8(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *yout);

/*=========================================================================*
 *		񓯊̃t[ϊ
 *		Async Frame Conversion
 *=========================================================================*/
void CRIAPI mwPlyFxCnvFrmRGB565Nw(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out, MwsfdCnvFrmCbFn cnvfrmcbfn, void *usrobj);
void CRIAPI mwPlyFxCnvFrmARGB1555Nw(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out, MwsfdCnvFrmCbFn cnvfrmcbfn, void *usrobj);
void CRIAPI mwPlyFxCnvFrmARGB4444Nw(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out, MwsfdCnvFrmCbFn cnvfrmcbfn, void *usrobj);
void CRIAPI mwPlyFxCnvFrmARGB8888Nw(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out, MwsfdCnvFrmCbFn cnvfrmcbfn, void *usrobj);


/*=========================================================================*
 *		񓯊̃t[ϊiNbvj
 *		Async Frame ConversioniClipj
 *=========================================================================*/
void CRIAPI mwPlyFxCnvFrmClipRGB565Nw(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out, MwsfdCnvFrmCbFn cnvfrmcbfn, void *usrobj, 
																			CriSint32 lux, CriSint32 luy, CriSint32 w, CriSint32 h);
void CRIAPI mwPlyFxCnvFrmClipARGB1555Nw(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out, MwsfdCnvFrmCbFn cnvfrmcbfn, void *usrobj, 
																			CriSint32 lux, CriSint32 luy, CriSint32 w, CriSint32 h);
void CRIAPI mwPlyFxCnvFrmClipARGB4444Nw(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out, MwsfdCnvFrmCbFn cnvfrmcbfn, void *usrobj, 
																			CriSint32 lux, CriSint32 luy, CriSint32 w, CriSint32 h);
void CRIAPI mwPlyFxCnvFrmClipARGB8888Nw(MWPLY mwply, MwsfdFrmObj *mwfrm, CriUint8 *out, MwsfdCnvFrmCbFn cnvfrmcbfn, void *usrobj, 
																			CriSint32 lux, CriSint32 luy, CriSint32 w, CriSint32 h);


/*=========================================================================*
 *		ʃvbgtH[
 *		For Each Platform-specific Functions
 *=========================================================================*/

/*-------------------------------------------------------------------------*
 *		hr[fW^ݒ
 *		Dolby Digital Configuration
 *-------------------------------------------------------------------------*/
/* DolbyDigitalĐp[Nobt@TCY̎擾 */
/* Get size of work buffer for DolbyDigital */
CriSint32 CRIAPI mwPlyGetDolbyDigitalWorkSize(void);
/* DolbyDigitalĐ@\̒ǉ */
/* Attach DolbyDigital */
void CRIAPI mwPlyAttachDolbyDigital(MWPLY mwply, void *wkptr, CriSint32 wksize);
/* DolbyDigitalĐ@\̕ */
/* Detach DolbyDigital */
void CRIAPI mwPlyDetachDolbyDigital(MWPLY mwply);
/* DolbyDigitalXg[`lԍ̐ݒ(ftHg̓`lP) */
/* Set channel number of DolbyDigital (Default channel = 1) */
void CRIAPI mwPlySetDolbyDigitalCh(MWPLY mwply, CriSint32 ch);

/*-------------------------------------------------------------------------*
 *		}``lI[fBIݒ
 *		Multi Channel Audio Configuration
 *-------------------------------------------------------------------------*/
/* }``lĐp[Nobt@TCY̎擾 */
/* Get size of work buffer for multi channel audio */
CriSint32 CRIAPI mwPlyGetMultiChannelWorkSize(void);
/* }``lI[fBIĐ@\̒ǉ */
/* Attach MultiChannel Audio */
void CRIAPI mwPlyAttachMultiChannel(MWPLY mwply, void *wkptr, CriSint32 wksize);
/* }``lI[fBIĐ@\̕ */
/* Detach MultiChannel Audio */
void CRIAPI mwPlyDetachMultiChannel(MWPLY mwply);
/* }``lI[fBĨXg[`lԍ̐ݒ(ftHg̓`lP) */
/* Set channel number of MultiChannel Audio (Default channel = 1) */
void CRIAPI mwPlySetMultiChannelCh(MWPLY mwply, CriSint32 ch);

/*-------------------------------------------------------------------------*
 *		vbgtH[ŗL̊egt@CĐ
 *		Platform Specific Extended File Playback
 *-------------------------------------------------------------------------*/
/* Movie start by LSN */
void CRIAPI mwPlyStartLsn(MWPLY mwply, CriUint32 lsn, CriUint32 bytesize);
/* Movie start looping playback by LSN */
void CRIAPI mwPlyStartLsnLp(MWPLY mwply, CriUint32 lsn, CriUint32 bytesize);

/*-------------------------------------------------------------------------*
 *		vbgtH[ŗL̓ݒ
 *		Platform Specific Special Configuration
 *-------------------------------------------------------------------------*/
/* pbNTCY̐ݒiftHg 2048 bytej */
/* Set system stream pack size (default = 2048)  */
void CRIAPI mwPlySetPackSize(CriSint32 packsize);
/* TlC[h̐ݒiON: 1/8k摜o͂j */
/* Set thumbnail mode (ON: Output 1/8 reduced image)  */
void CRIAPI mwPlySetThumbnail(MWPLY mwply, CriSint32 sw);
/* Fϊ̎w ON:xD, OFF:掿D(ftHg) */
void CRIAPI mwPlySetHighSpeedConversion(int sw);
/* ㉺t܂ɕϊ邩ǂݒ肷 */
void CRIAPI mwPlySetCnvBottomUp(MWPLY mwply, CriBool sw);
/* ㉺t܂ɕϊ邩ǂ擾 */
CriBool CRIAPI mwPlyGetCnvBottomUp(MWPLY mwply);
/* rfIPTSǗ̐ݒ (MPEG-2 TS/PSĐp) */
void CRIAPI mwPlySetVideoPts(MWPLY ply, void *ptswork, CriSint32 ptsworksiz);
/* rfIPID̐ݒ (MPEG-2 TSĐpAvȌꍇPIDw肪K{) */
void CRIAPI mwPlySetVideoPid(MWPLY ply, CriSint32 pid);
/* I[fBIPID̐ݒ (MPEG-2 TSĐpAvOꍇPIDw肪K{) */
void CRIAPI mwPlySetAudioPid(MWPLY ply, CriSint32 pid);
/* PESXg[Đ̐ݒiON: PESXg[ĐAOFF:PS/TSĐj */
/* Set PES stream playback mode (ON: playback PES,  OFF: playback PS/TS)  */
void CRIAPI mwPlySetPesSw(MWPLY mwply, CriSint32 sw);

/* 
 * L̊֐͔p~Anh쐬p[^ŊOt[v[p
 * [Nobt@wł悤ɂB
 * void CRIAPI mwPlySetDecodeOutBuf(CriSint32 bufnum, CriSint32 bufsize, CriUint8 **bufptr);
 */

/* Ot[v[p[Nobt@TCY̌vZ */
CriSint32 CRIAPI mwPlyCalcOuterFrmPool(CriSint32 max_width, CriSint32 max_height);
/* t[ϊp[Nobt@TCY̌vZ */
CriSint32 CRIAPI mwPlyCalcCnvFrmWorkSize(CriSint32 max_width, CriSint32 max_height, CriSint32 compo_mode);
/* t[ϊp[Nobt@̐ݒ */
void CRIAPI mwPlySetCnvFrmWorkBuffer(MWPLY mwply, CriUint8 *workbuf, CriSint32 worksize);
/* t[ϊp[Nobt@̉ */
void CRIAPI mwPlyReleaseCnvFrmWorkBuffer(MWPLY mwply);

/* [vĐ̐ݒ */
void CRIAPI mwPlySetInfiniteSingleLoop(MWPLY mwply, CriBool sw);
/* [vĎs񐔂̎擾 */
CriUint32 CRIAPI mwPlyGetInfiniteLoopCount(MWPLY mwply);
/* Đԏ̎擾iP[b]j */
CriSint32 CRIAPI mwPlyGetLimitTime(MWPLY mwply);

/* Đ~v */
/* MEMO: ۂ̒~ADXM_ExecMain֐ŎIɓAnhԂSTOPɂȂB */
/*       mwPlyStop/mwPlyDestroy̕ב}邽߂̎dg݁B */
/*       nhԂSTOPɂȂĂmwPlyDestroyĂԂƕׂȂB*/
void CRIAPI mwPlyRequestStop(MWPLY mwply);

/* Đt@C̎擾						*/
/* Get header information of playing movie file	*/
void CRIAPI mwPlyGetPlayingHdrInf(MWPLY mwply, MwsfdHdrInf *hdrinf);

/* ēǂݍ݊JnԂ̐ݒ */
/* Set reload timing */
void CRIAPI mwPlySetReloadTime(MWPLY mwply, CriFloat32 time);

/* őǂݍ݃ZN^̐ݒ */
/* Set maximam read sectors */
void CRIAPI mwPlySetMaxReadSct(MWPLY mwply, CriUint32 nsct);

/* ĥ݃[r̎wsN`Đ */
void CRIAPI mwPlyStartIpicture(MWPLY mwply, const CriChar8 *fname, CriUint32 fno, CriUint32 dec_num, 
						MwsfdSeekIpic *seekipic_tbl, CriUint32 seekipic_num);

/* t@Cwɂ t@C wb_iI[fBIڍׁj̎擾	*/
/* Get header informations by filename	*/
CriBool mwPlyReadAndGetHdrInf(
	const CriChar8 *fname,
	MwsfdHdrInf *hdrinf,
	MwsfdHdrAudioDetail *audio_detail);

/*=========================================================================*
 *		J֐
 *      Closed functions
 *-------------------------------------------------------------------------*
 *	݊̂߂Ɋ֐錾cĂ܂Bʏ͎gpKv܂B
 *	These function declarations are retained for compatibility.
 *	Usually, it is not necessary to use these functions.
 *=========================================================================*/
/* t[擾\₢킹				*/
/* Determine whether next frame is ready	*/
CriBool CRIAPI mwPlyIsNextFrmReady(MWPLY mwply);
/* t[̃sN`[Uf[^̎擾 */
/* Get next frame user data in picture layer */
void CRIAPI mwPlyGetNextPicUsr(MWPLY mwply, void **usrdatptr, CriSint32 *usrdatsize);



#ifdef __cplusplus
}
#endif

#endif	/* INCLUDED_CRIMWSFD_H */
