/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2001-2005 CRI-MW
 *
 * Library  : MWSFD Library (CRI Sofdec)
 * Module   : Library User's Header (PS3-Specific)
 * File     : crimwsfd_ps3.h
 * Date     : 2005-10-19
 * Version  : (see MWD_SFD_VER)
 *
 ****************************************************************************/
#ifndef	CRIMWSFD_PS3_H_INCLUDED		/* Re-definition prevention */
#define	CRIMWSFD_PS3_H_INCLUDED

/***************************************************************************
 *      Include file
 ***************************************************************************/
#include <crimwsfd.h>

/***************************************************************************
 *      MACRO CONSTANT
 ***************************************************************************/
#define	MWSFD_PPU_NUM_MAX	(2)
#define	MWSFD_SPU_NUM_MAX	(6)

/* V{݊}N */
/* Macros for compatibility */
#define	mwPlyFxCalcAsyncCnvFrmWorkSize	mwPlyFxCalcAsyncCnvFrmWorkSize_PS3SPU
#define	mwPlyFxIsEndCnvFrm				mwPlyFxIsEndCnvFrm_PS3SPU

/***************************************************************************
 *      Process MACRO
 ***************************************************************************/

/***************************************************************************
 *      Enum definition
 ***************************************************************************/

/***************************************************************************
 *      Data type definition
 ***************************************************************************/

/* Asynchronous frame conversion handle */
typedef	void *MwsfdAsyncFrame;

/* Parameters for processor threading */
typedef	struct {
	Uint32	ppu_num;		/* The number of PPU for decoding (0-2) */
	Sint32	ppu_prio;		/* PPU Thread Priority */
	Uint32	spu_num;		/* The number of SPU for decoding (0-6) */
	Sint32	spu_grp_prio;	/* SPU Thread Group Priority */
	Sint32	spu_model;		/* reserved */
} MwsfdProcessorThread_PS3;

/* gp\vZbT */
typedef struct {
	Uint8		ppu_flag;			/* PPUgp\tO */
	Uint8		thr_spu_num;		/* gp\SPUXbh */
	Uint8		raw_spu_num;		/* gp\ȐSPU */
} MwsfdProcessor_PS3;

/* SPURSZbgAbvp[^ */
/* SPURS setup parameters */
typedef struct {
	void	*spurs_handler;		/* SPURS handler	*/
	void	*spurs_work;		/* SPURS work area	*/
	Sint32	spurs_worksize;		/* SPURS work size	*/
	Sint32	max_contention;		/* max contention	*/
	Uint8	*priority;			/* priority x8		*/
} MwsfdSpursParameter_PS3;


/***************************************************************************
 *      Function Declaration
 ***************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif


/* YUVA8t[ϊ */
/* YUVA8 frame conversion */
void CRIAPI mwPlyFxCnvFrmYuva8_PS3(MWPLY mwply, MwsfdFrmObj *mwfrm, Uint8 *out);
void CRIAPI mwPlyFxCnvFrmClipYuva8_PS3(MWPLY mwply, MwsfdFrmObj *mwfrm, Uint8 *out, 
								Sint32 lux, Sint32 luy, Sint32 w, Sint32 h);

/* SPUɂ񓯊t[ϊ֐ */
/* Asynchronous frame conversion using SPU */
/* for SPU thread group version */
Sint32 CRIAPI mwPlyFxCalcAsyncCnvFrmWorkSize_PS3SPU(Sint32 requestpool);
void CRIAPI mwPlyFxAttachAsyncCnvFrm_PS3SPU(MwsfdProcessorThread_PS3 *processorthread, Sint32 requestpool, Char8 *work);
void CRIAPI mwPlyFxDetachAsyncCnvFrm_PS3SPU(void);
MwsfdAsyncFrame CRIAPI mwPlyFxReqCnvFrmRgba_PS3SPU(MWPLY mwply, MwsfdFrmObj *mwfrm, Uint8 *out);
MwsfdAsyncFrame CRIAPI mwPlyFxReqCnvFrmRgbaEv_PS3SPU(MWPLY mwply, MwsfdFrmObj *mwfrm, Uint8 *out, Sint32 ev, Uint32 userdata);
Bool CRIAPI mwPlyFxIsEndCnvFrm_PS3SPU(MwsfdAsyncFrame asyncframe);
/* for SPURS version */
Sint32 CRIAPI mwPlyFxCalcAsyncCnvFrmWorkSize_PS3SPURS(Sint32 requestpool);
void CRIAPI mwPlyFxAttachAsyncCnvFrm_PS3SPURS(MwsfdSpursParameter_PS3 *spursparameter, MwsfdProcessorThread_PS3 *processorthread, Sint32 requestpool, Char8 *work);
void CRIAPI mwPlyFxDetachAsyncCnvFrm_PS3SPURS(void);
MwsfdAsyncFrame CRIAPI mwPlyFxReqCnvFrmRgba_PS3SPURS(MWPLY mwply, MwsfdFrmObj *mwfrm, Uint8 *out);
MwsfdAsyncFrame CRIAPI mwPlyFxReqCnvFrmRgbaEv_PS3SPURS(MWPLY mwply, MwsfdFrmObj *mwfrm, Uint8 *out, void *ev, Uint32 userdata);
Bool CRIAPI mwPlyFxIsEndCnvFrm_PS3SPURS(MwsfdAsyncFrame asyncframe);
void * CRIAPI mwPlyFxGetAsyncCnvFrmTaskset_PS3SPURS(void);

/* vZbTƃXbfBOɊւp[^̐ݒ */
/* Setup parameters for processor threading */
void CRIAPI mwPlySetupProcessors_PS3(MwsfdProcessorThread_PS3 *processorthread);

/* gp\vZbT̐ݒ (A) */
/* Set usable processor (currently not implemented) */
void CRIAPI mwPlySetUsableProcessor_PS3(MWPLY mwply, MwsfdProcessor_PS3 *processor);

/* SPURSɊւ郏[N̈̌vZ */
/* Calculate work size for SPURS */
Sint32 CRIAPI mwPlyCalcSpursWorkSize_PS3(Sint32 spu_num);

/* SPURSɊւp[^̐ݒ */
/* Setup parameters for SPURS */
void CRIAPI mwPlySetupSpurs_PS3(MwsfdSpursParameter_PS3 *spurs);

/* fR[hɐSPURS^XNZbg̎擾 */
/* Get SPURS taskset for decoding */
void * CRIAPI mwPlyGetSpursTaskset_PS3(void);

/* PCMf[^擾֐ */
/* Get audio PCM data */
Uint32 CRIAPI mwPlyGetAudioPcmData_PS3(MWPLY mwply, Float32 data[], Uint32 num_channels, Uint32 num_samples);

#ifdef __cplusplus
}
#endif

#endif	/* CRIMWSFD_PS3_H_INCLUDED */
