/***************************************************************************
 *
 *	CRI Middleware SDK
 *
 *	Copyright (c) 2008 CRI-MW
 *
 *	Library	: ADX Library
 *	Module	: Functions for XAudio
 *	File	: adx_xaudio2.h
 *
 ***************************************************************************/

/* d`h~					*/
/* Prevention of redefinition	*/
#if !defined(_ADXXAUDIO2_H_INCLUDED)
#define _ADXXAUDIO2_H_INCLUDED

/***************************************************************************
 *       o[W
 *       Version
 ***************************************************************************/
#define ADXXAUDIO2_VERSION			"1.01"

/***************************************************************************
 *      CN[ht@C
 *      Include files
 ***************************************************************************/
#include "cri_xpt.h"
#include "cri_adxt.h"

/* Check of SDK version */
/* ADX library supports XAudio2 functions from June 2008. */
#if defined(XPT_TGT_XBOX360)
	#include <xtl.h>
	#if (_XDK_VER >= 7645)
		#define CRI_ADX_SUPPORT_XAUDIO2
	#endif
#elif defined(XPT_TGT_PC)
	#if defined(_MSC_VER) && (_MSC_VER >= 1400)
		/* NOTE : Following code makes error on DirectX SDK (March 2008).	*/
		/*        You need to modify 'dxsdkver.h' included in DirectX SDK.	*/
		/* See also) http://www.microsoft.com/downloads/details.aspx?FamilyID=572BE8A6-263A-4424-A7FE-69CFF1A5B180&displaylang=en */
		/* ӁFȉ̃R[hDirectX SDK (March 2008)ŃG[N܂B	*/
		/* @@@sɂ́ADirectX SDK'dxsdkver.h'CĂB	*/
		/* Qljhttp://www.microsoft.com/japan/msdn/directx/Releasenotes/dxreadmeMar08J.aspx */
		#include <dxsdkver.h>
		#if (_DXSDK_PRODUCT_MAJOR > 9) || \
			((_DXSDK_PRODUCT_MAJOR == 9) && (_DXSDK_PRODUCT_MINOR >= 23))
			#define CRI_ADX_SUPPORT_XAUDIO2
		#endif
	#endif
#endif

/* Checks whether XAudio2 functions are available. */
#if defined(CRI_ADX_SUPPORT_XAUDIO2)

#include <xaudio2.h>

/***************************************************************************
 *      萔}N
 *      Macro Constants
 ***************************************************************************/

/***************************************************************************
 *      }N
 *      Macro Functions
 ***************************************************************************/

/***************************************************************************
 *      f[^^錾
 *      Data Type Declarations
 ***************************************************************************/

/***************************************************************************
 *      ϐ錾
 *      Prototype Variables
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Prototype Functions
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/* TEh̃ZbgAbv */
/* Setup of sound */
CriSint32 CRIAPI ADXXAUDIO2_SetupSound(IXAudio2 *xa2, IXAudio2Voice *ov);

/* TEh̃Vbg_E */
/* Shutdown of sound */
CriSint32 CRIAPI ADXXAUDIO2_ShutdownSound(void);

/*---------------------------------------------------------------------------
 * Ǘp֐
 * Functions for memory management
 *-------------------------------------------------------------------------*/
/* TEhobt@mۗpmۊ֐̓o^ */
/* Sets the custom malloc function for sound buffer allocation */
void CRIAPI ADXXAUDIO2_SetUserMallocFunc(void *(*func)(void *obj, CriUint32 size), void *obj);

/* TEhobt@p֐̓o^ */
/* Sets the custom free function for sound buffer release */
void CRIAPI ADXXAUDIO2_SetUserFreeFunc(void (*func)(void *obj, void *mem), void *obj);

/*---------------------------------------------------------------------------
 * XAudio2p֐
 * Functions for setting XAudio2 parameters
 *-------------------------------------------------------------------------*/
/* ADXTnhXAudio2SourceVoice擾 */
/* Gets the XAudio2SourceVoice from ADXT handle. */
IXAudio2SourceVoice * CRIAPI ADXXAUDIO2_GetSourceVoice(ADXT adxt);

/* XAudio2SourceVoice쐬̃tOw肷								*/
/* ljADXTnhXAudio2SourceVoiceō쐬܂B				*/
/*       {֐gp邱ƂŁAADXTnhō쐬				*/
/*       XAudio2SourceVoiceɑ΂ătOݒ肷邱Ƃ\łB			*/
/*       XMPƘAADXTnh쐬ۂɂ́A						*/
/*       XAUDIO2_VOICE_MUSICw肵ĂB							*/
/*       iftHgԂł0w肳Ă܂Bj							*/
/* Sets the flags for XAudio2SourceVoice creation.							*/
/* NOTE) ADXT handle creates XAudio2SourceVoice internally.					*/
/*       The specified flags are appended to XAudio2SourceVoice.			*/
/*       The default value is 0.											*/
/*       If you want to create ADXT handle which cooperates with XMP,		*/
/*       please specify XAUDIO2_VOICE_MUSIC.								*/
void CRIAPI ADXXAUDIO2_SetSourceVoiceDefaultFlags(UINT32 Flags);

/* XAudio2SourceVoice쐬Ɏw肳tO擾 */
/* Gets the flags for XAudio2SourceVoice creation. */
UINT32 CRIAPI ADXXAUDIO2_GetSourceVoiceDefaultFlags(void);

/* XAudio2SourceVoice쐬̏o̓{CX̍őgw肷			*/
/* ljADXTnhXAudio2SourceVoiceō쐬܂B				*/
/*       {֐gp邱ƂŁAADXTnhō쐬				*/
/*       XAudio2SourceVoiceɑ΂čőg						*/
/*       ݒ肷邱Ƃ\łB											*/
/*       iftHgԂł1.0fw肳Ă܂Bj						*/
/* Sets the max frequency ratio for XAudio2SourceVoice creation.			*/
/* NOTE) ADXT handle creates XAudio2SourceVoice internally.					*/
/*       The specified max frequency ratio is used for						*/
/*       XAudio2SourceVoice creation.										*/
/*       The default value is 1.0f.											*/
void CRIAPI ADXXAUDIO2_SetSourceVoiceDefaultMaxFrequencyRatio(float MaxFrequencyRatio);

/* XAudio2SourceVoice쐬Ɏw肳őg擾 */
/* Gets the max frequency ratio for XAudio2SourceVoice creation. */
float CRIAPI ADXXAUDIO2_GetSourceVoiceDefaultMaxFrequencyRatio(void);

/* XAudio2SourceVoice쐬̏o̓{CXw肷							*/
/* ljADXTnhXAudio2SourceVoiceō쐬܂B				*/
/*       {֐gp邱ƂŁAADXTnhō쐬				*/
/*       XAudio2SourceVoiceɑ΂ďo̓{CXݒ肷邱Ƃ\łB		*/
/*       iftHgԂłADXXAUDIO2_SetupSound֐Ŏw肳ꂽ			*/
/*       {CXgp܂Bj											*/
/* Sets the output voice for XAudio2SourceVoice creation.					*/
/* NOTE) ADXT handle creates XAudio2SourceVoice internally.					*/
/*       The specified output voice is used for								*/
/*       XAudio2SourceVoice creation.										*/
/*       The default output voice is the voice specified via				*/
/*       the ADXXAUDIO2_SetupSound function.								*/
void CRIAPI ADXXAUDIO2_SetSourceVoiceDefaultOutputVoice(IXAudio2Voice *pOutput);

/* XAudio2SourceVoice쐬Ɏw肳o̓{CX擾 */
/* Gets the output voice for XAudio2SourceVoice creation. */
IXAudio2Voice *ADXXAUDIO2_GetSourceVoiceDefaultOutputVoice(void);

/* ADXCugpXAudio2Zbgʎqw肷					*/
/* ljADXCúAĐXAudio2Zbggp܂B	*/
/*       ftHgԂł́AZbg̎ʎqƂ0x7FFFFFFF			*/
/*       gp܂B														*/
/*       AvP[VXAudio2ZbggpꍇA				*/
/*       ̎ʎq̎gpKv܂B							*/
/*       ADXCugp鑀ZbgʎqύXꍇɁA		*/
/*       {֐gpĎʎqύXĂB							*/
/* Sets the XAudio2 Operation Set identifier of the ADX library.			*/
/* NOTE: The ADX library operates some methods as batch by using			*/
/*       XAudio2 Operation Set.												*/
/*       By default, the ADX library uses 0x7FFFFFFF as identifier of		*/
/*       Operation Set.														*/
/*       If you use XAudio2 Operation Set in your application,				*/
/*       you need to avoid using identifier used by the library.			*/
/*       By using this function, you can change the identifier used by		*/
/*       the library.														*/
void CRIAPI ADXXAUDIO2_SetOperationSetIdentifier(UINT32 OperationSet);

/* ADXCugpXAudio2Zbgʎq擾 */
/* Gets the XAudio2 Operation Set identifier of the ADX library. */
UINT32 CRIAPI ADXXAUDIO2_GetOperationSetIdentifier(void);

/* ADXTnhɑ΂ďo̓{CXݒ肷 */
/* lj̊֐IXAudio2Voice_SetOutputVoices֐̃bp[֐łB */
/* Sets the voice output to ADXT handle. */
/* NOTE: This function calls IXAudio2Voice_SetOutputVoices function. */
HRESULT CRIAPI ADXXAUDIO2_SetOutputVoices(ADXT adxt, const XAUDIO2_VOICE_SENDS *pSendList);

/* ADXTnhɑ΂ăGtFNg`F[ݒ肷						*/
/* lj̊֐IXAudio2Voice_SetEffectChain֐̃bp[֐łB	*/
/* Sets the effect chain to ADXT handle.								*/
/* NOTE: This function calls IXAudio2Voice_SetEffectChain function.		*/
HRESULT CRIAPI ADXXAUDIO2_SetEffectChain(
	ADXT adxt, const XAUDIO2_EFFECT_CHAIN *pEffectChain);

/* ADXTnhɑ΂ăGtFNgp[^ݒ肷							*/
/* lj̊֐IXAudio2Voice_SetEffectParameters֐̃bp[֐łB	*/
/* Sets the effect paramter to ADXT handle.										*/
/* NOTE: This function calls IXAudio2Voice_SetEffectParameters function.		*/
HRESULT CRIAPI ADXXAUDIO2_SetEffectParameters(ADXT adxt, UINT32 EffectIndex,
	const void *pParameters, UINT32 ParametersByteSize, UINT32 OperationSet);

/* ADXTnhGtFNgp[^擾								*/
/* lj̊֐IXAudio2Voice_GetEffectParameters֐̃bp[֐łB	*/
/* Gets the effect paramter from ADXT handle.									*/
/* NOTE: This function calls IXAudio2Voice_GetEffectParameters function.		*/
HRESULT CRIAPI ADXXAUDIO2_GetEffectParameters(ADXT adxt, UINT32 EffectIndex,
	void *pParameters, UINT32 ParametersByteSize);

/* ADXTnhɑ΂ăGtFNgL									*/
/* lj̊֐IXAudio2SourceVoice_EnableEffect֐̃bp[֐łB		*/
/* Enables the effect to ADXT handle.											*/
/* NOTE: This function calls IXAudio2SourceVoice_EnableEffect function.			*/
HRESULT CRIAPI ADXXAUDIO2_EnableEffect(ADXT adxt, UINT32 EffectIndex, UINT32 OperationSet);

/* ADXTnhɑ΂ăGtFNg𖳌									*/
/* lj̊֐IXAudio2SourceVoice_DisableEffect֐̃bp[֐łB	*/
/* Disables the effect to ADXT handle.											*/
/* NOTE: This function calls IXAudio2SourceVoice_DisableEffect function.		*/
HRESULT CRIAPI ADXXAUDIO2_DisableEffect(ADXT adxt, UINT32 EffectIndex, UINT32 OperationSet);

#ifdef __cplusplus
}
#endif

/***************************************************************************
 *      o[WƂ̌݊p
 *      For compatibility with old version
 ***************************************************************************/

#endif	/* CRI_ADX_SUPPORT_XAUDIO2 */

#endif	/* _ADXXAUDIO2_H_INCLUDED */

/* --- end of file --- */
