/***************************************************************************
 *
 *	CRI Middleware SDK
 *
 *	Copyright (c) 2005 CRI-MW
 *
 *	Library	: ADX Library
 *	Module	: Environmentally-dependent header for Xbox360
 *	File	: adx_xbox360.h
 *
 ***************************************************************************/

/* d`h~					*/
/* Prevention of redefinition	*/
#ifndef _ADXXBOX360_H_INCLUDED
#define _ADXXBOX360_H_INCLUDED

/***************************************************************************
 *       o[W
 *       Version
 ***************************************************************************/
#define ADXXBOX360_VERSION			"1.44"

/***************************************************************************
 *      CN[ht@C
 *      Include files
 ***************************************************************************/
#include <xtl.h>
#include "cri_xpt.h"
#include "cri_adxt.h"

/***************************************************************************
 *      萔}N
 *      Macro Constants
 ***************************************************************************/
/* ftHgvZbT蓖 */
/* Default thread processor */
#if defined(_XDK_VER) && (_XDK_VER >= 1600)
/* for Beta hardware or later */
#define ADXM_PROCESSOR_VSYNC		(5)		/* audio decode process */
#define ADXM_PROCESSOR_FS			(5)		/* file reading process	*/
#define ADXM_PROCESSOR_MWIDLE		(3)		/* movie decode process	*/
#else
/* for Alpha hardware */
#define ADXM_PROCESSOR_VSYNC		(0)		/* audio decode process */
#define ADXM_PROCESSOR_FS			(0)		/* file reading process	*/
#define ADXM_PROCESSOR_MWIDLE		(1)		/* movie decode process	*/
#endif

/* ftHgvCIeB */
/* Default thread priority */
#define ADXM_PRIO_VSYNC				(THREAD_PRIORITY_HIGHEST)		/* VsyncXbh */
#define ADXM_PRIO_FS				(THREAD_PRIORITY_ABOVE_NORMAL)	/* t@CXbh */
#define ADXM_PRIO_MWIDLE			(THREAD_PRIORITY_IDLE)			/* AChXbh */

/* X^bNTCY */
/* Thread stack size */
#define	ADXM_STACK_SIZE_VSYNC		(12288)
#define	ADXM_STACK_SIZE_FS			(12288)
#define	ADXM_STACK_SIZE_MWIDLE		(65536)

/* fBNgT[h	 */
/* Mode of directory look-up */
#define ADXFIC_MODE_ALLDIR			(-1)
#define ADXFIC_MODE_CURRENT			(0)

/* ADXFICnhXe[^X	 */
/* Status of ADXFIC handle */
#define ADXFIC_STAT_STOP			(0)
#define ADXFIC_STAT_CACHING			(1)
#define ADXFIC_STAT_CACHEEND		(2)
#define ADXFIC_STAT_ERROR			(3)

/* t@CRs[p[N̈TCYvZ}N */
/* Macro for work area size calculation (File copy) */
#define ADXFCP_WORK_SIZE			(260 * 1024)

/* ADXFCPnhXe[^X	 */
/* Status of ADXFCP handle */
#define ADXFCP_STAT_STOP			(0)
#define ADXFCP_STAT_PREP			(1)
#define ADXFCP_STAT_COPYING			(2)
#define ADXFCP_STAT_COPYEND			(3)
#define ADXFCP_STAT_ERROR			(4)

/* Game Disc File Cachinggp̓샂[h */
/* Game Disc File Caching mode */
#define ADXXBOX360_NO_XFILECACHE	(0)		/* Do not cache automatically */
#define ADXXBOX360_XFILECACHE_ALL	(1)		/* Cache all automatically */

/***************************************************************************
 *      }N
 *      Macro Functions
 ***************************************************************************/
/* t@CLbVp[N̈TCYvZ}N */
/* Macro for work area size calculation (File information cache) */
#define ADXFIC_CALC_WORK(num_dir)	\
	(64 + MAX_PATH + (num_dir * sizeof(HANDLE)) + 4)

/***************************************************************************
 *      f[^^錾
 *      Data Type Declarations
 ***************************************************************************/
/*--------------------------------------------------------------------------
 * t[[NʁiXbox360j
 * Type of framework
 *-------------------------------------------------------------------------*/
typedef enum {
	ADXM_FRAMEWORK_DEFAULT					= 0,	/* }`Xbh */
	ADXM_FRAMEWORK_XBOX360_SINGLE_THREAD	= 1,	/* VOXbh */
	ADXM_FRAMEWORK_XBOX360_MULTI_THREAD		= 2,	/* }`Xbh */
} AdxmFramework;

/*--------------------------------------------------------------------------
 * XbhZbgAbvp[^iXbox360j
 * Thread setup parameter for Xbox360
 *-------------------------------------------------------------------------*/
typedef struct {
	/* vCIeB */
	CriSint32			priority_vsync;		/* VsyncXbh */
	CriSint32 			priority_fs;		/* t@CXbh */
	CriSint32 			priority_mwidle;	/* AChXbh */
	/* vZbT */
	CriSint32			processor_vsync;	/* VsyncXbh */
	CriSint32			processor_fs;		/* t@CXbh */
	CriSint32			processor_mwidle;	/* AChXbh */
} AdxmThreadSprm;

/* Xbh̃ZbgAbvsۂ̒ӓ_									*/
/* (a) ZbgAbvp[^́At[[NƂ						*/
/* @@ADXM_FRAMEWORK_XBOX360_MULTI_THREADI񂾏ꍇ̂ݗLłB		*/
/* (b) ZbgAbvp[^́AADXM_SetupFramework֐Ɉprm			*/
/* @@ēn܂BNULLw肷ƃftHgݒ肪gp܂B			*/
/* Notes when setup of thread												*/
/* (a) If you need to apply custom framework setting, set the setup			*/
/*     parameter to ADXM_SetupFramework function as argument "prm".			*/
/*     When NULL is passed, the default setting is used.	 				*/
/* (b) The setup parameter is effective only when you chose 				*/
/*     ADXM_FRAMEWORK_XBOX360_MULTI_THREAD as framework.					*/

/*--------------------------------------------------------------------------
 *	t@CVXẽZbgAbvp[^\
 *	Parameter structure for file system setup function
 *-------------------------------------------------------------------------*/
typedef struct {
	CriChar8	*rtdir;				/* [gfBNg	*/
								/* Root directory		*/
} Adxxbox360SprmFs;

/*--------------------------------------------------------------------------
 *	t@CLbVnhiADXFICnhj
 *	File information cache handle (ADXFIC handle)
 *-------------------------------------------------------------------------*/
typedef void *ADXFIC;

/*--------------------------------------------------------------------------
 *	t@CRs[nhiADXFCPnhj
 *	File copy handle (ADXFCP handle)
 *-------------------------------------------------------------------------*/
typedef void *ADXFCP;

/***************************************************************************
 *      ϐ錾
 *      Prototype Variables
 ***************************************************************************/

/***************************************************************************
 *      ֐錾
 *      Prototype Functions
 ***************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

/* t@CVXẽZbgAbv */
/* Setup of filesystem */
void CRIAPI ADXXBOX360_SetupFileSystem(Adxxbox360SprmFs *sprm);

/* t@CVXẽVbg_E */
/* Shutdown of filesystem */
void CRIAPI ADXXBOX360_ShutdownFileSystem(void);

/* CRI~hEFÃt[[NZbgAbv */
/* Setup of framework */
CriBool CRIAPI ADXM_SetupFramework(AdxmFramework framework, AdxmThreadSprm *prm);

/* CRI~hEFÃt[[N̏I */
/* Shutdown of framework */
CriBool CRIAPI ADXM_ShutdownFramework(void);

/* t[[NZbgAbvp[^iȑOݒ肵lj̎擾 */
/* Gets the setup parameter which was set before */
void CRIAPI ADXM_GetFramework(AdxmFramework *framework, AdxmThreadSprm *prm);

/* _[eBfBXNG[_CAO̕\									*/
/* lj{֐ADX̓XbhgpāAXShowDirtyDiscErrorUI֐		*/
/*       񓯊Ɏs܂B												*/
/*       XShowDirtyDiscErrorUI֐ƈقȂA֐͕A܂̂ŁA		*/
/*       XbhŃtbvsƂ\łB			*/
/* Shows Dirty Disc Error UI												*/
/* NOTE: This function calls the XShowDirtyDiscErrorUI function				*/
/*       asynchronously by using ADX thread system.							*/
/*       This function is non-blocking function, so it is possible to do	*/
/*       the flip processing continuously in the same thread.				*/
void CRIAPI ADXXBOX360_ShowDirtyDiscErrorUI(CriUint32 index);

/*---------------------------------------------------------------------------
 * Game Disc File Cachingp֐
 * Functions for Game Disc File Caching
 *-------------------------------------------------------------------------*/
/* Game Disc File Cachinggp̓샂[hݒ							*/
/* ljftHgԂł́AADXCu͑SẴt@C				*/
/*       XFileCacheCreateUncachedFile֐gpăI[v܂B			*/
/*       AGame Disc File Caching@\gpđSẴt@C			*/
/*       HDDɃLbVꍇ́AADXXBOX360_XFILECACHE_ALL		*/
/*       w肵Ė{֐sĂB									*/
/*       LݒsƂŁAADXCu͑SẴt@C				*/
/*       CreateFile֐gpăI[v悤ύX܂B			*/
/* Sets how the ADX library cooperates with Game Disc File Caching			*/
/* NOTE) The ADX library opens all files using the							*/
/*       XFileCacheCreateUncachedFile function in default.					*/
/*       If you use Game Disc File Caching and need to cache all files 		*/
/*       to HDD, execute this function specifying							*/
/*       ADXXBOX360_XFILECACHE_ALL for the argument.						*/
/*       Then the ADX library becomes to open all files using the			*/
/*       CreateFile function.												*/
void CRIAPI ADXXBOX360_SetXFileCacheMode(CriSint32 mode);

/* Game Disc File Cachinggp̓샂[h擾 */
/* Gets the Game Disc File Caching mode which was set before */
CriSint32 CRIAPI ADXXBOX360_GetXFileCacheMode(void);

/*---------------------------------------------------------------------------
 * t@CLbVp֐
 * Functions for file information cache
 *-------------------------------------------------------------------------*/
/*  */
/* Initialization of ADXFIC */
void CRIAPI ADXFIC_Init(void);

/* I */
/* Finalization of ADXFIC */
void CRIAPI ADXFIC_Finish(void);

/* t@CLbVp[N̈TCY̎擾 */
/* Gets the work area size for file information cache creation */
CriSint32 CRIAPI ADXFIC_GetWorkSize(const CriChar8 *dname, CriSint32 mode);

/* t@CLbViADXFICnhj̍쐬 */
/* Creation of file information cache (ADXFIC handle creation) */
ADXFIC CRIAPI ADXFIC_Create(
	const CriChar8 *dname, CriSint32 mode, void *work, CriSint32 wksize);

/* t@CLbViADXFICnhj̔j */
/* Deletion of file information cache (ADXFIC handle deletion) */
void CRIAPI ADXFIC_Destroy(ADXFIC fic);

/* Xe[^X̎擾 */
/* Gets the status of handle */
CriSint32 CRIAPI ADXFIC_GetStat(ADXFIC fic);

/* t@CLbVĂ邩ǂ̃`FbN							*/
/* ӁjADXFIC_IsFileCached֐́At@CLbVfBNg	*/
/*       ܂܂Ă邩ǂApX̉͂̂ݔ肵܂B				*/
/*       ۂɃt@C݂邩ǂ͕ʓrADXF_IsExistFile֐		*/
/*       gpă`FbNKv܂B								*/
/* Checks whether specified file is in cache								*/
/* NOTE: The ADXFIC_IsFileCached function judges whether 					*/
/*       specified file is in cache, using the path analysis.				*/
/*       If you want to check the file existence, 							*/
/*       you should use the ADXF_IsExistFile function.						*/
CriBool CRIAPI ADXFIC_IsFileCached(const CriChar8 *fname);

#ifdef _DEBUG

/* ӁjL2֐̓fobÔ݂p							*/
/*       L2֐́A֐OutputDebugString֐gp܂B			*/
/*       [XɉL֐gpꍇATCRɒG܂B				*/
/* NOTE: The following two functions are only for debugging.				*/
/*       These functions use OutputDebugString function.					*/
/*       If you use these functions, your application conflicts with TCR.	*/

/* wnhɃLbVꂽt@C̈ꗗ\ */
/* Print the list of cached files in the handle */
void CRIAPI ADXFIC_DebugPrintFlist(ADXFIC fic);

/* SẴnhɃLbVꂽt@C̈ꗗ\ */
/* Print the list of cached files in all handles */
void CRIAPI ADXFIC_DebugPrintFlistAll(void);

#endif

/*---------------------------------------------------------------------------
 * t@CRs[p֐
 * Functions for file copy
 *-------------------------------------------------------------------------*/
/*  */
/* Initialization of ADXFCP */
void CRIAPI ADXFCP_Init(void);

/* I */
/* Finalization of ADXFCP */
void CRIAPI ADXFCP_Finish(void);

/* t@CRs[nhiADXFCPnhj̍쐬 */
/* Creation of file copy handle (ADXFCP handle creation) */
ADXFCP CRIAPI ADXFCP_Create(void *work, CriSint32 wksize);

/* t@CRs[nhiADXFCPnhj̔j */
/* Deletion of file copy handle (ADXFCP handle deletion) */
void CRIAPI ADXFCP_Destroy(ADXFCP fcp);

/* T[o */
/* Server function of all file copy handles */
void CRIAPI ADXFCP_ExecServer(void);

/* nhPʂ̃T[o */
/* Server function of file copy handle */
void CRIAPI ADXFCP_ExecHndl(ADXFCP fcp);

/* t@CRs[̊Jn */
/* Begins the file copy */
void CRIAPI ADXFCP_CopyFileNw(ADXFCP fcp, const CriChar8 *src, const CriChar8 *dst);

/* t@CTCY̎擾 */
/* Gets the total size of the file */
CriSint64 ADXFCP_GetFileSize(ADXFCP fcp);

/* Rs[ς݃TCY̎擾 */
/* Gets the total number of bytes transferred */
CriSint64 ADXFCP_GetNumTransferred(ADXFCP fcp);

/* t@CRs[̒~ */
/* Stops the file copy */
void CRIAPI ADXFCP_Stop(ADXFCP fcp);

/* t@CRs[̈ꎞ~ */
/* Pauses the file copy */
void CRIAPI ADXFCP_Pause(ADXFCP fcp, CriSint32 flag);

/* |[YԂ̎擾 */
/* Checks whether current copy process is paused */
CriBool CRIAPI ADXFCP_IsPaused(ADXFCP fcp);

/* Xe[^X̎擾 */
/* Gets the status of ADXFCP handle */
CriSint32 CRIAPI ADXFCP_GetStat(ADXFCP fcp);

/* ꎞt@Cgq̐ݒ */
/* Sets the file extension of the temporary file */
void CRIAPI ADXFCP_SetTempFileExt(const CriChar8 *ext);

/*---------------------------------------------------------------------------
 * ^C}֐
 * Timer functions
 *-------------------------------------------------------------------------*/
/* 64bitGetTickCount֐ */
/* Extended GetTickCount function (Supports 64bit count) */
CriSint64 CRIAPI ADXXBOX360_GetTickCount64(void);

#ifdef __cplusplus
}
#endif

/***************************************************************************
 *      o[WƂ̌݊p
 *      For compatibility with old version
 ***************************************************************************/
#define ADXXENON_SPRM_DVD					Adxxbox360SprmFs
#define ADXXBOX360_SPRM_FS					Adxxbox360SprmFs
#define ADXM_FRAMEWORK_XENON_SINGLE_THREAD	\
	ADXM_FRAMEWORK_XBOX360_SINGLE_THREAD
#define ADXM_FRAMEWORK_XENON_MULTI_THREAD	\
	ADXM_FRAMEWORK_XBOX360_MULTI_THREAD
#define ADXXENON_SetupDvdFs(sprm)			ADXXBOX360_SetupFileSystem(sprm)
#define ADXXENON_ShutdownDvdFs()			ADXXBOX360_ShutdownFileSystem()

#endif	/* #ifndef _ADXXBOX360_H_INCLUDED */

/* --- end of file --- */
