/****************************************************************************
 *
 * CRI Middleware SDK
 *
 * Copyright (c) 2001-2005 CRI-MW
 *
 * Library  : MWSFD Library (CRI Sofdec)
 * Module   : Library User's Header (xbox360-Specific)
 * File     : crimwsfd_xbox360.h
 * Date     : 2005-10-19
 * Version  : (see MWD_SFD_VER)
 *
 ****************************************************************************/
#ifndef	CRIMWSFD_XBOX360_H_INCLUDED		/* Re-definition prevention */
#define	CRIMWSFD_XBOX360_H_INCLUDED

/***************************************************************************
 *      Include file
 ***************************************************************************/
#include <crimwsfd.h>

/***************************************************************************
 *      MACRO CONSTANT
 ***************************************************************************/

/***************************************************************************
 *      Process MACRO
 ***************************************************************************/

/***************************************************************************
 *      Enum definition
 ***************************************************************************/

/***************************************************************************
 *      Data type definition
 ***************************************************************************/

/* gp\vZbT */
typedef struct {
	CriUint8		processor0_flag;  /* vZbT0 (RA0Xbh0) gp\tO */
	CriUint8		processor1_flag;  /* vZbT1 (RA0Xbh1) gp\tO */
	CriUint8		processor2_flag;  /* vZbT2 (RA1Xbh0) gp\tO */
	CriUint8		processor3_flag;  /* vZbT3 (RA1Xbh1) gp\tO */
	CriUint8		processor4_flag;  /* vZbT4 (RA2Xbh0) gp\tO */
	CriUint8		processor5_flag;  /* vZbT5 (RA2Xbh1) gp\tO */
} MwsfdProcessor_XBOX360;


/***************************************************************************
 *      Function Declaration
 ***************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif


/* gp\vZbT̐ݒ */
void CRIAPI mwPlySetUsableProcessor_XBOX360(MWPLY mwply, MwsfdProcessor_XBOX360 *processor);


#ifdef __cplusplus
}
#endif

#endif	/* CRIMWSFD_XBOX360_H_INCLUDED */
