#ifndef __dreinetworkutil_h__
#define __dreinetworkutil_h__

#pragma once

namespace DreiNetwork
{
	inline ACE_Message_Block *FindTailBlock(ACE_Message_Block *block)
	{
		ACE_Message_Block *tail = block;
		while (NULL != tail->cont())
			tail = tail->cont();
		return tail;
	}

	inline bool MakeMergedBlock(ACE_Message_Block *blockList, ACE_Message_Block *mergedBlock)
	{
		if (mergedBlock->capacity() < blockList->total_length())
			return false;
		ACE_Message_Block* block = blockList;
		do 
		{
			mergedBlock->copy(block->rd_ptr(), block->length());
		} while (NULL != (block = block->cont()));
		return true;
	}

	//inline void CharToWChar(const char* src, wchar_t* dst, int dstSize )
	//{
	//	MultiByteToWideChar(CP_ACP, 0, src, -1, dst, dstSize);
	//}

	//inline void WCharToChar(const wchar_t* src, char* dst, int dstSize )
	//{
	//	WideCharToMultiByte(CP_ACP, 0, src, (int)wcslen(src), dst, dstSize, NULL, NULL );
	//}

	class InterlockedValue
	{
	public:
		bool	CompareExchange(long exchange, long comparand)
		{
#ifdef WIN32
			return (comparand == InterlockedCompareExchange(&_value, exchange, comparand));
#else
			ACE_Guard<ACE_Thread_Mutex> guard(_lock);
			if (_value != comparand)
				return false;
			_value = exchange;
			return true;
#endif
		}

		void	Exchange(long exchange)
		{
#ifdef WIN32
			InterlockedExchange(&_value, exchange);
#else
			ACE_Guard<ACE_Thread_Mutex> guard(_lock);
			_value = exchange;
#endif
		}

		bool	Compare(long comparand)
		{
#ifdef WIN32
			return (_value == comparand);
#else
			ACE_Guard<ACE_Thread_Mutex> guard(_lock);
			return (_value == comparand);
#endif
		}

	private:
#ifndef WIN32
		ACE_Thread_Mutex	_lock;
#endif
		long							_value;
	};

	inline uint32 GetTick()
	{
#ifdef WIN32
		return GetTickCount();
#else 
		timeval tick;
		gettimeofday (&tick, 0);
		return (tick.tv_sec*1000 + tick.tv_usec/1000);
#endif
	}

}

#endif // __dreinetworkutil_h__