#ifndef __logger_h__
#define __logger_h__

#pragma once

namespace DreiNetwork
{

	class Logger
	{
	public:
		Logger();
		virtual ~Logger();

	public:
		void	SetConsoleLog();
		void	SetFileLog(const ACE_TCHAR* filename);
		void	SetDisable(bool flag);

	public:
		ACE_Log_Msg_Callback* RedirectTo(ACE_Log_Msg_Callback* callback);
		void	Log(const ACE_TCHAR* formatStr, ...);

	public:
		void	AddTime();
		void	AddDate();
		void	AddThreadId();
		void	AddProcessId();

	private:
		ACE_Log_Msg*						_logMsg;
		ACE_Log_Msg_Callback*		_logCallback;
		ACE_TCHAR*							_format;
		bool										_disable;
	};

} // namespace DreiNetwork

#ifdef  NO_DREI_LOG
#define	DREI_LOG(LOGGER, MSG,...) do {} while (0)
#else
#define	DREI_LOG(LOGGER, MSG,...) \
	LOGGER->Log(MSG, __VA_ARGS__) 
#endif

//#ifdef  NO_DREI_LOG
//	#define	DREI_LOG(LOGGER, MSG) do {} while (0)
//#else
//	#define	DREI_LOG(LOGGER, MSG) \
//		do { \
//			LOGGER->Log MSG; \
//		} while(0)
//#endif

#endif // __logger_h__