#include "stdafx.h"
#include "MemoryBlockPool.h"

namespace DreiNetwork
{

	//////////////////////////////////////////////////////////////////////////
	MemoryBlockPool::MemoryBlockPool(uint32 chunkCount, size_t chunkSize) : 
		_chunkAllocator(chunkCount, chunkSize), 
		_maxBufferSize(chunkSize),
		_maxChunkCount(chunkCount)
	{
	}

	MemoryBlockPool::~MemoryBlockPool()
	{
	}

	void* MemoryBlockPool::Allocate(const size_t bufferSize)
	{
		//DREI_DEBUG("Memory Allocate RequestSize(%d) MaxSize(%d), MaxChunk(%d), RemainChunk(%d)\n", 
		//	bufferSize, _maxBufferSize, _maxChunkCount, AvailableChunkCount());
		return _chunkAllocator.malloc(bufferSize);
	}

	void MemoryBlockPool::Dump()
	{
		DREI_DEBUG ("MemoryBlockPool Size(%d) MaxChunk(%d) RemainChunk(%d).\n", 
			_maxBufferSize, _maxChunkCount, _chunkAllocator.pool_depth());
	}

	uint32 MemoryBlockPool::AvailableChunkCount()
	{
		return (uint32)_chunkAllocator.pool_depth();
	}

	uint32 MemoryBlockPool::MaxChunkCount()
	{
		return _maxChunkCount;
	}

	void MemoryBlockPool::Deallocate( void* p )
	{
		_chunkAllocator.free(p);
	}

	uint32 MemoryBlockPool::ChunkSize()
	{
		return (uint32)_maxBufferSize;
	}
} // namespace DreiNetwork