#include "stdafx.h"
#include "SimpleConfig.h"

namespace DreiNetwork
{

	SimpleConfig::SimpleConfig(void)
	{
	}

	SimpleConfig::SimpleConfig(const SimpleConfig& other)
	{
		m_container.clear();
		StringMapConstIterator endIter = other.m_container.end();
		for(StringMapConstIterator iter = other.m_container.begin(); iter != endIter; ++iter)
			Add(iter->first, iter->second);
	}

	SimpleConfig::~SimpleConfig(void)
	{
	}

	bool SimpleConfig::AddImpl(const std::string& key, const std::string& value)
	{
		std::pair<StringMapIterator, bool> result;
		result = m_container.insert(std::pair<std::string, std::string>(key, value));
		if (false == result.second)
			return false;
		return true;
	}

	bool SimpleConfig::Remove(const std::string& key)
	{
		StringMapIterator iter = m_container.find(key);
		if (iter == m_container.end())
			return false;
		m_container.erase(iter);
		return true;
	}

	bool SimpleConfig::ReadFile( const char* filename )
	{
		FILE* r = fopen(filename, "rb");
		if (NULL == r)
			return false;

		uint32 fileBufferSize = 512;
		size_t readFileSize = 0;
		char* fileBuffer = NULL;
		do
		{
			fileBufferSize *= 2;
			if (NULL != fileBuffer)
			{
				delete [] fileBuffer;
				fileBuffer = NULL;
			}
			fileBuffer = new char[fileBufferSize];
			fseek(r , 0, SEEK_SET);
			readFileSize = fread(fileBuffer, 1, fileBufferSize, r);
		} while(readFileSize >= fileBufferSize);

		fclose(r);
		std::string readString(fileBuffer, readFileSize);
		delete [] fileBuffer;
		while ( readString.find("\r\n") != std::string::npos )
			readString.erase(readString.find ("\r\n"), 2 );

		return Parse(readString);
	}

	bool SimpleConfig::Parse(const std::string& source)
	{
		if (-1 == source.find("=") || -1 == source.find(";"))
			return false;

		std::string subSource = source;
		std::string key, value;

		while ( subSource.find(" ") != std::string::npos )
			subSource.erase(subSource.find (" "), 1);

		while(subSource.length() > 0)
		{
			int keyPos = (int)subSource.find("=");
			if (keyPos<0)
				break;	

			key = subSource.substr(0, keyPos);
			subSource = subSource.substr(keyPos+1);
			int valuePos = (int)subSource.find(";");
			if (valuePos<0)
				break;
			value = subSource.substr(0, valuePos);
			Add(key, value);
			subSource = subSource.substr(valuePos+1);
		}
		return true;
	}
	
	std::string SimpleConfig::GetValueImpl(const std::string& key) const
	{
		StringMapConstIterator iter = m_container.find(key);
		if (iter != m_container.end())
			return iter->second;
		return "";
	}

	void SimpleConfig::Clear()
	{
		m_container.clear();
	}

	std::string SimpleConfig::MakeString() const
	{
		std::string result;
		StringMapReverseIterator endIter = m_container.rend();
		for(StringMapReverseIterator iter = m_container.rbegin(); iter != endIter; ++iter)
			result += iter->first + "=" + iter->second + ";";
		return result;
	}
} // namespace DreiNetwork