#ifndef __simpleconfig_h__
#define __simpleconfig_h__

#pragma once

#include <string>
#include <map>
#include "DataTypeConvertor.h"

namespace DreiNetwork
{
	class SimpleConfig
	{
	public:
		typedef std::map<std::string, std::string>				StringKeyValueMap;
		typedef StringKeyValueMap::iterator								StringMapIterator;
		typedef StringKeyValueMap::const_iterator					StringMapConstIterator;
		typedef StringKeyValueMap::const_reverse_iterator StringMapReverseIterator;

	public:
		SimpleConfig();
		SimpleConfig(const SimpleConfig& other);
		virtual ~SimpleConfig();

		template<typename T>
		bool Add(const std::string& key, const T& value)
		{
			const int MaxValueLength = 64;
			ACE_TCHAR strValue[MaxValueLength] = {0,};
			ToString(value, strValue, MaxValueLength);
			return AddImpl(key, strValue);
		}

		bool Remove(const std::string& key);
		void Clear();

		template<typename T>
		T		GetValue(const std::string& key) const
		{
			std::string result = GetValueImpl(key);
			T value;
			ToNumeric(result.c_str(), value);
			return value;
		}

		////////////////////////////////////////////////////////////////////////
		// Description:
		//   Parsing and Add to container 
		//   i.e.) name=alice;level=40; => ["name", "alice"], ["level", "40"]
		////////////////////////////////////////////////////////////////////////
		bool ReadFile(const ACE_TCHAR* filename);
		bool Parse(const std::string& source);
		std::string MakeString() const;
		uint32 MakeBuffer(char* buffer, uint32 length) const;
		void EncryptKey(unsigned char* key, unsigned char keyLen);

	protected:
		bool AddImpl(const std::string& key, const std::string& value);
		std::string GetValueImpl(const std::string& key) const;

	private:
		StringKeyValueMap m_container;
	};


} // namespace DreiNetwork

#endif // __simpleconfig_h__