#include "stdafx.h"
#include "EchoBackChecker.h"
#include <ace/Message_Block.h>
#include <Drei/TimerUtil.h>


void EchoBackChecker::AddSendBuffer( uint32 streamId, const char* buffer, uint32 length )
{
	uint32 hashKey = GetHashCode(buffer, length);
	InsertToMap(hashKey, streamId, length);
}

bool EchoBackChecker::IsValidBuffer( uint32 streamId, const char* buffer, uint32 length, int32& elaspedTick )
{
	uint32 hashKey = GetHashCode(buffer, length);
	return VerifyKey(hashKey, streamId, length, elaspedTick);
}

uint32 EchoBackChecker::GetHashCode( const char* buffer, uint32 length )
{
	uint32 ch = 0;
	uint32 result = 0;
	result = 5381;
	for( uint32 i=0; i<length; i++ )
	{
		ch = (uint32)buffer[i];
		result = ((result<< 5) + result) + ch; // hash * 33 + ch
	}
	return result;
}

void EchoBackChecker::InsertToMap( uint32 key, uint32 streamId, uint32 length)
{
	std::pair<KeyMapIterator,bool> result;
	VerrifyData value;
	value.length = length;
	value.streamId = streamId;
	value.tick = DreiNetwork::GetTick();
	result = _keyMap.insert(std::make_pair(key, value));
	if (false == result.second)
		printf("same key\n");
		//ACE_ASSERT(false);
}

bool EchoBackChecker::VerifyKey( uint32 key, uint32 streamId, uint32 length, int32& elaspedTick)
{
	KeyMapIterator iter = _keyMap.find(key);
	if (iter == _keyMap.end())
		return false;
	VerrifyData value = iter->second;
	_keyMap.erase(iter);
	elaspedTick = DreiNetwork::GetTick() - value.tick;
	return (streamId == value.streamId && length == value.length);
}

uint32 EchoBackChecker::GetElementCount()
{
	return (uint32)_keyMap.size();
}