#ifndef __echobackchecker_h__
#define __echobackchecker_h__

#pragma once

#include <map>

struct VerrifyData
{
	uint32 streamId;
	uint32 length;
	uint32 tick;
};

class EchoBackChecker
{
public:
	void		AddSendBuffer(uint32 streamId, const char* buffer, uint32 length);
	bool		IsValidBuffer(uint32 streamId, const char* buffer, uint32 length, int32& elaspedTick);
	uint32	GetElementCount();

protected:
	uint32	GetHashCode(const char* buffer, uint32 length );
	void		InsertToMap(uint32 key, uint32 streamId, uint32 length);
	bool		VerifyKey(uint32 key, uint32 streamId, uint32 length, int32& elaspedTick);

private:
	typedef std::map<uint32, VerrifyData>	KeyMap;
	typedef	KeyMap::iterator							KeyMapIterator;
	KeyMap	_keyMap;
};


#endif // __echobackchecker_h__
