#pragma once

//#include <ace/Null_Mutex.h>
//#include <ace/Map_Manager.h>
#include <Drei/ThreadPool.h>

class EchoBackChecker;
namespace DreiNetwork 
{
	class CycleChecker;
	class SimpleConfig;
}

class NetworkThread : public DreiNetwork::ThreadPool
{
public:
	NetworkThread(DreiNetwork::SimpleConfig& config);
	virtual ~NetworkThread();

public:
	virtual bool	Begin();
	virtual void	Update();
	virtual void	End();
	void	SetReceiveQueueId(uint8 id);
	long	GetCurrentConnection();

protected:
	void	_ProcessRecvQueue(unsigned char queue_id);
	void	_OnConnect(unsigned int streamID, const char* ip);
	void	_OnRead(unsigned int streamID, char* buffer, size_t length);

	bool	_DisconnectTest( unsigned int streamID );
	void	_EchoTest( unsigned int streamID, char* buffer, size_t length);
	void	_OnClose(unsigned int streamID);
	
	void	MakeRandomBuffer(char* buffer, uint32 len);
	void	SendDummyData(uint32 streamId);

private:
	//ACE_Atomic_Op<ACE_Thread_Mutex, long>	_currentConnection;
	uint8		_queueId;
	uint32	_sendTerm;
	EchoBackChecker*	_bufferChecker;
	DreiNetwork::CycleChecker*	_disconnectCycle;
	DreiNetwork::CycleChecker*	_debugMsgCycle;
	DreiNetwork::SimpleConfig&	_configObj;
	
};
