// TestClient.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <ace/ACE.h>
#include <Drei/NetworkFacade.h>
#ifdef WIN32
#include <Drei/ProactorFactory.h>
#else
#include <Drei/ReactorFactory.h>
#endif

#include <Drei/SimpleConfig.h>
#include "NetworkThread.h"
//#include <Drei/MemoryObject.h>
//#include <Drei/Logger.h>

void EventSleep(int32 ms)
{
	ACE_Time_Value waitTime(ms/1000, (ms%1000)*1000);
	ACE_Event eventObj;
	eventObj.wait(&waitTime, 0);
}

bool NetworkInit(const DreiNetwork::SimpleConfig& configReader, uint8 queueID)
{
	uint16 port = configReader.GetValue<uint16>("ServerPort");
	DreiNetwork::SystemConfig config;
	config.Worker_Thread_Count = configReader.GetValue<uint8>("WorkerThread");
	config.Receive_Buffer_Len = configReader.GetValue<uint32>("ReceiveBufferLength");
	config.Interval_Send_Term = configReader.GetValue<uint32>("UpdateTerm");
	config.Send_Mode = DreiNetwork::eSM_Interval;

	DREI_LOG(ConsoleLogger, ACE_TEXT("Port(%d)"), port);
	DREI_LOG(ConsoleLogger, ACE_TEXT("WorkerThread Count(%d)"), config.Worker_Thread_Count);
	DREI_LOG(ConsoleLogger, ACE_TEXT("Receive buffer length(%d)"), config.Receive_Buffer_Len);
	DREI_LOG(ConsoleLogger, ACE_TEXT("Update term(%d)"), config.Interval_Send_Term);
	
#ifdef WIN32
	if (false == NetworkInstance->Create<DreiNetwork::ProactorFactory>())
#else
	if (false == NetworkInstance->Create<DreiNetwork::ReactorFactory>())
#endif
		return false;
	if (false == NetworkInstance->Open(&config))
		return false;

	DREI_LOG(ConsoleLogger, ACE_TEXT("Network start"), 0);
	return true;
}

void NetworkFini()
{
	NetworkInstance->Close();
	NetworkInstance->Destroy();
}

int ACE_TMAIN (int argc, ACE_TCHAR * argv[])
{
	srand((signed)time(NULL));
	ACE::init();

	const char* ConfigFilename = "TestClientConfig.txt";
	DreiNetwork::SimpleConfig configReader;

	ConsoleLogger->SetConsoleLog();
	
	if (false == configReader.ReadFile(ConfigFilename))
	{
		DREI_LOG(ConsoleLogger, ACE_TEXT("Read config fail(%s)"), ConfigFilename);
		return 0;
	}
	const uint8 QueueID = 103;
	if (false == NetworkInit(configReader, QueueID))
	{
		DREI_LOG(ConsoleLogger, ACE_TEXT("NetworkInit Fail."), 0);
		return 0;
	}

	uint32 connectionCount = configReader.GetValue<uint32>("ConnectionCount");
	if (argc > 1)
		connectionCount = atoi(argv[1]);

	uint16 port = configReader.GetValue<uint16>("ServerPort");
	std::string serverIp = configReader.GetValue<std::string>("ServerIp");
	NetworkThread netThread(configReader);
	netThread.SetReceiveQueueId(QueueID);
	netThread.Open(1);
	
	DREI_LOG(ConsoleLogger, ACE_TEXT("ConnectCount = %d, start connect."), connectionCount);
	for(uint32 i=0; i<connectionCount; ++i)
	{
		NetworkInstance->Connect(serverIp.c_str(), port, QueueID);
		EventSleep(configReader.GetValue<int32>("ConnectTerm"));
	}
	DREI_LOG(ConsoleLogger, ACE_TEXT("connect end"), 0);
	
	if (configReader.GetValue<bool>("DisconnectTest"))
	{
		while(true)
		{
			int32 fillupConnection = connectionCount - netThread.GetCurrentConnection();
			DREI_LOG(ConsoleLogger, 
				ACE_TEXT("Connection count(%ld) fillup(%d)"), 
				netThread.GetCurrentConnection(), fillupConnection);
			//DreiNetwork::MemoryPoolInstance->Dump();
			for(int32 i=0; i<fillupConnection; ++i)
			{
				NetworkInstance->Connect(serverIp.c_str(), port, QueueID);
				EventSleep(configReader.GetValue<int32>("ConnectTerm"));
			}
			EventSleep(1000);
		}
	}

	getchar();

	NetworkFini();
	netThread.Close();
	ACE::fini();
	return 0;
}

