#include "stdafx.h"
#include "EchoBackServer.h"
#include <Drei/NetworkFacade.h>
#include <Drei/MessageHeader.h>

namespace DreiNetwork
{

	EchoBackServer::EchoBackServer(NetworkFacade* manager) 
		: _recv_queue_id(-1), _manager(manager)
	{
	}

	void EchoBackServer::Update()
	{
		ACE_Message_Block* headBlock = NULL;
		ACE_Message_Block* commandBlock = NULL;

		bool receiveData = _manager->PopAllMessage(_recv_queue_id, &headBlock, 100);
		if (false == receiveData)
			return;

		commandBlock = headBlock;
		while(NULL != commandBlock)
		{
			MessagePostee postee;
			memcpy(&postee, commandBlock->rd_ptr(), sizeof(MessagePostee));
			commandBlock->rd_ptr(sizeof(MessagePostee));
			ACE_Message_Block* payloadBlock = commandBlock->cont();
			if ( eMH_Read == postee.command)
				_manager->SendRequest(postee.stream_id, payloadBlock, true);

			commandBlock = payloadBlock->cont();
		}
		headBlock->release();
	}

	void EchoBackServer::RecvQueueID(unsigned int id)
	{
		_recv_queue_id = id;
	}
}