/*
Copyright (c) 2006, Intel Corporation.

This Intel Laptop Gaming TDK ("Software") is furnished under license and may 
only be used or copied in accordance with the terms of that license. No license, 
express or implied, by estoppel or otherwise, to any intellectual property rights 
is granted by this document. The Software is subject to change without notice, 
and should not be construed as a commitment by Intel Corporation to market, 
license, sell or support any product or technology. Unless otherwise provided 
for in the license under which this Software is provided, the Software is 
provided AS IS, with no warranties of any kind, express or implied. 
Except as expressly permitted by the Software license, neither Intel Corporation 
nor its suppliers assumes any responsibility or liability for any errors or 
inaccuracies that may appear herein. Except as expressly permitted by the 
Software license, no part of the Software may be reproduced, stored in a 
retrieval system, transmitted in any form, or distributed by any means 
without the express written consent of Intel Corporation.
*/

/**
* This class defines NetworkInfo methods which provide access to Network adapter properties
* current connection status, signal strength etc. Methods provide access to all these  
* properties.
* Also provides events for connect/disconnect status and signal strength polling
*/

#ifndef ILGNETWORKINFO_H
#define ILGNETWORKINFO_H

//#include <iostream>
#include <ntddndis.h>
#include <Netcon.h>
#include <Wbemidl.h>
#include <comdef.h>
#include <Iphlpapi.h>
#include <ntddndis.h>
#include <wininet.h>
#include <winioctl.h>
#include <Netcon.h>
#include <atlcomcli.h>
#include <Process.h>
#include <string>
#include "ILGAbstractEventInfo.h"
#include "ILGNotify.h"
#include "ILGdefines.h"

#define ADAPTERS_NUM 50
#define ADA_NAME_PREFIX		"\\\\.\\"
#define MAX_LEN 260

typedef unsigned (WINAPI *PBEGINTHREADEX_THREADFUNC)(LPVOID lParam);
typedef unsigned *PBEGINTHREADEX_THAREDID;

// Warning here complains about using non-dll base class for creating PowerInfo
#pragma warning( disable : 4275 )

class NetworkInfo: public AbstractEventInfo
{
	
public:
	NetworkInfo();
	~NetworkInfo();
	int Get80211SignalStrength();
	bool IsWirelessAdapterConnected();
	bool IsWirelessAdapterEnabled();
	char** GetIPAddresses(int* cnt);
	char** GetAllNetworkAdapters(int* cnt);
	void Start(int event, Notifiable* m_pNot, int ThresholdValue = 0, int UpdateFreq = 2000);
	void Stop(int event);
	unsigned char* GetConnectedAdapter();

private:

	char m_AdapterNames[ADAPTERS_NUM][MAX_LEN];
	char m_AdapterDesc[ADAPTERS_NUM][MAX_LEN];
	int m_count;
	int m_IPAddressCount;
	static bool bInitialize;

	// parameters for two threads. Defined in base file
	// structure to pass to thread functions including this pointer for the class 
	// pointer to call back observer and threshold paramater.
	ThreadParamStruct m_pStruct[2];

	// Thread function for monitoring signal strength
	static DWORD WINAPI ThreadFuncSignalSt(LPVOID ThreadParam);

	// non-static function that the thread function calls to detect signal strength
	void ThreadMonitorSignalSt(Notifiable* pNotif, int frequency);

	// Thread function for watching connection status
	static DWORD WINAPI ThreadFuncConnectivity(LPVOID ThreadParam);

	// non-static function that the thread function calls to detect connect/disconnect status
	void ThreadMonitorConnectivity(Notifiable* pNotif, int frequency);

	// Thread handle
	HANDLE h[3];

	// Bool variable to control monitoring of power state
	bool bMonitorConnState;

	// Bool variable to control monitoring of change in power source
	bool bMonitorSignalSt;

	// Bool variables to check if the threads are already running
	bool bThread0Running, bThread1Running, bEndThread0, bEndThread1;

	CRITICAL_SECTION m_cs;
};

#endif ILGNETWORKINFO_H