////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   platform.h
//  Version:     v1.00
//  Created:     11/12/2002 by Timur.
//  Compilers:   Visual Studio.NET
//  Description: Platform dependend stuff.
//               Include this file instead of windows.h
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef _PHYSIMP_H_
#define _PHYSIMP_H_
#pragma once


struct ISystem {
	virtual int GetCPUFlags() = 0;
	virtual struct ILog *GetILog() = 0;
	virtual ISystem *GetISystemEventDispatcher() { return this; }
	virtual void RegisterListener(void*) {}
};
#define assert(a) {;}


class ICrySizer
{
public:
	virtual bool AddObject (const void* pIdentifier, size_t nSizeBytes,int nCount=1) {}
	template <typename T>	bool Add (const T* pId, size_t num) { return AddObject(pId, num * sizeof(T)); }
};


__declspec(naked) inline __int64 getTicks() { 
	__asm rdtsc
	__asm ret
}

extern int g_iLastProfilerId;
struct CFrameProfiler {
	CFrameProfiler(char *name) {
		m_name = name;
		m_id = ++g_iLastProfilerId;
	}
	char *m_name;
	int m_id;
};

struct CFrameProfilerTimeSample {
	int iTotalTime;
	int iSelfTime;
	int iCount;
	CFrameProfiler *pProfiler;
	unsigned __int64 iCode;
	int iChild,iNext;

	void Reset() {
		iChild = iNext = -1;
		iTotalTime = iSelfTime = iCount = 0;
	}
};

struct CFrameProfilerSectionBase {
	__int64 m_iStartTime;
	unsigned __int64 m_iCurCode;
	int m_iCurSlot;
	int m_bActive;
};

struct ProfilerData {
	int iLevel,iLastSampleSlot,iLastTimeSample;
	CFrameProfilerSectionBase sec0;
	CFrameProfilerSectionBase *pCurSection[16];
	CFrameProfilerTimeSample TimeSamples[256];
};
extern ProfilerData g_pd;

struct CFrameProfilerSection : CFrameProfilerSectionBase {
	CFrameProfilerSection(CFrameProfiler *pProfiler, int bActive=1) {
		if (m_bActive=bActive) {
			m_iCurCode = g_pd.pCurSection[g_pd.iLevel]->m_iCurCode | (unsigned __int64)pProfiler->m_id<<(7-g_pd.iLevel)*8;
			if (g_pd.TimeSamples[g_pd.iLastSampleSlot].iCode == m_iCurCode)
				m_iCurSlot = g_pd.iLastSampleSlot;
			else {
				if ((m_iCurSlot = g_pd.TimeSamples[g_pd.pCurSection[g_pd.iLevel]->m_iCurSlot].iChild) < 0) {
					g_pd.TimeSamples[g_pd.pCurSection[g_pd.iLevel]->m_iCurSlot].iChild = m_iCurSlot = ++g_pd.iLastTimeSample;
					g_pd.TimeSamples[m_iCurSlot].Reset();
				} else {
					for(; g_pd.TimeSamples[m_iCurSlot].iNext>=0 && g_pd.TimeSamples[m_iCurSlot].iCode!=m_iCurCode; m_iCurSlot=g_pd.TimeSamples[m_iCurSlot].iNext);
					if (g_pd.TimeSamples[m_iCurSlot].iCode!=m_iCurCode) {
						m_iCurSlot = (g_pd.TimeSamples[m_iCurSlot].iNext = ++g_pd.iLastTimeSample);
						g_pd.TimeSamples[m_iCurSlot].Reset();
					}
				}
				g_pd.TimeSamples[g_pd.iLastSampleSlot = m_iCurSlot].iCode = m_iCurCode;
			}
			g_pd.TimeSamples[m_iCurSlot].pProfiler = pProfiler;
			m_iStartTime = getTicks();
			g_pd.TimeSamples[m_iCurSlot].iCount++;
			g_pd.pCurSection[++g_pd.iLevel] = this;
		}
	}

	~CFrameProfilerSection() 
	{
		if (m_bActive) {
			int iTime = (int)(getTicks()-m_iStartTime);
			g_pd.TimeSamples[m_iCurSlot].iSelfTime += iTime;
			g_pd.TimeSamples[m_iCurSlot].iTotalTime += iTime;
			g_pd.TimeSamples[g_pd.pCurSection[--g_pd.iLevel]->m_iCurSlot].iSelfTime -= iTime;
		}
	}
};

void ResetProfiler(ProfilerData *pd)
{
	pd->iLevel = 0;
	pd->sec0.m_iCurCode = 0;
	pd->sec0.m_iCurSlot = pd->iLastSampleSlot = pd->iLastTimeSample = 0;
	pd->pCurSection[0] = &pd->sec0;
	pd->TimeSamples[0].Reset();
}

#include "Win32Specific.h"

#define PRINTF_PARAMS(...)
typedef unsigned int uint32;
#define MATH_H <math.h>
#define AUTO_STRUCT_INFO
#define AUTO_TYPE_INFO(a)
#define SPU_DOMAIN_LOCAL
#define SPU_DOMAIN_MAIN
#define UNIQUE_IFACE
#define DEVIRTUALIZE_HEADER_FIX(a) <NoIfaceWrapper.h>
#define DEVIRTUALIZATION_VTABLE_FIX
#define DLL_EXPORT __declspec(dllexport)
#define DLL_IMPORT __declspec(dllimport)
#define CPUF_SSE   1
#define CPUF_SSE2  2
#define CPUF_3DNOW 4
#define CPUF_MMX   8
#define CHECK_SIMD_ALIGNMENT

/*ILINE int __fastcall FtoI(float  x)	{
  int	t;
  __asm	fld x
  __asm fistp t
  return t;
}*/

#endif // _PLATFORM_H_
