////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   platform.h
//  Version:     v1.00
//  Created:     11/12/2002 by Timur.
//  Compilers:   Visual Studio.NET
//  Description: Platform dependend stuff.
//               Include this file instead of windows.h
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef _PLATFORM_H_
#define _PLATFORM_H_
#pragma once

#define DEBUG_BREAK _asm { int 3 }
#define _CPU_X86
#define STANDALONE_PHYSICS
#define __Endian_h__

#include <windows.h>
#include <Win32specific.h>

#include "stdio.h"

#define MATH_H <math.h>

#define CPUF_SSE   1
#define CPUF_SSE2  2
#define CPUF_3DNOW 4
#define CPUF_MMX   8

long   CryInterlockedIncrement( int volatile *lpAddend );
long   CryInterlockedDecrement( int volatile *lpAddend );
void*  CryCreateCriticalSection();
void   CryDeleteCriticalSection( void *cs );
void   CryEnterCriticalSection( void *cs );
void   CryLeaveCriticalSection( void *cs );
#define WRITE_LOCK_VAL (1<<16)

inline void CrySpinLock(volatile int *pLock,int checkVal,int setVal) { 
#ifdef _CPU_X86
	__asm {
	mov edx, setVal
	mov ecx, pLock
	Spin:
		mov eax, checkVal
		lock cmpxchg [ecx], edx
	jnz Spin }
#else
	while(_InterlockedCompareExchange(pLock,setVal,checkVal)!=checkVal);
#endif
}

inline void CryInterlockedAdd(volatile int *pVal, int iAdd) {
#ifdef _CPU_X86
	__asm {
		mov edx, pVal
		mov eax, iAdd
		lock add [edx], eax
	}
#else
	_InterlockedExchangeAdd(pVal,iAdd);
#endif
}

//////////////////////////////////////////////////////////////////////////
struct WriteLock
{
	ILINE WriteLock(volatile int &rw) { CrySpinLock(&rw,0,WRITE_LOCK_VAL); prw=&rw; }
	~WriteLock() { CryInterlockedAdd(prw,-WRITE_LOCK_VAL); }
private:
	volatile int *prw;
};

//////////////////////////////////////////////////////////////////////////
struct WriteLockCond
{
	ILINE WriteLockCond(volatile int &rw,int bActive=1)
	{
		if (bActive)
			CrySpinLock(&rw,0,iActive=WRITE_LOCK_VAL);
		else 
			iActive = 0;
		prw = &rw; 
	}
	~WriteLockCond() { CryInterlockedAdd(prw,-iActive); }
	void SetActive(int bActive=1) { iActive = -bActive & WRITE_LOCK_VAL; }
	void Release() { CryInterlockedAdd(prw,-iActive); }
private:
	volatile int *prw;
	int iActive;
};

//////////////////////////////////////////////////////////////////////////
struct ReadLock
{
	ILINE ReadLock(volatile int &rw)
	{
		CryInterlockedAdd(prw=&rw,1);
#ifdef NEED_ENDIAN_SWAP
		volatile char *pw=(volatile char*)&rw+1; for(;*pw;);
#else
		volatile char *pw=(volatile char*)&rw+2; for(;*pw;);
#endif
	}
	~ReadLock()	{	CryInterlockedAdd(prw,-1); }
private:
	volatile int *prw;
};

struct ReadLockCond
{
	ILINE ReadLockCond(volatile int &rw,int bActive)
	{
		if (bActive) {
			CryInterlockedAdd(&rw,1);
			bActivated = 1;
#ifdef NEED_ENDIAN_SWAP
			volatile char *pw=(volatile char*)&rw+1; for(;*pw;);
#else
			volatile char *pw=(volatile char*)&rw+2; for(;*pw;);
#endif
		}
		else
			bActivated = 0;
		prw = &rw; 
	}
	void SetActive(int bActive=1) { bActivated = bActive; }
	void Release() { CryInterlockedAdd(prw,-bActivated); }
	~ReadLockCond()	{	CryInterlockedAdd(prw,-bActivated); }

private:
	volatile int *prw;
	int bActivated;
};

//////////////////////////////////////////////////////////////////////////
//DWORD GetCurrentThreadId()


#define AUTO_STRUCT_INFO
#define AUTO_STRUCT_INFO_LOCAL
#define AUTO_TYPE_INFO(Type) Type ati(Type);
#define STRUCT_INFO_BEGIN(a)
#define STRUCT_INFO_END(a)
#define STRUCT_BITFIELD_INFO(a,b,c)
#define STRUCT_VAR_INFO(a,b)
#define TYPE_INFO(a)
#define assert(a) {;}

#if defined(__GNUC__)
  #define PRINTF_PARAMS(...) __attribute__ ((format (printf, __VA_ARGS__)))
  #define SCANF_PARAMS(...) __attribute__ ((format (scanf, __VA_ARGS__)))
#else
  #define PRINTF_PARAMS(...)
	#define SCANF_PARAMS(...)
#endif

#ifndef NOT_USE_CRY_MEMORY_MANAGER
#define USE_NEWPOOL
#include <CryMemoryManager.h>
#else
#define _ACCESS_POOL
#endif // NOT_USE_CRY_MEMORY_MANAGER

#include <string>
typedef std::string string;
typedef std::wstring wstring;

// 32/64 Bit versions.
#define SIGN_MASK(x) ((intptr_t)(x) >> ((sizeof(size_t)*8)-1))
#define BIT(x) (1<<(x))

#pragma warning(disable: 4018)

// macro for structure alignement
#define DEFINE_ALIGNED_DATA( type, name, alignment ) _declspec(align(alignment)) type name;
#define DEFINE_ALIGNED_DATA_STATIC( type, name, alignment ) static _declspec(align(alignment)) type name;
#define DEFINE_ALIGNED_DATA_CONST( type, name, alignment ) const _declspec(align(alignment)) type name;

#define _CRY_SYSTEM_H_
#define __CRYTHREAD_WINDOWS_H__
#define __CRYTHREADIMPL_WINDOWS_H__
#define __TYPEINFO_H
#define _CRY_COMMON_WIN32_SPECIFIC_HDR_
#define CRY_SIMD_H
#define _CryThread_h_

#define SwapEndian(a)
struct ISystemEventListener {};
enum { ESYSTEM_EVENT_RANDOM_SEED=1, ESYSTEM_EVENT_LEVEL_RELOAD, ESYSTEM_EVENT_LEVEL_POST_UNLOAD=16 };
typedef int ESystemEvent;
#define ModuleInitISystem(a,b)
#define FSystemAlloc FModuleAlloc
#define CryModuleRealloc realloc

typedef void* (*TPFAlloc)( void* ptr, size_t size );
ILINE void* ModuleAlloc( void* ptr, size_t size )
{
	if (size)
		return ptr ? realloc(ptr, size) : malloc(size);
	if (ptr)
		free(ptr);
	return 0;
}
ILINE void* SafeAlloc( TPFAlloc allocator, void *ptr, size_t size )
{
	return allocator(ptr,size);
}

// Convert one type to another, asserting there is no conversion loss.
// Usage: DestType dest;  check_convert(dest, src);
template<class D, class S>
inline D& check_convert(D& d, S const& s)
{
	d = D(s);
	assert(S(d) == s);
	return d;
}

// Convert one type to another, asserting there is no conversion loss.
// Usage: DestType dest;  check_convert(dest) = src;
template<class D>
struct CheckConvert
{
	CheckConvert(D& d)
		: dest(&d) {}

	template<class S>
	D& operator=(S const& s)
	{
		return check_convert(*dest, s);
	}

protected:
	D*	dest;
};

template<class D>
inline CheckConvert<D> check_convert(D& d)
{
	return d;
}

#define CryLog printf
#define CryLogAlways printf

struct IThreadTask {
	virtual void OnUpdate() {}
	virtual void Stop() {}
};
struct SThreadTaskInfo {
};
struct SThreadTaskParams
{
	uint32 nFlags;
	int	nPreferedThread;
	int16	nPriorityOff;
	int16	nStackSizeKB;
	const char* name;
	SThreadTaskParams() : nFlags(0),nPreferedThread(-1),nPriorityOff(0), name(""), nStackSizeKB(32) {}
};
#define THREAD_TASK_BLOCKING 0

struct IThreadTaskManager {
	static void MarkThisThreadForDebugging(const char*,bool) {}
	static void RegisterTask(IThreadTask *pTask, const SThreadTaskParams &options ) {
		CreateThread(0,0,TaskProc,pTask,0,0);
	}
	static void UnregisterTask(IThreadTask *pTask) { pTask->Stop(); }
	static unsigned long __stdcall TaskProc(void *pTask) { ((IThreadTask*)pTask)->OnUpdate(); return 0; }
};

struct CryEvent {
	CryEvent() { hEvent = CreateEvent(0,FALSE,FALSE,0); }
	~CryEvent() { CloseHandle(hEvent); }
	void Set() { SetEvent(hEvent); }
	int Wait(int interval=INFINITE) { return WaitForSingleObject(hEvent,interval); }
	HANDLE hEvent;
};

inline struct ISystem *GetISystem() { return 0; }
struct ISystem {
	virtual int GetCPUFlags() = 0;
	virtual struct ILog *GetILog() = 0;
	ISystem *GetISystemEventDispatcher() { return this; }
	void RegisterListener(void*) {}
	static IThreadTaskManager *GetIThreadTaskManager() { return 0; }
};
#define CryError {}
#define CryFatalError {}

#define _CRY_COMMON_CRY_SIZER_INTERFACE_HDR_
#define SIZER_COMPONENT_NAME
class ICrySizer
{
public:
	virtual bool AddObject (const void* pIdentifier, size_t nSizeBytes,int nCount=1) {}
	template <typename T>	bool Add (const T* pId, size_t num) { return AddObject(pId, num * sizeof(T)); }
};

#define MTRAND_H
inline float cry_frand() { return rand()*(1.0f/RAND_MAX); }
inline unsigned int cry_rand32() { return rand(); }
struct CMTRand_int32 {
	int Generate() { return rand(); }
	float GenerateFloat() { return rand()*(1.0f/RAND_MAX); }
	void seed(int) {}
};

ILINE int __fastcall FtoI(float  x)	{
  int	t;
  __asm	fld x
  __asm fistp t
  return t;
}

#define eBigEndian 1

#define gEnv (&m_vars)

#define SPU_DOMAIN_LOCAL
#define SPU_DOMAIN_MAIN
#define SPU_INDIRECT(...)
#define SPU_INDIRECT_TAG(a)
#define SIMPLE_THREAD_STACK_SIZE_KB (32)
#define SPU_NO_INLINE
#define SPU_LOCAL_PTR
#define SPU_LOCAL
#define SPU_LOCAL_FOR_JOBS(a,b)
#define SPU_MAIN_PTR(x) (x)
#define IF(a,b) if (a)
#define _ALIGN(a)
inline int WaitForJobFinish(int&,int) { return -1; }
inline void CreateJobThreads(int) {}

#define DEVIRTUALIZE_HEADER_FIX(a) <NoIfaceWrapper.h>
#define DEVIRTUALIZATION_VTABLE_FIX
#define UNIQUE_VIRTUAL_WRAPPER(a) <NoIfaceWrapper.h>
#define UNIQUE_IFACE
#define VIRTUAL virtual
#define PREFAST_SUPPRESS_WARNING(a)

#define CHECK_SIMD_ALIGNMENT

struct NoCopy	{
	NoCopy() {}
private:
	NoCopy(const NoCopy&);
	NoCopy& operator =(const NoCopy&);
};
#define CONST_VAR_FUNCTION(head, body) \
	inline head body \
	inline const head const body
#define using_type(super, type) \
	typedef typename super::type type;
template<typename T> inline	T Align(T nData, size_t nAlign)	{
	size_t size = (size_t(nData) + (nAlign-1)) & ~(nAlign-1);
	return T(size);
}
#define alignof _alignof
template<class D, class S> inline D check_cast(S const& s) {
	D d = D(s);
	return d;
}

extern "C" {
	__declspec(dllimport) unsigned long __stdcall TlsAlloc();
	__declspec(dllimport) void* __stdcall TlsGetValue(unsigned long dwTlsIndex);
	__declspec(dllimport) int __stdcall TlsSetValue(unsigned long dwTlsIndex, void* lpTlsValue);
}
#define TLS_DECLARE(type,var) extern int var##idx;
#define TLS_DEFINE(type,var) \
int var##idx; \
struct Init##var { \
	Init##var() { var##idx = TlsAlloc(); } \
}; \
Init##var g_init##var;
#define TLS_GET(type,var) (type)TlsGetValue(var##idx)
#define TLS_SET(var,val) TlsSetValue(var##idx,(void*)(val))

inline unsigned int CryGetCurrentThreadId()
{
	return GetCurrentThreadId();
}

///////////////////////////////////////////////
////////// Inlined Frame Profiler /////////////

__forceinline int64 CryQueryPerformanceCounter()
{
#if defined(_CPU_X86)
	int64 nTime;
	int64 *pnTime = &nTime;
	__asm {
		mov ebx, pnTime
		rdtsc
		mov [ebx], eax
		mov [ebx+4], edx
	}
#elif defined(WIN32)
	LARGE_INTEGER li;
	QueryPerformanceCounter( &li );
	return li.QuadPart;
#endif
}

__declspec(naked) inline __int64 getTicks() { 
	__asm rdtsc
	__asm ret
}

extern int g_iLastProfilerId;
struct CFrameProfiler {
	CFrameProfiler(char *name) {
		m_name = name;
		m_id = ++g_iLastProfilerId;
	}
	char *m_name;
	int m_id;
};

struct CFrameProfilerTimeSample {
	int iTotalTime;
	int iSelfTime;
	int iCount;
	CFrameProfiler *pProfiler;
	unsigned __int64 iCode;
	int iChild,iNext;

	void Reset() {
		iChild = iNext = -1;
		iTotalTime = iSelfTime = iCount = 0;
	}
};

struct CFrameProfilerSectionBase {
	__int64 m_iStartTime;
	unsigned __int64 m_iCurCode;
	int m_iCurSlot;
	int m_bActive;
};

struct ProfilerData {
	int iLevel,iLastSampleSlot,iLastTimeSample;
	CFrameProfilerSectionBase sec0;
	CFrameProfilerSectionBase *pCurSection[16];
	CFrameProfilerTimeSample TimeSamples[256];
};
extern ProfilerData g_pd;

struct CFrameProfilerSection : CFrameProfilerSectionBase {
	CFrameProfilerSection(CFrameProfiler *pProfiler, int bActive=1) {
		if (m_bActive=bActive) {
			m_iCurCode = g_pd.pCurSection[g_pd.iLevel]->m_iCurCode | (unsigned __int64)pProfiler->m_id<<(7-g_pd.iLevel)*8;
			if (g_pd.TimeSamples[g_pd.iLastSampleSlot].iCode == m_iCurCode)
				m_iCurSlot = g_pd.iLastSampleSlot;
			else {
				if ((m_iCurSlot = g_pd.TimeSamples[g_pd.pCurSection[g_pd.iLevel]->m_iCurSlot].iChild) < 0) {
					g_pd.TimeSamples[g_pd.pCurSection[g_pd.iLevel]->m_iCurSlot].iChild = m_iCurSlot = ++g_pd.iLastTimeSample;
					g_pd.TimeSamples[m_iCurSlot].Reset();
				} else {
					for(; g_pd.TimeSamples[m_iCurSlot].iNext>=0 && g_pd.TimeSamples[m_iCurSlot].iCode!=m_iCurCode; m_iCurSlot=g_pd.TimeSamples[m_iCurSlot].iNext);
					if (g_pd.TimeSamples[m_iCurSlot].iCode!=m_iCurCode) {
						m_iCurSlot = (g_pd.TimeSamples[m_iCurSlot].iNext = ++g_pd.iLastTimeSample);
						g_pd.TimeSamples[m_iCurSlot].Reset();
					}
				}
				g_pd.TimeSamples[g_pd.iLastSampleSlot = m_iCurSlot].iCode = m_iCurCode;
			}
			g_pd.TimeSamples[m_iCurSlot].pProfiler = pProfiler;
			m_iStartTime = getTicks();
			g_pd.TimeSamples[m_iCurSlot].iCount++;
			g_pd.pCurSection[++g_pd.iLevel] = this;
		}
	}

	~CFrameProfilerSection() 
	{
		if (m_bActive) {
			int iTime = (int)(getTicks()-m_iStartTime);
			g_pd.TimeSamples[m_iCurSlot].iSelfTime += iTime;
			g_pd.TimeSamples[m_iCurSlot].iTotalTime += iTime;
			g_pd.TimeSamples[g_pd.pCurSection[--g_pd.iLevel]->m_iCurSlot].iSelfTime -= iTime;
		}
	}
};

void ResetProfiler(ProfilerData *pd)
{
	pd->iLevel = 0;
	pd->sec0.m_iCurCode = 0;
	pd->sec0.m_iCurSlot = pd->iLastSampleSlot = pd->iLastTimeSample = 0;
	pd->pCurSection[0] = &pd->sec0;
	pd->TimeSamples[0].Reset();
}

#define DLL_EXPORT __declspec(dllexport)
#define DLL_IMPORT __declspec(dllimport)
#define STLALLOCATOR_CLEANUP

extern __declspec(thread) int iCaller;

#define FUNCTION_PROFILER( pISystem,subsystem ) \
	static CFrameProfiler staticFrameProfiler( __FUNCTION__ ); \
	CFrameProfilerSection frameProfilerSection( &staticFrameProfiler,(::iCaller=iCaller)^1 );	
#define FRAME_PROFILER( szProfilerName,pISystem,subsystem ) \
	static CFrameProfiler staticFrameProfiler( szProfilerName ); \
	CFrameProfilerSection frameProfilerSection( &staticFrameProfiler );
#define PROFILE_PHYSICS	0

#ifndef PHYSICS_EXPORTS
extern "C" __declspec(dllimport) ProfilerData *GetProfileData();
#endif 

#define TestbedPlaceholder foo() {}; int g_iLastProfilerId=0; ProfilerData g_pd; \
	__declspec(thread) int iCaller = 0; \
	CMTRand_int32 g_random_generator; \
	extern "C" CRYPHYSICS_API ProfilerData *GetProfileData() { return &g_pd; } \
	void TestbedPlaceholder


///////////////////////////////////////////////////////////////////////////////
// common Typedef                                                                   //
///////////////////////////////////////////////////////////////////////////////
typedef double real;
typedef int index_t;
typedef int                 INT;
typedef unsigned int        UINT;
typedef unsigned int        *PUINT;

#endif // _PLATFORM_H_
