#include "StdAfx.h"
#include "Resource.h"
#include "LevelLoader.h"

// This header must be included only once! in each module or executable
#include <platform_impl.h>

// Engine includes.
#include <IInput.h>
#include <IRenderer.h>

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
// We need shell api for Current Root Extrection.
#include "shlwapi.h"
#pragma comment(lib, "shlwapi.lib")




#define CRY_SYSTEM_DLL "CrySystem.dll"
#define DLL_INITFUNC_SYSTEM "CreateSystemInterface"

#define CRYENGINE_WINDOW_CLASSNAME "CryENGINE"

HINSTANCE g_hInstance = 0;

//////////////////////////////////////////////////////////////////////////
// Initializes Root folder of the game.
//////////////////////////////////////////////////////////////////////////
void InitRootDir()
{
#ifdef WIN32
	WCHAR szExeFileName[_MAX_PATH];

	GetModuleFileNameW( GetModuleHandle(NULL), szExeFileName, sizeof(szExeFileName));
	PathRemoveFileSpecW(szExeFileName);

	// Remove Bin32/Bin64 folder/
	WCHAR *lpPath = StrStrIW(szExeFileName,L"\\Bin32");
	if (lpPath)
		*lpPath = 0;
	lpPath = StrStrIW(szExeFileName,L"\\Bin64");
	if (lpPath)
		*lpPath = 0;

	SetCurrentDirectoryW( szExeFileName );
#endif
}

// Simple function to display error dialog
void Error( const char *sErrorText )
{
	MessageBox( 0,sErrorText, "Error", MB_OK | MB_DEFAULT_DESKTOP_ONLY);
}

class CCryEngine
{
	HMODULE m_hSystemHandle;
	ISystem *m_pISystem;

public:
	CCryEngine()
	{
		m_hSystemHandle = 0;
	};
	~CCryEngine()
	{
		if (m_hSystemHandle)
			CryFreeLibrary(m_hSystemHandle);
	}

	bool InitCrySystem( const char *sInCmdLine )
	{
		if (!InitWindowClass())
		{
			Error( "Failed to initialize window class" );
		}

		m_hSystemHandle = LoadLibrary( "CrySystem.dll" );
		if (!m_hSystemHandle)
		{
			Error( "CrySystem.DLL Loading Failed" );
			return false;
		}

		PFNCREATESYSTEMINTERFACE pfnCreateSystemInterface = (PFNCREATESYSTEMINTERFACE)::GetProcAddress( m_hSystemHandle,DLL_INITFUNC_SYSTEM );

		SSystemInitParams sip;
		sip.bEditor = false;
		sip.bDedicatedServer = false;
		sip.bPreview = false;
		sip.bTestMode = false;
		sip.hInstance = g_hInstance;

		sip.sLogFileName = "Game.log";
		strcpy( sip.szSystemCmdLine,sInCmdLine );

		m_pISystem = pfnCreateSystemInterface( sip );
		if (!m_pISystem)
		{
			Error( "CreateSystemInterface Failed" );

			return false;
		}

		// Initialized important global variables like GetISystem() gEnv etc.. 
		ModuleInitISystem(m_pISystem,"Launcher");

		// System is fully initialized and ready by now.

		return true;
	}

	bool InitWindowClass()
	{
		HINSTANCE hInstance = g_hInstance;

		WNDCLASS wc;
		memset(&wc, 0, sizeof(WNDCLASS));
		wc.style         = CS_OWNDC | CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
		wc.lpfnWndProc   = (WNDPROC)CCryEngine::WndProc;
		wc.cbClsExtra    = 0;
		wc.cbWndExtra    = 0;
		wc.hInstance     = GetModuleHandle(0);
		wc.hIcon         = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_SAMPLE1));
		wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
		wc.hbrBackground =(HBRUSH)GetStockObject(BLACK_BRUSH);
		wc.lpszMenuName  = 0;
		wc.lpszClassName = CRYENGINE_WINDOW_CLASSNAME;

		if (!RegisterClass(&wc))
		{
			return false;
		}
			//::ShowCursor(FALSE);
		return true;
	}

	static LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
	{
		switch(msg)
		{
		case WM_CLOSE:
			if (gEnv && gEnv->pSystem)
				gEnv->pSystem->Quit();
			return 0;
		case WM_HOTKEY:
		case WM_SYSCHAR:	// prevent ALT + key combinations from creating 'ding' sounds
			return  0;
		case WM_CHAR:
			{
				if (gEnv && gEnv->pInput)
				{
					SInputEvent event;
					event.modifiers = gEnv->pInput->GetModifiers();
					event.deviceId = eDI_Keyboard;
					event.state = eIS_UI;
					event.value = 1.0f;
					event.pSymbol = 0;//m_rawKeyboard->GetSymbol((lParam>>16)&0xff);
					if (event.pSymbol)
						event.keyId = event.pSymbol->keyId;

					wchar_t tmp[2] = { 0 };
					MultiByteToWideChar(CP_ACP, 0, (char*)&wParam, 1, tmp, 2);
					event.timestamp = tmp[0];

					char szKeyName[4] = {0};
					if (wctomb(szKeyName, (WCHAR)wParam) != -1)
					{
						if (szKeyName[1]==0 && ((unsigned char)szKeyName[0])>=32)
						{
							event.keyName = szKeyName;
							gEnv->pInput->PostInputEvent(event);
						}
					}
				}
			}
			break;
		case WM_MOVE:
			if(gEnv && gEnv->pSystem)
			{
				gEnv->pSystem->GetISystemEventDispatcher()->OnSystemEvent(ESYSTEM_EVENT_MOVE,LOWORD(lParam), HIWORD(lParam));
			}
			break;
		case WM_SIZE:
			if(gEnv && gEnv->pSystem)
			{
				gEnv->pSystem->GetISystemEventDispatcher()->OnSystemEvent(ESYSTEM_EVENT_RESIZE,LOWORD(lParam), HIWORD(lParam));
			}
			break;
		}

		return DefWindowProc(hWnd, msg, wParam, lParam);
	}

	void UpdateCamera()
	{
		static Vec3 campos( 1326, 1346, 140 );
		static Ang3 camang( DEG2RAD( -10 ), 0, DEG2RAD( 17 ) );
		CCamera cam = GetISystem()->GetViewCamera();
		cam.SetAngles( camang );
		cam.SetPosition( campos );
		GetISystem()->SetViewCamera( cam );
	}

	// Main Engine loop.
	int MainLoop()
	{
		bool bQuit = false;
		// Main message loop and per frame engine update
		MSG msg;
		while (!bQuit)
		{
			while (PeekMessage(&msg, 0, 0, 0,PM_REMOVE))
			{
				if (msg.message == WM_QUIT)
					bQuit = true;
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}

			UpdateCamera();

			// Basic frame update.
			m_pISystem->Update();
			m_pISystem->RenderBegin();
			m_pISystem->Render();
			m_pISystem->RenderEnd();
		}
		return 0;
	}
};

///////////////////////////////////////////////
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
	{
	// we need pass the full command line, including the filename
	// lpCmdLine does not contain the filename.

	g_hInstance = hInstance;

	InitRootDir();

	CCryEngine engine;

	int nRes = 0;
	if (engine.InitCrySystem( lpCmdLine ) )
	{
		CLevelLoader levelLoader( GetISystem(),"Levels" );
		levelLoader.LoadLevel( "PacificIsland" );

		nRes = engine.MainLoop();
	}

	return nRes;
}

