
#ifndef NAV_DATA_GENERATOR_H
#define NAV_DATA_GENERATOR_H

#include "Navigation.h"

class CNavDataGenerator {
public:
	CNavDataGenerator ();
	~CNavDataGenerator ();

	/// generate the triangulation for this level and mission
	void GenerateTriangulation(const char * szLevel, const char * szMission);
	/// generate 3d nav volumes for this level and mission
	void Generate3DVolumes(const char * szLevel, const char * szMission);
	/// generate flight navigation for this level and mission
	void GenerateFlightNavigation(const char * szLevel, const char * szMission);
	/// Automatically reconnect all waypoint nodes in all buildings,
	/// and disconnects nodes not in buildings (only affects automatically
	/// generated links)
	void ReconnectAllWaypointNodes();


	CNavigation * GetNavigation () { return m_pNavigation; }

private:
	CNavigation * m_pNavigation;
};

extern CNavDataGenerator g_navDataGenerator;

inline CNavDataGenerator * GetNavDataGenerator () { return & g_navDataGenerator; }
inline CNavigation * GetNavigation () { return g_navDataGenerator.GetNavigation (); }
inline CVertexList & GetVertexList () { return g_navDataGenerator.GetNavigation ()->GetVertexList (); }
inline CGraph * GetGraph () { return g_navDataGenerator.GetNavigation ()->GetGraph (); }

#endif // NAV_DATA_GENERATOR_H
