////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   brushface.h
//  Version:     v1.00
//  Created:     8/7/2002 by Timur.
//  Compilers:   Visual Studio.NET
//  Description: 
// -------------------------------------------------------------------------
//  History: Based on Andrey's Indoor editor.
//  02/03/2010 Refactored by Jaesik.
////////////////////////////////////////////////////////////////////////////

#ifndef __BRUSHFACE_H__
#define __BRUSHFACE_H__

#if _MSC_VER > 1000
#pragma once
#endif

#include "brushplane.h"

struct SBrushVertex
{
	SBrushVertex( const Vec3& _pos )	:
		pos(_pos),
		bSelected(0)
		
	{
		st[0] = 0;
		st[1] = 0;
	}

	SBrushVertex() :
		pos(0,0,0),
		bSelected(0)
	{
		st[0] = 0;
		st[1] = 0;
	}
 
	~SBrushVertex()
	{
	}
	
	int GetMemorySize();

	Vec3  pos;
	float st[2];
	bool bSelected;
};

struct SBrushTriangle
{
	SBrushTriangle()
		:	faceidx(-1),
			normal(0,1,0)
	{
		for( int i = 0; i < 3; i++ )
		{
			vertexindices[i] = -1;
			adjacentfidx[i] = -1;
		}
		boundbox.Reset();
	}

	bool SetVertexIndices( const std::vector<SBrushVertex*>& vtxlist, short i0, short i1, short i2, short fidx );
	bool SetVertexIndices( const Vec3& v0, const Vec3& v1, const Vec3& v2, short i0, short i1, short i2, short fidx );

	void MakeNormal( const std::vector<SBrushVertex*>& vtxlist );

	void CalcBound( const std::vector<SBrushVertex*>& vtxlist );
	void CalcBound( const Vec3& v0, const Vec3& v1, const Vec3& v2 );

	int GetMemorySize();


private:

	friend struct SBrush;
	friend struct SBrushFace;
	friend class	CBrushSerialize;

	short	vertexindices[3];
	short	adjacentfidx[3];
	short	faceidx;
	AABB	boundbox;
	Vec3	normal;
};

struct SBrushFace
{
	SBrushFace() : 
		matID(0),
		bSelected(false),
		selectededge(0)
	{
	}

	void MakePlane( const std::vector<SBrushVertex*>& vtxlist, int EntryIndex );

	void CalcTexCoords( SBrushVertex& v );
	const Vec3& GetCenter()	{	return center;	}
	void CalcCenter( const std::vector<SBrushVertex*>& vtxlist );
	void CalcPlane( const std::vector<SBrushVertex*>& vertexlist );

	void MapEdgeIndexToPolyIndices( const std::vector<SBrushVertex*>& vtxlist,  
																	const std::vector<SBrushTriangle*>& trilist, 
																	const int& nEdgeIndex,
																	int &rnFirstPolyVertex, 
																	int& rnSecondPolyVertex ) const;

	void CalcBound( const std::vector<SBrushVertex*>& vtxlist, Vec3& mins, Vec3& maxs );
	void CalcBound( const std::vector<SBrushVertex*>& vtxlist );

	static void CalcTextureBasis(	const SBrushPlane& p, 
																const SBrush::STexInfo& ti, 
																Vec3& u, 
																Vec3& v );

	static void CalcTexCoords(	const SBrushPlane& p, 
															const SBrush::STexInfo& ti, 
															const Vec3& pos, 
															float& tu, float &tv );

	short FindLocalVtxIndex( short globalidx ) const;

	void	FitTexture( const std::vector<SBrushVertex*>& vlist, float tileU, float tileV );

	int		GetMemorySize();	

private:

	friend struct SBrush;
	friend class	CBrushSerialize;

	std::vector<short>	pointindexlist;
	std::vector<short>	triangleidxlist;
	short								matID;
	SBrush::STexInfo		texinfo;
	AABB								boundbox;
	int									selectededge;
	bool								bSelected;
	SBrushPlane					plane;
	Vec3								center;
};

#endif __BRUSHFACE_H__