////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   brushplane.h
//  Version:     v1.00
//  Created:     9/7/2002 by Timur.
//  Compilers:   Visual Studio.NET
//  Description: 
// -------------------------------------------------------------------------
//  History: Based on Andrey's Indoor editor.
//	06/04/2007 Refactored by Jaesik
////////////////////////////////////////////////////////////////////////////

#ifndef __brushplane_h__
#define __brushplane_h__

#if _MSC_VER > 1000
#pragma once
#endif

struct SBrushPlane
{
	SBrushPlane()
	{
	}

	SBrushPlane( const SBrushPlane& p )
		:	normal(p.normal),
		distance(p.distance)
	{
	}

	SBrushPlane( const Vec3& _normal, float _dist ) 
		:	normal(_normal),
			distance(_dist)
	{
	}

	SBrushPlane( float a, float b, float c, float d )
	{
	}

	SBrushPlane( const Vec3& v0, const Vec3& v1, const Vec3& v2 )
	{
		normal = (v2-v1)^(v0-v1);
		normal.NormalizeSafe();
		distance = -normal.Dot(v2);
	}

	void CalcTextureAxis(Vec3& xv, Vec3& yv) const;

	float Distance( const Vec3& p ) const
	{
		return normal.Dot(p)+distance;
	}

	void Invert()
	{
		normal		= -normal;
		distance	= -distance;
	}

	bool IsSameFacing( const Vec3& n ) const
	{
		return normal.Dot(n) > 0.999f;
	}

	bool IsSameFacing( const SBrushPlane& p ) const
	{
		return IsSameFacing( p.normal );
	}


	bool IsEquivalent( const SBrushPlane& p, float epsilon = VEC_EPSILON ) const
	{
		return normal.IsEquivalent( p.normal, epsilon ) && fabs(p.distance-distance) < epsilon;
	}

	void CreatePoly( std::vector<Vec3>& outputlist );
	bool ClipByPlane( const SBrushPlane& split, const std::vector<Vec3>& inputlist, std::vector<Vec3>& outputlist );
	bool HitTest( const Vec3& p0, const Vec3& p1, float* tout = NULL, Vec3* vout = NULL, const float epsilon = 0.00001f ) const;

	Vec3 normal;
	float distance;
};

#endif // __brushplane_h__
