// LicenseLoginDialog.cpp : implementation file
//

#include "stdafx.h"
#include "LicenseCreateDialog.h"

#ifdef USING_LICENSE_PROTECTION

#include "IProtectionManager.h"

IMPLEMENT_DYNAMIC(CLicenseCreateDialog, CDialog)

const int MinTextLength = 4;
const int MaxTextLength = 20;
const int MessageBuffersize = 128;

static const string base64_chars = 
"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

static inline bool is_base64(uint8 c) 
{
	return (isalnum(c) || (c == '+') || (c == '/'));
}

inline string Base64Encode( uint8 const* bytes_to_encode, uint32 in_len )
{
	string ret;
	int i = 0;
	int j = 0;
	uint8 char_array_3[3];
	uint8 char_array_4[4];

	while (in_len--) 
	{
		char_array_3[i++] = *(bytes_to_encode++);
		if (i == 3) 
		{
			char_array_4[0] = (char_array_3[0] & 0xfc) >> 2;
			char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
			char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);
			char_array_4[3] = char_array_3[2] & 0x3f;

			for(i = 0; (i <4) ; i++)
				ret += base64_chars[char_array_4[i]];
			i = 0;
		}
	}

	if (i)
	{
		for(j = i; j < 3; j++)
			char_array_3[j] = '\0';

		char_array_4[0] = (char_array_3[0] & 0xfc) >> 2;
		char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
		char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);
		char_array_4[3] = char_array_3[2] & 0x3f;

		for (j = 0; (j < i + 1); j++)
			ret += base64_chars[char_array_4[j]];

		while((i++ < 3))
			ret += '=';
	}

	return ret;
}

//////////////////////////////////////////////////////////////////////////
CLicenseCreateDialog::CLicenseCreateDialog(CWnd* pParent /*=NULL*/) :
	CDialog(CLicenseCreateDialog::IDD, pParent), m_protectionManager(NULL)
{
	//{{AFX_DATA_INIT(CLicenseCreateDialog)
	//}}AFX_DATA_INIT
}


//////////////////////////////////////////////////////////////////////////
BOOL CLicenseCreateDialog::OnInitDialog()
{
	CDialog::OnInitDialog();
	RegisterCountryCombo();
	m_eUsername.SetFocus();
	return FALSE;
}


//////////////////////////////////////////////////////////////////////////
void CLicenseCreateDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLicenseCreateDialog)
	//}}AFX_DATA_MAP
	DDX_Control(pDX, IDC_EDIT_Firstname, m_eFirstname);
	DDX_Control(pDX, IDC_EDIT_LASTNAME, m_eLastname);
	DDX_Control(pDX, IDC_EDIT_EMAIL, m_eEmail);
	DDX_Control(pDX, IDC_EDIT_ADDRESS, m_eAddress);
	DDX_Control(pDX, IDC_EDIT_CITY, m_eCity);
	DDX_Control(pDX, IDC_COMBO_COUNTRY, m_cCountry);
	DDX_Control(pDX, IDC_EDIT_STATE, m_eState);
	DDX_Control(pDX, IDC_EDIT_ZIPCODE, m_eZipcode);
	DDX_Control(pDX, IDC_EDIT_CREATEPASSWORD, m_ePassword);
	DDX_Control(pDX, IDC_EDIT_CREATEUSERNAME, m_eUsername);
	DDX_Control(pDX, IDC_BUTTON_CREATESUBMIT, m_buttonSubmit);
	DDX_Control(pDX, IDC_BUTTON_CREATECANCEL, m_buttonCancel);
}


//////////////////////////////////////////////////////////////////////////
BEGIN_MESSAGE_MAP(CLicenseCreateDialog, CDialog)
	//{{AFX_MSG_MAP(CLicenseCreateDialog)
	// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON_CREATESUBMIT, &CLicenseCreateDialog::OnBnClickedButtonCreatesubmit)
	ON_BN_CLICKED(IDC_BUTTON_CREATECANCEL, &CLicenseCreateDialog::OnBnClickedButtonCreatecancel)
END_MESSAGE_MAP()


//////////////////////////////////////////////////////////////////////////

void CLicenseCreateDialog::OnBnClickedButtonCreatesubmit()
{
	// TODO: Add your control notification handler code here
	MakeDisableInput();
	CreateAccountImpl();
	MakeEnableInput();
}

void CLicenseCreateDialog::OnBnClickedButtonCreatecancel()
{
	// TODO: Add your control notification handler code here
	EndDialog(0);
}

bool CLicenseCreateDialog::IsValidEditText()
{
	if (false == CheckUsernameEdit())
		return false;
	if (false == CheckPasswordEdit())
		return false;
	if (false == CheckEachEdit(m_eFirstname, "First name"))
		return false;
	if (false == CheckEachEdit(m_eLastname, "Last name"))
		return false;
	if (false == CheckEachEdit(m_eEmail, "Email address"))
		return false;
	CString emailText;
	m_eEmail.GetWindowText(emailText);
	if (-1 == emailText.Find('@') || -1 == emailText.Find('.'))
	{
		MessageBox("Invalid Email address.", "Error", MB_ICONERROR);
		m_eEmail.SetFocus();
		return false;
	}

	if (false == CheckEachEdit(m_eAddress, "Address"))
		return false;
	if (false == CheckEachEdit(m_eCity, "City"))
		return false;

	CString countryText;
	m_cCountry.GetWindowText(countryText);
	if (countryText.IsEmpty())
	{
		const int buffersize = 128;
		char message[buffersize] = {0,};
		sprintf_s(message, buffersize, "Please select Country.", MB_ICONERROR);
		MessageBox(message, "Error");
		m_cCountry.SetFocus();
		return false;
	}
	if (false == CheckEachEdit(m_eState, "State"))
		return false;
	if (false == CheckEachEdit(m_eZipcode, "Zip code"))
		return false;

	return true;
}


bool CLicenseCreateDialog::CheckEachEdit(CEdit& editObj, CString editTitle)
{
	CString editText;
	editObj.GetWindowText(editText);
	if (editText.IsEmpty())
	{
		const int buffersize = 128;
		char message[buffersize] = {0,};
		sprintf_s(message, buffersize, "Please fill %s.", editTitle);
		MessageBox(message, "Error", MB_ICONERROR);
		editObj.SetFocus();
		return false;
	}
	return true;
}

void CLicenseCreateDialog::RegisterCountryCombo()
{
	m_cCountry.AddString("Aland Islands");
	m_cCountry.AddString("Albania");
	m_cCountry.AddString("Algeria");
	m_cCountry.AddString("American Samoa");
	m_cCountry.AddString("Andorra");
	m_cCountry.AddString("Angola");
	m_cCountry.AddString("Anguilla");
	m_cCountry.AddString("Antarctica");
	m_cCountry.AddString("Antigua and Barbuda");
	m_cCountry.AddString("Argentina");
	m_cCountry.AddString("Armenia");
	m_cCountry.AddString("Aruba");
	m_cCountry.AddString("Ascension Islands");
	m_cCountry.AddString("Asia/Pacific Region");
	m_cCountry.AddString("Australia");
	m_cCountry.AddString("Austria");
	m_cCountry.AddString("Azerbaijan");
	m_cCountry.AddString("Bahamas");
	m_cCountry.AddString("Bahrain");
	m_cCountry.AddString("Bangladesh");
	m_cCountry.AddString("Barbados");
	m_cCountry.AddString("Belarus");
	m_cCountry.AddString("Belgium");
	m_cCountry.AddString("Belize");
	m_cCountry.AddString("Benin");
	m_cCountry.AddString("Bermuda");
	m_cCountry.AddString("Bhutan");
	m_cCountry.AddString("Bolivia");
	m_cCountry.AddString("Bosnia and Herzegovina");
	m_cCountry.AddString("Botswana");
	m_cCountry.AddString("Bouvet Island");
	m_cCountry.AddString("Brazi");
	m_cCountry.AddString("British Indian Ocean Territory");
	m_cCountry.AddString("Brunei Darussalam");
	m_cCountry.AddString("Bulgaria");
	m_cCountry.AddString("Burkina Faso");
	m_cCountry.AddString("Burundi");
	m_cCountry.AddString("Cambodia");
	m_cCountry.AddString("Cameroon");
	m_cCountry.AddString("Canada");
	m_cCountry.AddString("Cape Verde");
	m_cCountry.AddString("Cayman Islands");
	m_cCountry.AddString("Central African Republic");
	m_cCountry.AddString("Chad");
	m_cCountry.AddString("Chile");
	m_cCountry.AddString("China");
	m_cCountry.AddString("Cocos Islands");
	m_cCountry.AddString("Colombia");
	m_cCountry.AddString("Comoros");
	m_cCountry.AddString("Congo");
	m_cCountry.AddString("Cook Islands");
	m_cCountry.AddString("Costa Rica");
	m_cCountry.AddString("Cote D'Ivoire");
	m_cCountry.AddString("Croatia");
	m_cCountry.AddString("Cuba");
	m_cCountry.AddString("Cyprus");
	m_cCountry.AddString("Czech Republic");
	m_cCountry.AddString("Denmark");
	m_cCountry.AddString("Djibouti");
	m_cCountry.AddString("Dominica");
	m_cCountry.AddString("East Timor");
	m_cCountry.AddString("Ecuador");
	m_cCountry.AddString("Egypt");
	m_cCountry.AddString("El Salvador");
	m_cCountry.AddString("Equatorial Guinea");
	m_cCountry.AddString("Eritrea");
	m_cCountry.AddString("Estonia");
	m_cCountry.AddString("Ethiopia");
	m_cCountry.AddString("Falkland Islands (Malvinas)");
	m_cCountry.AddString("Faroe Islands");
	m_cCountry.AddString("Fiji");
	m_cCountry.AddString("Finland");
	m_cCountry.AddString("France");
	m_cCountry.AddString("French Guiana");
	m_cCountry.AddString("French Polynesia");
	m_cCountry.AddString("Gabon");
	m_cCountry.AddString("Gambia");
	m_cCountry.AddString("Georgia");
	m_cCountry.AddString("Germany");
	m_cCountry.AddString("Ghana");
	m_cCountry.AddString("Gibraltar");
	m_cCountry.AddString("Greece");
	m_cCountry.AddString("Greenland");
	m_cCountry.AddString("Grenada");
	m_cCountry.AddString("Guadeloupe");
	m_cCountry.AddString("Guam");
	m_cCountry.AddString("Guatemala");
	m_cCountry.AddString("Guernsey");
	m_cCountry.AddString("Guinea");
	m_cCountry.AddString("Guinea-Bissau");
	m_cCountry.AddString("Guyana");
	m_cCountry.AddString("Haiti");
	m_cCountry.AddString("Heard Island and McDonald Islands");
	m_cCountry.AddString("Holy See (Vatican City State)");
	m_cCountry.AddString("Honduras");
	m_cCountry.AddString("Hong Kong");
	m_cCountry.AddString("Hungary");
	m_cCountry.AddString("Iceland");
	m_cCountry.AddString("India");
	m_cCountry.AddString("Indonesia");
	m_cCountry.AddString("Iran");
	m_cCountry.AddString("Iraq");
	m_cCountry.AddString("Ireland");
	m_cCountry.AddString("Isle of Man");
	m_cCountry.AddString("Israe");
	m_cCountry.AddString("Italy");
	m_cCountry.AddString("Jamaica");
	m_cCountry.AddString("Japan");
	m_cCountry.AddString("Jersey");
	m_cCountry.AddString("Jordan");
	m_cCountry.AddString("Kazakstan");
	m_cCountry.AddString("Kenya");
	m_cCountry.AddString("Kiribati");
	m_cCountry.AddString("Korea");
	m_cCountry.AddString("Kuwait");
	m_cCountry.AddString("Kyrgyzstan");
	m_cCountry.AddString("Lao People's Democratic Republic");
	m_cCountry.AddString("Latvia");
	m_cCountry.AddString("Lebanon");
	m_cCountry.AddString("Lesotho");
	m_cCountry.AddString("Liberia");
	m_cCountry.AddString("Libyan Arab Jamahiriya");
	m_cCountry.AddString("Liechtenstein");
	m_cCountry.AddString("Lithuania");
	m_cCountry.AddString("Luxembourg");
	m_cCountry.AddString("Macau");
	m_cCountry.AddString("Macedonia");
	m_cCountry.AddString("Madagascar");
	m_cCountry.AddString("Malawi");
	m_cCountry.AddString("Malaysia");
	m_cCountry.AddString("Maldives");
	m_cCountry.AddString("Mali");
	m_cCountry.AddString("Malta");
	m_cCountry.AddString("Marshall Islands");
	m_cCountry.AddString("Martinique");
	m_cCountry.AddString("Mauritania");
	m_cCountry.AddString("Mauritius");
	m_cCountry.AddString("Mayotte");
	m_cCountry.AddString("Mexico");
	m_cCountry.AddString("Micronesia, Federated States of");
	m_cCountry.AddString("Moldova, Republic of");
	m_cCountry.AddString("Monaco");
	m_cCountry.AddString("Mongolia");
	m_cCountry.AddString("Montenegro");
	m_cCountry.AddString("Montserrat");
	m_cCountry.AddString("Morocco");
	m_cCountry.AddString("Mozambique");
	m_cCountry.AddString("Myanmar");
	m_cCountry.AddString("Namibia");
	m_cCountry.AddString("Nauru");
	m_cCountry.AddString("Nepa");
	m_cCountry.AddString("Netherlands");
	m_cCountry.AddString("Netherlands Antilles");
	m_cCountry.AddString("New Caledonia");
	m_cCountry.AddString("New Zealand");
	m_cCountry.AddString("Nicaragua");
	m_cCountry.AddString("Niger");
	m_cCountry.AddString("Nigeria");
	m_cCountry.AddString("Niue");
	m_cCountry.AddString("Norfolk Island");
	m_cCountry.AddString("Northern Mariana Islands");
	m_cCountry.AddString("Norway");
	m_cCountry.AddString("Oman");
	m_cCountry.AddString("Pakistan");
	m_cCountry.AddString("Palau");
	m_cCountry.AddString("Palestinian Territory, Occupied");
	m_cCountry.AddString("Panama");
	m_cCountry.AddString("Papua New Guinea");
	m_cCountry.AddString("Paraguay");
	m_cCountry.AddString("Peru");
	m_cCountry.AddString("Philippines");
	m_cCountry.AddString("Pitcairn Islnds");
	m_cCountry.AddString("Poland");
	m_cCountry.AddString("Portuga");
	m_cCountry.AddString("Puerto Rico");
	m_cCountry.AddString("Qatar");
	m_cCountry.AddString("Reunion");
	m_cCountry.AddString("Romania");
	m_cCountry.AddString("Russian Federation");
	m_cCountry.AddString("Rwanda");
	m_cCountry.AddString("Saint Kitts and Nevis");
	m_cCountry.AddString("Saint Lucia");
	m_cCountry.AddString("Saint Pierre and Miquelon");
	m_cCountry.AddString("Saint Vincent and the Grenadines");
	m_cCountry.AddString("Samoa");
	m_cCountry.AddString("San Marino");
	m_cCountry.AddString("Sao Tome and Principe");
	m_cCountry.AddString("Saudi Arabia");
	m_cCountry.AddString("Senega");
	m_cCountry.AddString("Serbia");
	m_cCountry.AddString("Serbia-Montenegro");
	m_cCountry.AddString("Seychelles");
	m_cCountry.AddString("Sierra Leone");
	m_cCountry.AddString("Singapore");
	m_cCountry.AddString("Slovakia");
	m_cCountry.AddString("Slovenia");
	m_cCountry.AddString("Solomon Islands");
	m_cCountry.AddString("Somalia");
	m_cCountry.AddString("South Africa");
	m_cCountry.AddString("Spain");
	m_cCountry.AddString("Sri Lanka");
	m_cCountry.AddString("St. Helena");
	m_cCountry.AddString("Sudan");
	m_cCountry.AddString("Suriname");
	m_cCountry.AddString("Svalbard");
	m_cCountry.AddString("Swaziland");
	m_cCountry.AddString("Sweden");
	m_cCountry.AddString("Switzerland");
	m_cCountry.AddString("Syrian Arab Republic");
	m_cCountry.AddString("Taiwan");
	m_cCountry.AddString("Tajikistan");
	m_cCountry.AddString("Tanzania, United Republic of");
	m_cCountry.AddString("Thailand");
	m_cCountry.AddString("Togo");
	m_cCountry.AddString("Tokelau");
	m_cCountry.AddString("Tonga");
	m_cCountry.AddString("Trinidad and Tobago");
	m_cCountry.AddString("Tunisia");
	m_cCountry.AddString("Turkey");
	m_cCountry.AddString("Turkmenistan");
	m_cCountry.AddString("Turks and Caicos Islands");
	m_cCountry.AddString("Tuvalu");
	m_cCountry.AddString("Uganda");
	m_cCountry.AddString("Ukraine");
	m_cCountry.AddString("United Arab Emirates");
	m_cCountry.AddString("United Kingdom");
	m_cCountry.AddString("USA");
	m_cCountry.AddString("Uruguay");
	m_cCountry.AddString("Uzbekistan");
	m_cCountry.AddString("Vanuatu");
	m_cCountry.AddString("Venezuela");
	m_cCountry.AddString("Vietnam");
	m_cCountry.AddString("Virgin Islands, British");
	m_cCountry.AddString("Virgin Islands, U.S.");
	m_cCountry.AddString("Wallis and Futuna");
	m_cCountry.AddString("Yemen");
	m_cCountry.AddString("Yugoslavia");
	m_cCountry.AddString("Zambia");
	m_cCountry.AddString("Zimbabwe");
	m_cCountry.AddString("[other]");
}

void CLicenseCreateDialog::SetProtectionManager( IProtectionManager* mgr )
{
	m_protectionManager = mgr;
}

void CLicenseCreateDialog::CreateAccountImpl()
{
	if (false == IsValidEditText())
		return;

	SCreateAccountParam param;
	GetAccountParamText(param);
	
	string resultString, resultDetail;
	EPMErrorCode subErrorCode = PMEC_NO_ERROR;
	ECreateAccountResult resultCode = m_protectionManager->RequestCreateAccount(param, subErrorCode);
	if (eCA_Success == resultCode)
	{
		MessageBox("Your account has been created successfully.\n\nPlease check your e-mail for authentication.", "CreateAccount", MB_ICONINFORMATION);
		EndDialog(IDOK);
	}
	else if (eCA_BanCharacter == resultCode)
	{
		MessageBox("Please use only alphanumeric characters for your Username.", "CreateAccount Error", MB_ICONERROR);
		m_eUsername.SetFocus();
	}
	else if (eCA_DuplicateUsername == resultCode)
	{
		MessageBox("Duplicate Username.\n\nPlease try again with another Username.", "CreateAccount Error", MB_ICONERROR);
		m_eUsername.SetFocus();
	}
	else if (eCA_DuplicateEmail == resultCode)
	{
		MessageBox("Duplicate e-mail address.\n\nPlease try again with another e-mail address.", "CreateAccount Error", MB_ICONERROR);
		m_eEmail.SetFocus();
	}
	else if (eCA_InvalidDomain == resultCode)
	{
		MessageBox("The e-mail domain must comply with your Universities domain.\n\nPlease try again with valid e-mail domain.", "CreateAccount Error", MB_ICONERROR);
		m_eEmail.SetFocus();
	}
	else if (eCA_Undefined == resultCode)
	{
		if (PMEC_NO_ERROR == subErrorCode)
		{
			MessageBox("Undefined error.\n\nPlease try again later.", "CreateAccount Error", MB_ICONERROR);
		}
		else
		{
			const int ErrorMessageSize = 1024;
			char titleErrorMessage[ErrorMessageSize] = {0,};
			char captionErrorMessage[ErrorMessageSize] = {0,};
			m_protectionManager->GetSpecificErrorMessage(subErrorCode, titleErrorMessage, captionErrorMessage);
			MessageBox(captionErrorMessage, titleErrorMessage, MB_ICONINFORMATION | MB_OK | MB_APPLMODAL | MB_TOPMOST);
		}
	}
}

void CLicenseCreateDialog::MakeEnableInput()
{
	m_buttonSubmit.EnableWindow(TRUE);
	m_buttonCancel.EnableWindow(TRUE);
}

void CLicenseCreateDialog::MakeDisableInput()
{
	m_buttonSubmit.EnableWindow(FALSE);
	m_buttonCancel.EnableWindow(FALSE);
}

void CLicenseCreateDialog::GetAccountParamText( SCreateAccountParam& param )
{
	ConvertEditText(m_eUsername, param.username);
	ConvertEditText(m_ePassword, param.password);
	ConvertEditText(m_eFirstname, param.firstname);
	ConvertEditText(m_eLastname, param.lastname);
	ConvertEditText(m_eEmail, param.email);
	ConvertEditText(m_eAddress, param.address);
	ConvertEditText(m_eCity, param.city);
	ConvertEditText(m_eState, param.state);
	ConvertEditText(m_eZipcode, param.zipcode);

	string encodedPassword = Base64Encode((const uint8*)param.password.c_str(), param.password.length());
	param.password = encodedPassword;

	CString countryText;
	m_cCountry.GetWindowText(countryText);
	param.country.assign(countryText.GetString(), countryText.GetLength());
}

void CLicenseCreateDialog::ConvertEditText( CEdit& editObj, string& text )
{
	CString cstringText;
	editObj.GetWindowText(cstringText);
	text.assign(cstringText.GetString(), cstringText.GetLength());
}

bool CLicenseCreateDialog::CheckUsernameEdit()
{
	CString editText;
	m_eUsername.GetWindowText(editText);
	if (editText.IsEmpty())
	{
		char message[MessageBuffersize] = {0,};
		sprintf_s(message, MessageBuffersize, "Please fill %s.", "Username");
		MessageBox(message, "Error", MB_ICONERROR);
		m_eUsername.SetFocus();
		return false;
	}
	if (editText.GetLength() < MinTextLength)
	{
		char message[MessageBuffersize] = {0,};
		sprintf_s(message, MessageBuffersize, "Username must be longer than %d.", MinTextLength);
		MessageBox(message, "Error", MB_ICONERROR);
		m_eUsername.SetFocus();
		return false;
	}
	if (editText.GetLength() > MaxTextLength)
	{
		char message[MessageBuffersize] = {0,};
		sprintf_s(message, MessageBuffersize, "Username must be less than %d.", MaxTextLength);
		MessageBox(message, "Error", MB_ICONERROR);
		m_eUsername.SetFocus();
		return false;
	}
	return true;
}

bool CLicenseCreateDialog::CheckPasswordEdit()
{
	CString editText;
	m_ePassword.GetWindowText(editText);
	if (editText.IsEmpty())
	{
		char message[MessageBuffersize] = {0,};
		sprintf_s(message, MessageBuffersize, "Please fill Password.");
		MessageBox(message, "Error", MB_ICONERROR);
		m_ePassword.SetFocus();
		return false;
	}
	if (editText.GetLength() < MinTextLength)
	{
		char message[MessageBuffersize] = {0,};
		sprintf_s(message, MessageBuffersize, "Password must be longer than %d.", MinTextLength);
		MessageBox(message, "Error", MB_ICONERROR);
		m_ePassword.SetFocus();
		return false;
	}
	if (editText.GetLength() > MaxTextLength)
	{
		char message[MessageBuffersize] = {0,};
		sprintf_s(message, MessageBuffersize, "Password must be less than %d.", MaxTextLength);
		MessageBox(message, "Error", MB_ICONERROR);
		m_ePassword.SetFocus();
		return false;
	}
	return true;
}
#endif // USING_LICENSE_PROTECTION