////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek GmbH, 2002.
// -------------------------------------------------------------------------
//  File name:   LinkTool.h
//  Version:     v1.00
//  Created:     5/7/2002 by Lennert.
//  Compilers:   Visual C++ 6.0
//  Description: Definition of CLinkTool, tool used to link objects.
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __LinkTool_h__
#define __LinkTool_h__

#if _MSC_VER > 1000
#pragma once
#endif


//////////////////////////////////////////////////////////////////////////
class CLinkTool : public CEditTool,public IObjectSelectCallback
{
private:
	CBaseObject *m_pChild;
	Vec3 m_StartDrag;
	Vec3 m_EndDrag;
public:
	DECLARE_DYNAMIC(CLinkTool)

	CLinkTool(); // IPickObjectCallback *callback,CRuntimeClass *targetClass=NULL );

	// Ovverides from CEditTool
	bool MouseCallback( CViewport *view,EMouseEvent event,CPoint &point,int flags );

	virtual void BeginEditParams( IEditor *ie,int flags ) {};
	virtual void EndEditParams() {};

	virtual void Display( DisplayContext &dc );
	virtual bool OnKeyDown( CViewport *view,uint32 nChar,uint32 nRepCnt,uint32 nFlags );
	virtual bool OnKeyUp( CViewport *view,uint32 nChar,uint32 nRepCnt,uint32 nFlags ) { return false; };

	virtual bool OnSelectObject( CBaseObject *obj ) {return false;}
	virtual bool CanSelectObject( CBaseObject *obj ) { return true; };

	virtual bool OnSetCursor( CViewport *vp );

	void LinkSelectedToParent(CBaseObject * pParent);

protected:
	virtual ~CLinkTool();
	// Delete itself.
	void DeleteThis() { delete this; };

private:
	bool IsRelevant( CBaseObject *obj ) { return true; }
	bool ChildIsValid(CBaseObject *pParent, CBaseObject *pChild, int nDir=3);
	void LinkObject( CBaseObject * pChild, CBaseObject * pParent ); 

	HCURSOR m_hLinkCursor;
	HCURSOR m_hLinkNowCursor;
	HCURSOR m_hCurrCursor;
};


#endif // __LinkTool_h__
