#ifndef __AICoverSurface_h__
#define __AICoverSurface_h__

#pragma once


#include "BaseObject.h"

#include <ICoverSystem.h>


class CAICoverSurface
	: public CBaseObject
{
public:
	DECLARE_DYNCREATE(CAICoverSurface)

	enum EGenerateResult
	{
		Success = 0,
		Error,
	};

	virtual bool Init(IEditor* editor, CBaseObject *prev, const CString &file);
	virtual void InvalidateTM(int whyFlags);

	virtual void Serialize(CObjectArchive& archive);
	virtual XmlNodeRef Export(const CString &levelPath, XmlNodeRef &xmlNode);

	virtual void DeleteThis();
	virtual void Display(DisplayContext& disp);

	virtual int MouseCreateCallback(CViewport* view, EMouseEvent event, CPoint& point, int flags);
	virtual bool HitTest(HitContext& hitContext);
	virtual void GetLocalBounds(AABB &aabb);

	virtual void SetHelperScale(float scale);
	virtual float GetHelperScale();

	virtual void BeginEditParams(IEditor* editor, int flags);
	virtual void EndEditParams(IEditor* editor);

	virtual void BeginEditMultiSelParams(bool allSameType);
	virtual void EndEditMultiSelParams();

	float GetHelperSize() const;

	const CoverSurfaceID& GetSurfaceID() const;
	void SetSurfaceID(const CoverSurfaceID& coverSurfaceID);
	void Generate();

	template<typename T>
	void SerializeVar(CObjectArchive& archive, const char* name, CSmartVariable<T>& value)
	{
		if (archive.bLoading)
		{
			T saved;
			if (archive.node->getAttr(name, saved))
				value = saved;
		}
		else
			archive.node->setAttr(name, value);
	};

	template<typename T>
	void SerializeVarEnum(CObjectArchive& archive, const char* name, CSmartVariableEnum<T>& value)
	{
		if (archive.bLoading)
		{
			T saved;
			if (archive.node->getAttr(name, saved))
				value = saved;
		}
		else
			archive.node->setAttr(name, (T&)value);
	};

	template<>
	void SerializeVarEnum<CString>(CObjectArchive& archive, const char* name, CSmartVariableEnum<CString>& value)
	{
		if (archive.bLoading)
		{
			const char* saved;
			if (archive.node->getAttr(name, &saved))
				value = saved;
		}
		else
		{
			CString current;
			value->Get(current);

			archive.node->setAttr(name, current.GetString());
		}
	};

	template<typename T>
	void SerializeValue(CObjectArchive& archive, const char* name, T& value)
	{
		if (archive.bLoading)
			archive.node->getAttr(name, value);
		else
			archive.node->setAttr(name, value);
	};

	template<>
	void SerializeValue<CString>(CObjectArchive& archive, const char* name, CString& value)
	{
		if (archive.bLoading)
		{
			const char* saved;
			if (archive.node->getAttr(name, &saved))
				value = saved;
		}
		else
			archive.node->setAttr(name, value.GetString());
	};


protected:
	CAICoverSurface();
	virtual ~CAICoverSurface();

	void CreateSampler();
	void ReleaseSampler();
	void StartSampling();

	void SetPropertyVarsFromParams(const ICoverSampler::Params& params);
	ICoverSampler::Params GetParamsFromPropertyVars();

	void CommitSurface();
	void ClearSurface();

	void UpdatePropertyVars();
	void OnPropertyVarChange(IVariable* var);

	void CreatePropertyVars();
	void ClonePropertyVars(CVarBlockPtr originalPropertyVars);
	_smart_ptr<CVarBlock> m_propertyVars;

	CSmartVariableEnum<CString> m_samplerVar;
	
	CSmartVariable<float> m_limitLeftVar;
	CSmartVariable<float> m_limitRightVar;
	CSmartVariable<float> m_limitDepthVar;
	CSmartVariable<float> m_limitHeightVar;

	CSmartVariable<float> m_widthIntervalVar;
	CSmartVariable<float> m_heightIntervalVar;

	CSmartVariable<float> m_heightGapToleranceVar;
	CSmartVariable<float> m_widthGapToleranceVar;

	CSmartVariable<bool> m_simplifyVar;
	CSmartVariable<bool> m_refineEdgesVar;

	ICoverSampler* m_sampler;
	CoverSurfaceID m_surfaceID;
	float m_helperScale;
};


class CAICoverSurfaceClassDesc : public CObjectClassDesc
{
public:
	REFGUID ClassID()
	{
		// {27D79905-BC77-4175-BF36-D2D162B0309C}
		static const GUID guid = { 0x27d79905, 0xbc77, 0x4175, { 0xbf, 0x36, 0xd2, 0xd1, 0x62, 0xb0, 0x30, 0x9c } };

		return guid;
	}

	ObjectType GetObjectType()
	{
		return OBJTYPE_COVERSURFACE;
	}

	const char* ClassName()
	{
		return "CoverSurface"; 
	}

	const char* Category()
	{
		return "AI";
	}

	CRuntimeClass* GetRuntimeClass()
	{
		return RUNTIME_CLASS(CAICoverSurface);
	}

	int GameCreationOrder()
	{
		return 151; // after brushes
	}
};


#endif