////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2009.
// -------------------------------------------------------------------------
//  File name:   Wave.cpp
//  Version:     v1.00
//  Created:     2.09.2009 by Evgeny.
//  Compilers:   Visual Studio.NET
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "AIWave.h"

#include "AIWavePanel.h"

#include "AI/AIManager.h"


IMPLEMENT_DYNCREATE(CAIWaveObject, CEntity)


//////////////////////////////////////////////////////////////////////////
CAIWaveObject::CAIWaveObject()
{
	m_entityClass = "AIWave";
	UseMaterialLayersMask(false);
}

void CAIWaveObject::BeginEditParams(IEditor* ie, int flags)
{
	CBaseObject::BeginEditParams(ie, flags);	// First add standard dialogs

	if (!CEntity::m_panel)
	{
		CEntity::m_panel = new CAIWavePanel(AfxGetMainWnd());
		CEntity::m_panel->Create(CAIWavePanel::IDD, AfxGetMainWnd());
		CEntity::m_rollupId = AddUIPage(CString("Entity: ") + m_entityClass, CEntity::m_panel);
	}
	if (CEntity::m_panel && CEntity::m_panel->m_hWnd)
	{
		CEntity::m_panel->SetEntity(this);
		static_cast<CAIWavePanel*>(CEntity::m_panel)->UpdateAssignedAIsPanel();
	}

	CEntity::BeginEditParams( ie,flags ); // At the end add entity dialogs.
}

void CAIWaveObject::BeginEditMultiSelParams(bool bAllOfSameType)
{
	CBaseObject::BeginEditMultiSelParams(bAllOfSameType);

	if (!CEntity::m_panel)
	{
		CEntity::m_panel = new CAIWavePanel(AfxGetMainWnd());
		CEntity::m_panel->Create(CAIWavePanel::IDD, AfxGetMainWnd());
		CEntity::m_rollupId = AddUIPage(CString(m_entityClass) + " and other Entities", CEntity::m_panel);
	}
	if (CEntity::m_panel && CEntity::m_panel->m_hWnd)
	{
		static_cast<CAIWavePanel*>(CEntity::m_panel)->UpdateAssignedAIsPanel();
	}
}

void CAIWaveObject::EndEditMultiSelParams()
{
	if (m_rollupId != 0)
	{
		RemoveUIPage( m_rollupId );
	}
	m_rollupId = 0;
	m_panel = 0;

	CBaseObject::EndEditMultiSelParams();
}

void CAIWaveObject::SetName(const CString& newName)
{
	CString oldName = GetName();

	__super::SetName(newName);

	GetIEditor()->GetAI()->GetAISystem()->Reset(IAISystem::RESET_INTERNAL);

	GetObjectManager()->FindAndRenameProperty2("aiwave_Wave", oldName, newName);
}
