////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2009.
// -------------------------------------------------------------------------
//  File name:   Wave.h
//  Version:     v1.00
//  Created:     2.09.2009 by Evgeny.
//  Compilers:   Visual Studio.NET
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __aiwave_h__
#define __aiwave_h__

#if _MSC_VER > 1000
#pragma once
#endif

#include "Entity.h"


class CAIWaveObject : public CEntity
{
public:
	DECLARE_DYNCREATE(CAIWaveObject)

	virtual void InitVariables() {}

	void BeginEditParams(IEditor* ie, int flags);
	void BeginEditMultiSelParams(bool bAllOfSameType);
	void EndEditMultiSelParams();
	
	void SetName(const CString& newName);
	
protected:
	//! Ctor must be protected.
	CAIWaveObject();

	void DeleteThis() { delete this; };
};


class CAIWaveObjectClassDesc : public CObjectClassDesc
{
public:
	REFGUID ClassID()
	{
		// {10E57056-78C7-489e-B230-89B673196DE5}
		static const GUID guid = { 0x10e57056, 0x78c7, 0x489e, { 0xb2, 0x30, 0x89, 0xb6, 0x73, 0x19, 0x6d, 0xe5 } };
		return guid;
	};
	ObjectType GetObjectType() { return OBJTYPE_ENTITY; };
	const char* ClassName() { return "Entity::AIWave"; };
	const char* Category() { return ""; };
	CRuntimeClass* GetRuntimeClass() { return RUNTIME_CLASS(CAIWaveObject); };
	int GameCreationOrder() { return 51; }; // Should be created after AITerritories
};

#endif // __aiwave_h__