#include "StdAfx.h"
#include "HelpLink.h"

#include "Settings.h"

IMPLEMENT_DYNCREATE( CHelpLink, CBaseObject )

CHelpLink::CHelpLink()
{
	AddVariable( m_label, "Label" );
	AddVariable( m_link, "Link" );
}

void CHelpLink::OnEvent( ObjectEvent event )
{
	if ( event == EVENT_DBLCLICK )
	{
		const CString& url = ( CString )( m_link );
		bool isHttpUrl = ( url.Left( 7 ).CompareNoCase( "http://" ) == 0 );
		bool isFileUrl = ( url.Left( 7 ).CompareNoCase( "file://" ) == 0 );
		bool isValidUrl = ( isHttpUrl || isFileUrl );
		if ( ! isValidUrl )
		{
			return;
		}

		SHELLEXECUTEINFO shellInfo = { 0 };

		shellInfo.cbSize = sizeof( shellInfo );
		shellInfo.fMask = SEE_MASK_NOCLOSEPROCESS | SEE_MASK_FLAG_NO_UI;
		shellInfo.lpFile = url;
		shellInfo.nShow = SW_SHOWNORMAL;
		shellInfo.lpVerb = "open";

		ShellExecuteEx( &shellInfo );

		return;
	}

	CBaseObject::OnEvent( event );
}

void CHelpLink::Display( DisplayContext& dc )
{
	const Matrix34& wtm = GetWorldTM();

	Vec3 wp = wtm.GetTranslation();

	dc.SetColor( RGB( 255, 255, 255 ) );

	const char* szText = ( CString )( m_label );
	dc.DrawTextLabel( wp + Vec3( 0, 0, 1 ), 1.2f, szText );

	DrawDefault( dc );
}

XmlNodeRef CHelpLink::Export( const CString& levelPath, XmlNodeRef& xmlNode )
{
	return 0;
}

void CHelpLink::GetLocalBounds( AABB& box )
{
	float r = 20;
	box.min = -Vec3( r, r, r );
	box.max = Vec3( r, r, r );
}