#ifndef __Help_Link__h__
#define __Help_Link__h__
#pragma once

#include "BaseObject.h"

class CHelpLink
	: public CBaseObject
{
public:
	DECLARE_DYNCREATE( CHelpLink )

	virtual void Display( DisplayContext& disp );

	virtual XmlNodeRef Export( const CString& levelPath, XmlNodeRef& xmlNode );

	virtual void OnEvent( ObjectEvent event );

	virtual void GetLocalBounds( AABB& box );

protected:
	CHelpLink();

	virtual void DeleteThis() { delete this; }

	CVariable< CString > m_label;
	CVariable< CString > m_link;
};

class CHelpLinkClassDesc
	: public CObjectClassDesc
{
public:
	virtual REFGUID ClassID()
	{
		// {A64102BA-2521-4260-92D1-A893F841B53A}
		static const GUID guid = 
		{ 0xa64102ba, 0x2521, 0x4260, { 0x92, 0xd1, 0xa8, 0x93, 0xf8, 0x41, 0xb5, 0x3a } };
		return guid;
	}
	virtual ObjectType GetObjectType() { return OBJTYPE_TAGPOINT; }
	virtual const char* ClassName() { return "HelpLink"; }
	virtual const char* Category() { return "Misc"; }
	virtual CRuntimeClass* GetRuntimeClass() { return RUNTIME_CLASS( CHelpLink ); }
	virtual const char* GetTextureIcon() { return "Editor/ObjectIcons/HelpLink.bmp"; }
};

#endif