/*************************************************************************
Crytek Source File.
Copyright (C), Crytek Studios, 2001-2008.
-------------------------------------------------------------------------
$Id: CIrradianceVolumeObject.h,v 1.0 2008/05/19 12:14:13 AntonKaplanyan Exp wwwrun $
$DateTime$
Description:  Routine for rendering and managing of irradiance volumetric data
-------------------------------------------------------------------------
History:
- 12:6:2008   12:14 : Created by Anton Kaplanyan
*************************************************************************/

#ifndef __irrvolumeobject_h__
#define __irrvolumeobject_h__

#if _MSC_VER > 1000
#pragma once
#endif

#include "BaseObject.h"

/*!
 *	CTagPoint is an object that represent named 3d position in world.
 */
class CIrradianceVolumeObject : public CBaseObject
{
public:
	DECLARE_DYNCREATE(CIrradianceVolumeObject)

	//////////////////////////////////////////////////////////////////////////
	// Ovverides from CBaseObject.
	//////////////////////////////////////////////////////////////////////////
	virtual bool Init( IEditor *ie,CBaseObject *prev,const CString &file );
	/** Called when object is about to be deleted.
	All Game resources should be freed in this function.
	*/
	virtual void Done();
	virtual void Display( DisplayContext &dc );

	virtual void GetLocalBounds( AABB &box );

	virtual bool HitTest( HitContext &hc );

	//! Called when object is being created.
	virtual int MouseCreateCallback( CViewport *view,EMouseEvent event,CPoint &point,int flags );

	virtual bool CreateGameObject();

	//////////////////////////////////////////////////////////////////////////
	// parameters.
	//////////////////////////////////////////////////////////////////////////
	CVariable<float>		m_fDensity;
	CVariable<bool>			m_bSpecular;
	CVariable<bool>			m_bAutofit;

	//////////////////////////////////////////////////////////////////////////
	// Local callbacks.

	void OnDensityChange(IVariable *pVar);
	void OnSpecularChange(IVariable *pVar);
	void OnAutofitChange(IVariable *pVar);

protected:
	//! Dtor must be protected.
	CIrradianceVolumeObject();
	virtual ~CIrradianceVolumeObject();

	//! Convert ray given in world coordinates to the ray in local coordinates.
	void DeleteThis() { delete this; };

	// Invalidates cached transformation matrix.
	// nWhyFlags - Flags that indicate the reason for matrix invalidation.
	virtual void InvalidateTM( int nWhyFlags );

	bool				m_bNeedUpdateUI;		// flag to update Editor UI

	AABB				m_bbox;

	IIrradianceVolumeRenderNode* m_pIrradianceVolumeRenderNode;
};

/*!
 * Class Description of CIrradianceVolumeObject.	
 */
class CIrradianceVolumeObjectClassDesc : public CObjectClassDesc
{
public:
	REFGUID ClassID()
	{
		// {1B1E002A-D58C-4b7c-B108-C554180657FF}
		static const GUID guid = { 0x1b1e002a, 0xd58c, 0x4b7c, { 0xb1, 0x8, 0xc5, 0x54, 0x18, 0x6, 0x57, 0xff } };
		return guid;
	}
	ObjectType GetObjectType() { return OBJTYPE_VOLUME; };
	const char* ClassName() { return "IrradianceVolume"; };
	const char* Category() { return "Area"; };
	CRuntimeClass* GetRuntimeClass() { return RUNTIME_CLASS(CIrradianceVolumeObject); };
	const char* GetFileSpec() { return ""; };
	int GameCreationOrder() { return 150; };
	virtual const char* GetTextureIcon() { return "Editor/ObjectIcons/IrradianceVolume.bmp"; };
};

#endif // __irrvolumeobject_h__