#include "StdAfx.h"
#include "Light.h"
#include "../LightPanel.h"

/*

  CLight

*/

IMPLEMENT_DYNCREATE(CLight, CEntity)

//

CLightPanel *CLight::s_pPanel = NULL;
int CLight::s_panelID = NULL;

//

CLight::CLight()
{
	m_entityClass = "Light";
}

//

bool CLight::Init(IEditor *pEditor, CBaseObject *pPrev, const CString &file)
{
	if (!CEntity::Init(pEditor, pPrev, file))
		return false;

	return true;
}

void CLight::BeginEditParams(IEditor *pEditor, int flags)
{
	CBaseObject::BeginEditParams(pEditor, flags);
//	CEntity::BeginEditParams(pEditor, flags);

	if (!s_panelID)
	{
		s_pPanel = new CLightPanel();
		s_pPanel->Create(CLightPanel::IDD, AfxGetMainWnd());
		s_panelID = pEditor->AddRollUpPage(ROLLUP_OBJECTS, "Light", s_pPanel);
	}

	if (s_pPanel)
	{
		s_pPanel->SetEntity(this);
	}
}

void CLight::EndEditParams(IEditor *pEditor)
{
	if (s_panelID)
	{
		pEditor->RemoveRollUpPage(ROLLUP_OBJECTS, s_panelID);
		s_panelID = NULL;
		s_pPanel = NULL;
	}

	CBaseObject::EndEditParams(pEditor);
//	CEntity::EndEditParams(pEditor);
}
