#ifndef __Light_h_
#define __Light_h_

#if _MSC_VER > 1000
#pragma once
#endif

#include "Entity.h"
#include "../LightPanel.h"

class CLight :
	public CEntity
{
public:
	DECLARE_DYNCREATE(CLight)

private:
	static CLightPanel *s_pPanel;
	static int s_panelID;

public:
	CLight();

public:
	virtual bool Init(IEditor *pEditor, CBaseObject *pPrev, const CString &file);

	virtual void BeginEditParams(IEditor *pEditor, int flags);
	virtual void EndEditParams(IEditor *pEditor);
};

class CLightClassDesc :
	public CObjectClassDesc
{
public:
	REFGUID ClassID()
	{
		// {40226B9D-7BA3-415a-835D-B1FF5B1B4BBF}
		static const GUID guid = { 0x40226b9d, 0x7ba3, 0x415a, { 0x83, 0x5d, 0xb1, 0xff, 0x5b, 0x1b, 0x4b, 0xbf } };
		return guid;
	}
	ObjectType GetObjectType() { return OBJTYPE_ENTITY; }
	const char *ClassName() { return "StdLight"; }
	const char *Category() { return "Light"; }
	CRuntimeClass *GetRuntimeClass() { return RUNTIME_CLASS(CLight); }
};

#endif // __Light_h_
