////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2010.
// -------------------------------------------------------------------------
//  File name:   LightBox.cpp
//  Version:     v1.00
//  Created:     18/03/2010 by Martin Sherburn.
//  Description: CLightBox implementation.
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "LightBox.h"

//////////////////////////////////////////////////////////////////////////
// CBase implementation.
//////////////////////////////////////////////////////////////////////////
IMPLEMENT_DYNCREATE(CLightBox,CEntity)

//////////////////////////////////////////////////////////////////////////
CLightBox::CLightBox()
{
	mv_originAtCorner = true;
	m_entityClass = "LightBox";

	m_box.min=ZERO;
	m_box.max=Vec3(mv_width, mv_length, mv_height);
}

//////////////////////////////////////////////////////////////////////////
void CLightBox::InitVariables()
{
	CAreaBox::InitVariables();
	AddVariable( mv_originAtCorner,"OriginAtCorner",functor(*this, &CLightBox::OnSizeChange) );
}

//////////////////////////////////////////////////////////////////////////
void CLightBox::OnSizeChange(IVariable *pVar)
{
	Vec3 size( 0,0,0 );
	size.x = mv_width;
	size.y = mv_length;
	size.z = mv_height;

	if (mv_originAtCorner)
	{
		m_box.min = ZERO;
		m_box.max = size;
	}
	else
	{
		m_box.min = -size/2;
		m_box.max = size/2;
		// Make volume position bottom of bounding box.
		m_box.min.z = 0;
		m_box.max.z = size.z;
	}
	UpdateGameArea();
}
