////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2010.
// -------------------------------------------------------------------------
//  File name:   LightBox.h
//  Version:     v1.00
//  Created:     18/03/2010 by Martin Sherburn.
//  Description: CLightBox object definition.
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifndef __LightBox_h__
#define __LightBox_h__

#if _MSC_VER > 1000
#pragma once
#endif

#include "Entity.h"
#include "AreaBox.h"

class CLightBox : public CAreaBox
{
public:
	DECLARE_DYNCREATE(CLightBox)

	virtual void InitVariables();

protected:
	CLightBox();

	virtual void OnSizeChange(IVariable *pVar);

	CVariable<bool> mv_originAtCorner;
};

/*!
 * Class Description of LightBox.
 */
class CLightBoxClassDesc : public CObjectClassDesc
{
public:
	REFGUID ClassID()
	{
		// {5FF7FC57-8AF2-428e-AEC6-FABB4F59358A}
		static const GUID guid = { 0x5ff7fc57, 0x8af2, 0x428e, { 0xae, 0xc6, 0xfa, 0xbb, 0x4f, 0x59, 0x35, 0x8a } };
		return guid;
	}
	ObjectType GetObjectType() { return OBJTYPE_VOLUME; };
	const char* ClassName() { return "LightBox"; };
	const char* Category() { return "Area"; };
	CRuntimeClass* GetRuntimeClass() { return RUNTIME_CLASS(CLightBox); };
	int GameCreationOrder() { return 53; };
};

#endif // __LightBox_h__