////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2002.
// -------------------------------------------------------------------------
//  File name:   trackviewundo.cpp
//  Version:     v1.00
//  Created:     30/8/2002 by Timur.
//  Compilers:   Visual Studio.NET
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "TrackViewUndo.h"
#include "Objects\SequenceObject.h"
#include <IMovieSystem.h>

//////////////////////////////////////////////////////////////////////////
CUndoTrackObject::CUndoTrackObject( IAnimTrack *track, IAnimSequence* pSequence )
{
	// Stores the current state of this track.
	assert( track != 0 );

	m_pTrack = track;
	m_pSequence = pSequence;

	// Store undo info.
	m_undo = CreateXmlNode("Undo");
	m_pTrack->Serialize( m_undo,false );
	if(m_pSequence)
	{
		CBaseObject* pObj = GetIEditor()->GetObjectManager()->FindObject( m_pSequence->GetName() );
		if(pObj && pObj->IsKindOf(RUNTIME_CLASS(CSequenceObject)))
			pObj->SetLayerModified();
	}
}

//////////////////////////////////////////////////////////////////////////
void CUndoTrackObject::Undo( bool bUndo )
{
	if (!m_undo)
		return;

	if (bUndo)
	{
		m_redo = CreateXmlNode("Redo");
		m_pTrack->Serialize( m_redo,false );
	}
	// Undo track state.
	m_pTrack->Serialize( m_undo,true );
	if(m_pSequence)
	{
		CBaseObject* pObj = GetIEditor()->GetObjectManager()->FindObject( m_pSequence->GetName() );
		if(pObj && pObj->IsKindOf(RUNTIME_CLASS(CSequenceObject)))
			pObj->SetLayerModified();
	}

	if (bUndo)
	{
		// Refresh stuff after undo.
		GetIEditor()->GetAnimation()->ForceAnimation();
		GetIEditor()->UpdateTrackView(true);
	}
}

//////////////////////////////////////////////////////////////////////////
void CUndoTrackObject::Redo()
{
	if (!m_redo)
		return;

	// Redo track state.
	m_pTrack->Serialize( m_redo,true );
	if(m_pSequence)
	{
		CBaseObject* pObj = GetIEditor()->GetObjectManager()->FindObject( m_pSequence->GetName() );
		if(pObj && pObj->IsKindOf(RUNTIME_CLASS(CSequenceObject)))
			pObj->SetLayerModified();
	}

	// Refresh stuff after undo.
	GetIEditor()->GetAnimation()->ForceAnimation();
	GetIEditor()->UpdateTrackView(true);
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
CUndoAnimSequenceObject::CUndoAnimSequenceObject( IAnimSequence *seq )
{
	// Stores the current state of this track.
	assert( seq != 0 );

	m_pSequence = seq;

	// Store undo info.
	m_undo = CreateXmlNode("Undo");
	m_pSequence->Serialize( m_undo,false );

	CBaseObject* pObj = GetIEditor()->GetObjectManager()->FindObject( m_pSequence->GetName() );
	if(pObj && pObj->IsKindOf(RUNTIME_CLASS(CSequenceObject)))
		pObj->SetLayerModified();
}

//////////////////////////////////////////////////////////////////////////
void CUndoAnimSequenceObject::Undo( bool bUndo )
{
	if (!m_undo)
		return;

	if (bUndo)
	{
		m_redo = CreateXmlNode("Redo");
		m_pSequence->Serialize( m_redo,false );
	}
	// Undo track state.
	m_pSequence->Serialize( m_undo,true );
	CBaseObject* pObj = GetIEditor()->GetObjectManager()->FindObject( m_pSequence->GetName() );
	if(pObj && pObj->IsKindOf(RUNTIME_CLASS(CSequenceObject)))
		pObj->SetLayerModified();

	if (bUndo)
	{
		// Refresh stuff after undo.
		GetIEditor()->GetAnimation()->ForceAnimation();
		GetIEditor()->UpdateTrackView(false);
	}
}

//////////////////////////////////////////////////////////////////////////
void CUndoAnimSequenceObject::Redo()
{
	if (!m_redo)
		return;

	// Redo track state.
	m_pSequence->Serialize( m_redo,true );
	CBaseObject* pObj = GetIEditor()->GetObjectManager()->FindObject( m_pSequence->GetName() );
	if(pObj && pObj->IsKindOf(RUNTIME_CLASS(CSequenceObject)))
		pObj->SetLayerModified();

	// Refresh stuff after undo.
	GetIEditor()->GetAnimation()->ForceAnimation();
	GetIEditor()->UpdateTrackView(false);
}