////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2009.
// -------------------------------------------------------------------------
//  File name:   licenseinfo.h
//  Version:     v1.00
//  Created:     11/08/2009 by Younggi Lim
//  Compilers:   Visual Studio.NET
//  Description: encrypt/decrypt buffer 
//               insert licenseInfo file / Check licenseInfo file
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////
#include "StdAfx.h"
#include "LicenseInfo.h"

#ifdef USING_LICENSE_PROTECTION
#include "AesCryptography.h"
#include "PakFile.h"

static uint8 DataXorTable[] = 
{
	0x14,0x2D,0xA2,0xF6,0xB2,0x81,0x1B,0xEB,0x4D,0x8C,0xF4,0xB4,0xC1,0xA2,0x5F,0x28
};

static const char* LicenseFilename = "license.editor_data";
static const size_t LicenseInfoSize = 128;

CLicenseInfo::CLicenseInfo()
{
}

ELicenseFileResult CLicenseInfo::CheckLicenseFile(const char* filename)
{
	char licenseInfoBufferFromMemory[LicenseInfoSize] = {0,};
	GenerateLicenseInfoBuffer(licenseInfoBufferFromMemory, LicenseInfoSize);

	ICryPak *pIPak = GetIEditor()->GetSystem()->GetIPak();
	if (false == pIPak->OpenPack( filename ))
	{
		pIPak->ClosePack(filename);
		return eLF_NoFile;
	}

	ELicenseFileResult result = eLF_Valid;
	CCryFile cfile;
	char* fileBuffer = NULL;
	size_t fileSize  = 0;
	do 
	{
		char licenseInfoBufferFromFile[LicenseInfoSize] = {0,};
		CString path = Path::GetPath(filename);
		if (false == cfile.Open( Path::Make(path,LicenseFilename), "rb" ))
		{
			result = eLF_NoFile;
			break;
		}

		fileSize = cfile.GetLength();
		fileBuffer = new char[fileSize];
		if (false == cfile.ReadRaw(licenseInfoBufferFromFile, LicenseInfoSize))
		{
			result = eLF_Invalid;
			break;
		}

		if (0 != memcmp(licenseInfoBufferFromMemory, licenseInfoBufferFromFile, LicenseInfoSize))
		{
			result = eLF_Invalid;
			break;
		}
	} while(false);

	cfile.Close();
	pIPak->ClosePack(filename);
	if (NULL != fileBuffer)
		delete [] fileBuffer;
	return result;
}

void CLicenseInfo::InsertLicenseInfoFile(CPakFile& pakFile)
{
	char licenseInfoBuffer[LicenseInfoSize] = {0,};
	GenerateLicenseInfoBuffer(licenseInfoBuffer, LicenseInfoSize);
	pakFile.UpdateFile(LicenseFilename, licenseInfoBuffer, LicenseInfoSize);
}

void CLicenseInfo::InsertLicenseInfoFile(const CString& additionalPath, CPakFile& pakFile)
{
	char licenseInfoBuffer[LicenseInfoSize] = {0,};
	GenerateLicenseInfoBuffer(licenseInfoBuffer, LicenseInfoSize);
	CString licenseFileFullPath = additionalPath + LicenseFilename;
	pakFile.UpdateFile(licenseFileFullPath.GetString(), licenseInfoBuffer, LicenseInfoSize);
}

void CLicenseInfo::EncryptBuffer(char* buffer, size_t len)
{
	CString encryptKey;
	GetIEditor()->GetEncryptKey(encryptKey);
	CAesCryptography cryptObj;
	if (false == encryptKey.IsEmpty())
		cryptObj.SetKeyValue((const uint8*)encryptKey.GetString(), encryptKey.GetLength());
	char* outputBuffer = new char[len];
	cryptObj.EncryptBuffer((const uint8*)buffer, len, (uint8*)outputBuffer);
	memcpy(buffer, outputBuffer, len);
	delete [] outputBuffer;
}

void CLicenseInfo::EncryptBuffer(char* inputBuffer, const char* outputBuffer, size_t len)
{
	CString encryptKey;
	GetIEditor()->GetEncryptKey(encryptKey);
	CAesCryptography cryptObj;
	if (false == encryptKey.IsEmpty())
		cryptObj.SetKeyValue((const uint8*)encryptKey.GetString(), encryptKey.GetLength());
	cryptObj.EncryptBuffer((const uint8*)inputBuffer, len, (uint8*)outputBuffer);
}

void CLicenseInfo::DecryptBuffer(char* buffer, size_t len)
{
	CString encryptKey;
	GetIEditor()->GetEncryptKey(encryptKey);
	CAesCryptography cryptObj;
	if (false == encryptKey.IsEmpty())
		cryptObj.SetKeyValue((const uint8*)encryptKey.GetString(), encryptKey.GetLength());
	char* outputBuffer = new char[len];
	cryptObj.DecryptBuffer((const uint8*)buffer, len, (uint8*)outputBuffer);
	memcpy(buffer, outputBuffer, len);
	delete [] outputBuffer;
}

void CLicenseInfo::GenerateLicenseInfoBuffer(char* outputBuffer, size_t len)
{
	const string fakeString = "TheGettingStartedsectioncontainsalltheinformationyoullneedtogettheCryENGINE3SandboxinstalledonyourPCandready";
	CString encryptKey;
	GetIEditor()->GetEncryptKey(encryptKey);
	CAesCryptography cryptObj;
	if (false == encryptKey.IsEmpty())
		cryptObj.SetKeyValue((const uint8*)encryptKey.GetString(), encryptKey.GetLength());
	char xorBuffer[LicenseInfoSize] = {0,};
	int xorTableLength = sizeof(DataXorTable)-1;
	int fakeStringLength = fakeString.length()-1;
	int encryptKeyOffset = 0;
	for(int i=0; i<LicenseInfoSize; ++i)
	{
		xorBuffer[i] = fakeString.at(i%fakeStringLength)^DataXorTable[i%xorTableLength];
		if (i>=20 && i<39)
			xorBuffer[i] = encryptKey.GetAt(encryptKeyOffset++)^DataXorTable[i%xorTableLength];
	}
	cryptObj.EncryptBuffer((const uint8*)xorBuffer, LicenseInfoSize, (uint8*)outputBuffer);
}

#endif // USING_LICENSE_PROTECTION