////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2009.
// -------------------------------------------------------------------------
//  File name:   licenseinfo.h
//  Version:     v1.00
//  Created:     11/08/2009 by Younggi Lim
//  Compilers:   Visual Studio.NET
//  Description: encrypt/decrypt buffer 
//               insert licenseInfo file / Check licenseInfo file
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#ifdef USING_LICENSE_PROTECTION

#ifndef __licenseinfo_h__
#define __licenseinfo_h__

#pragma once

#ifdef USING_TAGES_SECURITY
#	define TAGES_EXPORT __declspec(dllexport)
#else 
#	define TAGES_EXPORT
#endif // USING_TAGES_SECURITY

enum ELicenseFileResult
{
	eLF_NoFile,
	eLF_Invalid,
	eLF_Valid,
};

class CLicenseInfo
{
public:
	CLicenseInfo();

	///////////////////////////////////////////////////////
	// Description:
	//   Check License file is exist / invalid / valid
	///////////////////////////////////////////////////////
	TAGES_EXPORT	ELicenseFileResult CheckLicenseFile(const char* filename);

	/////////////////////////////////////////////////////////
	// Description:
	//   Insert License Information file inside pak(.cry) file
	/////////////////////////////////////////////////////////
	TAGES_EXPORT	void InsertLicenseInfoFile(CPakFile& pakFile);
	TAGES_EXPORT	void InsertLicenseInfoFile(const CString& additionalPath, CPakFile& pakFile);
	TAGES_EXPORT	void EncryptBuffer(char* buffer, size_t len);
	TAGES_EXPORT	void EncryptBuffer(char* inputBuffer, const char* outputBuffer, size_t len);
	TAGES_EXPORT	void DecryptBuffer(char* buffer, size_t len);

protected:
	void GenerateLicenseInfoBuffer(char* outputBuffer, size_t len);
};

#endif // __licenseinfo_h__

#endif // USING_LICENSE_PROTECTION