// HelpersDialog.cpp : implementation file
//

#include "stdafx.h"
#include "HelpersDialog.h"


// CHelpersDialog dialog

IMPLEMENT_DYNAMIC(CHelpersDialog, CDialog)

CHelpersDialog::CHelpersDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CHelpersDialog::IDD, pParent)
{

}

CHelpersDialog::CHelpersDialog(const std::vector<string>& helpers, CWnd* pParent /*=NULL*/)
: CDialog(CHelpersDialog::IDD, pParent)
, m_helpVec(helpers)
{

}

CHelpersDialog::~CHelpersDialog()
{
}

void CHelpersDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_HELPERS_COMBO, m_helpers);
}


BEGIN_MESSAGE_MAP(CHelpersDialog, CDialog)
	ON_CBN_SELENDOK(IDC_HELPERS_COMBO, &CHelpersDialog::OnCbnSelendokHelpersCombo)
END_MESSAGE_MAP()


// CHelpersDialog message handlers

void CHelpersDialog::OnCbnSelendokHelpersCombo()
{
	m_helpers.GetLBText(m_helpers.GetCurSel(), m_selectedHelper);
}

CString CHelpersDialog::GetHelper() const
{
	return m_selectedHelper;
}

BOOL CHelpersDialog::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetWindowText("Select helper");
	
	m_helpers.ResetContent();
	for (int i = 0; i < m_helpVec.size(); ++i)
	{
		m_helpers.AddString(m_helpVec.at(i));
	}
	m_helpers.SetCurSel(-1);

	return TRUE;
}