////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2001-2008.
// -------------------------------------------------------------------------
//  File name:   WeaponEditorDialog.h
//  Version:     v1.00
//  Created:     15-02-2008 by Evgeny Strokov
//  Compilers:   Visual Studio.NET 2005
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////

#include "StdAfx.h"
#include "Resource.h"
#include "WeaponEditorDialog.h"
#include "IViewPane.h"

#include <IItem.h>
#include "ItemSystem.h"
#include "..\..\GameK01\GameDll\WeaponGameObject.h"
#include "..\..\GameK01\GameDll\WeaponAttachment.h"

#define WEAPONEDITOR_FILTER "Weapon Editor Files (*.xml)|*.xml"
#define WEAPONREPLAY_FILTER "Weapon Replay Files (*.xml)|*.xml"

#define IDW_WE_PREVIEW_PANE  AFX_IDW_CONTROLBAR_FIRST+10
#define IDW_WE_SETTINGS_PANE  AFX_IDW_CONTROLBAR_FIRST+11

#define WED_DIALOGFRAME_CLASSNAME "WeaponEditorDialog"

//////////////////////////////////////////////////////////////////////////
IMPLEMENT_DYNCREATE(CWeaponEditorDialog,CXTPFrameWnd)

BEGIN_MESSAGE_MAP(CWeaponEditorDialog, CXTPFrameWnd)
	ON_WM_SIZE()
	ON_WM_CLOSE()
	ON_WM_SETFOCUS()
	ON_WM_DESTROY()

	ON_COMMAND( ID_WEAPON_OPEN, OnFileOpen )
	ON_COMMAND( ID_WEAPON_SAVE, OnFileSave )
	ON_COMMAND( ID_REPLAY_OPEN, OnReplayOpen )
	ON_COMMAND( ID_REPLAY_PLAY, OnReplayPlay )

	ON_MESSAGE(XTPWM_DOCKINGPANE_NOTIFY, OnDockingPaneNotify)

	ON_COMMAND(ID_CHAREDIT_MOVE, OnMoveMode)
	ON_UPDATE_COMMAND_UI(ID_CHAREDIT_MOVE, OnMoveModeUpdateUI)
	ON_COMMAND(ID_CHAREDIT_ROTATE, OnRotateMode)
	ON_UPDATE_COMMAND_UI(ID_CHAREDIT_ROTATE, OnRotateModeUpdateUI)

END_MESSAGE_MAP()
//////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////
class CWeaponEditorViewClass : public TRefCountBase<IViewPaneClass>
{
	//////////////////////////////////////////////////////////////////////////
	// IClassDesc
	//////////////////////////////////////////////////////////////////////////
	virtual ESystemClassID SystemClassID() { return ESYSTEM_CLASS_VIEWPANE; };
	virtual REFGUID ClassID()
	{
		// {1DD3EA98-9718-4150-8CC4-6D7D630F2CEF}
		static const GUID guid = 
		{ 0x1dd3ea98, 0x9718, 0x4150, { 0x8c, 0xc4, 0x6d, 0x7d, 0x63, 0xf, 0x2c, 0xef } };
		return guid;
	}
	virtual const char* ClassName() { return "Weapon Editor"; };
	virtual const char* Category() { return "Weapon Editor"; };
	//////////////////////////////////////////////////////////////////////////
	virtual CRuntimeClass* GetRuntimeClass() { return RUNTIME_CLASS(CWeaponEditorDialog); };
	virtual const char* GetPaneTitle() { return _T("Weapon Editor"); };
	virtual EDockingDirection GetDockingDirection() { return DOCK_FLOAT; };
	virtual CRect GetPaneRect() { return CRect(200,200,600,500); };
	virtual bool SinglePane() { return false; };
	virtual bool WantIdleUpdate() { return true; };
};

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorDialog::RegisterViewClass()
{
	GetIEditor()->GetClassFactory()->RegisterClass( new CWeaponEditorViewClass );
}

//////////////////////////////////////////////////////////////////////////
CWeaponEditorDialog::CWeaponEditorDialog()
: m_pWeapon(NULL)
{
	WNDCLASS wndcls;
	HINSTANCE hInst = AfxGetInstanceHandle();
	if (!(::GetClassInfo(hInst, WED_DIALOGFRAME_CLASSNAME, &wndcls)))
	{
		// otherwise we need to register a new class
		//wndcls.style            = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
		wndcls.style            = CS_DBLCLKS;
		wndcls.lpfnWndProc      = ::DefWindowProc;
		wndcls.cbClsExtra       = wndcls.cbWndExtra = 0;
		wndcls.hInstance        = hInst;
		wndcls.hIcon            = NULL;
		wndcls.hCursor          = AfxGetApp()->LoadStandardCursor(IDC_ARROW);
		wndcls.hbrBackground    = (HBRUSH) (COLOR_3DFACE + 1);
		//wndcls.hbrBackground    = 0;
		wndcls.lpszMenuName     = NULL;
		wndcls.lpszClassName    = WED_DIALOGFRAME_CLASSNAME;
		if (!AfxRegisterClass(&wndcls))
		{
			AfxThrowResourceException();
		}
	}
	CRect rc(0,0,0,0);
	BOOL bRes = Create( WS_CHILD|WS_VISIBLE,rc,AfxGetMainWnd() );
	if (!bRes)
		return;

	GetIEditor()->RegisterNotifyListener(this);

	OnInitDialog();
}

//////////////////////////////////////////////////////////////////////////
CWeaponEditorDialog::~CWeaponEditorDialog()
{
	CleanUpEntity();
	GetIEditor()->UnregisterNotifyListener(this);
}

//////////////////////////////////////////////////////////////////////////
BOOL CWeaponEditorDialog::Create( DWORD dwStyle,const RECT& rect,CWnd* pParentWnd )
{
	return __super::Create(WED_DIALOGFRAME_CLASSNAME, "", dwStyle, rect, pParentWnd);
}


//////////////////////////////////////////////////////////////////////////
BOOL CWeaponEditorDialog::OnInitDialog()
{
	ModifyStyle(0, WS_CLIPCHILDREN );

	CRect rc;
	GetClientRect( &rc );

	try
	{    
		// Initialize the command bars
		if (!InitCommandBars())      
			return -1;
	}	catch (CResourceException *e){
		e->Delete();
		return -1;
	}

	// Get a pointer to the command bars object.
	CXTPCommandBars* pCommandBars = GetCommandBars();
	if(pCommandBars == NULL)
	{
		TRACE0("Failed to create command bars object.\n");
		return -1; 
	}

	// Add the menu bar
	CXTPCommandBar* pMenuBar = pCommandBars->SetMenu( _T("Menu Bar"),IDR_WEAPON_EDITOR );	
	pMenuBar->SetFlags(xtpFlagStretched);
	pMenuBar->EnableCustomization(FALSE);

	// Create the toolbar
	m_toolbar.Create( this,WS_CHILD|WS_VISIBLE|CBRS_TOP|CBRS_TOOLTIPS|CBRS_FLYBY );
	VERIFY( m_toolbar.LoadToolBar(IDR_CHARACTER_EDITOR) );

	GetDockingPaneManager()->InstallDockingPanes(this);
	GetDockingPaneManager()->SetTheme(xtpPaneThemeOffice2003);
	GetDockingPaneManager()->SetThemedFloatingFrames(TRUE);

	// init TaskPanel
	//CreateTaskPanel();

	m_panePreview.Create(CWeaponEditorPreviewDialog::IDD, this);
	CXTPDockingPane *pPreviewPane = GetDockingPaneManager()->CreatePane(IDW_WE_PREVIEW_PANE, CRect(0,0,800,400), dockLeftOf);
	pPreviewPane->SetTitle( _T("Preview") );
	pPreviewPane->SetOptions( xtpPaneNoCloseable );

	m_paneSettings.Create(CWeaponEditorSettingsDialog::IDD, this);
	m_paneSettings.SetEditorDialog(this);
	CXTPDockingPane *pSettingsPane = GetDockingPaneManager()->CreatePane(IDW_WE_SETTINGS_PANE, CRect(0,0,280,400), dockRightOf);
	pSettingsPane->SetTitle( _T("Settings") );
	// Set pane resize limits
	CSize minSize = CSize(280,400); minSize.cy = 100;
	pSettingsPane->SetMinTrackSize(minSize);
	CSize maxSize = CSize(280,400); maxSize.cy = INT_MAX;
	pSettingsPane->SetMaxTrackSize(maxSize);
	pSettingsPane->SetOptions( xtpPaneNoCloseable );

	m_panePreview.GetModelViewport()->SetSettingsDialog(&m_paneSettings);
	RecalcLayout();

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////
LRESULT CWeaponEditorDialog::OnDockingPaneNotify(WPARAM wParam, LPARAM lParam)
{
	if (wParam == XTP_DPN_SHOWWINDOW)
	{
		// get a pointer to the docking pane being shown.
		CXTPDockingPane* pwndDockWindow = (CXTPDockingPane*)lParam;    
		if (!pwndDockWindow->IsValid())
		{
			switch (pwndDockWindow->GetID())
			{
			case IDW_WE_PREVIEW_PANE:
				pwndDockWindow->Attach(&m_panePreview);
				m_panePreview.SetOwner( this );
				break;
			case IDW_WE_SETTINGS_PANE:
				pwndDockWindow->Attach(&m_paneSettings);
				m_paneSettings.SetOwner( this );
				break;
			default:
				return FALSE;
			}
		}
		return TRUE;
	}
	return FALSE;
}

//////////////////////////////////////////////////////////////////////////
BOOL CWeaponEditorDialog::PreTranslateMessage(MSG* pMsg)
{
	// allow tooltip messages to be filtered
	if (__super::PreTranslateMessage(pMsg))
		return TRUE;

	if (pMsg->message >= WM_KEYFIRST && pMsg->message <= WM_KEYLAST)
	{
		// All keypresses are translated by this frame window

		::TranslateMessage(pMsg);
		::DispatchMessage(pMsg);

		return TRUE;
	}
	return FALSE;
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorDialog::OnClose()
{
	__super::OnClose();    
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorDialog::PostNcDestroy()
{

	delete this;
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorDialog::OnSize(UINT nType, int cx, int cy)
{
	__super::OnSize(nType, cx, cy);
	//if (m_panePreview.m_hWnd && m_paneSettings.m_hWnd)
	//{
	//	CRect rc;
	//	GetClientRect(rc);

	//	int settingsWidth = 260;
	//	rc.DeflateRect(4,0,4,4);
	//	rc.top += 24; // menu

	//	CRect toolbarRc = rc;
	//	toolbarRc.bottom = toolbarRc.top + 32;
	//	toolbarRc.right -= settingsWidth;
	//	m_toolbar.MoveWindow(toolbarRc);

	//	CRect settingsRc = rc;
	//	settingsRc.left = settingsRc.right - settingsWidth;
	//	m_paneSettings.MoveWindow(settingsRc);

	//	CRect viewRc = rc;
	//	viewRc.top = toolbarRc.bottom + 4;
	//	viewRc.right = settingsRc.left-4;
	//	viewRc.bottom = rc.bottom;
	//	m_panePreview.MoveWindow(viewRc);
	//}	
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorDialog::OnSetFocus(CWnd* pOldWnd)
{
	__super::OnSetFocus(pOldWnd);
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorDialog::OnDestroy()
{
	if (m_pWeapon && m_paneSettings.HasChanges())
	{
		const char* fileName = m_pWeapon->GetEntity()->GetClass()->GetName();
		if (IDYES == AfxMessageBox( string().Format("Save changes to %s.xml?", fileName), MB_YESNO|MB_ICONQUESTION ))
			m_paneSettings.OnSave();
	}
	__super::OnDestroy();  
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorDialog::OnFileOpen()
{ 
	CString filepath;
	CString initDir(PathUtil::GetGameFolder()+"\\Items\\Weapons");
	if (!CFileUtil::SelectSingleFile( EFILE_TYPE_ANY, filepath, WEAPONEDITOR_FILTER, initDir ))
		return;
	if (m_pWeapon && m_paneSettings.HasChanges())
	{
		const char* fileName = m_pWeapon->GetEntity()->GetClass()->GetName();
		if (IDYES == AfxMessageBox( string().Format("Save changes to %s.xml?", fileName), MB_YESNO|MB_ICONQUESTION ))
			m_paneSettings.OnSave();
	}
	LoadFile(filepath);
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorDialog::LoadFile(const char* filepath)
{
	CleanUpEntity();
	if (gEnv->pGame)
		if (IGameFramework* pGF=gEnv->pGame->GetIGameFramework())
			if (IItemSystem* pIS=pGF->GetIItemSystem())
				pIS->Reload();

	XmlNodeRef node = gEnv->pSystem->LoadXmlFile(filepath);
	if (!node)
		return;

	CString filename = node->getAttr("name");
	CString className = node->getAttr("class");

	if(className != "K01_Item")
	{
		AfxMessageBox("Old weapon system files are not supported.");
		return;
	}

	SEntitySpawnParams params;
	params.pClass = gEnv->pEntitySystem->GetClassRegistry()->FindClass(filename);
	params.sName = filename;
	params.nFlags = ENTITY_FLAG_NO_PROXIMITY | ENTITY_FLAG_CASTSHADOW;

	if (!params.pClass)
		return;

	EntityId accId=0;
	if (IEntity *pEntity = gEnv->pEntitySystem->SpawnEntity(params))
		accId=pEntity->GetId();

	IGameFramework* pGameFramework = gEnv->pGame->GetIGameFramework();
	IItemSystem* pItemSystem = pGameFramework->GetIItemSystem();
	if (accId)
		m_pWeapon = pItemSystem->GetItem(accId);

	if (m_pWeapon)
	{
		m_pWeapon->GetIItemEdit()->BindToEditor(true);
		m_pWeapon->GetIItemBox()->Physicalize(false, false);
		m_pWeapon->Select(true);

		m_panePreview.GetModelViewport()->SetWeapon(m_pWeapon);
		
		m_paneSettings.OnLoad();
	}
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorDialog::OnFileSave()
{
	m_paneSettings.OnSave();
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorDialog::OnReplayOpen()
{
	CString filepath;
	string userPath = gEnv->pCryPak->GetAlias("%USER%");
	CString initDir(userPath + "\\Replays\\");
	if (!CFileUtil::SelectSingleFile( EFILE_TYPE_ANY, filepath, WEAPONREPLAY_FILTER, initDir ))
		return;

	if (m_pWeapon)
		m_pWeapon->LoadReplay(filepath);
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorDialog::OnReplayPlay()
{
	if (m_pWeapon)
	{
		CAnimationContext *ac = GetIEditor()->GetAnimation();
		if (!ac->IsPlaying())
			ac->SetPlaying( true );

		m_pWeapon->PlayReplay();

		if (m_panePreview.GetModelViewport()->GetPaused())
			m_panePreview.GetModelViewport()->SetPaused(false);
	}
}

//////////////////////////////////////////////////////////////////////////
const char* CWeaponEditorDialog::GetWeaponName() const
{
	if (m_pWeapon)
		return m_pWeapon->GetEntity()->GetClass()->GetName();
	else
		return NULL;
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorDialog::OnMoveMode()
{
	m_panePreview.GetModelViewport()->m_Button_MOVE+=1;
	m_panePreview.GetModelViewport()->m_Button_MOVE&=1;
	if (m_panePreview.GetModelViewport()->m_Button_MOVE) 
		m_panePreview.GetModelViewport()->m_Button_ROTATE=0;
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorDialog::OnMoveModeUpdateUI(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck(m_panePreview.GetModelViewport()->m_Button_MOVE);
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorDialog::OnRotateMode()
{
	m_panePreview.GetModelViewport()->m_Button_ROTATE+=1;
	m_panePreview.GetModelViewport()->m_Button_ROTATE&=1;
	if (m_panePreview.GetModelViewport()->m_Button_ROTATE) 
		m_panePreview.GetModelViewport()->m_Button_MOVE=0;
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorDialog::OnRotateModeUpdateUI(CCmdUI *pCmdUI)
{
	pCmdUI->SetCheck(m_panePreview.GetModelViewport()->m_Button_ROTATE);
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorDialog::CleanUpEntity()
{
	if(m_pWeapon)
	{
		m_pWeapon->Select(false);
		gEnv->pEntitySystem->RemoveEntity(m_pWeapon->GetEntityId(),true);
		m_pWeapon = 0;
	}
}

//////////////////////////////////////////////////////////////////////////
void CWeaponEditorDialog::OnEditorNotifyEvent( EEditorNotifyEvent event )
{
	if (event != eNotify_OnBeginLoad)
		return;

	if (m_pWeapon && m_paneSettings.HasChanges())
	{
		const char* fileName = m_pWeapon->GetEntity()->GetClass()->GetName();
		if (IDYES == AfxMessageBox( string().Format("Editor must close current file. Save changes to %s.xml?", fileName), MB_YESNO|MB_ICONQUESTION ))
			m_paneSettings.OnSave();
	}
	CleanUpEntity();
	m_panePreview.GetModelViewport()->SetWeapon(0);
	m_paneSettings.OnLoad();
}
